/* GSAMBAD, an easy to use GTK+ frontend for the SAMBA file and print server.
 * Copyright (C) 2006 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
*/



#include "../config.h"
#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "widgets.h"
#include "gettext.h"
#include "functions.h"
#include "show_info.h"
#include "allocate.h"
#include "add_change_user.h"
#include "populate_users.h"
#include "select_first_user.h"
#include "populate_user_settings.h"
#include "commands.h"

extern int activated;



/* Add or change the system and samba user */
void add_change_user(struct w *widgets)
{
    FILE *fp;
    gchar *info, *path, *cmd;

    G_CONST_RETURN gchar *username;
    G_CONST_RETURN gchar *password;
    G_CONST_RETURN gchar *groupname;
    G_CONST_RETURN gchar *comment;
    G_CONST_RETURN gchar *homedir;
    G_CONST_RETURN gchar *shell;

    /* Get the users widget settings */
    username  = gtk_entry_get_text(GTK_ENTRY(widgets->user_set_entry[0]));
    password  = gtk_entry_get_text(GTK_ENTRY(widgets->user_set_entry[1]));
    groupname = gtk_entry_get_text(GTK_ENTRY(widgets->user_set_entry[2]));
    comment   = gtk_entry_get_text(GTK_ENTRY(widgets->user_set_entry[3]));
    homedir   = gtk_entry_get_text(GTK_ENTRY(widgets->user_set_entry[4]));
    /* Its a gtk combo box entry new text */
    shell     = gtk_entry_get_text(GTK_ENTRY(GTK_BIN(widgets->user_set_combo[0])->child));

//    printf("Selected user: %s\n", username);
//    printf("Selected pass: %s\n", password);
//    printf("Selected grp : %s\n", groupname);
//    printf("Selected cmnt: %s\n", comment);
//    printf("Selected home: %s\n", homedir);
//    printf("Selected Shell: %s\n", shell);


    /* The smbpasswd file is sometimes missing from rpm installs etc so
       attempt to make it before adding or changing any users */
    path = g_strdup_printf("%s", SAMBA_PASSWD);
    if( ! file_exists(path) )
      make_file_chmod(path, "0600");

    if( ! file_exists(path) )
    {
	info = g_strdup_printf(_("Failed creating missing file:\n%s\n"), path);
	show_info(info);
	g_free(info);
	g_free(path);
	return;
    }
    g_free(path);



    /* Root user specified, only change its samba settings */
    if( ! strcmp(username, "root") )
    {
	/* If the root system user doesnt exist, tell the user and return. */	
	if( ! user_exists(username) )
	{
    	    info = g_strdup_printf(_("The root system user doesnt exist.\nAdd it with uid/gid 0 then retry.\n"));
    	    show_info(info);
    	    g_free(info);
    	    return;
	}

	if( password!=NULL && strlen(password) >= atoi(MIN_PASS_LEN) )
	{
    	    cmd = g_strdup_printf("%s -s -a '%s'", SMBPASSWD_BINARY, username);
    	    if((fp=popen(cmd, "w"))==NULL)
    	    {
		perror("popen");
    		info = g_strdup_printf(_("Failed changing samba password or adding samba user: %s\n"), username);
    		show_info(info);
    		g_free(info);
		g_free(cmd);
    		return;
	    }
	    fputs(password, fp);
	    fputs("\n", fp);
	    fputs(password, fp);
	    fputs("\n", fp);
	    pclose(fp);
	    g_free(cmd);

	    /* The account should be disabled (locked) */
	    if( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widgets->user_set_checkbutton[0])) )
	    {
		cmd = g_strdup_printf("%s -d '%s'", SMBPASSWD_BINARY, username);
    		if((fp=popen(cmd, "w"))==NULL)
    		{
		    perror("popen");
    		    info = g_strdup_printf(_("Locking samba account: %s has failed.\n"), username);
    		    show_info(info);
    		    g_free(info);
		    g_free(cmd);
    		    return;
		}
		g_free(cmd);
		fclose(fp);
	    }
	    else
    	      {
    		  /* 
    		    The account should be enabled (unlocked). This requires a password if 
    		    it didnt have one before beeing locked. So we require a new password. */
		    cmd = g_strdup_printf("%s -e '%s'", SMBPASSWD_BINARY, username);
    		    if((fp=popen(cmd, "w"))==NULL)
    		    {
		        perror("popen");
    		        info = g_strdup_printf(_("Unlocking samba account: %s has failed.\n"), username);
    		        show_info(info);
    		        g_free(info);
		        g_free(cmd);
    		        return;
		    }
		    fputs(password, fp);
		    fputs("\n", fp);
		    fputs(password, fp);
		    fputs("\n", fp);
		    pclose(fp);
		    g_free(cmd);
	      }

    	      info = g_strdup_printf(_("The root users samba password was changed.\nNothing else was changed for this user.\n"));
    	      show_info(info);
    	      g_free(info);
    	      return;
	}
	else
	  {
	      info = g_strdup_printf(_("The password is too short, adding or passwording samba user root failed.\n"));
	      show_info(info);
	      g_free(info);
	      return;
	  }
    }


    
    /* Non root user modification follows... */


    /* The system user doesnt exist, add it */
    if( ! user_exists(username) )
    {
	/* Add the system group if it doesnt exist */
	if( ! group_exists(groupname) )
	{    
	    cmd = g_strdup_printf("%s %s", "groupadd", groupname);
	    if( ! run_command(cmd) )
	    {
		printf("Error adding system group: %s\n", groupname);
		printf("The command was: %s\n", cmd);
		g_free(cmd);
		return;
	    }
	    g_free(cmd);
	}

	/* Add the user to the specified group */
	cmd = g_strdup_printf("%s '%s' -d '%s' -c '%s' -s '%s' -g '%s'", "useradd", username, homedir, comment, shell, groupname);
	if( ! run_command(cmd) )
	{
	    printf("Error adding the system user: %s\n", username);
	    printf("The command was: %s\n", cmd);
	    g_free(cmd);
	    return;
	}
	g_free(cmd);
    }


    /* Make sure that the system user exists */
    if( ! user_exists(username) )
    {
	info = g_strdup_printf(_("Error adding system user: %s\n"), username);
	show_info(info);
	g_free(info);
	return;
    }
    


    /* The system user exists, modify its system and samba settings... */



    /* Add a new samba user with this password or change the old password. */
    if( password!=NULL && strlen(password) >= atoi(MIN_PASS_LEN) )
    {
        cmd = g_strdup_printf("%s -s -a '%s'", SMBPASSWD_BINARY, username);
        if((fp=popen(cmd, "w"))==NULL)
        {
	    perror("popen");
    	    info = g_strdup_printf(_("Failed changing password or adding samba user: %s\n"), username);
    	    show_info(info);
    	    g_free(info);
	    g_free(cmd);
    	    return;
	}
	fputs(password, fp);
	fputs("\n", fp);
	fputs(password, fp);
	fputs("\n", fp);
	pclose(fp);
	g_free(cmd);

	/* Change the system users password */
	// FIXME ?
    }




    /* The account should be disabled (locked) */
    if( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widgets->user_set_checkbutton[0])) ) // && ! smbuser_locked(username))
    {
	cmd = g_strdup_printf("%s -d '%s'", SMBPASSWD_BINARY, username);
    	if((fp=popen(cmd, "w"))==NULL)
    	{
	    perror("popen");
    	    info = g_strdup_printf(_("Locking samba account: %s has failed.\n"), username);
    	    show_info(info);
    	    g_free(info);
	    g_free(cmd);
    	    return;
	}
	g_free(cmd);
	fclose(fp);
    }
    else
      {

//	if( ! gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widgets->user_set_checkbutton[0])) ) // && smbuser_locked(username))
            /* The account should be enabled (unlocked).
               This requires a password if it didnt have one before beeing locked. 
               So we require a new password. */
            if( password!=NULL && strlen(password) >= atoi(MIN_PASS_LEN) )
            {
		cmd = g_strdup_printf("%s -e '%s'", SMBPASSWD_BINARY, username);
    		if((fp=popen(cmd, "w"))==NULL)
    		{
		    perror("popen");
    		    info = g_strdup_printf(_("Unlocking samba account: %s has failed.\n"), username);
    		    show_info(info);
    		    g_free(info);
		    g_free(cmd);
    		    return;
		}
		fputs(password, fp);
		fputs("\n", fp);
		fputs(password, fp);
		fputs("\n", fp);
		pclose(fp);
		g_free(cmd);
	    }
	    else
	      {
    		    info = g_strdup_printf(_("Unlocking samba account: %s has failed.\nA valid password must be supplied.\n"), username);
    		    show_info(info);
    		    g_free(info);
	      }
      }
	    


    /* Change this users system comment */
    cmd = g_strdup_printf("%s -c '%s' '%s'\n", "usermod", comment, username);
    if((fp=popen(cmd, "w"))==NULL)
    {
	perror("popen");
    	info = g_strdup_printf(_("Failed changing password or adding samba user: %s\n"), username);
    	show_info(info);
    	g_free(info);
	g_free(cmd);
    	return;
    }
    pclose(fp);
    g_free(cmd);

    /* Change other settings as well */
	    
    // Fixme... also change these..
    //    printf("Selected group : %s\n", groupname);
    //    DONE   printf("Selected comment: %s\n", comment);
    //    printf("Selected home: %s\n", homedir);
    //    printf("Selected Shell: %s\n", shell);



    /* Create directory: /var/samba/profiles/UserName */
    cmd = g_strdup_printf("mkdir -p %s/samba/profiles/%s", LOCALSTATEDIR, username);
    if( ! run_command(cmd) )
    {
	printf("Error creating directory: %s/samba/profiles/%s\n", LOCALSTATEDIR, username);
	printf("The command was: %s\n", cmd);
	g_free(cmd);
	return;
    }
    g_free(cmd);

    /* Chown directory: /var/samba/profiles/UserName to this user.group */
    cmd = g_strdup_printf("chown %s:%s %s/samba/profiles/%s", username, groupname, LOCALSTATEDIR, username);
    if( ! run_command(cmd) )
    {
	printf("Error chowning directory: %s/samba/profiles/%s\n", LOCALSTATEDIR, username);
	printf("The command was: %s\n", cmd);
	g_free(cmd);
	return;
    }
    g_free(cmd);
    


    /* Update the user tab */
    populate_users(widgets);
    select_first_user(widgets); /* Fixme: Should be scroll to and select this user */
    populate_user_settings(widgets);
}
