#ifndef GAMMA_TABLES_H
#define GAMMA_TABLES_H
/* Gamma tables for the spca5xx camera (25/12/2003) by mxhaard@magic.fr
* Original work from
* Adam M. Costello <amc @ cs.berkeley.edu>
* Gamma_tables_h is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Gamma_tables_h is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
*/
/*	Gtable[0][n] -> 2.2
*	Gtable[1][n] -> 1.7
*	Gtable[2][n] -> 1.45
*	Gtable[3][n] -> 1
*	Gtable[4][n] -> 0.6896
*	Gtable[5][n] -> 0.5882
*	Gtable[6][n] -> 0.4545
*	
*/
static unsigned char GTable[7][256] = {
// gamma-coeff = 2.2000
    {
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
     1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2,
     3, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6,
     6, 7, 7, 7, 8, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12,
     12, 13, 13, 13, 14, 14, 15, 15, 16, 16, 17, 17, 18, 18, 19, 19,
     20, 20, 21, 22, 22, 23, 23, 24, 25, 25, 26, 26, 27, 28, 28, 29,
     30, 30, 31, 32, 33, 33, 34, 35, 35, 36, 37, 38, 39, 39, 40, 41,
     42, 43, 43, 44, 45, 46, 47, 48, 49, 49, 50, 51, 52, 53, 54, 55,
     56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71,
     73, 74, 75, 76, 77, 78, 79, 81, 82, 83, 84, 85, 87, 88, 89, 90,
     91, 93, 94, 95, 97, 98, 99, 100, 102, 103, 105, 106, 107, 109, 110,
     111,
     113, 114, 116, 117, 119, 120, 121, 123, 124, 126, 127, 129, 130, 132,
     133, 135,
     137, 138, 140, 141, 143, 145, 146, 148, 149, 151, 153, 154, 156, 158,
     159, 161,
     163, 165, 166, 168, 170, 172, 173, 175, 177, 179, 181, 182, 184, 186,
     188, 190,
     192, 194, 196, 197, 199, 201, 203, 205, 207, 209, 211, 213, 215, 217,
     219, 221,
     223, 225, 227, 229, 231, 234, 236, 238, 240, 242, 244, 246, 248, 251,
     253, 255,
     },
// gamma-coeff = 1.7000
    {
     0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 2, 2, 2,
     2, 3, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6, 6, 6, 7, 7,
     7, 8, 8, 9, 9, 10, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14,
     15, 15, 16, 17, 17, 18, 18, 19, 19, 20, 21, 21, 22, 22, 23, 24,
     24, 25, 26, 26, 27, 28, 28, 29, 30, 30, 31, 32, 33, 33, 34, 35,
     36, 36, 37, 38, 39, 39, 40, 41, 42, 43, 43, 44, 45, 46, 47, 48,
     48, 49, 50, 51, 52, 53, 54, 55, 56, 56, 57, 58, 59, 60, 61, 62,
     63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78,
     79, 80, 81, 82, 83, 84, 85, 87, 88, 89, 90, 91, 92, 93, 94, 95,
     97, 98, 99, 100, 101, 102, 103, 105, 106, 107, 108, 109, 111, 112,
     113, 114,
     115, 117, 118, 119, 120, 122, 123, 124, 125, 127, 128, 129, 131, 132,
     133, 134,
     136, 137, 138, 140, 141, 142, 144, 145, 146, 148, 149, 151, 152, 153,
     155, 156,
     157, 159, 160, 162, 163, 164, 166, 167, 169, 170, 172, 173, 175, 176,
     177, 179,
     180, 182, 183, 185, 186, 188, 189, 191, 192, 194, 195, 197, 198, 200,
     202, 203,
     205, 206, 208, 209, 211, 212, 214, 216, 217, 219, 220, 222, 224, 225,
     227, 228,
     230, 232, 233, 235, 237, 238, 240, 242, 243, 245, 247, 248, 250, 252,
     253, 255,
     },
// gamma-coeff = 1.4500
    {
     0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4,
     5, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12,
     13, 13, 14, 14, 15, 16, 16, 17, 17, 18, 19, 19, 20, 21, 21, 22,
     23, 23, 24, 25, 25, 26, 27, 28, 28, 29, 30, 31, 31, 32, 33, 34,
     34, 35, 36, 37, 38, 38, 39, 40, 41, 42, 42, 43, 44, 45, 46, 47,
     47, 48, 49, 50, 51, 52, 53, 54, 55, 55, 56, 57, 58, 59, 60, 61,
     62, 63, 64, 65, 66, 67, 68, 69, 69, 70, 71, 72, 73, 74, 75, 76,
     77, 78, 79, 80, 81, 82, 83, 84, 85, 87, 88, 89, 90, 91, 92, 93,
     94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 105, 106, 107, 108, 109,
     110,
     111, 112, 114, 115, 116, 117, 118, 119, 120, 122, 123, 124, 125, 126,
     127, 129,
     130, 131, 132, 133, 134, 136, 137, 138, 139, 140, 142, 143, 144, 145,
     147, 148,
     149, 150, 151, 153, 154, 155, 156, 158, 159, 160, 161, 163, 164, 165,
     166, 168,
     169, 170, 172, 173, 174, 175, 177, 178, 179, 181, 182, 183, 185, 186,
     187, 188,
     190, 191, 192, 194, 195, 196, 198, 199, 200, 202, 203, 205, 206, 207,
     209, 210,
     211, 213, 214, 215, 217, 218, 220, 221, 222, 224, 225, 227, 228, 229,
     231, 232,
     234, 235, 236, 238, 239, 241, 242, 243, 245, 246, 248, 249, 251, 252,
     254, 255,
     },
// gamma-coeff = 1.0000
    {
     0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
     16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
     32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
     48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
     64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
     80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
     96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110,
     111,
     112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125,
     126, 127,
     128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141,
     142, 143,
     144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157,
     158, 159,
     160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173,
     174, 175,
     176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189,
     190, 191,
     192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205,
     206, 207,
     208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221,
     222, 223,
     224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237,
     238, 239,
     240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253,
     254, 255,
     },
// gamma-coeff = 0.6896
    {
     0, 6, 9, 12, 15, 17, 19, 21, 23, 25, 27, 29, 31, 33, 34, 36,
     38, 39, 41, 43, 44, 46, 47, 49, 50, 51, 53, 54, 56, 57, 58, 60,
     61, 62, 64, 65, 66, 67, 69, 70, 71, 72, 74, 75, 76, 77, 78, 79,
     81, 82, 83, 84, 85, 86, 87, 89, 90, 91, 92, 93, 94, 95, 96, 97,
     98, 99, 100, 101, 102, 104, 105, 106, 107, 108, 109, 110, 111, 112,
     113, 114,
     115, 116, 117, 118, 119, 120, 121, 121, 122, 123, 124, 125, 126, 127,
     128, 129,
     130, 131, 132, 133, 134, 135, 136, 136, 137, 138, 139, 140, 141, 142,
     143, 144,
     145, 145, 146, 147, 148, 149, 150, 151, 152, 153, 153, 154, 155, 156,
     157, 158,
     159, 159, 160, 161, 162, 163, 164, 164, 165, 166, 167, 168, 169, 169,
     170, 171,
     172, 173, 174, 174, 175, 176, 177, 178, 178, 179, 180, 181, 182, 183,
     183, 184,
     185, 186, 187, 187, 188, 189, 190, 190, 191, 192, 193, 194, 194, 195,
     196, 197,
     197, 198, 199, 200, 201, 201, 202, 203, 204, 204, 205, 206, 207, 207,
     208, 209,
     210, 210, 211, 212, 213, 213, 214, 215, 216, 216, 217, 218, 219, 219,
     220, 221,
     222, 222, 223, 224, 225, 225, 226, 227, 227, 228, 229, 230, 230, 231,
     232, 232,
     233, 234, 235, 235, 236, 237, 237, 238, 239, 240, 240, 241, 242, 242,
     243, 244,
     245, 245, 246, 247, 247, 248, 249, 249, 250, 251, 252, 252, 253, 254,
     254, 255,
     },
// gamma-coeff = 0.5882
    {
     0, 10, 15, 19, 22, 25, 28, 31, 33, 36, 38, 40, 42, 44, 46, 48,
     50, 52, 54, 55, 57, 59, 60, 62, 64, 65, 67, 68, 70, 71, 72, 74,
     75, 77, 78, 79, 81, 82, 83, 84, 86, 87, 88, 89, 91, 92, 93, 94,
     95, 97, 98, 99, 100, 101, 102, 103, 105, 106, 107, 108, 109, 110, 111,
     112,
     113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126,
     127, 128,
     129, 130, 131, 132, 133, 134, 135, 135, 136, 137, 138, 139, 140, 141,
     142, 143,
     144, 144, 145, 146, 147, 148, 149, 150, 150, 151, 152, 153, 154, 155,
     156, 156,
     157, 158, 159, 160, 160, 161, 162, 163, 164, 164, 165, 166, 167, 168,
     168, 169,
     170, 171, 172, 172, 173, 174, 175, 175, 176, 177, 178, 178, 179, 180,
     181, 181,
     182, 183, 184, 184, 185, 186, 187, 187, 188, 189, 190, 190, 191, 192,
     192, 193,
     194, 195, 195, 196, 197, 197, 198, 199, 200, 200, 201, 202, 202, 203,
     204, 204,
     205, 206, 206, 207, 208, 208, 209, 210, 210, 211, 212, 212, 213, 214,
     214, 215,
     216, 216, 217, 218, 218, 219, 220, 220, 221, 222, 222, 223, 224, 224,
     225, 226,
     226, 227, 227, 228, 229, 229, 230, 231, 231, 232, 233, 233, 234, 234,
     235, 236,
     236, 237, 238, 238, 239, 239, 240, 241, 241, 242, 242, 243, 244, 244,
     245, 245,
     246, 247, 247, 248, 248, 249, 250, 250, 251, 251, 252, 253, 253, 254,
     254, 255,
     },
// gamma-coeff = 0.4545
    {
     0, 21, 28, 34, 39, 43, 46, 50, 53, 56, 59, 61, 64, 66, 68, 70,
     72, 74, 76, 78, 80, 82, 84, 85, 87, 89, 90, 92, 93, 95, 96, 98,
     99, 101, 102, 103, 105, 106, 107, 109, 110, 111, 112, 114, 115, 116,
     117, 118,
     119, 120, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133,
     134, 135,
     136, 137, 138, 139, 140, 141, 142, 143, 144, 144, 145, 146, 147, 148,
     149, 150,
     151, 151, 152, 153, 154, 155, 156, 156, 157, 158, 159, 160, 160, 161,
     162, 163,
     164, 164, 165, 166, 167, 167, 168, 169, 170, 170, 171, 172, 173, 173,
     174, 175,
     175, 176, 177, 178, 178, 179, 180, 180, 181, 182, 182, 183, 184, 184,
     185, 186,
     186, 187, 188, 188, 189, 190, 190, 191, 192, 192, 193, 194, 194, 195,
     195, 196,
     197, 197, 198, 199, 199, 200, 200, 201, 202, 202, 203, 203, 204, 205,
     205, 206,
     206, 207, 207, 208, 209, 209, 210, 210, 211, 212, 212, 213, 213, 214,
     214, 215,
     215, 216, 217, 217, 218, 218, 219, 219, 220, 220, 221, 221, 222, 223,
     223, 224,
     224, 225, 225, 226, 226, 227, 227, 228, 228, 229, 229, 230, 230, 231,
     231, 232,
     232, 233, 233, 234, 234, 235, 235, 236, 236, 237, 237, 238, 238, 239,
     239, 240,
     240, 241, 241, 242, 242, 243, 243, 244, 244, 245, 245, 246, 246, 247,
     247, 248,
     248, 249, 249, 249, 250, 250, 251, 251, 252, 252, 253, 253, 254, 254,
     255, 255,
     },
};
#endif				/* GAMMA_TABLES_H */
