//*****************************************************************************
//                              DlgGcpCfgGEN.cpp                              *
//                             ------------------                             *
//  Started     : 27/02/2004                                                  *
//  Last Update : 30/07/2009                                                  *
//  Copyright   : (C) 2004 by M.S.Waters                                      *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#include "gnucap/dialogs/DlgGcpCfgGEN.hpp"

//*****************************************************************************
// Implement an event table.

BEGIN_EVENT_TABLE( DlgGcpCfgGEN, wxDialog )

  EVT_BUTTON( ID_BTN_OK,     DlgGcpCfgGEN::OnBtnOk     )
  EVT_BUTTON( ID_BTN_CLEAR,  DlgGcpCfgGEN::OnBtnClear  )
  EVT_BUTTON( ID_BTN_CANCEL, DlgGcpCfgGEN::OnBtnCancel )

END_EVENT_TABLE( )

//*****************************************************************************
// Constructor.
//
// Argument List :
//   poWin - A pointer to the dialog parent window

DlgGcpCfgGEN::DlgGcpCfgGEN( wxWindow * poWin ) :
                wxDialog( poWin, -1, wxT(""), wxDefaultPosition, wxDefaultSize,
                          wxDEFAULT_DIALOG_STYLE, wxDialogNameStr )
{
  SetTitle( wxT("Generator Setup") );
  Initialize( );
  bClear( );
}

//*****************************************************************************
// Destructor.

DlgGcpCfgGEN::~DlgGcpCfgGEN( )
{
}

//*****************************************************************************
// Initialize object attributes.

void  DlgGcpCfgGEN::Initialize( void )
{
  // Call all the initialization functions
  Create( );
  ToolTips( );

  // Layout the of the display objects
  DoLayout( );
}

//*****************************************************************************
// Create the display objects.

void  DlgGcpCfgGEN::Create( void )
{
  wxPanel * poPnl1;

  // Create the overall panel and controls
  poPnl1 = new wxPanel( this );

  m_oPnlAmplitude.bCreate( poPnl1, ID_PNL_AMPLITUDE, 95 );
  m_oPnlOffset   .bCreate( poPnl1, ID_PNL_OFFSET,    95 );

  m_oPnlAmplitude.bSetName( wxT("Amplitude") );
  m_oPnlOffset   .bSetName( wxT("DC Offset") );

  m_oPnlAmplitude.bSetUnitsType( eUNITS_SCLR );
  m_oPnlOffset   .bSetUnitsType( eUNITS_VOLT );

  // Create the sine wave panel and controls
  poPnl1 = new wxPanel( this );

  m_oPnlSinFreq .bCreate( poPnl1, ID_PNL_SIN_FREQ,  95 );
  m_oPnlSinPhase.bCreate( poPnl1, ID_PNL_SIN_PHASE, 95 );

  m_oPnlSinFreq .bSetName( wxT("Frequency")     );
  m_oPnlSinPhase.bSetName( wxT("Initial Phase") );

  m_oPnlSinFreq .bSetUnitsType( eUNITS_FREQ  );
  m_oPnlSinPhase.bSetUnitsType( eUNITS_PHASE );

  m_oPnlSinFreq .bSetRange( 0.0, 1000.0 );
  m_oPnlSinFreq .bSetUnits( wxT("Hz") );

  // Create the pulse panel and controls
  poPnl1 = new wxPanel( this );

  m_oPnlPulInitial.bCreate( poPnl1, ID_PNL_PUL_INITIAL, 95 );
  m_oPnlPulMin    .bCreate( poPnl1, ID_PNL_PUL_MIN,     95 );
  m_oPnlPulMax    .bCreate( poPnl1, ID_PNL_PUL_MAX,     95 );
  m_oPnlPulDelay  .bCreate( poPnl1, ID_PNL_PUL_DELAY,   95 );
  m_oPnlPulRise   .bCreate( poPnl1, ID_PNL_PUL_RISE,    95 );
  m_oPnlPulWidth  .bCreate( poPnl1, ID_PNL_PUL_WIDTH,   95 );
  m_oPnlPulFall   .bCreate( poPnl1, ID_PNL_PUL_FALL,    95 );
  m_oPnlPulPeriod .bCreate( poPnl1, ID_PNL_PUL_PERIOD,  95 );

  m_oPnlPulInitial.bSetName( wxT("Initial Value") );
  m_oPnlPulMin    .bSetName( wxT("Min Level")     );
  m_oPnlPulMax    .bSetName( wxT("Max Level")     );
  m_oPnlPulDelay  .bSetName( wxT("Initial Delay") );
  m_oPnlPulRise   .bSetName( wxT("Rise Time")     );
  m_oPnlPulWidth  .bSetName( wxT("Pulse Width")   );
  m_oPnlPulFall   .bSetName( wxT("Fall Time")     );
  m_oPnlPulPeriod .bSetName( wxT("Period")        );

  m_oPnlPulInitial.bSetUnitsType( eUNITS_VOLT );
  m_oPnlPulMin    .bSetUnitsType( eUNITS_VOLT );
  m_oPnlPulMax    .bSetUnitsType( eUNITS_VOLT );
  m_oPnlPulDelay  .bSetUnitsType( eUNITS_TIME );
  m_oPnlPulRise   .bSetUnitsType( eUNITS_TIME );
  m_oPnlPulWidth  .bSetUnitsType( eUNITS_TIME );
  m_oPnlPulFall   .bSetUnitsType( eUNITS_TIME );
  m_oPnlPulPeriod .bSetUnitsType( eUNITS_TIME );

  // Create the buttons panel and the button controls
  poPnl1 = new wxPanel( this );

  m_oBtnOk    .Create( poPnl1, ID_BTN_OK,     wxT("OK")     );
  m_oBtnClear .Create( poPnl1, ID_BTN_CLEAR,  wxT("Clear")  );
  m_oBtnCancel.Create( poPnl1, ID_BTN_CANCEL, wxT("Cancel") );
}

//*****************************************************************************
// Initialize the tool tips.

void  DlgGcpCfgGEN::ToolTips( void )
{
  m_oPnlAmplitude .SetToolTip( wxT("The overall amplitude of the sine wave and the pulse train") );
  m_oPnlOffset    .SetToolTip( wxT("The DC offset applied to the entire signal") );

  m_oPnlSinFreq   .SetToolTip( wxT("The frequency of the sine wave generator for a Transient analysis") );
  m_oPnlSinPhase  .SetToolTip( wxT("The phase of the sine wave at startup") );

  m_oPnlPulInitial.SetToolTip( wxT("The initial value of the source") );
  m_oPnlPulMin    .SetToolTip( wxT("The 'OFF' value for the pulse train") );
  m_oPnlPulMax    .SetToolTip( wxT("The 'ON' value for the pulse train") );
  m_oPnlPulDelay  .SetToolTip( wxT("The time until the first pulse") );
  m_oPnlPulRise   .SetToolTip( wxT("The time taken to go from 0 to the pulsed value") );
  m_oPnlPulWidth  .SetToolTip( wxT("The width of each pulse") );
  m_oPnlPulFall   .SetToolTip( wxT("The time taken to go from the pulsed value to 0") );
  m_oPnlPulPeriod .SetToolTip( wxT("The period of the pulse train") );
}

//*****************************************************************************
// Layout the dialog display objects.

void  DlgGcpCfgGEN::DoLayout( void )
{
  wxPanel     * poPnl;
  wxBoxSizer  * poSzr;
  wxSizerFlags  oFlags;

  // Create and set the underlying dialog's sizer
  poSzr = new wxBoxSizer( wxVERTICAL );
  SetSizer( poSzr );

  // Create and set the sizer for the total panel
  poPnl = (wxPanel *) m_oPnlAmplitude.GetParent( );
  poSzr = new wxStaticBoxSizer( wxVERTICAL, poPnl, wxT(" Overall ") );
  poPnl->SetSizer( poSzr );

  // Layout the total panel
  oFlags.Align( wxALIGN_CENTER );
  oFlags.Border( wxTOP | wxLEFT | wxRIGHT, 10 );
  poSzr->Add( &m_oPnlAmplitude, oFlags );
  oFlags.Border( wxBOTTOM, 5 );
  poSzr->Add( &m_oPnlOffset,    oFlags );
  poSzr->SetSizeHints( poPnl );

  oFlags.Border( wxTOP | wxLEFT | wxRIGHT, 10 );
  GetSizer( )->Add( poPnl, oFlags );

  // Create and set the sizer for the sinusoid parameter panel
  poPnl = (wxPanel *) m_oPnlSinFreq.GetParent( );
  poSzr = new wxStaticBoxSizer( wxVERTICAL, poPnl, wxT(" Sinusoid ") );
  poPnl->SetSizer( poSzr );

  // Layout the sine wave parameter panel
  oFlags.Border( wxTOP | wxLEFT | wxRIGHT, 10 );
  poSzr->Add( &m_oPnlSinFreq,  oFlags );
  oFlags.Border( wxBOTTOM, 5 );
  poSzr->Add( &m_oPnlSinPhase, oFlags );
  poSzr->SetSizeHints( poPnl );

  oFlags.Border( wxTOP | wxLEFT | wxRIGHT, 10 );
  GetSizer( )->Add( poPnl, oFlags );

  // Create and set the sizer for the pulse parameter panel
  poPnl = (wxPanel *) m_oPnlPulInitial.GetParent( );
  poSzr = new wxStaticBoxSizer( wxVERTICAL, poPnl, wxT(" Pulse ") );
  poPnl->SetSizer( poSzr );

  // Layout the pulse parameter panel
  oFlags.Border( wxTOP, 10 );
  poSzr->Add( &m_oPnlPulInitial, oFlags );
  oFlags.Border( wxLEFT | wxRIGHT, 10 );
  poSzr->Add( &m_oPnlPulMin,     oFlags );
  poSzr->Add( &m_oPnlPulMax,     oFlags );
  poSzr->Add( &m_oPnlPulDelay,   oFlags );
  poSzr->Add( &m_oPnlPulRise,    oFlags );
  poSzr->Add( &m_oPnlPulWidth,   oFlags );
  poSzr->Add( &m_oPnlPulFall,    oFlags );
  oFlags.Border( wxBOTTOM, 5 );
  poSzr->Add( &m_oPnlPulPeriod,  oFlags );
  poSzr->SetSizeHints( poPnl );

  oFlags.Border( wxALL, 10 );
  GetSizer( )->Add( poPnl, oFlags );

  // Create and set the sizer for the buttons panel
  poPnl = (wxPanel *) m_oBtnOk.GetParent( );
  poSzr = new wxBoxSizer( wxHORIZONTAL );
  poPnl->SetSizer( poSzr );

  // Layout the button panel
  oFlags.Border( wxTOP | wxBOTTOM, 10 );
  oFlags.Align( wxALIGN_RIGHT );
  poSzr->Add( &m_oBtnOk,     oFlags );
  poSzr->AddSpacer( 10 );
  oFlags.Align( wxALIGN_CENTER );
  poSzr->Add( &m_oBtnClear,  oFlags );
  poSzr->AddSpacer( 10 );
  oFlags.Align( wxALIGN_LEFT );
  poSzr->Add( &m_oBtnCancel, oFlags );
  poSzr->SetSizeHints( poPnl );

  oFlags.Align( wxALIGN_CENTER );
  oFlags.Border( wxBOTTOM, 10 );
  GetSizer( )->Add( poPnl, oFlags );

  // Set dialogues minimum size and initial size as calculated by the sizer
  GetSizer( )->SetSizeHints( this );
}

//*****************************************************************************
// Set the values in the value panel controls.
//
// Argument List :
//   roCmdGEN - A reference to a GENERATOR command object

void  DlgGcpCfgGEN::SetValues( CmdGnuCapGEN & roCmdGEN )
{
  SetEvtHandlerEnabled( FALSE );

  m_oPnlAmplitude .bSetValue( roCmdGEN.m_osAmplitude  );
  m_oPnlOffset    .bSetValue( roCmdGEN.m_osOffset     );

  m_oPnlSinFreq   .bSetValue( roCmdGEN.m_osSinFreq    );
  m_oPnlSinPhase  .bSetValue( roCmdGEN.m_osSinPhase   );

  m_oPnlPulInitial.bSetValue( roCmdGEN.m_osPulInitial );
  m_oPnlPulMin    .bSetValue( roCmdGEN.m_osPulMin     );
  m_oPnlPulMax    .bSetValue( roCmdGEN.m_osPulMax     );
  m_oPnlPulDelay  .bSetValue( roCmdGEN.m_osPulDelay   );
  m_oPnlPulRise   .bSetValue( roCmdGEN.m_osPulRise    );
  m_oPnlPulWidth  .bSetValue( roCmdGEN.m_osPulWidth   );
  m_oPnlPulFall   .bSetValue( roCmdGEN.m_osPulFall    );
  m_oPnlPulPeriod .bSetValue( roCmdGEN.m_osPulPeriod  );

  SetEvtHandlerEnabled( TRUE );
}

//*****************************************************************************
// Get the values from the value panel controls.
//
// Argument List :
//   roCmdGEN - A reference to a GENERATOR command object

void  DlgGcpCfgGEN::GetValues( CmdGnuCapGEN & roCmdGEN )
{
  SetEvtHandlerEnabled( FALSE );

  roCmdGEN.m_osAmplitude  = m_oPnlAmplitude .rosGetValue( );
  roCmdGEN.m_osOffset     = m_oPnlOffset    .rosGetValue( );

  roCmdGEN.m_osSinFreq    = m_oPnlSinFreq   .rosGetValue( );
  roCmdGEN.m_osSinPhase   = m_oPnlSinPhase  .rosGetValue( );

  roCmdGEN.m_osPulInitial = m_oPnlPulInitial.rosGetValue( );
  roCmdGEN.m_osPulMin     = m_oPnlPulMin    .rosGetValue( );
  roCmdGEN.m_osPulMax     = m_oPnlPulMax    .rosGetValue( );
  roCmdGEN.m_osPulDelay   = m_oPnlPulDelay  .rosGetValue( );
  roCmdGEN.m_osPulRise    = m_oPnlPulRise   .rosGetValue( );
  roCmdGEN.m_osPulWidth   = m_oPnlPulWidth  .rosGetValue( );
  roCmdGEN.m_osPulFall    = m_oPnlPulFall   .rosGetValue( );
  roCmdGEN.m_osPulPeriod  = m_oPnlPulPeriod .rosGetValue( );

  roCmdGEN.bFormat( );

  SetEvtHandlerEnabled( TRUE );
}

//*****************************************************************************
// Reset all dialog settings to defaults.
//
// Return Values :
//   TRUE  - Success
//   FALSE - Failure

bool  DlgGcpCfgGEN::bClear( void )
{
  m_oCmdGEN.bClear( );

  SetValues( m_oCmdGEN );

  return( TRUE );
}

//*****************************************************************************
// Set the values in the value panel controls.
//
// Argument List :
//   roCmdGEN - A reference to a GENERATOR command object
//
// Return Values :
//   TRUE  - Success
//   FALSE - Failure

bool  DlgGcpCfgGEN::bSetValues( CmdGnuCapGEN & roCmdGEN )
{
  SetValues( roCmdGEN );
  m_oCmdGEN = roCmdGEN;

  return( TRUE );
}

//*****************************************************************************
// Get the values from the value panel controls.
//
// Argument List :
//   roCmdGEN - A reference to a GENERATOR command object
//
// Return Values :
//   TRUE  - Success
//   FALSE - Failure

bool  DlgGcpCfgGEN::bGetValues( CmdGnuCapGEN & roCmdGEN )
{
  GetValues( roCmdGEN );

  return( TRUE );
}

//*****************************************************************************
//
//                             Event Handlers
//
//*****************************************************************************
// OK button event handler.
//
// Argument List :
//   roEvtCmd - An object holding information about the event (not used)

void  DlgGcpCfgGEN::OnBtnOk( wxCommandEvent & roEvtCmd )
{
  GetValues( m_oCmdGEN );
  EndModal( wxID_OK );
}

//*****************************************************************************
// Clear button event handler.
//
// Argument List :
//   roEvtCmd - An object holding information about the event (not used)

void  DlgGcpCfgGEN::OnBtnClear( wxCommandEvent & roEvtCmd )
{
  bClear( );
}

//*****************************************************************************
// Cancel button event handler.
//
// Argument List :
//   roEvtCmd - An object holding information about the event (not used)

void  DlgGcpCfgGEN::OnBtnCancel( wxCommandEvent & roEvtCmd )
{
  SetValues( m_oCmdGEN );
  EndModal( wxID_CANCEL );
}

//*****************************************************************************
