/* GStreamer
 *
 * unit test for videofilter elements
 *
 * Copyright (C) <2006> Mark Nauwelaerts <mnauw@users.sourceforge.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __VIDEOFILTER_TEST_H__
#define __VIDEOFILTER_TEST_H__

G_BEGIN_DECLS

#include <unistd.h>
#include <stdarg.h>

#include <gst/check/gstcheck.h>

typedef struct _RunInfo RunInfo;

struct _RunInfo
{
  gint in_size;
  gint out_size;
  gint in_count;
  gint out_count;
  const gchar * in_caps;
  const gchar * out_caps;
};

void check_filter (const gchar * name, RunInfo * info, const gchar * prop, ...);

static inline void init_runinfo_full (RunInfo * ri,
    gint in_s, gint out_s, gint in_c, gint out_c,
    const gchar * in_cap, const gchar * out_cap)
{
  ri->in_size = in_s;
  ri->out_size = out_s;
  ri->in_count = in_c;
  ri->out_count = out_c;
  ri->in_caps = in_cap;
  ri->out_caps = out_cap;
}

#define YUV_CAPS_FULL(w, h, f) "video/x-raw-yuv, " \
  "format = (fourcc) I420, "                       \
  "width = (int) " #w ", "                         \
  "height = (int) " #h ", "                        \
  "framerate = (fraction) " #f ", "                \
  "pixel-aspect-ratio = (fraction) 1/1"

#define YUV_CAPS(w, h)  YUV_CAPS_FULL(w, h, 25/1)

#define BGR_CAPS(w, h) \
    "video/x-raw-rgb, "              \
    "bpp = (int) 24, "               \
    "depth = (int) 24, "             \
    "endianness = (int) BIG_ENDIAN, "\
    "red_mask = (int) 0x0000FF, "    \
    "green_mask = (int) 0x00FF00, "  \
    "blue_mask = (int) 0xFF0000, "   \
    "width = " #w ", "               \
    "height = " #h ", "              \
    "framerate = (fraction) 25/1, "  \
    "pixel-aspect-ratio = (fraction) 1/1"

#define BGRx_CAPS(w, h) \
    "video/x-raw-rgb, "              \
    "bpp = (int) 32, "               \
    "depth = (int) 24, "             \
    "endianness = (int) BIG_ENDIAN, "\
    "red_mask = (int) 0x0000FF00, "  \
    "green_mask = (int) 0x00FF0000, "\
    "blue_mask = (int) 0xFF000000, " \
    "width = " #w ", "               \
    "height = " #h ", "              \
    "framerate = (fraction) 25/1, "  \
    "pixel-aspect-ratio = (fraction) 1/1"

#define INIT_RUNINFO_FULL(ri, in_w, in_h, out_w, out_h, in_count, out_count, \
    in_caps, in_s_f, out_caps, out_s_f)  \
  init_runinfo_full (ri, in_w * in_h * in_s_f, out_w * out_h * out_s_f, in_count, out_count, \
    in_caps ## _CAPS (in_w, in_h), out_caps ## _CAPS (out_w, out_h))

#define INIT_RUNINFO(ri, in_w, in_h, out_w, out_h, in_count, out_count, capstype, s_f)  \
  INIT_RUNINFO_FULL (ri, in_w, in_h, out_w, out_h, in_count, out_count, capstype, s_f, \
      capstype, s_f)

#define INIT_RUNINFO_YUV(ri, count)  \
  INIT_RUNINFO (ri, 384, 288, 384, 288, count, count, YUV, 3 / 2)

#define INIT_RUNINFO_BGR(ri, count)  \
  INIT_RUNINFO (ri, 384, 288, 384, 288, count, count, BGR, 3)

#define INIT_RUNINFO_BGRx(ri, count)  \
  INIT_RUNINFO (ri, 384, 288, 384, 288, count, count, BGRx, 4)

G_END_DECLS

#endif /* __VIDEOFILTER_TEST_H__ */
