/**
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *   James Willcox <jwillcox@cs.indiana.edu>
 */

#ifndef __EGG_RECENT_UTIL__
#define __EGG_RECENT_UTIL__

#include <gtk/gtk.h>
#ifndef USE_STABLE_LIBGNOMEUI
#include <libgnomeui/gnome-icon-theme.h>
#endif

G_BEGIN_DECLS

gchar * egg_recent_util_escape_underlines (const gchar *uri);
gchar * egg_recent_util_get_unique_id (void);
#ifndef USE_STABLE_LIBGNOMEUI
GdkPixbuf * egg_recent_util_get_icon (GnomeIconTheme *theme,
				      const gchar *uri,
				      const gchar *mime_type,
				      int size);
#endif

G_END_DECLS

#endif /* __EGG_RECENT_UTIL__ */
