/* Routines to manipulate transformations

  This code is part of xink, by Raph Levien.

  xink version 0.02

  Copyright 1997 Raph Levien <raph@acm.org>

  This code is free for commercial and non-commercial use or
  redistribution, as long as the source code release, startup screen,
  or product packaging includes this copyright notice.
*/

#include <math.h>
#include "xform.h"

/* Apply a transform to a point. */
void xform_point (point *dst, const xform *x, const point *src) {
  dst->x = src->x * x->scale + x->off_x;
  dst->y = src->y * x->scale + x->off_y;
}

/* Apply a transform to a rectangle. The new rectangle conforms to
   integer coordinates, and is conservative, i.e. fully encloses the
   "ideal" transformed rectangle. */
void xform_rect (rect *dst, const xform *x, const rect *src) {
  dst->x0 = floor (src->x0 * x->scale + x->off_x);
  dst->y0 = floor (src->y0 * x->scale + x->off_y);
  dst->x1 = ceil (src->x1 * x->scale + x->off_x);
  dst->y1 = ceil (src->y1 * x->scale + x->off_y);
}

/* Invert a transform. */
void xform_inv (xform *dst, const xform *src) {
  dst->scale = 1.0 / src->scale;
  dst->off_x = -dst->scale * src->off_x;
  dst->off_y = -dst->scale * src->off_y;
}

