/*  Etalk basic user-editable configuration
 *
 *  Copyright (C) 1994, 1995 Free Software Foundation
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, you can either send email to this
 *  program's author (see below) or write to:
 * 
 *               The Free Software Foundation, Inc.
 *               675 Mass Ave.
 *               Cambridge, MA 02139, USA. 
 * 
 *  Please send bug reports, etc. to zappo@gnu.org.
 *
 *  $Id: sitecnfg.h,v 1.7 1997/12/14 20:54:01 zappo Exp $
 * 
 * Configuration variables to for setting up etalk to be compiled
 */

/*
 * SYSTEM_RC and SYSTEM_HOST_RC are strings representing where the
 * system wide etalk rc files will reside.  Not defining this will
 * mean there will never be a system RC file.  Defineing it as
 * "/etc/hosts.talk" is safe, and there is no need for this file to
 * exist.  This file needs to be a specific file name, and not
 * relational.  SYSTEM_RC is for etalk commands, and SYSTEM_HOST_RC is
 * for host names.
 */
#ifndef SYSTEM_RC
#define SYSTEM_RC "/etc/gtalkrc"
#endif
#ifndef SYSTEM_HOST_RC
#define SYSTEM_HOST_RC "/etc/hosts.talk"
#endif

/* LOCAL_RC is a string representing the local users rc file.  This should
 * always be ".hosts.talk" since that is what the documentation points to.
 * Internally, start at the root of the user directory.
 */
#ifndef LOCAL_RC
#define LOCAL_RC ".hosts.talk"
#endif
#ifndef LOCAL_RC_ENV
#define LOCAL_RC_ENV "TALK_HOSTS"
#endif

/* SCRIPT_RC is a string representing the file in which script
 * commands to be run at startup are kept.  This file will be loaded
 * from the users top level directory.  If the ENV file is found
 * first, then the default is not used.
 */
#ifndef SCRIPT_RC
#define SCRIPT_RC ".gtalkrc"
#endif
#ifndef SCRIPT_RC_ENV
#define SCRIPT_RC_ENV "GTALKRC"
#endif

/* RINGER_RC is a string representing a file which will contain a
 * specification of how the talk daemon should ring the user it is
 * interested in.  This file name will be appended to a users home
 * directory when it is looked up.
 */
#ifndef RINGER_RC
#define RINGER_RC ".ringer"
#endif

/* BLACKLIST_FILE is a string representing the file located in the user's
 * home directory where a blacklist, or filter file is kept.
 */
#ifndef BLACKLIST_FILE
#define BLACKLIST_FILE ".talkfilter"
#endif

/* DEFAULT_PAGER is a string representing how to fork off a pager to
 * view a file.  This is for file transfers when the extension is not
 * known.  If the environment variable specified is set, that pager is
 * used instead.  The pager used must be an X application
 */
#ifndef DEFAULT_PAGER
#define DEFAULT_PAGER "xedit"
#endif
#ifndef DEFAULT_PAGER_ENV
#define DEFAULT_PAGER_ENV "TALK_XVIEW"
#endif

/* End of header */
