/*
 * Copyright (C) 1994, 95, 96, 97, 98 Free Software Foundation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you can either send email to this
 * program's author (see below) or write to:
 *
 *              The Free Software Foundation, Inc.
 *              675 Mass Ave.
 *              Cambridge, MA 02139, USA. 
 *
 * Please send bug reports, etc. to zappo@gnu.org
 *
 * $Log: gtalklib.h,v $
 * Revision 1.29  1998/10/11 11:41:33  zappo
 * Changed GTALK_VERSION to VERSION for automake.
 *
 * Revision 1.28  1998/05/01 16:43:33  zappo
 * Added new extension handling prototypes.
 *
 * Revision 1.27  1998/04/28 22:36:16  zappo
 * Added new function prototype.
 *
 * Revision 1.26  1998/01/04 15:16:20  zappo
 * Update copyright year.
 *
 * Revision 1.25  1997/12/14 19:20:07  zappo
 * Renamed package to gtalk, renamed symbols and files apropriately
 * Fixed copyright and email address.
 *
 * Revision 1.24  1997/10/18 03:02:29  zappo
 * Added a "verified" field to the host object.  This keeps track of when
 * we completely verify the deamon type of a given host.
 *
 * Revision 1.23  1997/07/23 01:22:01  zappo
 * Added debugging into the generic list w/ magic numbers.
 *
 * Revision 1.22  1997/07/11 21:27:27  zappo
 * Added generic list structures and prototypes.
 *
 * Revision 1.21  1997/02/23 03:22:42  zappo
 * API change on GT_clean_dev changes.
 *
 * Revision 1.20  1997/01/28 03:23:41  zappo
 * Prototype maintenance
 *
 * Revision 1.19  1997/01/26  15:33:51  zappo
 * Now uses ETALK_VERSION which is a string for the ETALKLIB_ macro
 *
 * Revision 1.18  1996/03/02  03:26:21  zappo
 * Updated prototypes and added a new IO device type (pipe)
 *
 * Revision 1.17  1995/12/10  01:12:16  zappo
 * Added a new prototype
 *
 * Revision 1.16  1995/11/21  04:03:07  zappo
 * Added many new prototypes, and the IO_FILE type
 *
 * Revision 1.15  1995/09/20  23:23:07  zappo
 * Updated some defines to be more stable in the X environment
 *
 * Revision 1.14  1995/05/27  01:37:53  zappo
 * Added new fn from gtl_x.c
 *
 * Revision 1.13  1995/05/09  23:48:33  zappo
 * Added gtl_cw.c prototypes
 *
 * Revision 1.12  1995/04/18  22:25:13  zappo
 * Added gtl_x.c references into the list.
 *
 * Revision 1.11  1995/04/10  21:41:44  zappo
 * Added prototypes for strdup and strtok on the off chance they don't
 * exist.
 *
 * Revision 1.10  1995/04/05  00:55:12  zappo
 * Chanded a definition
 *
 * Revision 1.9  1995/03/30  02:36:31  zappo
 * Added gtl_util's definitions
 *
 * Revision 1.8  1995/03/25  04:37:52  zappo
 * Typo from updating prototypes.
 *
 * Revision 1.7  1995/03/25  04:11:15  zappo
 * Updated copyright, and fixed non-ansi prototypes.
 *
 * Revision 1.6  1995/03/04  14:44:45  zappo
 * Added syslogdebug variable for debug level of syslog messages in
 * daemon.
 *
 * Revision 1.5  1995/02/01  03:39:13  zappo
 * Changed type of timeout in device, and added some functions.
 *
 * Revision 1.4  1995/01/28  16:22:41  zappo
 * Added some new ringer specific stuff
 *
 * Revision 1.3  1994/11/19  17:08:12  zappo
 * Added some new function prototypes and moved EMPTY to UNUSED
 * identifier
 *
 * Revision 1.2  1994/11/16  23:29:19  zappo
 * Moved some elements out of the talk library file.  May change it's
 * name soon.
 *
 * Revision 1.1  1994/08/29  23:42:07  zappo
 * Initial revision
 *
 */
#ifndef GTALKLIB_

#define GTALKLIB_ "GTALK library routines " VERSION \
" (c) 1994-98 Free Software Foundation"

#include "config.h"

/*
 * First, lets make some of those standard define we all love
 * to use.
 */
#ifndef TRUE
#  define TRUE 1
#endif
/* This was defined by X, but I never use it as a 0 */
#ifdef Success
#undef Success
#endif
#define Success 1
#ifndef FALSE
#  define FALSE 0
#endif
#define Fail 0

/*
 * Generic List Support
 */
struct GenericListNode {
  struct GenericListNode *next, *prev; /* linked list data  */
  int                     verify;      /* magic number      */
};

struct GenericList {
  struct GenericListNode *first, *last;	/* List Q data                */
  struct GenericList     *next;	        /* Next ptr for list o lists. */
  int                     verify;       /* Magic Number               */
};

#define MakeList(listvar) struct GenericList (listvar) = { NULL, NULL, NULL }
#define FirstElement(list) ((void *)(((struct GenericList *)&(list))->first))
#define NextElement(node) ((void *)(((struct GenericListNode *)(node))->next))

/*
 * Define an object which will be the input interface for
 * multiple sets of ports and types of input devices.
 */
enum InputDeviceType { IO_TTY = 0, IO_TCP = 1, IO_UDP = 2, IO_X = 3, 
			 IO_FILE = 4, IO_PIPE = 5 };

enum InputState { UNUSED = 0, CONNECTED = 1, LISTENING = 2, WAITING = 3,
		    IDLE = 4, DEAD = 5 };

enum DMN_deletion_type { DMN_invite, DMN_announce };

struct InputDevice {
  struct GenericListNode link;	    /* Linked List Data                    */
  enum InputDeviceType   type;	    /* type of IO port                     */
  enum InputState        state;	    /* current state                       */
  char                  *name;	    /* logical name to keep trak of this   */
  struct sockaddr_in     raddr;	    /* socket address of remote /listing   */
  struct sockaddr_in     lraddr;    /* recv anyone, this is last snder     */
  struct sockaddr_in     laddr;	    /* socket address of local's name      */
  int                    fd;	    /* file descriptor                     */
  struct HostObject     *host;	    /* host we are attached to             */
  long                   sendc;	    /* number of send char/units           */
  long                   recvc;	    /* number of recieve char/units        */
  void                 (*readme)(); /* what to do when there is input      */
  int                    timeout;   /* when to timeout (global seconds)    */
  void                 (*timefn)(); /* what to do when there is no input   */
  void                 (*timemsg)();/* msg to print when there is no input */
};

/*
 * Describe hosts structures.  Host structures are only used
 * when attempting to connect to a hosts TALKD, and that is 
 * what all states represent.
 */
				/* GTALKD is stub for later */
enum DaemonType { OTALKD = 0, NTALKD = 1, GTALKD = 2 };
enum RCFileType { RC_system, RC_local, RC_new, RC_changed };

struct HostObject {
  struct GenericListNode link;	  /* Linked List Data                      */
  char                  *name;	  /* official name of the machine          */
  enum DaemonType        type;	  /* type of the daemon                    */
  unsigned char          verified;/* non-nil if we have verified this host */
  enum RCFileType        rc;	  /* where was daemon info from            */
  struct sockaddr_in     addr;	  /* host address structure.               */
  int                    addr_len;/* length of address from host ent       */
};

/* There needs to be a verbose and syslogdebug variable defined in main.
 */
extern int verbose;
extern int syslogdebug;

/*
 * Now lets advertise some function prototypes used in
 * controlling objects.  DISP_message must be declared
 * within the context of the running application for
 * library parts to work.
 */
extern void DISP_message();

#ifdef PROTOTYPES
/* gtl_list.c */
extern struct GenericListNode *LIST_alloc(struct GenericList *list, size_t size);
extern struct GenericListNode *LIST_find(struct GenericList *list, unsigned char (*predicate)(), void *criteria);
extern struct GenericListNode *LIST_find_next(struct GenericListNode *start, unsigned char (*predicate)(), void *criteria);
extern int LIST_map(struct GenericList *list, void (*predicate)(), void *data);
extern void LIST_deallocate(struct GenericList *list, void *node);
extern void LIST_verify();

/* gtl_dev.c */
extern struct InputDevice *GT_gen_iodev(enum InputDeviceType type, int fd, struct sockaddr_in  *raddr);
extern struct sockaddr_in GT_portable_address(struct InputDevice *dev);
extern int GT_select_all(void *Ctxt, struct InputDevice *reton);
extern int GT_select_one(void *Ctxt, struct InputDevice *dev);
extern void GT_close_all(void *Ctxt, struct InputDevice *save);
extern void GT_set_quicktimer(void (*fn)(), struct InputDevice *dev);
extern struct InputDevice *GT_tty();
extern struct InputDevice *GT_pipe(int pipefd, char *appname, char *direct);
extern struct InputDevice *GT_open_output_file(char *name);
extern int GT_send(struct InputDevice *dev, void *buffer, int size);
extern int GT_recv(struct InputDevice *dev, void *buffer, int size);
extern char *GT_dev_name(struct InputDevice *io);
extern void GT_end_recursion();

extern void GT_print_q_list();
extern void GT_clean_dev(struct InputDevice *io, int clean);
extern void GT_clean();
extern int GT_dev_num();
extern void GT_print_device(struct InputDevice *io);
extern void print_swapped_sockaddr(struct sockaddr *addr);
extern void print_sockaddr(struct sockaddr *addr);

/* gtl_tcp.c */
extern struct InputDevice *TCP_listen();
extern struct InputDevice *TCP_connect(struct sockaddr *addr);
extern struct InputDevice *TCP_accept(struct InputDevice *listening);

/* gtl_udp.c */
extern struct sockaddr_in *UDP_receive_port();
extern void                UDP_setup_localport();
extern struct InputDevice *UDP_host(char *machine);
extern int                 UDP_daemon_change( struct InputDevice *io );
extern struct InputDevice *UDP_servent(const char *servent_name);
extern struct InputDevice *UDP_byaddr(struct InputDevice *dev, struct sockaddr_in *addr);
extern struct InputDevice *UDP_stdin();
extern void                UDP_reset_ports();

/* gtl_host.c */
extern struct HostObject *HOST_gen_local_host();
extern struct HostObject *HOST_gen_host( char *machine );
extern struct HostObject *HOST_gen_host_by_addr( struct sockaddr *addr, int size );
extern void               HOST_print();
extern int                HOST_number();

/* gtl_ring.c */
extern int RING_activate(char *user, int *rf, struct InputDevice *rs, void (*rm)());
extern int RING_deactivate(char *user);
extern struct InputDevice *RING_open(char *ringfile, struct InputDevice *udp);
extern void RING_print_control();
extern void RING_print_response();

/* gtl_extend.c */
extern void EXT_clear_extension_data();
extern int EXT_extension_length();
extern void EXT_add_extension_data(u_char type, void *data);
extern void *EXT_fetch_extension_data(u_char type, void *extend, int *length);

/* gtl_util.c */
extern int GTL_scmp(const char *s1, const char *s2, int   len);
extern char *GTL_gethome(char *user, int   self);
#ifndef HAVE_STRDUP
extern char *strdup(const char *__s);
#endif
#ifndef HAVE_STRTOK
extern char *strtok(char *__s, const char *__delim);
#endif

/* gtl_cw.c */
extern void CW_display_copywrite();

#ifdef _XLIB_H_
/* gtl_x.c */
extern struct InputDevice *GTL_x(Display *display);
#ifdef _XRESOURCE_H_
extern int GTL_get_resource(Display *display, char *name, char *class, XrmValue *value);
#endif /* _XRESOURCE_H_ */

#endif /* _XLIB_H_ */

#else /* PROTOTYPES */
/* gtl_list.c */
extern struct GenericListNode *LIST_alloc();
extern struct GenericListNode *LIST_find();
extern struct GenericListNode *LIST_find_next();
extern int LIST_map();
extern void LIST_deallocate();
extern void LIST_verify();

/* gtl_dev.c */
extern struct InputDevice *GT_gen_iodev();
extern struct sockaddr_in GT_portable_address();
extern int GT_select_all();
extern int GT_select_one();
extern void GT_close_all();
extern void GT_set_quicktimer();
extern struct InputDevice *GT_tty();
extern struct InputDevice *GT_pipe();
extern struct InputDevice *GT_open_output_file();
extern int GT_send();
extern int GT_recv();
extern char *GT_dev_name();
extern void GT_end_recursion();
extern void GT_print_q_list();
extern void GT_clean_dev();
extern void GT_clean();
extern int GT_dev_num();
extern void GT_print_device();
extern void print_swapped_sockaddr();
extern void print_sockaddr();

/* gtl_tcp.c */
extern struct InputDevice *TCP_listen();
extern struct InputDevice *TCP_connect();
extern struct InputDevice *TCP_accept();

/* gtl_udp.c */
extern struct sockaddr_in *UDP_receive_port();
extern void                UDP_setup_localport();
extern struct InputDevice *UDP_host();
extern int                 UDP_daemon_change();
extern struct InputDevice *UDP_servent();
extern struct InputDevice *UDP_byaddr();
extern struct InputDevice *UDP_stdin();
extern void                UDP_reset_ports();

/* gtl_host.c */
extern struct HostObject *HOST_gen_local_host();
extern struct HostObject *HOST_gen_host();
extern struct HostObject *HOST_gen_host_by_addr();
extern void               HOST_print();
extern int                HOST_number();

/* gtl_ring.c */
extern int RING_activate();
extern int RING_deactivate();
extern struct InputDevice *RING_open();
extern void RING_print_control();
extern void RING_print_response();

/* gtl_extend.c */
extern void EXT_clear_extension_data();
extern int EXT_extension_length();
extern void EXT_add_extension_data();
extern void *EXT_fetch_extension_data();

/* gtl_msgm.c */
extern char *msg_types[];
extern char *msg_responses[];
extern int control_size();
extern int response_size();
extern void ETM_control_print();
extern int DMN_check_compile();
extern int Response_Display();
extern int ETM_response_print();

/* gtl_util.c */
extern int GTL_scmp();
extern char *GTL_gethome();
#ifndef HAVE_STRDUP
extern char *strdup();
#endif
#ifndef HAVE_STRTOK
extern char *strtok();
#endif

/* gtl_cw.c */
extern void CW_display_copywrite();

#ifdef _XLIB_H_
/* gtl_x.c */
extern struct InputDevice *GTL_x();
#ifdef _XRESOURCE_H_
extern int GTL_get_resource();
#endif /* _XRESOURCE_H_ */

#endif /* _XLIB_H_ */

#endif /* PROTOTYPES */

#endif /* etalklib_ */
