#! /bin/sh
#
# $Id: configure.gnu,v 1.1 2004/11/26 18:49:38 rmanfredi Exp $
#
# GNU configure-like front end to metaconfig's Configure.
#
# Written by Andy Dougherty <doughera@lafcol.lafayette.edu>
# Matthew Green <mrg@mame.mu.oz.au> and Tom Tromey <tromey@cygnus.com>.
#
# Reformatted and modified for inclusion in the dist-3.0 package by
# Raphael Manfredi <Raphael_Manfredi@grenoble.hp.com>.
#
# This script belongs to the public domain and may be freely redistributed.
#
# The remaining of this leading shell comment may be removed if you
# include this script in your own package.
#
# $Log: configure.gnu,v $
# Revision 1.1  2004/11/26 18:49:38  rmanfredi
# Moved from configure
#
# Revision 1.59  2004/07/12 22:13:17  rmanfredi
# Added GNU configure-like front end to Configure.
#
# Revision 3.0.1.2  1997/02/28  16:28:49  ram
# patch61: added the srcdir support now that we have src.U
# patch61: random cleanup for nicer help message
#
# Revision 3.0.1.1  1995/07/25  14:16:21  ram
# patch56: created
#

(exit $?0) || exec sh $0 $argv:q
opts=''
verbose=''
create='-e'
srcdir=''
while test $# -gt 0; do
	case $1 in
    --help)
		cat <<EOM
Usage: configure [options]
This is GNU configure-like front end for a metaconfig-generated Configure.
It emulates the following GNU configure options (must be fully spelled out):

    --help               --srcdir=DIRECTORY
    --no-create          --silent
    --prefix=PREFIX      --verbose
    --quiet              --version

And it honours these environment variables: CC, CFLAGS and DEFS.

Furthermore, it ignores the following arguments, when supplied:

    --cache-file=FILE    --target=TARGET
    --enable-*           --with-*
    --host=HOST
EOM
		exit 0
		;;
	--no-create)
		create='-E'
		shift
		;;
	--prefix=*)
		arg=`echo $1 | sed 's/--prefix=/-Dprefix=/'`
		opts="$opts $arg"
		shift
		;;
	--prefix)
		shift
		opts="$opts -Dprefix=$1"
		shift
		;;
	--srcdir=*)
		arg=`echo $1 | sed 's/--srcdir=//'`
		srcdir=$arg
		shift
		;;
	--srcdir)
		shift
		srcdir=$1
		shift
		;;
	--quiet|--silent)
		exec >/dev/null 2>&1
		shift
		;;
	--verbose)
		verbose=true
		shift
		;;
	--version)
		copt="$copt -V"
		shift
		;;
	--host=*|--target=*|--cache-file=*|--enable-*|--with-*)
		shift
		;;
	--*)
		opt=`echo $1 | sed 's/=.*//'`
		echo "This GNU configure front end does not understand $opt"
		exit 1
		;;
	*)
		opts="$opts $1"
		shift
		;;
	esac
done

case "$CC" in
'') ;;
*) opts="$opts -Dcc='$CC'";;
esac

# Join DEFS and CFLAGS together.
ccflags=''
case "$DEFS" in
'') ;;
*) ccflags=$DEFS;;
esac
case "$CFLAGS" in
'') ;;
*) ccflags="$ccflags $CFLAGS";;
esac
case "$ccflags" in
'') ;;
*) opts="$opts -Dccflags='$ccflags'";;
esac

# Don't use -s if they want verbose mode
case "$verbose" in
'') copt="$copt -ds";;
*) copt="$copt -d";;
esac

# Figure out srcdir if not set already
case "$srcdir" in
'') srcdir=`echo $0 | sed -e 's%/[^/][^/]*$%%'`;;
esac
case "$srcdir" in
".") ;;
*) opts="$opts -Dsrc=$srcdir";;
esac

set X sh $srcdir/Configure $copt $create $opts
shift
echo "$@"
exec "$@"
