// GtkSharp.Generation.EnumGen.cs - The Enumeration Generatable.
//
// Author: Mike Kestner <mkestner@speakeasy.net>
//
// Copyright (c) 2001 Mike Kestner
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the
// Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.


namespace GtkSharp.Generation {

	using System;
	using System.IO;
	using System.Xml;

	public class EnumGen : GenBase, IGeneratable  {
		
		public EnumGen (XmlElement ns, XmlElement elem) : base (ns, elem) {}
		
		public string MarshalType {
			get
			{
				return "int";
			}
		}
		public string MarshalReturnType {
			get
			{
				return MarshalType;
			}
		}

		public string CallByName (string var_name)
		{
			return "(int) " + var_name;
		}
		
		public string FromNative(string var)
		{
			return "(" + QualifiedName + ")" + var;
		}
		
		public string FromNativeReturn(string var)
		{
			return FromNative (var);
		}

		public virtual string ToNativeReturn(string var)
		{
			return CallByName (var);
		}
		
		public void Generate ()
		{
			GenerationInfo gen_info = new GenerationInfo (NSElem);
			Generate (gen_info);
		}

		public void Generate (GenerationInfo gen_info)
		{
			StreamWriter sw = gen_info.OpenStream (Name);

			sw.WriteLine ("namespace " + NS + " {");
			sw.WriteLine ();
			sw.WriteLine ("\tusing System;");
			sw.WriteLine ();

			if (Elem.GetAttribute("type") == "flags") {
				sw.WriteLine ();
				sw.WriteLine ("\t[Flags]");
			}

			// Ok, this is obscene.  We need to go through the enums first
			// to find "large" values.  If we find some, we need to change
			// the base type of the enum.

			string enum_type = null;

			foreach (XmlNode node in Elem.ChildNodes) {
				if (!(node is XmlElement) || node.Name != "member") {
					continue;
				}

				XmlElement member = (XmlElement) node;

				if (member.HasAttribute("value")) {
					string value = member.GetAttribute("value");
					if (value.EndsWith("U")) {
						enum_type = "uint";
						member.SetAttribute("value", value.TrimEnd('U'));
					}
				}
			}

			sw.WriteLine ("#region Autogenerated code");
					
			if (enum_type != null)
				sw.WriteLine ("\tpublic enum " + Name + " : " + enum_type + " {");
			else
				sw.WriteLine ("\tpublic enum " + Name + " {");

			sw.WriteLine ();
				
			foreach (XmlNode node in Elem.ChildNodes) {
				if (!(node is XmlElement) || node.Name != "member") {
					continue;
				}
				
				XmlElement member = (XmlElement) node;

				sw.Write ("\t\t" + member.GetAttribute("name"));
				if (member.HasAttribute("value")) {
					sw.WriteLine (" = " + member.GetAttribute("value") + ",");
				} else {
					sw.WriteLine (",");
				}
			}

			sw.WriteLine ("\t}");
			sw.WriteLine ("#endregion");
			sw.WriteLine ("}");
			sw.Close ();
			Statistics.EnumCount++;
		}
		
	}
}

