/* 
** attributes.c: Handles the attributes of widgets
** copyright: (c) 2003 by Lszl Pere
** email: pipas@linux.pte.hu
**
** This program is free software; you can redistribute it and/or 
** modify  it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of
** the License, or (at your option) any later version.
**
** $Id:$
** $Log:$
*/

#include <gtk/gtk.h>
#include "gtkdialog.h"
#include "attributes.h"
#include "stringman.h"

AttributeSet *attributeset_new(void)
{
	AttributeSet *new_set;
	int n;

	new_set = pip_malloc(sizeof(AttributeSet), __func__);
	new_set->n_attr = ATTRNUMBER;
	new_set->attr = pip_malloc(sizeof(GList *) * ATTRNUMBER, __func__);
	new_set->_pointer = pip_malloc(sizeof(int) * ATTRNUMBER, __func__);
	for (n = 0; n < ATTRNUMBER; ++n) {
		new_set->attr[n] = NULL;
		new_set->_pointer[n] = NULL;
	}
	return (new_set);
}

gboolean attributeset_is_avail(AttributeSet * set, int attribute)
{
	if (set == NULL | attribute < 0 | attribute >= ATTRNUMBER)
		return FALSE;

	if (set->attr[attribute] == NULL)
		return FALSE;
	else
		return TRUE;
}

gboolean attributeset_cmp_left(AttributeSet * set, int attribute,
			       const char *str)
{
	Attribute *a;
	g_assert(set != NULL && str != NULL);
	
	if (!attributeset_is_avail(set, attribute))
		return (FALSE);
	
	a = set->attr[attribute]->data;
	if (strncasecmp(a->text, str, strlen(str)) == 0)
		return (TRUE);
	
	return (FALSE);
}

char *attributeset_get_first(AttributeSet * set, int attribute)
{
	Attribute *a;
	g_assert(set != NULL);
	
	if (attribute >= set->n_attr || set->attr[attribute] == NULL) {
#ifdef DEBUG
		fprintf(stderr, "%s(): Warning, first argument is NULL.\n",
			__func__);
		fflush(stderr);
#endif
		return (NULL);
	}

	set->_pointer[attribute] = set->attr[attribute];
	a = set->_pointer[attribute]->data;
	return a->text;
}

char *attributeset_get_this_tagattr(
		AttributeSet *set,
		int attribute,
		const char *name){
	tag_attr *t;
	int q;
	
	g_assert(set != NULL && name != NULL);

#ifdef DEBUG
	fprintf(stderr, "%s(): Searching for '%s'...\n", __func__, name);
	fflush(stderr);
#endif

	if (attribute >= set->n_attr || set->_pointer[attribute] == NULL)
		return NULL;
	
	t = ((Attribute *)set->_pointer[attribute]->data)->tag_attributes;
	for (q = 0; q < t->n; ++q){
		if ( strncasecmp(t->pairs[q].name, name, strlen(t->pairs[q].name) - 1) == 0){
			return t->pairs[q].value;
		}
	}
	
	return NULL;
}

char *attributeset_get_next(AttributeSet * set, int attribute)
{
	Attribute *a;
	
	g_assert(set != NULL);
	
	if (attribute >= set->n_attr || 
			g_list_next(set->_pointer[attribute]) == NULL)
		return (NULL);
	
	set->_pointer[attribute] = g_list_next(set->_pointer[attribute]);
	
	a = set->_pointer[attribute]->data;
	return (a->text);
}


char *attributeset_set_if_unset(AttributeSet * set, int attribute,
				const char *s)
{
	Attribute *a;
	g_assert(set != NULL && s != NULL);
	g_assert(attribute <= set->n_attr);

#ifdef DEBUG	
	fprintf(stderr, "%s(): Start.\n", __func__);
	fprintf(stderr, "%s(): Setting a default value %d <- '%s'.\n", 
			__func__, attribute, s);
	fflush(stderr);
#endif
	
	if (attributeset_is_avail(set, attribute))
		return attributeset_get_first(set, attribute);
	
	return (attributeset_insert(set, attribute, s));
}

char *attributeset_insert_with_tagattrs(AttributeSet * set, 
		          		int attribute, 
			  		const char *s,
			  		tag_attr *tag_attributes){

	char *value;
	Attribute *a;
	/* Some error checking needed. 
	 */
	if (s == NULL) s = "(null)";
	if (set == NULL) set = attributeset_new();

	/* 
        ** FIXME: We should allocate more memory
	*/
	if (attribute >= set->n_attr || attribute < 0) {
		fprintf(stderr, "%s(): Invalid attribute: %d\n", __func__,
			attribute);
		return (NULL);
	}

	/* We make a copy of the string and insert into the list. The 
	 * return value is the newly allocated string.
	 */
	value = strdup(s);
	a = pip_malloc(sizeof(Attribute), __func__);
	a->text = value;
	a->tag_attributes = tag_attributes;
	set->attr[attribute] = g_list_append(set->attr[attribute], a);
	return value;
}

char *attributeset_insert(AttributeSet * set, 
		          int attribute, 
			  const char *s)
{
	tag_attr *text = new_tag_attributeset("text", s);	
	return attributeset_insert_with_tagattrs(set, attribute, s, text);
}

