#include <stdlib.h>
#include <stdio.h>
#include <gtk/gtk.h>
#include "stack.h"
#include "gtkdialog.h"

#ifndef STACKSIZE
#define STACKSIZE 2048 
#endif


stackelement stack[STACKSIZE];
int sp = 0;

void push_widget(GtkWidget * widget, int widgettype)
{
	stackelement s;
	s.nwidgets = 1;
	s.widgets[0] = widget;
	s.widgettypes[0] = widgettype;
	push(s);
}


void push(stackelement new)
{
#ifdef DEBUG
	fprintf(stderr, "%s: start\n", __func__);
	fflush(stderr);
#endif
	if (sp == STACKSIZE) {
		fprintf(stderr, "Stack overflow.\n");
		exit(EXIT_FAILURE);
	}
	stack[sp++] = new;
#ifdef DEBUG
	fprintf(stderr, "%s: stack pointer: %d\n", __func__, sp);
	fflush(stderr);
#endif
}

stackelement pop()
{
	if (sp == 0) {
		fprintf(stderr, "Stack underflow.\n");
		fflush(stderr);
		exit(EXIT_FAILURE);
	}
	sp--;

#ifdef DEBUG
	fprintf(stderr, "%s: stack pointer: %d\n", __func__, sp);
	fflush(stderr);
#endif

	return (stack[sp]);
}
