/* 
** stringman.c: Special string maniplutations.
** copyright: (c) 2003 by Lszl Pere
** email: pipas@linux.pte.hu
**
** This program is free software; you can redistribute it and/or 
** modify  it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of
** the License, or (at your option) any later version.
**
** $Id: stringman.c,v 1.1 2004/11/16 20:43:31 root Exp root $
** $Log: stringman.c,v $
** Revision 1.1  2004/11/16 20:43:31  root
** Initial revision
**
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include "gtkdialog.h"
#include "stringman.h"
#include "memory.h"
#include "widgets.h"

#define IN_TEXT         1
#define IN_SEPARATOR    2

char *find_pixmap(char *filename)
{
	char tmp[128];
	static char *line = NULL;
	static int length = 0;
	FILE *locate;

	if (access(filename, R_OK) == 0)
		return filename;

	snprintf(tmp, 127, "/usr/share/icons/Bluecurve/16x16/stock/%s",
			filename);
	tmp[127] = '\0';
	if (access(tmp, R_OK) == 0)
		return strdup(tmp);


	snprintf(tmp, 127, "locate /%s", filename);
	tmp[127] = '\0';

	locate = popen(tmp, "r");
	if (!locate)
		return "";

	while (getline(&line, &length, locate) != -1) {
		line[strlen(line) - 1] = '\0';
		if (access(line, R_OK) == 0) {
			pclose(locate);
			return line;
		}
	}
}

/*
 *  Cutting the line to substrings with the given field separator.
 */
list_t *linecutter(char *str, int fs)
{
	list_t *parts;
	int n, q;
	
	g_assert(str != NULL);
#ifdef DEBUG
	fprintf(stderr, "%s(): Starting.\n", __func__);
	fflush(stderr);
#endif

	parts = pip_malloc(sizeof(list_t), __func__);
	parts->line = pip_malloc(sizeof(char *) * 128, __func__);
	parts->maxlines = 128;
	parts->line[0] = str;
	parts->n_lines = 1;
	
	for(n = 0; n <= strlen(str); ++n){
		if (str[n] == fs){
			parts->line[parts->n_lines] = strdup(str + n + 1);
			++parts->n_lines;
		}
	}
	
	parts->line[parts->n_lines] = NULL;

	for (n = 0; n < parts->n_lines - 1; ++n){
		for (q = 0; q < strlen(parts->line[n]); ++q)
			if (*(parts->line[n] + q) == fs)
				*(parts->line[n] + q)= '\0';
	}
	return parts;
}

/*
** This function will give a default name for widgets, so every
** widget can get a variable name.
*/
char *str_default_name(int itype)
{
	static int serial = 0;
	char *type;
	char *name;

	name = pip_malloc(64, __func__);

	++serial;
	type = widgets_to_str(itype);
	sprintf(name, "%s%03d", type, serial);
	return (name);
}

char *get_tag_attribute(tag_attr *attr, char *name){
	int q;

	if (attr == NULL || name == NULL)
		return NULL;


	for (q = 0; q < attr->n; ++q){
		if (strcmp(attr->pairs[q].name, name) == 0)
			return attr->pairs[q].value;
	}

	return NULL;
}

tag_attr *add_tag_attribute(tag_attr *attr, char *name, char *value){
	g_assert(attr != NULL);
	g_assert(name != NULL && value != NULL);

	//
	// If the store is full, we enlarge its size.
	//
	if (attr->n == attr->nmax){
		attr->nmax += 32;
		attr->pairs = g_realloc(attr->pairs,
				attr->nmax * sizeof(namevalue));
	}

	attr->pairs[attr->n].name = g_strdup(name);
	attr->pairs[attr->n].value = g_strdup(value);
	++attr->n;
	return attr;
}

/*
 * Simple functions to handle attributesets, name/value pair list.
 */
tag_attr *new_tag_attributeset(char *name, char *value){
	tag_attr *New;

	g_assert(name != NULL);
	g_assert(value != NULL);
#ifdef DEBUG
	fprintf(stderr, "%s(): Name: '%s' Value: '%s'.\n",
			__func__, name, value);
	fflush(stderr);
#endif
	New = pip_malloc(sizeof(tag_attr), __func__);
	
	New->pairs = pip_malloc(sizeof(namevalue) * 32, __func__);
	New->nmax = 32;
	New->n = 1;
	
	New->pairs[0].name = g_strdup(name);
	New->pairs[0].value = g_strdup(value);
#ifdef DEBUG
	fprintf(stderr, "%s(): end\n", __func__);
	fflush(stderr);
#endif
	return New;
}

