/*Written with Emacs.*/
/*
  GtkDiskFree shows free space on your mounted partitions.  Copyright
  (C) 2001-2002 Dj-Death (Landwerlin Lionel)
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
  USA */

#include "main.h"
#include "utils.h"
#include "configure.h"
#include "widgets.h"
#include "interface.h"
#include "diskfree.h"
#include "mount.h"

#include "icons/error.xpm"

void
open_cmd_tube (const gchar *cmd, const gchar *mount_point)
{
	gint status;
	gchar error[MAXLINE], *line;
	FILE *sh, *tmp;
	
	setbuf(stdout, error);
	line = g_strconcat(cmd, " ", mount_point, " &> ", TUBE_NAME, NULL);
	sh = popen(line, "r");
	g_free(line);
	
	status = pclose(sh);
	
	if (status == 0) {
		remove(TUBE_NAME);
		gui_list_main_update(GTK_TREE_VIEW(list_treeview));
		
		return;
	} else {
		if ((tmp = fopen(TUBE_NAME, "r")) == NULL) {
			gui_list_main_update(GTK_TREE_VIEW(list_treeview)); 
			
			return;
		}
		if (fgets(error, MAXLINE-1, tmp) == NULL) {
			fclose(tmp);
			remove(TUBE_NAME);
			gui_list_main_update(GTK_TREE_VIEW(list_treeview));
			
			return;
		}
		fclose(tmp);
		remove(TUBE_NAME);
		error_window(error);
	}
	gui_list_main_update(GTK_TREE_VIEW(list_treeview));
	
	return;
}

void
mount_fs (const gchar *mount_point, const gchar *type)
{
	if (!strcmp(type, SMBFS_TYPE))
		open_cmd_tube(options->smbmount_cmds[0], mount_point);
	else
		open_cmd_tube(options->mount_cmds[0], mount_point);
	
	return;
}

void
umount_fs (const gchar *mount_point, const gchar *type)
{
	if (!strcmp(type, SMBFS_TYPE))
		open_cmd_tube(options->smbmount_cmds[1], mount_point);
	else
		open_cmd_tube(options->mount_cmds[1], mount_point);
	
	return;
}

void
error_window (const gchar *text)
{
	gchar *lbl;
	GtkWidget *window;
	GtkWidget *hbox;
	GtkWidget *label;
	GtkWidget *button;
	GtkWidget *pixmap;
	
	window = gtk_dialog_new();
	gtk_window_set_resizable(GTK_WINDOW(window), FALSE);
	gtk_window_set_title(GTK_WINDOW(window), _("gtkdiskfree : error"));
	gtk_window_set_modal(GTK_WINDOW(window), TRUE);
	gtk_container_set_border_width(GTK_CONTAINER(window), 8);
	gtk_widget_realize(window);
	
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->vbox),
			   hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);
	
	pixmap = widget_pixmap_create_from_data(window->window, error_xpm);
	gtk_box_pack_start(GTK_BOX(hbox),
			   pixmap, FALSE, FALSE, 0);
	gtk_widget_show(pixmap);
	
	
	lbl = g_strdup_printf("error : %s", text);
	label = gtk_label_new(lbl);
	g_free(lbl);
	gtk_box_pack_start(GTK_BOX(hbox), label,
			   FALSE, FALSE, 0);
	gtk_widget_show(label);
	
	button = gtk_button_new_with_label(_("OK"));
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	g_signal_connect_swapped(G_OBJECT(button), "clicked",
				 G_CALLBACK(gtk_widget_destroy),
				 G_OBJECT(window));
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->action_area),
			   button, TRUE, TRUE, 0);
	gtk_widget_grab_default(button);
	gtk_widget_show(button);
	
	gtk_widget_show(window);
	
	return;
}
