// -*- C++ -*-

/* window_test_plotcanvas.cc
 * 
 * Copyright (C) 2000 GtkExtra-- Development Team  
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "window_test_plotcanvas.h"
#include "icons.h"
#include <math.h>

Window_Test_PlotCanvas::Window_Test_PlotCanvas()
: m_VBox(false, 0),
  m_PlotCanvas(GTK_PLOT_LETTER_W, GTK_PLOT_LETTER_H, 1),
  m_Plot1(0, .5, .25),
  m_Plot2(0, .5, .25),
  m_Button1("1"),
  m_Button2("2"),
  m_vecDataSets(5)
{ 
  set_title("GtkExtra::PlotCanvas Demo");
  set_usize(550, 650);
  m_VBox.set_border_width(0);
  add(m_VBox);

  m_ScrolledWindow.set_border_width(0);
  m_ScrolledWindow.set_policy(GTK_POLICY_ALWAYS, GTK_POLICY_ALWAYS);
  m_VBox.pack_start(m_ScrolledWindow, true, true, 0);
  
  m_PlotCanvas.set_flags(GTK_PLOT_CANVAS_DND_FLAGS);
  m_ScrolledWindow.add_with_viewport(m_PlotCanvas);

  //Plot 1:
  m_PlotCanvas.set_active_plot(m_Plot1);
  m_Plot1.set_range(-1. ,1., -1., 1.4);
  m_Plot1.legends_move( .500, .05);
  m_Plot1.set_legends_border(GTK_PLOT_BORDER_NONE,0);
  m_Plot1.axis_hide_title(GTK_PLOT_AXIS_TOP);
  m_Plot1.axis_show_ticks(GTK_PLOT_AXIS_BOTTOM, 15, 3);
  m_Plot1.axis_set_ticks(GTK_PLOT_AXIS_X, 1., 1);
  m_Plot1.axis_set_ticks(GTK_PLOT_AXIS_Y, 1., 1);
  m_Plot1.axis_set_visible(GTK_PLOT_AXIS_TOP, true);
  m_Plot1.axis_set_visible(GTK_PLOT_AXIS_RIGHT, true);
  m_Plot1.x0_set_visible(true);
  m_Plot1.y0_set_visible(true);

  m_PlotCanvas.add_plot(m_Plot1, .15, .06);

  build_example1(m_Plot1);
  m_Plot1.show();
 
  //Plot 2:
  Gdk_Color color("light yellow");
  m_Plot2.get_colormap().alloc(color);
  m_Plot2.set_background(color);

  color.parse("light blue");
  m_PlotCanvas.get_colormap().alloc(color);
  m_Plot2.legends_set_attributes(0, 0, Gdk_Color(0), color);
  m_Plot2.set_range(0. , 1., 0., .85);
  m_Plot2.axis_set_visible(GTK_PLOT_AXIS_TOP, TRUE);
  m_Plot2.axis_set_visible(GTK_PLOT_AXIS_RIGHT, TRUE);
  m_Plot2.grids_set_visible(TRUE, TRUE, TRUE, TRUE);
  m_PlotCanvas.add_plot(m_Plot2, .15, .4);
  m_Plot2.axis_hide_title(GTK_PLOT_AXIS_TOP);
  m_Plot2.axis_hide_title(GTK_PLOT_AXIS_RIGHT);
  m_Plot2.set_legends_border(GTK_PLOT_BORDER_SHADOW, 3);
  m_Plot2.legends_move(.58, .05);

  build_example2(m_Plot2);
  m_Plot2.show();
  
  m_PlotCanvas.put_text(.40, .020,
		  "Times-BoldItalic", 16, 0, Gdk_Color(0), Gdk_Color(0), true,
		  GTK_JUSTIFY_CENTER,
		  "DnD titles, legends and plots");
  m_PlotCanvas.put_text( .40, .72, 
		   "Times-Roman", 16, 0, Gdk_Color(0), Gdk_Color(0), true,
		   GTK_JUSTIFY_CENTER,
		   "You can use \\ssubindices\\b\\b\\b\\b\\b\\b\\b\\b\\b\\b\\N\\Ssupraindices");
  m_PlotCanvas.put_text(.40, .745,  
		  "Times-Roman", 16, 0, Gdk_Color(0), Gdk_Color(0), true,
		  GTK_JUSTIFY_CENTER,
		  "Format text mixing \\Bbold \\N\\i, italics, \\ggreek \\4\\N and \\+different fonts");

  //TODO: Wrap this:
  //See discussion in GtkExtra list.
  GtkPlotCanvasChild* pChild = gtk_plot_canvas_child_new(GTK_PLOT_CANVAS_CUSTOM);
  pChild->draw_child = ::draw_child; //Address of function.

  m_PlotCanvas.put_child(*pChild, .5, .5, .58, .56);

 
  m_PlotCanvas.select_item.connect(slot(this, &Window_Test_PlotCanvas::on_PlotCanvas_select_item));

  //Buttons:
  m_Button1.set_usize(20, 20);
  m_Button2.set_usize(20, 20);
  m_PlotCanvas.put(m_Button1, 0, 0);
  m_PlotCanvas.put(m_Button2, 20, 0);
  
  m_Button1.toggled.connect(bind<gint>(slot(this, &Window_Test_PlotCanvas::on_Button_toggled), 1));
  m_Button2.toggled.connect(bind<gint>(slot(this, &Window_Test_PlotCanvas::on_Button_toggled), 2));

  activate_plot(2);

  show_all();
  
  // show the window before printing !!!
  m_PlotCanvas.export_ps("demoplot.ps", GTK_PLOT_PORTRAIT, false, GTK_PLOT_LETTER);
  //m_Plot2.export_ps("plotdemo.eps", GTK_PLOT_PORTRAIT, true, GTK_PLOT_LETTER);
}

Window_Test_PlotCanvas::~Window_Test_PlotCanvas()
{
}

gint Window_Test_PlotCanvas::delete_event_impl(GdkEventAny*)
{ 
  Gtk::Main::quit();
  return 0; 
}

void
Window_Test_PlotCanvas::build_example1(GtkExtra::Plot& refPlot)
{

 static gdouble px1[]={0., 0.2, 0.4, 0.6, 0.8, 1.0};
 static gdouble py1[]={.2, .4, .5, .35, .30, .40};
 static gdouble dx1[]={.2, .2, .2, .2, .2, .2};
 static gdouble dy1[]={.1, .1, .1, .1, .1, .1};

 static gdouble px2[]={0., -0.2, -0.4, -0.6, -0.8, -1.0};
 static gdouble py2[]={.2, .4, .5, .35, .30, .40};
 static gdouble dx2[]={.2, .2, .2, .2, .2, .2};
 static gdouble dy2[]={.1, .1, .1, .1, .1, .1};

 //Custom tick labels:
 refPlot.axis_use_custom_tick_labels(GTK_PLOT_AXIS_RIGHT, true);
 GtkExtra::PlotAxis* pPlotAxisRight = refPlot.get_axis(GTK_PLOT_AXIS_RIGHT);
 
 if(pPlotAxisRight)
 {
   //TODO: why does this segfault?
   //pPlotAxisRight->tick_label.connect(slot(this, &Window_Test_PlotCanvas::on_axis_tick_label));
 }

 Gdk_Colormap colormap = refPlot.get_colormap();

 m_vecDataSets[0] = new GtkExtra::PlotData;
 refPlot.add_data(m_vecDataSets[0]);
 m_vecDataSets[0]->set_points(px1, py1, dx1, dy1, 6);
 Gdk_Color color("red");
 Gdk_Colormap::get_system().alloc(color); 

 m_vecDataSets[0]->set_symbol(GTK_PLOT_SYMBOL_DIAMOND,
			GTK_PLOT_SYMBOL_OPAQUE,
			10, 2, color, color);
 m_vecDataSets[0]->set_line_attributes(GTK_PLOT_LINE_SOLID,
				1, color);

 m_vecDataSets[0]->set_connector(GTK_PLOT_CONNECT_SPLINE);

 m_vecDataSets[0]->show_yerrbars();
 m_vecDataSets[0]->set_legend("Spline + EY");
 m_vecDataSets[0]->show();

 m_vecDataSets[3] = new GtkExtra::PlotData;
 refPlot.add_data(m_vecDataSets[3]);
 m_vecDataSets[3]->set_points(px2, py2, dx2, dy2, 6);
 
 m_vecDataSets[3]->set_line_attributes(GTK_PLOT_LINE_SOLID,
				 4, color);
 // color.parse("black");   	// This craches the application 
				// when color is used !!!
 color.set_rgb(169*256,169*256,169*256);    // DarkGrey
 colormap.alloc(color);
 m_vecDataSets[3]->set_symbol(GTK_PLOT_SYMBOL_SQUARE,
		       GTK_PLOT_SYMBOL_OPAQUE,
		       8, 2, color, color);
 m_vecDataSets[3]->set_connector(GTK_PLOT_CONNECT_STRAIGHT);
 m_vecDataSets[3]->set_x_attributes(GTK_PLOT_LINE_SOLID,
			      0, color);
 m_vecDataSets[3]->set_y_attributes(GTK_PLOT_LINE_SOLID,
			      0, color);
 m_vecDataSets[3]->set_legend("Line + Symbol");
 m_vecDataSets[3]->show();
 
 Gdk_Color color2("blue");
 Gdk_Colormap::get_system().alloc(color2); 

 m_vecDataSets[1] = new GtkExtra::PlotData(refPlot, (GtkPlotFunc) function);
 m_vecDataSets[1]->set_line_attributes(GTK_PLOT_LINE_SOLID,
				0, color2);
 m_vecDataSets[1]->set_legend("Function Plot");
 m_vecDataSets[1]->show();
}


void
Window_Test_PlotCanvas::build_example2(GtkExtra::Plot& refPlot)
{

 static double px2[] = {.1, .2, .3, .4, .5, .6, .7, .8};
 static double py2[] = {.012, .067, .24, .5, .65, .5, .24, .067};
 static double dx2[] = {.1, .1, .1, .1, .1, .1, .1, .1};

 
 m_vecDataSets[4]= new GtkExtra::PlotData(refPlot,(GtkPlotFunc) gaussian);
 Gdk_Color color("dark green");
 Gdk_Colormap::get_system().alloc(color); 
 m_vecDataSets[4]->set_line_attributes(GTK_PLOT_LINE_DASHED,
				 2, color);
 m_vecDataSets[4]->set_legend("Gaussian");
 m_vecDataSets[4]->show();

 color.parse("blue");
 Gdk_Colormap::get_system().alloc(color);
 m_vecDataSets[2] = new GtkExtra::PlotBar(GTK_ORIENTATION_VERTICAL); //subclass of PlotData.
 refPlot.add_data(m_vecDataSets[2]);
 m_vecDataSets[2]->set_points(px2, py2, dx2, 0, 8);
 m_vecDataSets[2]->set_symbol(GTK_PLOT_SYMBOL_NONE,
			GTK_PLOT_SYMBOL_OPAQUE,
			10, 2, color, color);
 m_vecDataSets[2]->set_line_attributes(GTK_PLOT_LINE_NONE,
				 1, color);

 m_vecDataSets[2]->set_legend("V Bars");
 m_vecDataSets[2]->show();
}

gint
Window_Test_PlotCanvas::on_PlotCanvas_select_item(GdkEventButton* event, GtkPlotCanvasChild* item)
{
  if(item)
  {
	  switch(item->type)
	  {
	    case GTK_PLOT_CANVAS_TEXT:
          printf("Item selected: TEXT\n");
          break;
	    case GTK_PLOT_CANVAS_TITLE:
          printf("Item selected: TITLE\n");
          break;
	    case GTK_PLOT_CANVAS_LEGENDS:
          printf("Item selected: LEGENDS\n");
          break;
	    case GTK_PLOT_CANVAS_PLOT:
          printf("Item selected: PLOT\n");
          break;
	    case GTK_PLOT_CANVAS_AXIS:
          printf("Item selected: AXIS\n");
          break;
	    case GTK_PLOT_CANVAS_DATA:
	    {
          printf("Item selected: DATA\n");

          /* This isn't the same as active_x and active_y - they are always 0.
          gdouble x = 0;
          gdouble y = 0;
          m_PlotCanvas.get_active_point(x, y); 
          */
          printf("Active point: %d -> %f %f\n", 
                m_PlotCanvas.gtkobj()->active_point, //Not wrapped, because I'm not sure that it's really needed.
                m_PlotCanvas.gtkobj()->active_x, //See note above.
                m_PlotCanvas.gtkobj()->active_y //See note above.
                );
           
          break;
        }
	    case GTK_PLOT_CANVAS_NONE:
          printf("Item selected: NONE\n");
          break;
	    case GTK_PLOT_CANVAS_CUSTOM:
          printf("This is a custom child. Isn't it neat?\n");
          break;
        default:
          break;
	  }
  }

  if(item->type == GTK_PLOT_CANVAS_PLOT)
	{
	  //Activate the appropriate button:
	  //This doesn't really work, because the active_plot is the previously active plot,
	  //not the plot that will be active after this signal handler returns true.
	  //However, it doesn't work in the C version either, so this is a faithful transaltion.
	  
	  GtkExtra::Plot* pPlotActive = m_PlotCanvas.get_active_plot();
	  if(pPlotActive)
	  {
	    if(pPlotActive == &m_Plot1)
	    {
	      if(!m_Button1.get_active())
	      {
	        m_Button1.set_active(true);
	        m_Button2.set_active(false);
	      }
	    }
	    else if(pPlotActive == &m_Plot2)
	    {
	      if(!m_Button2.get_active())
	      {
	        m_Button2.set_active(true);
	        m_Button1.set_active(false);
	      }
	    }
	  }
	}

  return true;
}

//iButtonNumber parameter is from a bind<>:
void
Window_Test_PlotCanvas::on_Button_toggled(gint iButtonNumber)
{
  //Select the apropriate plot:
  //Activate the appropriate grid:
  //This doesn't seem to do anything. Maybe 'active' != 'selected'.
  //However, it doesn't work in the C version either, so this is a faithful transaltion.
  GtkExtra::Plot* pPlot = 0;
  if(iButtonNumber == 1)
  {
    pPlot = &m_Plot1;
  }
  else if(iButtonNumber == 2)
  {
    pPlot = &m_Plot2;
  }

  if(pPlot)
  {
    m_PlotCanvas.set_active_plot(*pPlot);
  }
}

void
Window_Test_PlotCanvas::activate_plot(gint iPlotNumber)
{
  GtkExtra::Plot* pPlot = 0;
  Gtk::ToggleButton* pButton = 0;
  Gtk::ToggleButton* pButtonOther = 0;
  if(iPlotNumber == 1)
  {
    pPlot = &m_Plot1;
    pButton = &m_Button1;
    pButtonOther = &m_Button2;
  }
  else if(iPlotNumber == 2)
  {
    pPlot = &m_Plot2;
    pButton = &m_Button2;
    pButtonOther = &m_Button1;
  }

  if(pPlot && pButton)
  {
    m_PlotCanvas.set_active_plot(*pPlot);
    if(!(pButton->get_active())) pButton->set_active(true);
    //pButton->set_mode(true);
    
    if(pButtonOther->get_active()) pButtonOther->set_active(false);
    //pButtonOther->set_mode(false);

    pButton->queue_draw();
  }
}

gboolean Window_Test_PlotCanvas::on_axis_tick_label(gdouble *tick_value, gchar *label)
{
  gboolean return_value = FALSE;

  if(tick_value)
  {
	  if(*tick_value == 0.0)
	  {
	    g_snprintf(label, 100, "custom label at 0.0");
	    return_value = TRUE;
	  }
  }
  
  return return_value;
}


//Functions used by Plots:
//These can not be member methods.
gdouble function(GtkPlot *plot, GtkPlotData *data, gdouble x, gboolean *err)
{
 *err = FALSE;

 return(-.5+.3*sin(3.*x)*sin(50.*x));
}

gdouble gaussian(GtkPlot *plot, GtkPlotData *data, gdouble x, gboolean *err)
{
 gdouble y;
 *err = FALSE;
 y = .65*exp(-.5*pow(x-.5,2)/.02);
 return y;
}



//global function:
//Copied from original example
void draw_child(GtkPlotCanvas *canvas, GtkPlotCanvasChild *child)
{
  GdkColormap *colormap = 0;
  GdkPixmap *pixmap = 0;
  GdkBitmap *mask = 0;

  colormap = gdk_colormap_get_system();

  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                                 plot_icon2);

  gdk_draw_pixmap(canvas->pixmap, 
                  GTK_WIDGET(canvas)->style->fg_gc[GTK_STATE_NORMAL],
                  pixmap,
		  0, 0,
		  child->allocation.x, child->allocation.y,
                  child->allocation.width, child->allocation.height);

  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

