
// -*- C++ -*-

/* real_time.cc
 * 
 * Copyright (C) 2000 Gtk+Extra-- Development Team 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <math.h>
#include <stdlib.h>

#include <vector>
#include <algorithm>

#include <gdk--/color.h>
#include <gtk--/window.h>
#include <gtk--/main.h>
#include <gtk--/button.h>
#include <gtk--/box.h>
#include <gtk--/scrolledwindow.h>

#include "gtkextra--/plot.h"
#include "gtkextra--/plotcanvas.h"

using namespace SigC;
using namespace std;

class TestTimer
{

public: 
  TestTimer() {}
  ~TestTimer() {}
  
  void start() {
    m_timer = Gtk::Main::timeout.connect(m_timer_slot, 1000);
  }

  void stop() {
    m_timer.disconnect();
  }

  void set_slot(Slot0<gint> tslot) {
    m_timer.disconnect();
    m_timer_slot=tslot;
  }

protected:
  SigC::Slot0<gint> m_timer_slot;
  SigC::Connection m_timer;

};


class TestData : public GtkExtra::PlotData
{

public:
  TestData();
  ~TestData() {}

};


TestData::TestData()
{

  Gdk_Color color("red");
  Gdk_Colormap::get_system().alloc(color);

  set_legend("Random pulse");
  set_symbol(GTK_PLOT_SYMBOL_DIAMOND,
	     GTK_PLOT_SYMBOL_OPAQUE,
	     10, 2, color, color);
  set_line_attributes(GTK_PLOT_LINE_SOLID,
		      1, color);

  paint();
} 

class TestPlot : public GtkExtra::Plot
{

public:
  TestPlot();
  ~TestPlot() {}

  gint on_timer_update();

private:

  void range_changed_cb() {
    cout << "Range was changed\n";
  }
  
  TestData m_dataset;
  std::vector<gdouble> m_vecpx, m_vecpy;

};


TestPlot::TestPlot() :
  Plot(0, .65, .45)
{
  Gdk_Color color("light yellow");
  get_colormap().alloc(color);
  set_background(color);

  color.parse("white");
  get_colormap().alloc(color);
  legends_set_attributes(0, 0, Gdk_Color(0), color);
  set_range(0. ,20., 0., 1.);
  axis_set_ticks(GTK_PLOT_AXIS_X, 2, 1);
  axis_set_ticks(GTK_PLOT_AXIS_Y, .1, 1);
  axis_labels_set_numbers(GTK_PLOT_AXIS_TOP, 0, 0);
  axis_labels_set_numbers(GTK_PLOT_AXIS_BOTTOM, 0, 0);
  axis_set_visible(GTK_PLOT_AXIS_TOP, TRUE);
  axis_set_visible(GTK_PLOT_AXIS_RIGHT, TRUE);
  grids_set_visible(TRUE, TRUE, TRUE, TRUE);
  axis_hide_title(GTK_PLOT_AXIS_TOP);
  axis_hide_title(GTK_PLOT_AXIS_RIGHT);
  axis_set_title(GTK_PLOT_AXIS_LEFT, "Intensity");
  axis_set_title(GTK_PLOT_AXIS_BOTTOM, "Time (s)");
  set_legends_border(GTK_PLOT_BORDER_SHADOW, 3);
  legends_move(.60, .10);
  show();

  // Monitor any range change (to test the changed signal)
  changed.connect(slot(this,&TestPlot::range_changed_cb));

  m_dataset.show();
  add_data(&m_dataset);

}


gint TestPlot::on_timer_update()
{ 
  gdouble y = rand()%10/10.;

  gdouble x = 0;
  if(m_vecpx.size() == 0)
    x = 1;
  else
    x = m_vecpx.back() + 1;

  m_vecpx.push_back(x);
  m_vecpy.push_back(y);

  m_dataset.set_numpoints(m_vecpx.size()); 
  m_dataset.set_x(*(m_vecpx.begin())); 
  m_dataset.set_y(*(m_vecpy.begin())); 

  gdouble xmin = 0;
  gdouble xmax = 0;
  get_xrange(xmin , xmax);

  if(x > xmax)
  {
    set_xrange(xmin + 5. , xmax + 5.);
    paint();
  }
  else
  {
    m_dataset.draw_points(1);
  }

  return TRUE;
}  
 
class TestWindow : public Gtk::Window
{
 
public:
  TestWindow();
  ~TestWindow();

  void add_plot();

protected:

  //Used by std::transform algorithm.
  template <class T>
  class Delete
  {
  public:
    T operator()(T t) { delete(t); return t; }
  };

  void on_button_stop_clicked() {
    m_timer.stop();
  }

  void on_destroy() {
    m_timer.stop();
    Main::quit();
  }

  gint on_timer_update()
  {
    if(!m_pActive_plot) return FALSE;
    
    gint result = m_pActive_plot->on_timer_update();
    m_canvas.refresh();
    return result;
  }
  
  Gtk::VBox m_vbox;
  Gtk::ScrolledWindow m_scrollw;
  Gtk::HBox m_hbox;
  Gtk::Button m_button;
  GtkExtra::PlotCanvas m_canvas;
  TestPlot* m_pActive_plot;
  std::vector<TestPlot*> m_vecPlots;

  static const gfloat scale = 1.;
  static const gint page_width = (gint) (GTK_PLOT_LETTER_W * scale);
  static const gint page_height= (gint) (GTK_PLOT_LETTER_H * scale);

  TestTimer m_timer;

};


TestWindow::TestWindow() :
  Window(GTK_WINDOW_TOPLEVEL), m_vbox(false,0), m_hbox(false,0),
  m_button("Stop"), m_canvas(page_width,page_height)
{
  m_pActive_plot = 0;
  
  set_title("GtkPlot Real Time Demo");
  set_usize(550,650);
  set_border_width(0);
  destroy.connect(slot(this,&TestWindow::on_destroy));

  add(m_vbox);
  m_vbox.show();

  m_scrollw.set_border_width(0);
  m_scrollw.set_policy(GTK_POLICY_ALWAYS,GTK_POLICY_ALWAYS);
  m_scrollw.show();
  m_vbox.pack_start(m_scrollw, true, true,0);
  
  m_hbox.set_border_width(10);
  m_vbox.pack_start(m_hbox,false,false,0);

  m_button.clicked.connect(slot(this,&TestWindow::on_button_stop_clicked));
  m_hbox.pack_start(m_button,true,false);
  m_button.show();
  
  m_hbox.show();
  
  m_canvas.unset_flags(GTK_PLOT_CANVAS_DND_FLAGS);
  m_scrollw.add_with_viewport(m_canvas);

  Gdk_Color color("light blue");
  m_canvas.get_colormap().alloc(color);
  m_canvas.set_background(color);
  m_canvas.put_text(.45, .05,
		  "Times-BoldItalic", 20, 0, Gdk_Color(0), Gdk_Color(0), true,
		  GTK_JUSTIFY_CENTER,
		  "Real Time Demo");
  m_canvas.show();

}

TestWindow::~TestWindow()
{
  // Delete plots
  transform(m_vecPlots.begin(),m_vecPlots.end(),m_vecPlots.begin(),Delete<TestPlot*>());

}


void TestWindow::add_plot()
{

  m_pActive_plot=new TestPlot;
  m_vecPlots.push_back(m_pActive_plot);
  m_canvas.add_plot(*m_pActive_plot,.15, .15);
  m_timer.set_slot(slot(this,&TestWindow::on_timer_update));
  m_timer.start();

}


int main(int argc, char *argv[])
{
  Gtk::Main apps(argc, argv);
  
  TestWindow test_window;
  test_window.show();
  test_window.add_plot();

  apps.run();
  
  return(0);
  
}


