// -*- C++ -*-

/* menu_popup.cc
 * 
 * Copyright (C) 2000 GtkExtra-- Development Team  
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "menu_popup.h"

Menu_Popup::Menu_Popup()
{
  items().push_back(Gtk::Menu_Helpers::MenuElem("Add Column"));
  m_pMenuItem_AddColumn = items().back();
  
  items().push_back(Gtk::Menu_Helpers::MenuElem("Add Row"));
  m_pMenuItem_AddRow = items().back();
  
	items().push_back(Gtk::Menu_Helpers::MenuElem("Insert Row"));
	m_pMenuItem_InsertRow = items().back();
	
  items().push_back(Gtk::Menu_Helpers::MenuElem("Insert Column"));
  m_pMenuItem_InsertColumn = items().back();
  
  items().push_back(Gtk::Menu_Helpers::MenuElem("Delete Row"));
  m_pMenuItem_DeleteRow = items().back();

  items().push_back(Gtk::Menu_Helpers::MenuElem("Delete Column"));
  m_pMenuItem_DeleteColumn = items().back();

  items().push_back(Gtk::Menu_Helpers::MenuElem("Clear Cells"));
  m_pMenuItem_ClearCells = items().back();
}

Menu_Popup::~Menu_Popup()
{
}

Gtk::MenuItem* Menu_Popup::get_MenuItem_AddColumn() const
{
  return m_pMenuItem_AddColumn;
}

Gtk::MenuItem* Menu_Popup::get_MenuItem_AddRow() const
{
  return m_pMenuItem_AddRow;
}

Gtk::MenuItem* Menu_Popup::get_MenuItem_InsertRow() const
{
  return m_pMenuItem_InsertRow;
}

Gtk::MenuItem* Menu_Popup::get_MenuItem_InsertColumn() const
{
  return m_pMenuItem_InsertColumn;
}

Gtk::MenuItem* Menu_Popup::get_MenuItem_DeleteRow() const
{
  return m_pMenuItem_DeleteRow;
}

Gtk::MenuItem* Menu_Popup::get_MenuItem_DeleteColumn() const
{
  return m_pMenuItem_DeleteColumn;
}

Gtk::MenuItem* Menu_Popup::get_MenuItem_ClearCells() const
{
  return m_pMenuItem_ClearCells;
}

void Menu_Popup::Set_AllSensitive()
{
  for(Gtk::Menu_Helpers::MenuList::iterator iter = items().begin(); iter != items().end(); iter++)
  {
    Gtk::MenuItem* pMenuItem = *iter;
    pMenuItem->set_sensitive(true);
  }
}

