/* templates.h
 * 
 * Written by David Allen <s2mdalle@titan.vcu.edu>
 * http://opop.nols.com/
 * Released under the terms of the GNU General Public License
 */

#define TEMPLATES_H
#define MAXIMUM_ROWS           6
#define MODMAP_MAX_KEYPERMOD   2

/* Abstract data types */

typedef struct{
     KeySym lower_case;      /* What happens when pressed by itself */
     KeySym upper_case;      /* What happens when pressed with Shift/CL */
     KeySym alt_gr;          /* Alt GR+ button -- mostly unused */
     KeyCode code;
     char *aux_string;       /* Cheating string holder for things that aren't
			      * right with XKeysymToString() -- most notably
			      * the F keys and the keypad keys 
			      * This should NEVER be used in conjunction
			      * with foreign windows - only text insertion in
			      * our editing buffer
			      */
} KEY;

typedef struct {
     char *tab;
     char *backspace;
     char *caps_lock;
     char *space;
     char *alt;
     char *alt_gr;
     char *control;
     char *shift;
} KeyboardTranslation;

typedef struct{
     int row_values[MAXIMUM_ROWS];
     int keycount;
     KeySym *syms;
     KeyCode *codes;
     KeyboardTranslation *trans;
     char *name;
     ModmapTable *modmap;
} KEYBOARD;

/* Macros */
#define NO_KEYBOARD            ((KEYBOARD *)NULL)
#define NO_KEY                 ((KEY *)NULL)
#define IS_VALID_KEYBOARD(x)   (x == NO_KEYBOARD)
#define IS_VALID_KEY     (x)   (x == NO_KEY)

/* Function prototypes */
void gtkeyboard_print_key                (KEY *input);
void destroy_key_wrapper(GtkWidget *emitter, gpointer data);
KEY *gtkeyboard_key_copy                 (KEY *key);
KEY *gtkeyboard_keyboard_get_key         (KEYBOARD *keyb, int row, int keyno);
KEYBOARD *gtkeyboard_destroy_keyboard    (KEYBOARD *input);
KEYBOARD *read_keyboard_template         (char *filename);
void gtkeyboard_key_set_code             (KEY *key, KeyCode input);
int is_uppercase_key                     (KEYBOARD *keyb, KeySym i);
int gtkeyboard_keyboard_row_count_items  (KEYBOARD *input, int rowno);
KEY *gtkeyboard_destroy_key              (KEY *input);
KEY *gtkeyboard_new_key                  (const KeySym lower, 
					  const KeySym upper, 
					  const KeySym altgr,
					  const char *alt);

