// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GDKMM_GL_DRAWABLE_H
#define _GDKMM_GL_DRAWABLE_H

#include <glibmm.h>

// -*- C++ -*-
/* gdkglextmm - C++ Wrapper for GdkGLExt
 * Copyright (C) 2002-2003  Naofumi Yasufuku
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.
 */

#include <glibmm/interface.h>

#include <gdkmm/gl/defs.h>
#include <gdkmm/gl/config.h>
#include <gdkmm/gl/context.h>

#include <GL/gl.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdkGLDrawable GdkGLDrawable;
typedef struct _GdkGLDrawableClass GdkGLDrawableClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

namespace GL
{ class Drawable_Class; } // namespace GL

} // namespace Gdk
namespace Gdk
{
namespace GL
{

class Context;

  /** @defgroup GLDrawables  GL Drawables
   */

  /** OpenGL rendering surface abstract class.
   *
   *
   */


class Drawable : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Drawable CppObjectType;
  typedef Drawable_Class CppClassType;
  typedef GdkGLDrawable BaseObjectType;
  typedef GdkGLDrawableClass BaseClassType;

private:
  friend class Drawable_Class;
  static CppClassType drawable_class_;

  // noncopyable
  Drawable(const Drawable&);
  Drawable& operator=(const Drawable&);

protected:
  Drawable(); // you must derive from this class
  explicit Drawable(GdkGLDrawable* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Drawable();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdkGLDrawable*       gobj()       { return reinterpret_cast<GdkGLDrawable*>(gobject_); }

  ///Provides access to the underlying C GObject.  
  const GdkGLDrawable* gobj() const { return reinterpret_cast<GdkGLDrawable*>(gobject_); }

private:


public:

  
  /** Attach an OpenGL rendering context to a @a gldrawable .
   * @param glcontext A Gdk::GLContext.
   * @return <tt>true</tt> if it is successful, <tt>false</tt> otherwise.
   */
  bool make_current(const Glib::RefPtr<Context>& glcontext);

  
  /** Returns whether the @a gldrawable  supports the double-buffered visual.
   * @return <tt>true</tt> if the double-buffered visual is supported,
   * <tt>false</tt> otherwise.
   */
  bool is_double_buffered() const;

  
  /** Exchange front and back buffers.
   */
  void swap_buffers();

  
  /** Complete OpenGL execution prior to subsequent GDK drawing calls.
   */
  void wait_gl();

  
  /** Complete GDK drawing execution prior to subsequent OpenGL calls.
   */
  void wait_gdk();

  
  /** Delimits the begining of the OpenGL execution.
   * @param glcontext A Gdk::GLContext.
   * @return <tt>true</tt> if it is successful, <tt>false</tt> otherwise.
   */
  bool gl_begin(const Glib::RefPtr<Context>& glcontext);

  
  /** Delimits the end of the OpenGL execution.
   */
  void gl_end();

  
  /** Gets Gdk::GLConfig with which the @a gldrawable  is configured.
   * @return The Gdk::GLConfig.
   */
  Glib::RefPtr<Config> get_gl_config();
  
  /** Gets Gdk::GLConfig with which the @a gldrawable  is configured.
   * @return The Gdk::GLConfig.
   */
  Glib::RefPtr<const Config> get_gl_config() const;

  
  /** Fills *width and *height with the size of GL drawable.
   * width or height can be <tt>0</tt> if you only want the other one.
   * @param width Location to store drawable's width, or <tt>0</tt>.
   * @param height Location to store drawable's height, or <tt>0</tt>.
   */
  void get_size(int& width, int& height);

  
  /** Returns the current Gdk::GLDrawable.
   * @return The current Gdk::GLDrawable or <tt>0</tt> if there is no current drawable.
   */
  static Glib::RefPtr<Drawable> get_current();

public:

  
  /** Renders a cube.
   * The cube is centered at the modeling coordinates origin with sides of
   * length @a size .
   * @param solid <tt>true</tt> if the cube should be solid.
   * @param size Length of cube sides.
   */
  static void draw_cube(bool solid, double size);

  
  /** Renders a sphere centered at the modeling coordinates origin of
   * the specified @a radius . The sphere is subdivided around the Z axis into
   *  @a slices  and along the Z axis into @a stacks .
   * @param solid <tt>true</tt> if the sphere should be solid.
   * @param radius The radius of the sphere.
   * @param slices The number of subdivisions around the Z axis (similar to lines of
   * longitude).
   * @param stacks The number of subdivisions along the Z axis (similar to lines of
   * latitude).
   */
  static void draw_sphere(bool solid, double radius, int slices, int stacks);

  
  /** Renders a cone oriented along the Z axis.
   * The @a base  of the cone is placed at Z = 0, and the top at Z = @a height .
   * The cone is subdivided around the Z axis into @a slices , and along
   * the Z axis into @a stacks .
   * @param solid <tt>true</tt> if the cone should be solid.
   * @param base The radius of the base of the cone.
   * @param height The height of the cone.
   * @param slices The number of subdivisions around the Z axis.
   * @param stacks The number of subdivisions along the Z axis.
   */
  static void draw_cone(bool solid, double base, double height, int slices, int stacks);

  
  /** Renders a torus (doughnut) centered at the modeling coordinates
   * origin whose axis is aligned with the Z axis.
   * @param solid <tt>true</tt> if the torus should be solid.
   * @param inner_radius Inner radius of the torus.
   * @param outer_radius Outer radius of the torus.
   * @param nsides Number of sides for each radial section.
   * @param rings Number of radial divisions for the torus.
   */
  static void draw_torus(bool solid, double inner_radius, double outer_radius, int nsides, int rings);

  
  /** Renders a tetrahedron centered at the modeling coordinates
   * origin with a radius of the square root of 3.
   * @param solid <tt>true</tt> if the tetrahedron should be solid.
   */
  static void draw_tetrahedron(bool solid);

  
  /** Renders a octahedron centered at the modeling coordinates
   * origin with a radius of 1.0.
   * @param solid <tt>true</tt> if the octahedron should be solid.
   */
  static void draw_octahedron(bool solid);

  
  /** Renders a dodecahedron centered at the modeling coordinates
   * origin with a radius of the square root of 3.
   * @param solid <tt>true</tt> if the dodecahedron should be solid.
   */
  static void draw_dodecahedron(bool solid);

  
  /** Renders a icosahedron.
   * The icosahedron is centered at the modeling coordinates origin
   * and has a radius of 1.0.
   * @param solid <tt>true</tt> if the icosahedron should be solid.
   */
  static void draw_icosahedron(bool solid);

  
  /** Renders a teapot.
   * Both surface normals and texture coordinates for the teapot are generated.
   * The teapot is generated with OpenGL evaluators.
   * @param solid <tt>true</tt> if the teapot should be solid.
   * @param scale Relative size of the teapot.
   */
  static void draw_teapot(bool solid, double scale);


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

  /** @example shapes.h
   *
   * Geometric object rendering example.
   *
   */

  /** @example shapes.cc
   *
   * Geometric object rendering example.
   *
   */

} // namespace GL
} // namespace Gdk


namespace Glib
{

/** @relates Gdk::GL::Drawable */
Glib::RefPtr<Gdk::GL::Drawable> wrap(GdkGLDrawable* object, bool take_copy = false);

} // namespace Glib

#endif /* _GDKMM_GL_DRAWABLE_H */

