/*
 *   Copyright (C) 2007 Tristan Heaven <tristanheaven@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License along
 *   with this program; if not, write to the Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <stdlib.h>
#include <sys/stat.h>
#include <gtk/gtk.h>

#include "main.h"
#include "gui.h"
#include "list.h"
#include "prefs.h"

static void parse_args(int argc, char *argv[])
{
	if (argc == 2)
		gui_chooser_set_filename(argv[1]);
	else if (argc > 2)
		for (int i = 1; i != argc; i++)
			list_append_row(argv[i]);
}

int main(int argc, char *argv[])
{
#if ENABLE_NLS
	bindtextdomain(PACKAGE, LOCALEDIR);
	bind_textdomain_codeset(PACKAGE, "UTF-8");
	textdomain(PACKAGE);
#endif

	gtk_init(&argc, &argv);
	gui_init();

	list_init();

	prefs_load();
	atexit(prefs_save);

	parse_args(argc, argv);

	// Show window here so it doesn't resize just after it appears
	gtk_widget_show(gui_widget("window"));

	gtk_main();

	return EXIT_SUCCESS;
}

unsigned int get_filesize(const char *filename)
{
	struct stat s;

	if (stat(filename, &s) == -1)
		return 0;
	else
		return s.st_size;
}

bool file_exists(const char *filename)
{
	return (g_file_test(filename, G_FILE_TEST_EXISTS) &&
		!g_file_test(filename, G_FILE_TEST_IS_DIR));
}
