/*  GTKtalog.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <config.h>
#if (defined(OS_PPC_DARWIN) || defined(OS_FREEBSD) || defined(OS_NETBSD) || defined(OS_OPENBSD))
#include <sys/param.h>
#include <sys/mount.h>
#endif
#include <gnome.h>

#include "progressbar.h"

static GtkWidget *progress_appbar[GNOMEAPPBAR_NB];
static gboolean progress_is_gnome_progress[GNOMEAPPBAR_NB];
static gulong progress_currentValue[GNOMEAPPBAR_NB][2];
static gulong progress_totalValue[GNOMEAPPBAR_NB][2];
static gboolean progress_INeedReset = TRUE;
static gboolean progress_mode[GNOMEAPPBAR_NB];

void
progress_reset ()
{
#ifndef GNOME1
  GtkProgressBar *progress;
#endif
  gint i;
  progress_INeedReset = FALSE;
  for (i = 0; i < GNOMEAPPBAR_NB; i++)
    {
      if (progress_appbar[i])
	{
	  if (progress_is_gnome_progress[i])
	    gtk_progress_set_activity_mode (GTK_PROGRESS
					    (gnome_appbar_get_progress
					     (GNOME_APPBAR
					      (progress_appbar[i]))), FALSE);
	  else
	    gtk_progress_set_activity_mode (GTK_PROGRESS
					    (progress_appbar[i]), FALSE);




	  progress_mode[i] = FALSE;
	  progress_currentValue[i][0] = 0;
	  progress_currentValue[i][1] = 0;
	  if (progress_is_gnome_progress[i])
	    {
#ifdef GNOME1
	      gnome_appbar_set_progress (GNOME_APPBAR (progress_appbar[i]),
					 0);
#else
	      progress =
		gnome_appbar_get_progress (GNOME_APPBAR (progress_appbar[i]));
	      gtk_progress_set_percentage (GTK_PROGRESS (progress), 0);
#endif
	    }
	  else
	    gtk_progress_set_percentage (GTK_PROGRESS (progress_appbar[i]),
					 0);
	}
    }
}

gboolean
progress_needReset ()
{
  return progress_INeedReset;
}

/* Return the size of the filesystem
   FIXME: Will take the size of the current filesystem.
        That means it won't work if you only try to catalog a part of a drive
*/
glong
getStats (char *foldername)
{
  struct statfs statBuf;

  if (statfs (foldername, &statBuf) == -1)
    return -1;


  /* Total size of the CD in Bytes */
  return statBuf.f_blocks * statBuf.f_bsize;
}

void
progress_createTimeout (gpointer pstru)
{
  gtk_timeout_add (PROGRESS_BAR_TIMEOUT, progress_timeout, pstru);
}

/* Update the progress_bar.
   The progress bar must be passed with a gpointer */
gint
progress_timeout (gpointer pstru)
{
  gfloat new_val;
  gint reg = GPOINTER_TO_INT (pstru);

  if (!progress_appbar[reg])
    return (FALSE);


  new_val =
    ((((float) progress_currentValue[reg][1]) * (1 << (sizeof (gulong) / 2)) *
      (sizeof (gulong) / 2)) +
     ((float) progress_currentValue[reg][0])) /
    ((((float) progress_totalValue[reg][1]) * (sizeof (gulong) / 2) *
      (sizeof (gulong) / 2)) + ((float) progress_totalValue[reg][0]));

  if (progress_mode[reg])
    {
      /* Set the new value */
      progress_addCurrent (1, reg);
      if (new_val > 1.99)
	new_val = 0;
      if ((new_val >= 0) && (new_val < 1.))
	{
	  if (progress_is_gnome_progress[reg])
	    {
#ifndef GNOME1
	      GtkProgressBar *progress;
#endif
#ifdef GNOME1
	    gnome_appbar_set_progress (GNOME_APPBAR (progress_appbar[reg]),
				       new_val);
#else
	      progress =
		gnome_appbar_get_progress (GNOME_APPBAR
					   (progress_appbar[reg]));
	      gtk_progress_set_percentage (GTK_PROGRESS (progress), new_val);
#endif

	    }
	  else
	    gtk_progress_set_percentage (GTK_PROGRESS (progress_appbar[reg]),
					 new_val);
	}
      else
	{
	  if (progress_is_gnome_progress[reg])
	    {
#ifndef GNOME1
	      GtkProgressBar *progress;
#endif
#ifdef GNOME1
	    gnome_appbar_set_progress (GNOME_APPBAR (progress_appbar[reg]),
				       2. - new_val);
#else
	      progress =
		gnome_appbar_get_progress (GNOME_APPBAR
					   (progress_appbar[reg]));
	      gtk_progress_set_percentage (GTK_PROGRESS (progress),
					   2. - new_val);
#endif
	    }
	  else
	    gtk_progress_set_percentage (GTK_PROGRESS (progress_appbar[reg]),
					 2. - new_val);
	}
    }
  else
    {
      /* Set the new value */
      if (new_val > 0.99)
	new_val = 1;
      if (new_val >= 0)
	{
	  if (progress_is_gnome_progress[reg])
	    {
#ifndef GNOME1
	      GtkProgressBar *progress;
#endif
#ifdef GNOME1
	    gnome_appbar_set_progress (GNOME_APPBAR (progress_appbar[reg]),
				       new_val);
#else
	      progress =
		gnome_appbar_get_progress (GNOME_APPBAR
					   (progress_appbar[reg]));
	      gtk_progress_set_percentage (GTK_PROGRESS (progress), new_val);
#endif
	    }
	  else
	    gtk_progress_set_percentage (GTK_PROGRESS (progress_appbar[reg]),
					 new_val);
	}

      /* Stop the timer */
      if (new_val == 1)
	{
	  progress_INeedReset = TRUE;
	  if (progress_is_gnome_progress[reg])
	    {
#ifndef GNOME1
	      GtkProgressBar *progress;
#endif
#ifdef GNOME1
	    gnome_appbar_set_progress (GNOME_APPBAR (progress_appbar[reg]),
				       0);
#else
	      progress =
		gnome_appbar_get_progress (GNOME_APPBAR
					   (progress_appbar[reg]));
	      gtk_progress_set_percentage (GTK_PROGRESS (progress), 0);
#endif
	    }
	  else
	    gtk_progress_set_percentage (GTK_PROGRESS (progress_appbar[reg]),
					 0);
	}
    }
  /* As this is a timeout function, return TRUE so that it
   * continues to get called */
  return (TRUE);
}

void
progress_setTotal (gulong total_m, gulong total_b, gint reg)
{
  progress_totalValue[reg][1] = total_m;
  progress_totalValue[reg][0] = total_b;
}

gulong
progress_getTotal_m (gint reg)
{
  return progress_totalValue[reg][1];
}

gulong
progress_getTotal_b (gint reg)
{
  return progress_totalValue[reg][0];
}

void
progress_setCurrent (gulong current_m, gulong current_b, gint reg)
{
  progress_currentValue[reg][1] = current_m;
  progress_currentValue[reg][0] = current_b;
}

gulong
progress_getCurrent_m (gint reg)
{
  return progress_currentValue[reg][1];
}

gulong
progress_getCurrent_b (gint reg)
{
  return progress_currentValue[reg][0];
}

void
progress_addCurrent (guint value, gint reg)
{
  progress_currentValue[reg][0] += value;
  if (progress_currentValue[reg][0] < value)
    progress_currentValue[reg][1]++;
}

void
progress_set_activity_mode (gint reg, gboolean is_activity_mode)
{
  if (progress_appbar[reg])
    {

      if (progress_is_gnome_progress[reg])
	gtk_progress_set_activity_mode (GTK_PROGRESS
					(gnome_appbar_get_progress
					 (GNOME_APPBAR
					  (progress_appbar[reg]))),
					is_activity_mode);
      else
	gtk_progress_set_activity_mode (GTK_PROGRESS
					(progress_appbar[reg]),
					is_activity_mode);
      progress_mode[reg] = is_activity_mode;
      if (is_activity_mode)
	{
	  progress_totalValue[reg][0] = 10;
	  progress_totalValue[reg][1] = 0;
	  progress_currentValue[reg][0] = 0;
	  progress_currentValue[reg][1] = 0;
	}
    }
}

void
progress_setStatus (gchar * msg, gint reg)
{
  if (progress_is_gnome_progress[reg])
    {
      gnome_appbar_set_status (GNOME_APPBAR (progress_appbar[reg]), msg);
      gnome_appbar_refresh (GNOME_APPBAR (progress_appbar[reg]));
    }
}

void
progress_setGnomeAppBar (GtkWidget * appbar, gint reg,
			 gboolean is_gnome_appabar)
{
  progress_appbar[reg] = appbar;
  progress_is_gnome_progress[reg] = is_gnome_appabar;
}
