/* tag.cpp

  Created by SMF aka Antoine Laydier (laydier@usa.net)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

/*=============================================================================
  HEADERs
 =============================================================================*/
#include "mp3tag.h"
#include "mp3tools.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

/*=============================================================================
 Class : Tag
 =============================================================================*/
const int Tag::genre_largest=145;
const char * const Tag::genres[] =
{
  "Blues",            "Classic Rock",         "Country",           "Dance",
  "Disco",            "Funk",                 "Grunge",            "Hip-Hop",
  "Jazz",             "Metal",                "New Age",           "Oldies",
  "Other",            "Pop",                  "R&B",               "Rap",
  "Reggae",           "Rock",                 "Techno",            "Industrial",
  "Alternative",      "Ska",                  "Death Metal",       "Pranks",
  "Soundtrack",       "Euro-Techno",          "Ambient",           "Trip-Hop",
  "Vocal",            "Jazz+Funk",            "Fusion",            "Trance",
  "Classical",        "Instrumental",         "Acid",              "House",
  "Game",             "Sound Clip",           "Gospel",            "Noise",
  "AlternRock",       "Bass",                 "Soul",              "Punk",
  "Space",            "Meditative",           "Instrumental Pop",  "Instrumental Rock",
  "Ethnic",           "Gothic",               "Darkwave",          "Techno-Industrial",
  "Electronic",       "Pop-Folk",             "Eurodance",         "Dream",
  "Southern Rock",    "Comedy",               "Cult",              "Gangsta",
  "Top 40",           "Christian Rap",        "Pop/Funk",          "Jungle",
  "Native American",  "Cabaret",              "New Wave",          "Psychadelic",
  "Rave",             "Showtunes",            "Trailer",           "Lo-Fi",
  "Tribal",           "Acid Punk",            "Acid Jazz",         "Polka",
  "Retro",            "Musical",              "Rock & Roll",       "Hard Rock",
  "Folk",             "Folk-Rock",            "National Folk",     "Swing",
  "Fast Fusion",      "Bebob",                "Latin",             "Revival",
  "Celtic",           "Bluegrass",            "Avantgarde",        "Gothic Rock",
  "Progressive Rock", "Psychedelic Rock",     "Symphonic Rock",    "Slow Rock",
  "Big Band",         "Chorus",               "Easy Listening",    "Acoustic",
  "Humour",           "Speech",               "Chanson",           "Opera",
  "Chamber Music",    "Sonata",               "Symphony",          "Booty Bass",
  "Primus",           "Porn Groove",          "Satire",            "Slow Jam",
  "Club",             "Tango",                "Samba",             "Folklore",
  "Ballad",           "Power Ballad",         "Rhytmic Soul",      "Freestyle",
  "Duet",             "Punk Rock",            "Drum Solo",         "Acapella",
  "Euro-House",       "Dance Hall",           "Goa",               "Drum & Bass",
  "Club-House",       "Hardcore",             "Terror",            "Indie",
  "BritPop",          "Negerpunk",            "Polsk Punk",        "Beat",
  "Christian Gangsta Rap", "Heavy Metal",     "Black Metal",       "Crossover",
  "Contemporary Christian", "Christian Rock", "Merengue",          "Salsa",
  "Trash Metal",
  "Unknown"
};

bool Tag::get(FILE * file)
{
  int temp;
  tag song;

  fseek(file, -128, SEEK_END);
  temp = fread(&song, 128, 1, file);
  
  if (!strncmp(song.tag, "TAG", 3)) {
    Tools::safecopy(title, song.title, 30);
    Tools::safecopy(artist, song.artist, 30);
    Tools::safecopy(album, song.album, 30);
    Tools::safecopy(year, song.year, 4);
    Tools::safecopy(comment, song.comment, 30);
    gennum = song.genre & 0xFF;
    if ((gennum < 0) || (gennum >= genre_largest)) {
      gennum = 255;
    }
    strcpy(genre, Tag::genres[(gennum<=genre_largest)?gennum:genre_largest]);
    return (1);
  } else {
    return (0);
  }
}

Tag::Tag()
{
  title[0] = 0;
  artist[0] = 0;
  album[0] = 0;
  year[0] = 0;
  comment[0] = 0;
  genre[0] = 0;
  gennum = 255;
}

void Tag::copy(Tag * from)
{
  if (from->title[0])
    strncpy(title, from->title, 30);
  if (from->artist[0])
    strncpy(artist, from->artist, 30);
  if (from->album[0])
    strncpy(album, from->album, 30);
  if (from->year[0])
    strncpy(year, from->year, 4);
  if (from->comment[0])
    strncpy(comment, from->comment, 30);
  if (from->gennum != -1)
    gennum = from->gennum;
  if ((gennum < 0) || (gennum >= Tag::genre_largest)) {
    gennum = 255;
  }
  strcpy(genre, Tag::genres[(gennum<=genre_largest)?gennum:genre_largest]);
}

bool Tag::set(FILE * file)
{
  size_t temp;
  tag song;
  
  Tools::spacecopy(song.title, title, 30);
  Tools::spacecopy(song.artist, artist, 30);
  Tools::spacecopy(song.album, album, 30);
  Tools::spacecopy(song.year, year, 4);
  Tools::spacecopy(song.comment, comment, 30);
  
  if (gennum >= genre_largest || gennum < 0) {
    song.genre = 255;
  } else {
    temp = gennum;
    song.genre = (unsigned char) temp;
  }
  
  fseek(file, -128, SEEK_END);
  temp = fread(&song, 3, 1, file);
  if (!strncmp(song.tag, "TAG", 3)) {
    fseek(file, -128, SEEK_END);
  } else {
    fseek(file, 0, SEEK_END);
  }
  
  strncpy(song.tag, "TAG", 3);
  temp = fwrite(&song, 128, 1, file);
  if (temp == 1) {
    return (true);
  } else {
    return (false);
  }
}

void Tag::setTitle(const char * newTitle)     { strncpy(title, newTitle, 30); }
void Tag::setAlbum(const char * newAlbum)     { strncpy(album, newAlbum, 30);}
void Tag::setArtist(const char * newArtist)   { strncpy(artist, newArtist, 30); }
void Tag::setYear(const char * newYear)       { strncpy(year, newYear, 4); }
void Tag::setComment(const char * newComment) { strncpy(comment, newComment, 30);}
void Tag::setGenre(int newGenre) 
{ 
  gennum = (newGenre<0 || newGenre>=Tag::genre_largest) ? 255 : newGenre; 
  strcpy(genre, Tag::genres[(gennum<=genre_largest)?gennum:genre_largest]); 
}

