/* 
 * Copyright (c) Tony Bybell 1999-2006
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 */


/*
 * tree.h 12/05/98ajb
 */
#ifndef WAVE_TREE_H
#define WAVE_TREE_H

#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "debug.h"
#include "symbol.h"
#include "vcd.h"

extern char hier_delimeter, hier_was_explicitly_set, alt_hier_delimeter;
extern char hier_grouping;

/* Kind of the tree.  */
enum tree_kind
 {
   /* Unknown.  */
   TREE_UNKNOWN,

   /* An internal signal.  */
   TREE_SIGNAL,

   /* An in/out/inout signal.  */
   TREE_IN,
   TREE_OUT,
   TREE_INOUT,

   /* An element of a vector.  */
   TREE_VECTOREL,
   /* An element of a record.  */
   TREE_RECORDEL,

   /* A Subinstance.  */
   TREE_INSTANCE,

   /* A package (somewhat VHDL specific ?).  */
   TREE_PACKAGE,

   /* A base (source file).  Not yet implemented.  */
   TREE_BASE
 };

struct tree
{
struct tree *next;
struct tree *child;
int which;		/* 'i' for facs[i] table, -1 means not a full signame */

unsigned char kind; 	/* Kind of the leaf.  (use a bit field ?).  */
char name[1];
};

struct treechain
{
struct tree *tree;	/* top of list of selected item in hierarchy */
struct tree *label;	/* actual selected item in hierarchy */
struct treechain *next;
};


struct autocoalesce_free_list
{
struct autocoalesce_free_list *next;	/* list of coalesced names generated by treesearch gadget..only user of this struct */
char *name;				/* free up next time filtering is performed */
};


extern struct tree *treeroot;
extern int fast_tree_sort; /* won't work with lxt2 because of how aliasing stacks */
			   /* names at the end of the main hierarchy 010104ajb    */

void init_tree(void);
void build_tree_from_name(const char *s, int which);
int treegraft(struct tree *t);
void treedebug(struct tree *t, char *s);
void maketree(GtkCTreeNode *subtree, struct tree *t);
char *leastsig_hiername(char *nam);

void treesort(struct tree *t, struct tree *p);
void order_facs_from_treesort(struct tree *t, void *v);

void treenamefix(struct tree *t);

#endif

/*
 * $Id: tree.h,v 1.2 2007/04/20 02:08:17 gtkwave Exp $
 * $Log: tree.h,v $
 * Revision 1.2  2007/04/20 02:08:17  gtkwave
 * initial release
 *
 */

