/* 
 * Copyright (c) Tony Bybell 1999-2009.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 */

#include "globals.h"
#include <config.h>
#include "pixmaps.h"

#ifdef WAVE_USE_GTK2
/* Apply GMASK to GPIX and return a GdkPixbuf with an alpha channel.  */
/* this function from gtkutil.c in emacs                              */      
static GdkPixbuf *
xg_get_pixbuf_from_pix_and_mask (GdkPixmap *gpix, GdkPixmap *gmask, GdkColormap *cmap)
{
  int width, height;
  GdkPixbuf *icon_buf, *tmp_buf;
      
  gdk_drawable_get_size (gpix, &width, &height);
  tmp_buf = gdk_pixbuf_get_from_drawable (NULL, gpix, cmap,
                                          0, 0, 0, 0, width, height);
  icon_buf = gdk_pixbuf_add_alpha (tmp_buf, FALSE, 0, 0, 0);
  g_object_unref (G_OBJECT (tmp_buf));
          
  if (gmask)
    {
      GdkPixbuf *mask_buf = gdk_pixbuf_get_from_drawable (NULL,
                                                          gmask,
                                                          NULL,
                                                          0, 0, 0, 0,
                                                          width, height);
      guchar *pixels = gdk_pixbuf_get_pixels (icon_buf);
      guchar *mask_pixels = gdk_pixbuf_get_pixels (mask_buf);
      int rowstride = gdk_pixbuf_get_rowstride (icon_buf);
      int mask_rowstride = gdk_pixbuf_get_rowstride (mask_buf);
      int y;

      for (y = 0; y < height; ++y)
        {
          guchar *iconptr, *maskptr;
          int x;  
 
          iconptr = pixels + y * rowstride;
          maskptr = mask_pixels + y * mask_rowstride;
          
          for (x = 0; x < width; ++x)
            {
              /* In a bitmap, RGB is either 255/255/255 or 0/0/0.  Checking
                 just R is sufficient.  */
              if (maskptr[0] == 0)
                iconptr[3] = 0; /* 0, 1, 2 is R, G, B.  3 is alpha.  */
                
              iconptr += rowstride/width;
              maskptr += mask_rowstride/width;
            }
        }
         
      g_object_unref (G_OBJECT (mask_buf));
    }
     
  return(icon_buf);
}
#endif


/* XPM */
static char * icon_redo[] = {
"24 24 126 2",
"  	c None",
". 	c #000000",
"+ 	c #F0FFEE",
"@ 	c #CAE3C6",
"# 	c #F5FFF4",
"$ 	c #0D110C",
"% 	c #729C6C",
"& 	c #A6CAA1",
"* 	c #CBE4C7",
"= 	c #EFFDEE",
"- 	c #172116",
"; 	c #88B583",
"> 	c #CCE5C8",
", 	c #CDE6C9",
"' 	c #CFE7CB",
") 	c #F3FFF2",
"! 	c #7FA879",
"~ 	c #689063",
"{ 	c #CDE5C9",
"] 	c #CFE7CA",
"^ 	c #D0E9CC",
"/ 	c #D4EAD0",
"( 	c #D5ECD1",
"_ 	c #AED5A9",
": 	c #9ABC95",
"< 	c #63865F",
"[ 	c #2B3A29",
"} 	c #8CB887",
"| 	c #70986A",
"1 	c #71986B",
"2 	c #729A6B",
"3 	c #759C6D",
"4 	c #759F6F",
"5 	c #76A170",
"6 	c #567453",
"7 	c #AFCBAC",
"8 	c #7EAB77",
"9 	c #78A472",
"0 	c #6F9669",
"a 	c #70976A",
"b 	c #71996B",
"c 	c #739B6D",
"d 	c #759F6E",
"e 	c #77A170",
"f 	c #526F4C",
"g 	c #B7D2B2",
"h 	c #60835B",
"i 	c #A5C9A0",
"j 	c #9AC195",
"k 	c #4F6B4C",
"l 	c #769F70",
"m 	c #516D4C",
"n 	c #B9D5B4",
"o 	c #7BA574",
"p 	c #C7E0C3",
"q 	c #6D9568",
"r 	c #51714E",
"s 	c #B6D3B2",
"t 	c #81AB7C",
"u 	c #C3DBBF",
"v 	c #6B9265",
"w 	c #C8EFC3",
"x 	c #A7CCA2",
"y 	c #B5D2B1",
"z 	c #80A87A",
"A 	c #90B68B",
"B 	c #79A674",
"C 	c #C6EAC1",
"D 	c #DEF7D9",
"E 	c #B3D7AE",
"F 	c #BBD9B8",
"G 	c #AFCCAB",
"H 	c #749E6D",
"I 	c #5B7B57",
"J 	c #8CB087",
"K 	c #BBE1B6",
"L 	c #DAF5D6",
"M 	c #E1F7DD",
"N 	c #DCF4D6",
"O 	c #D7F0D3",
"P 	c #CFECCB",
"Q 	c #C6E3C3",
"R 	c #BCD6B9",
"S 	c #7EA778",
"T 	c #64885F",
"U 	c #A6C1A3",
"V 	c #B3D5AE",
"W 	c #CDEAC9",
"X 	c #D0EBCB",
"Y 	c #CAE9C5",
"Z 	c #C7E6C3",
"` 	c #C3E3BF",
" .	c #BDDCBA",
"..	c #B5D2B2",
"+.	c #96B991",
"@.	c #76A071",
"#.	c #3A4E37",
"$.	c #5E7F5A",
"%.	c #8FAF8B",
"&.	c #9CBE97",
"*.	c #C7E0C4",
"=.	c #CBE3C6",
"-.	c #CDE4C9",
";.	c #CBE4C8",
">.	c #C7E1C4",
",.	c #C2DBBF",
"'.	c #88AF82",
").	c #6B9266",
"!.	c #557451",
"~.	c #63885E",
"{.	c #759C70",
"].	c #749E6F",
"^.	c #72996B",
"/.	c #739A6D",
"(.	c #71996C",
"_.	c #6E9668",
":.	c #6C9367",
"<.	c #5F815A",
"[.	c #70996B",
"}.	c #6E9467",
"|.	c #698F63",
"1.	c #6B9166",
"2.	c #5D8059",
"3.	c #4D6A49",
"4.	c #6A8F64",
"5.	c #283926",
"              .                                 ",
"              . .                               ",
"              . + .                             ",
"        . . . . @ # .                           ",
"      $ % & @ @ * * = .           . .           ",
"    - ; @ @ * * > , ' ) .       . ! ~ .         ",
"  . % @ * * > { ] ^ / ( _ .       . : < .       ",
"  [ & @ } | 1 2 3 4 5 6 .           . 7 .       ",
". 8 @ 9 0 a b c d e f .             . g h .     ",
". i j 0 k . . . l m .       .       . n o .     ",
". p q h .     . r .       . .       . s t .     ",
". u v .       . .       . w .     . x y z .     ",
". A B .       .       . C D . . . E F G H .     ",
". I J .             . K L M N O P Q R S T .     ",
"  . U .           . V W X Y Z `  ...+.@.#..     ",
"  . $.%..       . &.*.=., -.;.>.,.'.).!..       ",
"    . ~.{..       . ].^.c /.(.| _.:.<.. .       ",
"      . .           . [.}.|.~ 1.2.3.. .         ",
"                      . q 4.. . . .             ",
"                        5.)..                   ",
"                          . .                   ",
"                            .                   ",
"                                                ",
"                                                "};

/* XPM */
static char * icon_larrow[] = {
"24 24 43 1",
" 	c None",
".	c #000000",
"+	c #B9D0B9",
"@	c #CDDECB",
"#	c #B6C7B6",
"$	c #B1C9B0",
"%	c #B3C4B3",
"&	c #B4CBB2",
"*	c #B5CEB5",
"=	c #B7CCB5",
"-	c #B9CEB7",
";	c #BAD1BA",
">	c #BBCFBA",
",	c #BBD0B9",
"'	c #B2C9B0",
")	c #7EAB78",
"!	c #AAC7A8",
"~	c #B3CAB1",
"{	c #B0C9B0",
"]	c #B0C9AE",
"^	c #AEC7AC",
"/	c #AAC5A8",
"(	c #A9C4A7",
"_	c #698267",
":	c #2D2D2D",
"<	c #CFDFCC",
"[	c #ADC8AB",
"}	c #B0C7AE",
"|	c #ADC6AB",
"1	c #678C63",
"2	c #9BAD9A",
"3	c #85AE81",
"4	c #87AF84",
"5	c #87B083",
"6	c #88AF84",
"7	c #88B085",
"8	c #86AF82",
"9	c #547150",
"0	c #3C5235",
"a	c #5B7950",
"b	c #4A6342",
"c	c #3B5035",
"d	c #415639",
"                        ",
"                        ",
"                        ",
"            .           ",
"           ..           ",
"          .+.           ",
"         .@#.           ",
"        .@$%........    ",
"       .@&*=-;->,').    ",
"      .@!~{]^///^(_.    ",
"     :<[}||[!^^}^[1.    ",
"    .23444445645789.    ",
"     .0aaaaaaaaaaab.    ",
"      .0aaaaaaaaaab.    ",
"       .0aabccccccd.    ",
"        .0ab........    ",
"         .0b.           ",
"          .b.           ",
"           ..           ",
"            .           ",
"                        ",
"                        ",
"                        ",
"                        "};

/* XPM */
static char * icon_rarrow[] = {
"24 24 41 1",
" 	c None",
".	c #000000",
"+	c #8CA782",
"@	c #B1CDAE",
"#	c #77A16E",
"$	c #B4CEB1",
"%	c #ACC8A9",
"&	c #709867",
"*	c #C1D6BD",
"=	c #BDD3B8",
"-	c #BFD4BB",
";	c #C2D7BE",
">	c #B0CAAD",
",	c #B2CBB0",
"'	c #AAC7A8",
")	c #0F1308",
"!	c #AEC5A8",
"~	c #AEC8AD",
"{	c #ABC7A8",
"]	c #AAC6A7",
"^	c #A8C6A5",
"/	c #ADC8AD",
"(	c #A8C7A8",
"_	c #A5C4A3",
":	c #7F9F76",
"<	c #A6BFA0",
"[	c #ABC7AA",
"}	c #A7C5A4",
"|	c #A9C7A6",
"1	c #AFC8AD",
"2	c #A4C3A2",
"3	c #6B9060",
"4	c #778E6F",
"5	c #698D60",
"6	c #6B9063",
"7	c #445B2C",
"8	c #6B8661",
"9	c #5B7950",
"0	c #6C8562",
"a	c #65815C",
"b	c #506B46",
"                        ",
"                        ",
"                        ",
"           .            ",
"           ..           ",
"           .+.          ",
"           .@#.         ",
"    ........$%&.        ",
"    .*=-;;;;>,'&)       ",
"    .!~{{{]^'/(_:.      ",
"    .<[^}^|{%'{123.     ",
"    .45666666666657.    ",
"    .8999999999997.     ",
"    .099999999997.      ",
"    .abbbbbb9997.       ",
"    ........b97.        ",
"           .b7.         ",
"           .7.          ",
"           ..           ",
"           .            ",
"                        ",
"                        ",
"                        ",
"                        "};


/* XPM */
static char * icon_zoomin[] = {
"24 24 131 2",
"  	c None",
". 	c #343434",
"+ 	c #2D2D2D",
"@ 	c #292929",
"# 	c #262626",
"$ 	c #2E2E2E",
"% 	c #303030",
"& 	c #737373",
"* 	c #A1A1A1",
"= 	c #B4B4B4",
"- 	c #B2B2B2",
"; 	c #9D9D9D",
"> 	c #676767",
", 	c #202020",
"' 	c #1C1C1C",
") 	c #272727",
"! 	c #616161",
"~ 	c #CACACA",
"{ 	c #CFCFCF",
"] 	c #D0D0D0",
"^ 	c #CECECE",
"/ 	c #C9C9C9",
"( 	c #C1C1C1",
"_ 	c #A7A7A7",
": 	c #4C4C4C",
"< 	c #131313",
"[ 	c #222222",
"} 	c #757575",
"| 	c #D3D3D3",
"1 	c #DBDBDB",
"2 	c #E7E7E7",
"3 	c #EFEFEF",
"4 	c #F3F3F3",
"5 	c #F1F1F1",
"6 	c #E5E5E5",
"7 	c #D2D2D2",
"8 	c #BCBCBC",
"9 	c #5E5E5E",
"0 	c #101010",
"a 	c #212121",
"b 	c #5B5B5B",
"c 	c #CCCCCC",
"d 	c #D7D7D7",
"e 	c #F5F5F5",
"f 	c #FAFAFA",
"g 	c #FBFBFB",
"h 	c #F8F8F8",
"i 	c #F0F0F0",
"j 	c #E1E1E1",
"k 	c #C2C2C2",
"l 	c #434343",
"m 	c #0F0F0F",
"n 	c #1F1F1F",
"o 	c #B9B9B9",
"p 	c #D6D6D6",
"q 	c #F9F9F9",
"r 	c #FDFDFD",
"s 	c #FCFCFC",
"t 	c #F2F2F2",
"u 	c #ECECEC",
"v 	c #E4E4E4",
"w 	c #ABABAB",
"x 	c #0E0E0E",
"y 	c #1B1B1B",
"z 	c #6D6D6D",
"A 	c #FEFEFE",
"B 	c #EEEEEE",
"C 	c #E6E6E6",
"D 	c #575757",
"E 	c #090909",
"F 	c #141414",
"G 	c #A8A8A8",
"H 	c #D8D8D8",
"I 	c #F6F6F6",
"J 	c #F4F4F4",
"K 	c #DCDCDC",
"L 	c #9B9B9B",
"M 	c #060606",
"N 	c #111111",
"O 	c #C5C5C5",
"P 	c #DFDFDF",
"Q 	c #444444",
"R 	c #454545",
"S 	c #424242",
"T 	c #EDEDED",
"U 	c #BFBFBF",
"V 	c #C6C6C6",
"W 	c #E3E3E3",
"X 	c #414141",
"Y 	c #EAEAEA",
"Z 	c #E0E0E0",
"` 	c #BABABA",
" .	c #050505",
"..	c #0B0B0B",
"+.	c #A5A5A5",
"@.	c #D1D1D1",
"#.	c #939393",
"$.	c #020202",
"%.	c #0A0A0A",
"&.	c #5F5F5F",
"*.	c #D9D9D9",
"=.	c #EBEBEB",
"-.	c #E9E9E9",
";.	c #D4D4D4",
">.	c #000000",
",.	c #E2E2E2",
"'.	c #DADADA",
").	c #CBCBCB",
"!.	c #3B3B3B",
"~.	c #D5D5D5",
"{.	c #C8C8C8",
"].	c #BDBDBD",
"^.	c #515151",
"/.	c #C7C7C7",
"(.	c #CDCDCD",
"_.	c #B8B8B8",
":.	c #030303",
"<.	c #313131",
"[.	c #999999",
"}.	c #BBBBBB",
"|.	c #B6B6B6",
"1.	c #909090",
"2.	c #2B2B2B",
"3.	c #010101",
"4.	c #7A7A7A",
"5.	c #9A9A9A",
"6.	c #777777",
"7.	c #3C3C3C",
"8.	c #686868",
"9.	c #797979",
"0.	c #3A3A3A",
"                                                ",
"              . + @ # # #                       ",
"          $ % & * = - ; > , '                   ",
"        ) ! = ~ { ] ^ / ( _ : <                 ",
"      [ } ~ | 1 2 3 4 5 6 7 8 9 0               ",
"    a b c d 6 e f g f h e i j k l m             ",
"    n o p 2 q g r r s g h t u v w x             ",
"  y z 7 j e f r A A r s q e B C 1 D E           ",
"  F G H B I q s A A r g h J B C K L M           ",
"  N O P 3 e Q Q R R R Q l S T 6 1 U M           ",
"  x V W u t l Q Q Q Q l S X Y Z d `  .          ",
"  ..+.j 2 T 5 J I I e 4 3 u v 1 @.#.$.          ",
"  %.&.*.j C =.B 3 3 B T -.v 1 ;.~ : >.          ",
"    %.= H K ,.6 C C 2 W P '.;.).* $.            ",
"    M !.c 7 ;.'.1 '.1 H ~.] {.].$ >.            ",
"       .^.k /.).c (.).).{.k _.R >.              ",
"        :.<.[.}.].8 8 8 |.1.2.>.>.>.            ",
"          3.:.X 4.5.5.6.7.>.>.  >.>.>.>.        ",
"              >.>.>.>.>.>.        , , >.>.      ",
"                                  >.8.. >.>.    ",
"                                    >.9.0.>.>.  ",
"                                      >.8.n >.  ",
"                                        >.>.    ",
"                                                "};

/* XPM */
static char * icon_zoomout[] = {
"24 24 132 2",
"  	c None",
". 	c #343434",
"+ 	c #2D2D2D",
"@ 	c #292929",
"# 	c #262626",
"$ 	c #2E2E2E",
"% 	c #303030",
"& 	c #737373",
"* 	c #A1A1A1",
"= 	c #B4B4B4",
"- 	c #B2B2B2",
"; 	c #9D9D9D",
"> 	c #676767",
", 	c #202020",
"' 	c #1C1C1C",
") 	c #272727",
"! 	c #616161",
"~ 	c #CACACA",
"{ 	c #CFCFCF",
"] 	c #D0D0D0",
"^ 	c #CECECE",
"/ 	c #C9C9C9",
"( 	c #C1C1C1",
"_ 	c #A7A7A7",
": 	c #4C4C4C",
"< 	c #131313",
"[ 	c #222222",
"} 	c #757575",
"| 	c #D3D3D3",
"1 	c #DBDBDB",
"2 	c #E7E7E7",
"3 	c #EFEFEF",
"4 	c #F3F3F3",
"5 	c #F1F1F1",
"6 	c #E5E5E5",
"7 	c #D2D2D2",
"8 	c #BCBCBC",
"9 	c #5E5E5E",
"0 	c #101010",
"a 	c #212121",
"b 	c #5B5B5B",
"c 	c #CCCCCC",
"d 	c #D7D7D7",
"e 	c #F5F5F5",
"f 	c #FAFAFA",
"g 	c #FBFBFB",
"h 	c #F8F8F8",
"i 	c #F0F0F0",
"j 	c #E1E1E1",
"k 	c #C2C2C2",
"l 	c #434343",
"m 	c #0F0F0F",
"n 	c #1F1F1F",
"o 	c #B9B9B9",
"p 	c #D6D6D6",
"q 	c #F9F9F9",
"r 	c #FDFDFD",
"s 	c #454545",
"t 	c #F2F2F2",
"u 	c #ECECEC",
"v 	c #E4E4E4",
"w 	c #ABABAB",
"x 	c #0E0E0E",
"y 	c #1B1B1B",
"z 	c #6D6D6D",
"A 	c #FEFEFE",
"B 	c #FCFCFC",
"C 	c #EEEEEE",
"D 	c #E6E6E6",
"E 	c #575757",
"F 	c #090909",
"G 	c #141414",
"H 	c #A8A8A8",
"I 	c #D8D8D8",
"J 	c #F6F6F6",
"K 	c #F4F4F4",
"L 	c #DCDCDC",
"M 	c #9B9B9B",
"N 	c #060606",
"O 	c #111111",
"P 	c #C5C5C5",
"Q 	c #DFDFDF",
"R 	c #444444",
"S 	c #424242",
"T 	c #EDEDED",
"U 	c #BFBFBF",
"V 	c #C6C6C6",
"W 	c #E3E3E3",
"X 	c #414141",
"Y 	c #EAEAEA",
"Z 	c #E0E0E0",
"` 	c #BABABA",
" .	c #050505",
"..	c #0B0B0B",
"+.	c #A5A5A5",
"@.	c #D1D1D1",
"#.	c #939393",
"$.	c #020202",
"%.	c #0A0A0A",
"&.	c #5F5F5F",
"*.	c #D9D9D9",
"=.	c #EBEBEB",
"-.	c #E9E9E9",
";.	c #D4D4D4",
">.	c #000000",
",.	c #E2E2E2",
"'.	c #3F3F3F",
").	c #DADADA",
"!.	c #CBCBCB",
"~.	c #3B3B3B",
"{.	c #D5D5D5",
"].	c #C8C8C8",
"^.	c #BDBDBD",
"/.	c #515151",
"(.	c #C7C7C7",
"_.	c #CDCDCD",
":.	c #B8B8B8",
"<.	c #030303",
"[.	c #313131",
"}.	c #999999",
"|.	c #BBBBBB",
"1.	c #B6B6B6",
"2.	c #909090",
"3.	c #2B2B2B",
"4.	c #010101",
"5.	c #7A7A7A",
"6.	c #9A9A9A",
"7.	c #777777",
"8.	c #3C3C3C",
"9.	c #686868",
"0.	c #797979",
"a.	c #3A3A3A",
"                                                ",
"              . + @ # # #                       ",
"          $ % & * = - ; > , '                   ",
"        ) ! = ~ { ] ^ / ( _ : <                 ",
"      [ } ~ | 1 2 3 4 5 6 7 8 9 0               ",
"    a b c d 6 e f g f h e i j k l m             ",
"    n o p 2 q g r s s g h t u v w x             ",
"  y z 7 j e f r A s s B q e C D 1 E F           ",
"  G H I C J q B A s s g h K C D L M N           ",
"  O P Q 3 e R R s s s R l S T 6 1 U N           ",
"  x V W u t l R R R R l S X Y Z d `  .          ",
"  ..+.j 2 T 5 K J l l 4 3 u v 1 @.#.$.          ",
"  %.&.*.j D =.C 3 X X T -.v 1 ;.~ : >.          ",
"    %.= I L ,.6 D '.'.W Q ).;.!.* $.            ",
"    N ~.c 7 ;.).1 ).1 I {.] ].^.$ >.            ",
"       ./.k (.!.c _.!.!.].k :.s >.              ",
"        <.[.}.|.^.8 8 8 1.2.3.>.>.>.            ",
"          4.<.X 5.6.6.7.8.>.>.  >.>.>.>.        ",
"              >.>.>.>.>.>.        , , >.>.      ",
"                                  >.9.. >.>.    ",
"                                    >.0.a.>.>.  ",
"                                      >.9.n >.  ",
"                                        >.>.    ",
"                                                "};

/* XPM */
static char * icon_zoomfit[] = {
"24 24 140 2",
"  	c None",
". 	c #343434",
"+ 	c #2D2D2D",
"@ 	c #292929",
"# 	c #262626",
"$ 	c #2E2E2E",
"% 	c #303030",
"& 	c #737373",
"* 	c #A1A1A1",
"= 	c #B4B4B4",
"- 	c #B2B2B2",
"; 	c #9D9D9D",
"> 	c #676767",
", 	c #202020",
"' 	c #1C1C1C",
") 	c #272727",
"! 	c #616161",
"~ 	c #CACACA",
"{ 	c #CFCFCF",
"] 	c #D0D0D0",
"^ 	c #CECECE",
"/ 	c #C9C9C9",
"( 	c #C1C1C1",
"_ 	c #A7A7A7",
": 	c #4C4C4C",
"< 	c #131313",
"[ 	c #222222",
"} 	c #757575",
"| 	c #D3D3D3",
"1 	c #DBDBDB",
"2 	c #E7E7E7",
"3 	c #EFEFEF",
"4 	c #F3F3F3",
"5 	c #F1F1F1",
"6 	c #E5E5E5",
"7 	c #D2D2D2",
"8 	c #BCBCBC",
"9 	c #5E5E5E",
"0 	c #101010",
"a 	c #212121",
"b 	c #5B5B5B",
"c 	c #CCCCCC",
"d 	c #464646",
"e 	c #4B4B4B",
"f 	c #505050",
"g 	c #525252",
"h 	c #FBFBFB",
"i 	c #FAFAFA",
"j 	c #515151",
"k 	c #4F4F4F",
"l 	c #4A4A4A",
"m 	c #C2C2C2",
"n 	c #434343",
"o 	c #0F0F0F",
"p 	c #1F1F1F",
"q 	c #B9B9B9",
"r 	c #D6D6D6",
"s 	c #535353",
"t 	c #FDFDFD",
"u 	c #FCFCFC",
"v 	c #4D4D4D",
"w 	c #E4E4E4",
"x 	c #ABABAB",
"y 	c #0E0E0E",
"z 	c #1B1B1B",
"A 	c #6D6D6D",
"B 	c #E1E1E1",
"C 	c #FEFEFE",
"D 	c #F9F9F9",
"E 	c #4E4E4E",
"F 	c #E6E6E6",
"G 	c #575757",
"H 	c #090909",
"I 	c #141414",
"J 	c #A8A8A8",
"K 	c #D8D8D8",
"L 	c #EEEEEE",
"M 	c #F8F8F8",
"N 	c #DCDCDC",
"O 	c #9B9B9B",
"P 	c #060606",
"Q 	c #111111",
"R 	c #C5C5C5",
"S 	c #DFDFDF",
"T 	c #F5F5F5",
"U 	c #F7F7F7",
"V 	c #F2F2F2",
"W 	c #EDEDED",
"X 	c #BFBFBF",
"Y 	c #C6C6C6",
"Z 	c #E3E3E3",
"` 	c #ECECEC",
" .	c #F4F4F4",
"..	c #F0F0F0",
"+.	c #EAEAEA",
"@.	c #E0E0E0",
"#.	c #D7D7D7",
"$.	c #BABABA",
"%.	c #050505",
"&.	c #0B0B0B",
"*.	c #A5A5A5",
"=.	c #F6F6F6",
"-.	c #D1D1D1",
";.	c #939393",
">.	c #020202",
",.	c #0A0A0A",
"'.	c #5F5F5F",
").	c #D9D9D9",
"!.	c #E9E9E9",
"~.	c #484848",
"{.	c #D4D4D4",
"].	c #000000",
"^.	c #494949",
"/.	c #474747",
"(.	c #454545",
"_.	c #CBCBCB",
":.	c #3B3B3B",
"<.	c #DADADA",
"[.	c #444444",
"}.	c #414141",
"|.	c #BDBDBD",
"1.	c #C7C7C7",
"2.	c #CDCDCD",
"3.	c #C8C8C8",
"4.	c #B8B8B8",
"5.	c #030303",
"6.	c #313131",
"7.	c #999999",
"8.	c #BBBBBB",
"9.	c #B6B6B6",
"0.	c #909090",
"a.	c #2B2B2B",
"b.	c #010101",
"c.	c #7A7A7A",
"d.	c #9A9A9A",
"e.	c #777777",
"f.	c #3C3C3C",
"g.	c #686868",
"h.	c #797979",
"i.	c #3A3A3A",
"                                                ",
"              . + @ # # #                       ",
"          $ % & * = - ; > , '                   ",
"        ) ! = ~ { ] ^ / ( _ : <                 ",
"      [ } ~ | 1 2 3 4 5 6 7 8 9 0               ",
"    a b c d e f g h i j f k l m n o             ",
"    p q r : g g s t u g j k v w x y             ",
"  z A 7 B f g t C C t u D f E F 1 G H           ",
"  I J K L j g u C C t h M f E F N O P           ",
"  Q R S 3 T M h t t u i U V W 6 1 X P           ",
"  y Y Z ` V T M i i i U  ...+.@.#.$.%.          ",
"  &.*.B 2 E k  .=.=.T 4 3 v e 1 -.;.>.          ",
"  ,.'.).B e v L 3 3 L W !.e ~.{.~ : ].          ",
"    ,.= K ~.l e e F 2 l ^./.(._.* >.            ",
"    P :.c (.(./.~.<.1 /.d [.}.|.$ ].            ",
"      %.j m 1._.c 2._._.3.m 4.(.].              ",
"        5.6.7.8.|.8 8 8 9.0.a.].].].            ",
"          b.5.}.c.d.d.e.f.].].  ].].].].        ",
"              ].].].].].].        , , ].].      ",
"                                  ].g.. ].].    ",
"                                    ].h.i.].].  ",
"                                      ].g.p ].  ",
"                                        ].].    ",
"                                                "};

/* XPM */
static char * icon_zoomundo[] = {
"24 24 31 1",
" 	c None",
".	c #000000",
"+	c #EFE5BA",
"@	c #EFE7C1",
"#	c #EED680",
"$	c #EFE4B6",
"%	c #D5B75D",
"&	c #B29544",
"*	c #D1B051",
"=	c #C0AF73",
"-	c #C0A048",
";	c #986B07",
">	c #D1940C",
",	c #E0B74C",
"'	c #D9C374",
")	c #8F6406",
"!	c #D59D1C",
"~	c #B1933F",
"{	c #DFB74A",
"]	c #CCB76D",
"^	c #B8820A",
"/	c #D9A72E",
"(	c #D7A62C",
"_	c #C7B26A",
":	c #D4B150",
"<	c #A39256",
"[	c #E2CB79",
"}	c #C9B46B",
"|	c #8D7E4A",
"1	c #AE9C5C",
"2	c #96864F",
"                        ",
"                        ",
"                        ",
"          .             ",
"         ..             ",
"        .+.             ",
"       .@#....          ",
"      .$####%&.         ",
"     .+#######*.        ",
"    .=#########-.       ",
"     .;>>>>>>,#'..      ",
"      .)>>>>>>!#~.      ",
"       .)>...;>{].      ",
"        .;. ..^/#.      ",
"         ..  ..>#.      ",
"          .   .(_.      ",
"              .:<.      ",
"              .[.       ",
"             .}|.       ",
"            .12.        ",
"             ..         ",
"                        ",
"                        ",
"                        "};

/* XPM */
static char * zoom_larrow[] = {
"24 24 57 1",
" 	c None",
".	c #000000",
"+	c #F7F7F7",
"@	c #CBD6CA",
"#	c #E7EFE7",
"$	c #ACC8A9",
"%	c #C9DBC9",
"&	c #E6EEE5",
"*	c #BFCEBF",
"=	c #E7EFE6",
"-	c #BBCFBA",
";	c #B3C4B3",
">	c #E6EEE6",
",	c #B9CEB7",
"'	c #B5CEB5",
")	c #B7CCB5",
"!	c #BFD4BF",
"~	c #C7D7C5",
"{	c #DBE5DB",
"]	c #DAE5D9",
"^	c #CBDAC9",
"/	c #7EAB78",
"(	c #BAD1B9",
"_	c #B3CAB1",
":	c #B0C9B0",
"<	c #B0C9AE",
"[	c #AEC7AC",
"}	c #AAC5A8",
"|	c #A9C4A7",
"1	c #698267",
"2	c #E4ECE3",
"3	c #2D2D2D",
"4	c #E0EADE",
"5	c #B3CCB1",
"6	c #B0C7AE",
"7	c #ADC6AB",
"8	c #ADC8AB",
"9	c #AAC7A8",
"0	c #678C63",
"a	c #9FB79B",
"b	c #6B9063",
"c	c #C2CDC2",
"d	c #8EB48A",
"e	c #87AF84",
"f	c #87B083",
"g	c #88AF84",
"h	c #88B085",
"i	c #86AF82",
"j	c #547150",
"k	c #95A88F",
"l	c #5B7950",
"m	c #3C5235",
"n	c #4A6342",
"o	c #3B5035",
"p	c #415639",
"q	c #889D7F",
"r	c #475E3E",
"                        ",
"                        ",
"                        ",
"  ....        .         ",
"  .+@.       ..         ",
"  .#$.      .%.         ",
"  .#$.     .&*.         ",
"  .#$.    .=-;........  ",
"  .#$.   .>,'),!~{]^/.  ",
"  .#$.  .>(_:<[}}}[|1.  ",
"  .2$. 34567789[[6[80.  ",
"  .ab..cdeeeeefgefhij.  ",
"  .kl. .mllllllllllln.  ",
"  .kl.  .mlllllllllln.  ",
"  .kl.   .mllnoooooop.  ",
"  .kl.    .mln........  ",
"  .kl.     .mn.         ",
"  .kl.      .n.         ",
"  .qr.       ..         ",
"  ....        .         ",
"                        ",
"                        ",
"                        ",
"                        "};

/* XPM */
static char * zoom_rarrow[] = {
"24 24 52 1",
" 	c None",
".	c #000000",
"+	c #F7F7F7",
"@	c #CBD6CA",
"#	c #BECEBA",
"$	c #E7EFE7",
"%	c #ACC8A9",
"&	c #EBF2EA",
"*	c #77A16E",
"=	c #E3EBE2",
"-	c #709867",
";	c #F8F8F7",
">	c #F1F5F0",
",	c #ECF2EB",
"'	c #E5EEE3",
")	c #E0EBDF",
"!	c #D8E6D6",
"~	c #C6D9C2",
"{	c #C5D7C3",
"]	c #B2CBB0",
"^	c #AAC7A8",
"/	c #0F1308",
"(	c #DDE6DB",
"_	c #AEC8AD",
":	c #ABC7A8",
"<	c #AAC6A7",
"[	c #A8C6A5",
"}	c #ADC8AD",
"|	c #A8C7A8",
"1	c #A5C4A3",
"2	c #7F9F76",
"3	c #D6E1D4",
"4	c #ABC7AA",
"5	c #A7C5A4",
"6	c #A9C7A6",
"7	c #AFC8AD",
"8	c #A4C3A2",
"9	c #6B9060",
"0	c #E4ECE3",
"a	c #A7B6A2",
"b	c #698D60",
"c	c #6B9063",
"d	c #445B2C",
"e	c #9FB79B",
"f	c #9FB199",
"g	c #5B7950",
"h	c #95A88F",
"i	c #9FAF99",
"j	c #789171",
"k	c #506B46",
"l	c #889D7F",
"m	c #475E3E",
"                        ",
"                        ",
"                        ",
"        .        ....   ",
"        ..       .+@.   ",
"        .#.      .$%.   ",
"        .&*.     .$%.   ",
" ........=%-.    .$%.   ",
" .;>,')!~{]^-/   .$%.   ",
" .(_:::<[^}|12.  .$%.   ",
" .34[5[6:%^:789. .0%.   ",
" .abccccccccccbd..ec.   ",
" .fgggggggggggd. .hg.   ",
" .iggggggggggd.  .hg.   ",
" .jkkkkkkgggd.   .hg.   ",
" ........kgd.    .hg.   ",
"        .kd.     .hg.   ",
"        .d.      .hg.   ",
"        ..       .lm.   ",
"        .        ....   ",
"                        ",
"                        ",
"                        ",
"                        "};

/* XPM */
static char * prev_page_xpm[] = {
"24 24 170 2",
"  	c None",
". 	c #000000",
"+ 	c #040506",
"@ 	c #0B0F12",
"# 	c #959FAA",
"$ 	c #C3C6CA",
"% 	c #82909E",
"& 	c #F1F1F1",
"* 	c #D5D7D8",
"= 	c #0A0D10",
"- 	c #11171C",
"; 	c #8693A0",
"> 	c #EFF0F0",
", 	c #DEDEDE",
"' 	c #D5D5D5",
") 	c #9B9FA4",
"! 	c #0E1317",
"~ 	c #85929F",
"{ 	c #DBDBDB",
"] 	c #CACACA",
"^ 	c #C8C8C8",
"/ 	c #C8C9CA",
"( 	c #0C0F13",
"_ 	c #141A20",
": 	c #798895",
"< 	c #D2D2D2",
"[ 	c #C3C3C3",
"} 	c #CDCDCD",
"| 	c #74797E",
"1 	c #171F26",
"2 	c #7F8D9A",
"3 	c #DADADA",
"4 	c #D3D3D3",
"5 	c #C4C4C4",
"6 	c #CECECE",
"7 	c #C0C0C0",
"8 	c #B1B1B1",
"9 	c #0D1115",
"0 	c #768592",
"a 	c #EEEFEF",
"b 	c #D9D9D9",
"c 	c #D0D0D0",
"d 	c #C2C2C2",
"e 	c #CBCBCB",
"f 	c #C9C9C9",
"g 	c #BCBCBC",
"h 	c #A4A7A9",
"i 	c #686B6C",
"j 	c #333333",
"k 	c #414F5D",
"l 	c #ADB5BC",
"m 	c #EAEAEA",
"n 	c #BFBFBF",
"o 	c #BDBDBD",
"p 	c #C6C6C6",
"q 	c #B5B6B7",
"r 	c #899096",
"s 	c #B8B8B8",
"t 	c #FFFFFF",
"u 	c #404142",
"v 	c #4D6074",
"w 	c #EBEBEB",
"x 	c #D1D1D1",
"y 	c #C1C1C1",
"z 	c #B7B7B7",
"A 	c #979FA7",
"B 	c #A1A3A4",
"C 	c #FCFDFD",
"D 	c #F3F4F4",
"E 	c #EBECED",
"F 	c #EAEBEC",
"G 	c #E9EAEB",
"H 	c #EEEFF1",
"I 	c #F6F7F8",
"J 	c #E4E5E6",
"K 	c #929395",
"L 	c #32414F",
"M 	c #8C98A2",
"N 	c #E7E7E7",
"O 	c #BBBBBB",
"P 	c #A4A7AB",
"Q 	c #939699",
"R 	c #D7D8D8",
"S 	c #FAFCFC",
"T 	c #F9FAFB",
"U 	c #F8F9FA",
"V 	c #F7F8F9",
"W 	c #F5F6F8",
"X 	c #F7F7F9",
"Y 	c #C6C7C7",
"Z 	c #4F5E6A",
"` 	c #4C5F72",
" .	c #E8E8E8",
"..	c #BEBEBE",
"+.	c #1F1F1F",
"@.	c #B5B5B6",
"#.	c #979EA4",
"$.	c #A8A8A8",
"%.	c #FDFEFE",
"&.	c #F5F6F6",
"*.	c #E7E9E9",
"=.	c #F0F1F2",
"-.	c #E0E2E3",
";.	c #8F969D",
">.	c #151C22",
",.	c #354453",
"'.	c #8D99A2",
").	c #E3E3E3",
"!.	c #8E949A",
"~.	c #9D9F9F",
"{.	c #F2F3F4",
"].	c #F1F2F3",
"^.	c #F6F6F7",
"/.	c #A6A8AB",
"(.	c #737F8A",
"_.	c #4B5F71",
":.	c #CDDECB",
"<.	c #97999B",
"[.	c #E7E8E8",
"}.	c #F4F5F5",
"|.	c #FBFBFB",
"1.	c #D8D8DA",
"2.	c #939BA3",
"3.	c #0F1418",
"4.	c #B1C9B0",
"5.	c #E6E7E8",
"6.	c #FAFAFB",
"7.	c #F5F5F7",
"8.	c #AEB2B6",
"9.	c #5C6C7C",
"0.	c #B4CBB2",
"a.	c #B5CEB5",
"b.	c #B9CEB7",
"c.	c #BAD1BA",
"d.	c #BBD0B9",
"e.	c #B2C9B0",
"f.	c #7EAB78",
"g.	c #FBFCFC",
"h.	c #DEE1E3",
"i.	c #9DA6AE",
"j.	c #AAC7A8",
"k.	c #B3CAB1",
"l.	c #B0C9B0",
"m.	c #AEC7AC",
"n.	c #AAC5A8",
"o.	c #A9C4A7",
"p.	c #698267",
"q.	c #F9F9FA",
"r.	c #BBBFC4",
"s.	c #566779",
"t.	c #2D2D2D",
"u.	c #CFDFCC",
"v.	c #ADC8AB",
"w.	c #B0C7AE",
"x.	c #ADC6AB",
"y.	c #678C63",
"z.	c #D1D2D4",
"A.	c #9AA3AC",
"B.	c #3C5235",
"C.	c #5B7950",
"D.	c #4A6342",
"E.	c #E8ECEE",
"F.	c #B2B8BE",
"G.	c #717D88",
"H.	c #3B5035",
"I.	c #415639",
"J.	c #7A8695",
"K.	c #768594",
"L.	c #2C343D",
"M.	c #21272E",
"              . +                               ",
"            @ # $ .                             ",
"          @ % & * =                             ",
"        - ; > , ' ) .                           ",
"      ! ~ > { ] ^ / (                           ",
"    _ : & ' ] < [ } | .                         ",
"  1 2 > 3 4 5 6 7 ] 8 9                         ",
". 0 a b 4 c d e f g h i j . . . . . . .         ",
"k l m < n } e o p q r s t t t t t t t u .       ",
". v w x [ y ^ z [ A B C D E F G H I J K .       ",
"  L M N f O 5 d P Q R C S T U V W X Y Z .       ",
"  . `  .p ..+.@.#.$.%.&.*.E F =.U -.;.>..       ",
"    ,.'.).. . !.~.t %.C S {.].V ^./.(.+         ",
"    . _.. :.. <.b t [.a }.T U |.1.2.3.          ",
"      . :.4.. . . . . . . 5.6.7.8.9..           ",
"    . :.0.a.b.c.b.d.e.f.. T g.h.i.=             ",
"  . :.j.k.l.m.n.n.m.o.p.. g.q.r.s..             ",
"t.u.v.w.x.x.j.m.m.m.v.y.. t z.A.+               ",
"  . B.C.C.C.C.C.C.C.C.D.. E.F.G..               ",
"    . B.C.C.H.H.H.H.H.I.. J.K..                 ",
"      . B.C.. . . . . . . L.M.                  ",
"        . B..                                   ",
"          . .                                   ",
"            .                                   "};

/* XPM */
static char * next_page_xpm[] = {
"24 24 172 2",
"  	c None",
". 	c #000000",
"+ 	c #040506",
"@ 	c #0B0F12",
"# 	c #959FAA",
"$ 	c #C3C6CA",
"% 	c #82909E",
"& 	c #F1F1F1",
"* 	c #D5D7D8",
"= 	c #0A0D10",
"- 	c #11171C",
"; 	c #8693A0",
"> 	c #EFF0F0",
", 	c #DEDEDE",
"' 	c #D5D5D5",
") 	c #9B9FA4",
"! 	c #0E1317",
"~ 	c #85929F",
"{ 	c #DBDBDB",
"] 	c #CACACA",
"^ 	c #C8C8C8",
"/ 	c #C8C9CA",
"( 	c #0C0F13",
"_ 	c #141A20",
": 	c #798895",
"< 	c #D2D2D2",
"[ 	c #C3C3C3",
"} 	c #CDCDCD",
"| 	c #74797E",
"1 	c #171F26",
"2 	c #7F8D9A",
"3 	c #DADADA",
"4 	c #D3D3D3",
"5 	c #C4C4C4",
"6 	c #CECECE",
"7 	c #C0C0C0",
"8 	c #B1B1B1",
"9 	c #0D1115",
"0 	c #768592",
"a 	c #EEEFEF",
"b 	c #D9D9D9",
"c 	c #D0D0D0",
"d 	c #C2C2C2",
"e 	c #CBCBCB",
"f 	c #C9C9C9",
"g 	c #BCBCBC",
"h 	c #A4A7A9",
"i 	c #686B6C",
"j 	c #333333",
"k 	c #414F5D",
"l 	c #ADB5BC",
"m 	c #EAEAEA",
"n 	c #BFBFBF",
"o 	c #BDBDBD",
"p 	c #C6C6C6",
"q 	c #B5B6B7",
"r 	c #899096",
"s 	c #B8B8B8",
"t 	c #FFFFFF",
"u 	c #404142",
"v 	c #4D6074",
"w 	c #EBEBEB",
"x 	c #D1D1D1",
"y 	c #C1C1C1",
"z 	c #B7B7B7",
"A 	c #979FA7",
"B 	c #A1A3A4",
"C 	c #FCFDFD",
"D 	c #F3F4F4",
"E 	c #EBECED",
"F 	c #EAEBEC",
"G 	c #E9EAEB",
"H 	c #EEEFF1",
"I 	c #F6F7F8",
"J 	c #E4E5E6",
"K 	c #929395",
"L 	c #32414F",
"M 	c #8C98A2",
"N 	c #E7E7E7",
"O 	c #BBBBBB",
"P 	c #A4A7AB",
"Q 	c #939699",
"R 	c #D7D8D8",
"S 	c #FAFCFC",
"T 	c #F9FAFB",
"U 	c #F8F9FA",
"V 	c #F7F8F9",
"W 	c #F5F6F8",
"X 	c #F7F7F9",
"Y 	c #C6C7C7",
"Z 	c #4F5E6A",
"` 	c #4C5F72",
" .	c #E8E8E8",
"..	c #BEBEBE",
"+.	c #B5B5B6",
"@.	c #979EA4",
"#.	c #A8A8A8",
"$.	c #FDFEFE",
"%.	c #F5F6F6",
"&.	c #E7E9E9",
"*.	c #F0F1F2",
"=.	c #8F969D",
"-.	c #151C22",
";.	c #354453",
">.	c #8D99A2",
",.	c #E3E3E3",
"'.	c #8E949A",
").	c #9D9F9F",
"!.	c #F2F3F4",
"~.	c #F1F2F3",
"{.	c #F6F6F7",
"].	c #4B5F71",
"^.	c #E5E5E5",
"/.	c #9E9FA0",
"(.	c #97999B",
"_.	c #E7E8E8",
":.	c #F4F5F5",
"<.	c #FBFBFB",
"[.	c #D8D8DA",
"}.	c #77A16E",
"|.	c #394957",
"1.	c #828F97",
"2.	c #8A8E92",
"3.	c #B4B4B4",
"4.	c #ACC8A9",
"5.	c #709867",
"6.	c #4A5D70",
"7.	c #ABABAB",
"8.	c #F8F8F8",
"9.	c #C1D6BD",
"0.	c #BDD3B8",
"a.	c #BFD4BB",
"b.	c #C2D7BE",
"c.	c #B2CBB0",
"d.	c #AAC7A8",
"e.	c #0F1308",
"f.	c #242F3A",
"g.	c #696D71",
"h.	c #777879",
"i.	c #F2F3F3",
"j.	c #AEC5A8",
"k.	c #AEC8AD",
"l.	c #ABC7A8",
"m.	c #AAC6A7",
"n.	c #A8C6A5",
"o.	c #ADC8AD",
"p.	c #A8C7A8",
"q.	c #A5C4A3",
"r.	c #7F9F76",
"s.	c #4A5F74",
"t.	c #313E4B",
"u.	c #B3BDC6",
"v.	c #D1D7DD",
"w.	c #D9DEE3",
"x.	c #F6F7F7",
"y.	c #A6BFA0",
"z.	c #ABC7AA",
"A.	c #A9C7A6",
"B.	c #AFC8AD",
"C.	c #A4C3A2",
"D.	c #6B9060",
"E.	c #2B343C",
"F.	c #29323B",
"G.	c #4F5F70",
"H.	c #5E7184",
"I.	c #919EAB",
"J.	c #6C8562",
"K.	c #5B7950",
"L.	c #445B2C",
"M.	c #252D35",
"N.	c #65815C",
"O.	c #506B46",
"              . +                               ",
"            @ # $ .                             ",
"          @ % & * =                             ",
"        - ; > , ' ) .                           ",
"      ! ~ > { ] ^ / (                           ",
"    _ : & ' ] < [ } | .                         ",
"  1 2 > 3 4 5 6 7 ] 8 9                         ",
". 0 a b 4 c d e f g h i j . . . . . . .         ",
"k l m < n } e o p q r s t t t t t t t u .       ",
". v w x [ y ^ z [ A B C D E F G H I J K .       ",
"  L M N f O 5 d P Q R C S T U V W X Y Z .       ",
"  . `  .p ..s +.@.#.$.%.&.E F *.U . =.-..       ",
"    ;.>.,.y ..'.).t $.C S !.~.V {.. . +         ",
"    . ].^.y /.(.b t _.a :.T U <.[.. }..         ",
"      |.1.{ 2.3.t t $.. . . . . . . 4.5..       ",
"      . 6.O 7.t 8.& > . 9.0.a.b.b.b.c.d.5.e.    ",
"        f.g.h.i.t t t . j.k.l.l.m.n.o.p.q.r..   ",
"        . s.t.u.v.w.x.. y.z.n.n.A.l.d.l.B.C.D.. ",
"          . E.F.G.H.I.. J.K.K.K.K.K.K.K.K.L..   ",
"                . . M.. N.O.O.O.O.O.K.K.L..     ",
"                      . . . . . . . K.L..       ",
"                                  . L..         ",
"                                  . .           ",
"                                  .             "};

/* XPM */
static char * wave_info[] = {
"48 52 677 2",
"  	c None",
". 	c #000000",
"+ 	c #232323",
"@ 	c #1F1F1F",
"# 	c #DADADA",
"$ 	c #FFFFFF",
"% 	c #F6F6F6",
"& 	c #CFCFCF",
"* 	c #707070",
"= 	c #FEFEFE",
"- 	c #FBFBFB",
"; 	c #EDEDED",
"> 	c #C0C0C0",
", 	c #FF0000",
"' 	c #F7F7F7",
") 	c #D7D7D7",
"! 	c #F1F1F1",
"~ 	c #B7B7B7",
"{ 	c #D2D2D2",
"] 	c #AEAEAE",
"^ 	c #070707",
"/ 	c #FDFDFD",
"( 	c #B8B8B8",
"_ 	c #DCDCDC",
": 	c #A4A4A3",
"< 	c #0E0E0E",
"[ 	c #F5F5F4",
"} 	c #B5B5B5",
"| 	c #F9F9F9",
"1 	c #FCFCFC",
"2 	c #CBCBCB",
"3 	c #A5A5A5",
"4 	c #FDFDFC",
"5 	c #F4F4F4",
"6 	c #ACACAC",
"7 	c #ECECEC",
"8 	c #C3C3C3",
"9 	c #C2C2C2",
"0 	c #C9C9C8",
"a 	c #A8A8A8",
"b 	c #FCFCFB",
"c 	c #F4F4F3",
"d 	c #ABABAB",
"e 	c #515151",
"f 	c #474747",
"g 	c #464645",
"h 	c #464646",
"i 	c #5D5D5C",
"j 	c #A9A9A9",
"k 	c #FAFAFA",
"l 	c #F2F2F2",
"m 	c #F3F3F3",
"n 	c #AAAAAA",
"o 	c #A0A09F",
"p 	c #8A8A8A",
"q 	c #7A7A7A",
"r 	c #6C6C6C",
"s 	c #454545",
"t 	c #FAFAF9",
"u 	c #E7E7E7",
"v 	c #C6C6C5",
"w 	c #BABAB9",
"x 	c #F5F5F5",
"y 	c #EDEDEB",
"z 	c #B2B2B2",
"A 	c #949494",
"B 	c #7F7F7F",
"C 	c #8B8B8B",
"D 	c #8D8D8D",
"E 	c #EFEFEF",
"F 	c #737373",
"G 	c #727272",
"H 	c #666666",
"I 	c #4F4F4F",
"J 	c #4E4E4E",
"K 	c #4D4D4D",
"L 	c #505050",
"M 	c #CACACA",
"N 	c #4B4B4B",
"O 	c #4A4A4A",
"P 	c #4C4C4C",
"Q 	c #525252",
"R 	c #575757",
"S 	c #373737",
"T 	c #A1A1A1",
"U 	c #363636",
"V 	c #333333",
"W 	c #353535",
"X 	c #3F3F3F",
"Y 	c #5C5C5C",
"Z 	c #6B6B6B",
"` 	c #B1B1B1",
" .	c #A6A6A6",
"..	c #E4E4E4",
"+.	c #2E2E2E",
"@.	c #2D2D2D",
"#.	c #252525",
"$.	c #191919",
"%.	c #1B1B1B",
"&.	c #1C1C1C",
"*.	c #1E1E1E",
"=.	c #212121",
"-.	c #B9B9B9",
";.	c #1D1D1D",
">.	c #171717",
",.	c #242424",
"'.	c #222222",
").	c #919191",
"!.	c #292929",
"~.	c #F3F3F2",
"{.	c #9C9C9C",
"].	c #696969",
"^.	c #030303",
"/.	c #010101",
"(.	c #B0B0B0",
"_.	c #080808",
":.	c #060606",
"<.	c #868686",
"[.	c #040404",
"}.	c #0C0C0C",
"|.	c #2A2A2A",
"1.	c #F2F2F1",
"2.	c #979797",
"3.	c #5F5F5F",
"4.	c #131413",
"5.	c #222421",
"6.	c #2B302A",
"7.	c #B4BAB3",
"8.	c #2B312A",
"9.	c #2A3029",
"0.	c #292E28",
"a.	c #282D26",
"b.	c #272D26",
"c.	c #262C25",
"d.	c #252C24",
"e.	c #242B23",
"f.	c #242B22",
"g.	c #8B9289",
"h.	c #1E241D",
"i.	c #151814",
"j.	c #101010",
"k.	c #303030",
"l.	c #F1F1F0",
"m.	c #8E8E8E",
"n.	c #D4D4D4",
"o.	c #272A26",
"p.	c #495546",
"q.	c #64825E",
"r.	c #6B9063",
"s.	c #ABD3A2",
"t.	c #658D5C",
"u.	c #628C59",
"v.	c #608A56",
"w.	c #5E8B54",
"x.	c #598550",
"y.	c #57864D",
"z.	c #54844A",
"A.	c #518046",
"B.	c #4F8143",
"C.	c #84B779",
"D.	c #46773C",
"E.	c #344E2F",
"F.	c #1C241A",
"G.	c #F0F0F0",
"H.	c #848484",
"I.	c #D0D0D0",
"J.	c #262825",
"K.	c #5A6E56",
"L.	c #86C476",
"M.	c #8FE878",
"N.	c #8DEC74",
"O.	c #93F479",
"P.	c #84E66A",
"Q.	c #81E665",
"R.	c #7DE661",
"S.	c #7AE75C",
"T.	c #75E259",
"U.	c #72E653",
"V.	c #6EE14F",
"W.	c #6BE14A",
"X.	c #67E446",
"Y.	c #6FEC4D",
"Z.	c #60E53D",
"`.	c #53B13A",
" +	c #32522B",
".+	c #141A13",
"++	c #0B0B0B",
"@+	c #2B2B2B",
"#+	c #EFEFEE",
"$+	c #EFEFED",
"%+	c #777777",
"&+	c #CDCDCD",
"*+	c #414B3F",
"=+	c #7FB372",
"-+	c #93F778",
";+	c #90F974",
">+	c #8AF06F",
",+	c #90F474",
"'+	c #81E666",
")+	c #79E55C",
"!+	c #76E758",
"~+	c #71E153",
"{+	c #6FE64E",
"]+	c #67E145",
"^+	c #63E441",
"/+	c #69EE46",
"(+	c #60F537",
"_+	c #5AF032",
":+	c #449030",
"<+	c #20301D",
"[+	c #080908",
"}+	c #0A0A0A",
"|+	c #EEEEED",
"1+	c #EEEEEC",
"2+	c #FBFBFA",
"3+	c #747474",
"4+	c #313131",
"5+	c #1C1E1C",
"6+	c #586D53",
"7+	c #8AD676",
"8+	c #90FB73",
"9+	c #87E66E",
"0+	c #74B065",
"a+	c #9FD095",
"b+	c #5E8B53",
"c+	c #5A8850",
"d+	c #57864C",
"e+	c #548649",
"f+	c #508145",
"g+	c #4E8242",
"h+	c #4B7F3F",
"i+	c #487E3C",
"j+	c #47823A",
"k+	c #73C060",
"l+	c #56DA34",
"m+	c #58F72C",
"n+	c #4BBE2D",
"o+	c #284821",
"p+	c #0F140E",
"q+	c #343434",
"r+	c #414141",
"s+	c #EDEDEC",
"t+	c #E2E2E2",
"u+	c #D8D8D8",
"v+	c #C6C6C6",
"w+	c #BEBEBE",
"x+	c #BABABA",
"y+	c #BDC1BC",
"z+	c #B0D6A8",
"A+	c #96F57C",
"B+	c #8FFA72",
"C+	c #9AE089",
"D+	c #A7C0A2",
"E+	c #A6B0A3",
"F+	c #A0A79F",
"G+	c #9CA39B",
"H+	c #989E96",
"I+	c #949B92",
"J+	c #90978E",
"K+	c #878F85",
"L+	c #828B80",
"M+	c #7E8C7B",
"N+	c #799972",
"O+	c #67C750",
"P+	c #56F62C",
"Q+	c #56E92E",
"R+	c #619E53",
"S+	c #606C5E",
"T+	c #565756",
"U+	c #5A5A5A",
"V+	c #7B7B7B",
"W+	c #828282",
"X+	c #ECECEB",
"Y+	c #757575",
"Z+	c #3B4439",
"`+	c #77B069",
" @	c #8AF66D",
".@	c #84EC68",
"+@	c #65965A",
"@@	c #313C2F",
"#@	c #9C9D9C",
"$@	c #050505",
"%@	c #0D0F0C",
"&@	c #758672",
"*@	c #3D832D",
"=@	c #4DE625",
"-@	c #4AF21E",
";@	c #369320",
">@	c #182E13",
",@	c #050704",
"'@	c #121212",
")@	c #494949",
"!@	c #565656",
"~@	c #2C2C2C",
"{@	c #171917",
"]@	c #4D6149",
"^@	c #7FCE6C",
"/@	c #87FB68",
"(@	c #7DDB65",
"_@	c #53744C",
":@	c #1F241E",
"<@	c #959595",
"[@	c #020202",
"}@	c #70786E",
"|@	c #2E5B24",
"1@	c #45CA22",
"2@	c #48F719",
"3@	c #39B719",
"4@	c #1A3E12",
"5@	c #050C04",
"6@	c #141514",
"7@	c #595959",
"8@	c #EBEBEA",
"9@	c #F8F8F8",
"0@	c #5E5E5E",
"a@	c #BCBCBC",
"b@	c #638A5A",
"c@	c #82E867",
"d@	c #83FA62",
"e@	c #72C15E",
"f@	c #40543C",
"g@	c #151714",
"h@	c #6B6E6A",
"i@	c #203B1B",
"j@	c #39A51E",
"k@	c #42F112",
"l@	c #3AD410",
"m@	c #1E5C10",
"n@	c #061103",
"o@	c #111211",
"p@	c #555555",
"q@	c #EAEAE9",
"r@	c #EAEAE8",
"s@	c #F8F8F7",
"t@	c #5B5B5B",
"u@	c #0D0D0D",
"v@	c #3A4638",
"w@	c #71AE62",
"x@	c #81F563",
"y@	c #7DF15E",
"z@	c #64A155",
"A@	c #313D2E",
"B@	c #646664",
"C@	c #162813",
"D@	c #2C7919",
"E@	c #3ADE0E",
"F@	c #36DF09",
"G@	c #21780D",
"H@	c #091A05",
"I@	c #0E0F0D",
"J@	c #444444",
"K@	c #E9E9E8",
"L@	c #E9E9E7",
"M@	c #5D5D5D",
"N@	c #B6B6B6",
"O@	c #1A1C19",
"P@	c #4B6146",
"Q@	c #75C262",
"R@	c #7EF65D",
"S@	c #75DA5A",
"T@	c #517949",
"U@	c #212720",
"V@	c #0C160A",
"W@	c #1E5213",
"X@	c #30BA0C",
"Y@	c #33DD04",
"Z@	c #25890C",
"`@	c #0C2507",
" #	c #10130F",
".#	c #F6F6F5",
"+#	c #262B25",
"@#	c #5A8052",
"##	c #79E05E",
"$#	c #7BF957",
"%#	c #6BC554",
"&#	c #3E5639",
"*#	c #131613",
"=#	c #878787",
"-#	c #050A04",
";#	c #13350B",
">#	c #299E0B",
",#	c #32DA04",
"'#	c #2BB208",
")#	c #133D0A",
"!#	c #0F160E",
"~#	c #3E3E3E",
"{#	c #E8E8E7",
"]#	c #E8E8E6",
"^#	c #AFAFAF",
"/#	c #323D30",
"(#	c #66A257",
"_#	c #7AF458",
":#	c #75F553",
"<#	c #5EA44E",
"[#	c #2F3D2C",
"}#	c #0A0B0A",
"|#	c #838383",
"1#	c #585858",
"2#	c #010201",
"3#	c #091D06",
"4#	c #20720B",
"5#	c #30D004",
"6#	c #2FCB04",
"7#	c #1B610A",
"8#	c #0F1A0D",
"9#	c #404040",
"0#	c #131513",
"a#	c #3F513B",
"b#	c #6BB957",
"c#	c #75F752",
"d#	c #6EDC50",
"e#	c #4D7A43",
"f#	c #212A20",
"g#	c #808080",
"h#	c #545454",
"i#	c #040D02",
"j#	c #143F0A",
"k#	c #29A807",
"l#	c #2FCA04",
"m#	c #1F760A",
"n#	c #142511",
"o#	c #404240",
"p#	c #E7E7E6",
"q#	c #E6E6E4",
"r#	c #3C3C3C",
"s#	c #151515",
"t#	c #222721",
"u#	c #507348",
"v#	c #6FD654",
"w#	c #72F94D",
"x#	c #64C14B",
"y#	c #3B5836",
"z#	c #161A15",
"A#	c #7D7D7D",
"B#	c #010400",
"C#	c #0B2006",
"D#	c #218109",
"E#	c #2EC903",
"F#	c #249407",
"G#	c #163210",
"H#	c #3A3D3A",
"I#	c #565655",
"J#	c #E5E5E4",
"K#	c #CCCCCC",
"L#	c #C1C1C1",
"M#	c #B4B4B4",
"N#	c #AAABA9",
"O#	c #A8B5A5",
"P#	c #92D084",
"Q#	c #77F555",
"R#	c #73F84E",
"S#	c #84CE72",
"T#	c #93A38F",
"U#	c #8C8D8B",
"V#	c #7E7E7E",
"W#	c #797979",
"X#	c #717171",
"Y#	c #686868",
"Z#	c #636363",
"`#	c #424342",
" $	c #3A4538",
".$	c #337622",
"+$	c #2EBC08",
"@$	c #2DB00A",
"#$	c #2F5F23",
"$$	c #515750",
"%$	c #686867",
"&$	c #E1E1E0",
"*$	c #E3E3E2",
"=$	c #111111",
"-$	c #FBFDFA",
";$	c #EDF2EC",
">$	c #2E342D",
",$	c #575D56",
"'$	c #3F453E",
")$	c #2B322A",
"!$	c #2A3129",
"~$	c #2A3128",
"{$	c #293127",
"]$	c #A9B5A7",
"^$	c #466341",
"/$	c #66C050",
"($	c #6DFA47",
"_$	c #66E644",
":$	c #477D3C",
"<$	c #212A1F",
"[$	c #040403",
"}$	c #040504",
"|$	c #787978",
"1$	c #020302",
"2$	c #030801",
"3$	c #103807",
"4$	c #26A305",
"5$	c #2AB602",
"6$	c #1D6809",
"7$	c #283725",
"8$	c #3F443E",
"9$	c #CFD1CD",
"0$	c #D7D8D5",
"a$	c #323831",
"b$	c #E3F8DE",
"c$	c #CAEFC1",
"d$	c #6A9460",
"e$	c #7AA670",
"f$	c #6C9A62",
"g$	c #619057",
"h$	c #608F54",
"i$	c #5C8C51",
"j$	c #5A8C4E",
"k$	c #96CD89",
"l$	c #5EA44D",
"m$	c #69DF4A",
"n$	c #6AF945",
"o$	c #63C949",
"p$	c #45693D",
"q$	c #2C3B28",
"r$	c #1C2919",
"s$	c #1B2817",
"t$	c #1D2D1A",
"u$	c #7A8B76",
"v$	c #172614",
"w$	c #10190E",
"x$	c #152312",
"y$	c #1A2C15",
"z$	c #1C2C19",
"A$	c #1D291A",
"B$	c #1C2819",
"C$	c #172214",
"D$	c #152013",
"E$	c #515B4E",
"F$	c #111C0F",
"G$	c #111F0D",
"H$	c #15350D",
"I$	c #25850C",
"J$	c #2AB603",
"K$	c #218D05",
"L$	c #1E5111",
"M$	c #2B4D22",
"N$	c #0C2A04",
"O$	c #99B392",
"P$	c #AEBBA9",
"Q$	c #A6A7A5",
"R$	c #51644D",
"S$	c #B4F4A4",
"T$	c #9BF783",
"U$	c #88EC6D",
"V$	c #86EB6B",
"W$	c #81EC65",
"X$	c #7DE860",
"Y$	c #79E85B",
"Z$	c #75E757",
"`$	c #71E651",
" %	c #79F159",
".%	c #6BE84A",
"+%	c #6DF649",
"@%	c #6EF44A",
"#%	c #64BB4E",
"$%	c #4C7E3F",
"%%	c #39652E",
"&%	c #315C26",
"*%	c #2E5822",
"=%	c #2D5921",
"-%	c #73A266",
";%	c #2A591E",
">%	c #2C5821",
",%	c #3A6E2C",
"'%	c #407C30",
")%	c #427634",
"!%	c #38632E",
"~%	c #346029",
"{%	c #325D26",
"]%	c #305C24",
"^%	c #59864D",
"/%	c #2C591F",
"(%	c #2B5A1E",
"_%	c #28571B",
":%	c #265919",
"<%	c #2C7818",
"[%	c #2CAB08",
"}%	c #26A603",
"|%	c #259506",
"1%	c #288E0B",
"2%	c #1E8404",
"3%	c #42A029",
"4%	c #5EA14B",
"5%	c #90998D",
"6%	c #4F624A",
"7%	c #B0F49F",
"8%	c #97F77E",
"9%	c #84EB67",
"0%	c #83EA67",
"a%	c #7DEC60",
"b%	c #77E75A",
"c%	c #75E857",
"d%	c #70E552",
"e%	c #6DE64D",
"f%	c #74F053",
"g%	c #6BE44A",
"h%	c #71EC52",
"i%	c #6ACE51",
"j%	c #569546",
"k%	c #416E35",
"l%	c #336128",
"m%	c #315E24",
"n%	c #305F24",
"o%	c #2E5E21",
"p%	c #BEBCCB",
"q%	c #736F79",
"r%	c #2F362E",
"s%	c #DFF7DA",
"t%	c #C4EEBA",
"u%	c #619056",
"v%	c #71A165",
"w%	c #639558",
"x%	c #5B8E4F",
"y%	c #588D4C",
"z%	c #558A49",
"A%	c #538945",
"B%	c #8DC67F",
"C%	c #538A46",
"D%	c #59914C",
"E%	c #4F7846",
"F%	c #405A3A",
"G%	c #364A31",
"H%	c #34482F",
"I%	c #32472D",
"J%	c #32482D",
"K%	c #30462B",
"L%	c #625B81",
"M%	c #272534",
"N%	c #0F100F",
"O%	c #FAFDF9",
"P%	c #E8EEE5",
"Q%	c #2A3228",
"R%	c #60685F",
"S%	c #4C544A",
"T%	c #424B41",
"U%	c #434C42",
"V%	c #4F584D",
"W%	c #50594E",
"X%	c #ABB5A9",
"Y%	c #4C554A",
"Z%	c #3F473D",
"`%	c #373D36",
" &	c #3B3E3A",
".&	c #515450",
"+&	c #525652",
"@&	c #535652",
"#&	c #CAC8D5",
"$&	c #ECECEA",
"%&	c #555655",
"&&	c #383938",
"*&	c #474847",
"=&	c #626262",
"-&	c #616161",
";&	c #606060",
">&	c #A7A3B8",
",&	c #847F9C",
"'&	c #736D8E",
")&	c #DBDAE2",
"!&	c #9691AB",
"~&	c #EBEBE9",
"{&	c #B8B5C6",
"]&	c #E7E7E5",
"^&	c #E4E4E3",
"/&	c #E4E4E2",
"(&	c #EDECF0",
"_&	c #E5E5E3",
":&	c #E6E6E5",
"<&	c #E3E3E1",
"[&	c #A9A9A7",
"}&	c #A3A3A2",
"|&	c #A3A3A1",
"1&	c #E2E2E0",
"2&	c #E1E1DF",
"3&	c #9A9A9A",
"4&	c #8C8C8C",
"  . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . + @                       ",
". # $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ % & * .                   ",
". $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ = = = = = = = = = = = = - % ; > .                 ",
". $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ = = = = = = = = = = = = = = ' ) $ ! ~ .               ",
". $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ = = = = = = = = = = = = = = = = ' { $ $ ; ] ^             ",
". $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ = = = = = = = = = = = = = = = = / / % ( $ / $ _ : <           ",
". $ $ $ $ $ $ $ $ $ $ $ $ $ $ = = = = = = = = = = = = = = / / / / / / [ } $ | 1 $ 2 3 .         ",
". $ $ $ $ $ $ $ $ $ $ $ $ = = = = = = = = = = = = = / / / / / 4 1 1 1 5 6 7 8 2 ( 9 0 a .       ",
". $ $ $ $ $ $ $ $ $ $ = = = = = = = = = = = / / / / / / 4 1 1 1 1 1 b c d e f g h h i j .       ",
". $ $ $ $ $ $ $ $ = = = = = = = = = = / / / / / 4 1 1 1 1 1 1 b - - k l m > n o p q r s .       ",
". $ $ $ $ $ $ = = = = = = = = / / / / / 1 / / / / 1 1 b - - - - k t t | - ' ' u v 0 w q .       ",
". $ $ . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . x y j .       ",
". $ $ . z A q B C D E F G H e I J K L K M N h h O P Q R P S T U V W U V W X Y Z . m m ` .       ",
". $ = .  .B R Q h S ..+.@.#.$.%.&.$.*.=.-.$.;.>.$.@ *.,.'.>.).;.>.$.;.>.$.!.X X . ~.~.} .       ",
". $ / . {.].U ;.^.. # . . . . . . /.^.^ (._.^ ^ :.^ :.^ ^ :.<.[.^.. . . . }.|.|.. 1.1.} .       ",
". $ / . 2.3.@ ^.. . ) . . . . . :.4.5.6.7.8.9.0.a.b.c.d.e.f.g.h.i._.. . . j.k.k.. l.l.} .       ",
". $ 1 . m.h ^.. . . n.. . . . _.o.p.q.r.s.t.u.v.w.x.y.z.A.B.C.D.E.F._.. . < @.@.. G.G.} .       ",
". $ b . H.V . . . . I.. . . [.J.K.L.M.N.O.P.Q.R.S.T.U.V.W.X.Y.Z.`. +.+/.. ++!.@+. #+$+} .       ",
". $ - . %+k.. . . . &+. . . j.*+=+-+;+>+,+'+R.)+!+~+{+W.]+^+/+(+_+:+<+[+. }+@+W . |+1+} .       ",
". $ 2+. 3+4+. . . . M . . /.5+6+7+8+9+0+a+b+c+d+e+f+g+h+i+j+k+l+m+n+o+p+. }+q+r+. s+s+} .       ",
". $ k . E t+u+n.& 2 v+9 w+x+y+z+A+B+C+D+E+F+G+H+I+J+g.K+L+M+N+O+P+Q+R+S+T+U+V+W+. 7 X+} .       ",
". $ t . Y+k.. . . . 8 . . < Z+`+ @.@+@@@#@^ :.^ $@^ :.:.:.%@&@*@=@-@;@>@,@'@)@!@. X+X+} .       ",
". $ | . Z ~@. . . . > . . {@]@^@/@(@_@:@<@. . . . . . . . [@}@|@1@2@3@4@5@6@P 7@. 8@8@} .       ",
". $ 9@. 0@#.. . . . a@. [.0.b@c@d@e@f@g@).. . . . . . . . . h@i@j@k@l@m@n@o@s p@. q@r@} .       ",
". $ s@. t@#.. . . . -.. u@v@w@x@y@z@A@++D . . . . . . . . . B@C@D@E@F@G@H@I@J@R . K@L@} .       ",
". $ % . M@!.. . . . N@/.O@P@Q@R@S@T@U@^.p . . . . . . . . . 0@V@W@X@Y@Z@`@ #J@t@. L@L@} .       ",
". $ .#. U++ . . . . z [.+#@###$#%#&#*#. =#. . . . . . . . . U+-#;#>#,#'#)#!#~#R . {#]#} .       ",
". $ x . t@#.. . . . ^#++/#(#_#:#<#[#}#. |#. . . . . . . . . 1#2#3#4#5#6#7#8#9#R . ]#]#} .       ",
". $ c . t@#.. . . . 6 0#a#b#c#d#e#f#[.. g#. . . . . . . . . h#. i#j#k#l#m#n#o#U+. p#q#} .       ",
". $ l . r#s#. . . . n t#u#v#w#x#y#z#/.. A#. . . . . . . . . e . B#C#D#E#F#G#H#I#. q#J#} .       ",
"[@= 1.^ K#L#-.M#(.6 N#O#P#Q#R#S#T#U#W+V#W#Y+X#r Y#Z#3.t@!@Q J )@`# $.$+$@$#$$$%$. &$*$} .       ",
"=$-$;$>$,$'$)$!$~${$]$^$/$($_$:$<$^ [$}$|$1$. . . . . . . . O . . 2$3$4$5$6$7$8$B#9$0$(..       ",
"a$b$c$d$e$f$g$h$i$j$k$l$m$n$o$p$q$r$s$t$u$v$w$x$y$z$A$B$C$D$E$w$F$G$H$I$J$K$L$M$N$O$P$Q$.       ",
"R$S$T$U$V$W$X$Y$Z$`$ %.%+%@%#%$%%%&%*%=%-%;%>%,%'%)%!%~%{%]%^%/%(%_%:%<%[%}%|%1%2%3%4%5%.       ",
"6%7%8%9%0%a%b%c%d%e%f%g%h%i%j%k%l%m%n%o%p%p%p%p%p%p%p%p%p%p%p%p%p%p%p%p%p%p%p%p%p%p%p%p%p%p%p%q%",
"r%s%t%u%v%w%x%y%z%A%B%C%D%E%F%G%H%I%J%K%p%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%M%",
"N%O%P%Q%R%S%T%U%V%W%X%Y%Z%`% &.&+&+&@&.&p%L%L%L%#&L%L%#&L%L%#&L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%M%",
"/.= $&^ %&`#&&*&=&-&( ;&`#q+r#h#R 1#R 7@p%L%L%L%>&,&'&)&>&L%#&L%'&!&'&L%,&L%L%,&L%'&,&L%L%L%L%M%",
". $ ~&. . . . . . . . . . . . . . . . . p%L%L%L%!&!&!&!&#&L%#&L%#&!&)&L%#&L%'&{&,&#&>&{&L%L%L%M%",
". $ q@q@q@r@r@K@K@{#]#]#]&q#q#J#^&/&/&/&p%L%L%L%L%#&{&'&#&!&!&L%,&{&(&L%{&,&{&,&#&!&!&)&L%L%L%M%",
". $ r@K@K@K@K@{#]#]#p#p#]&]&q#q#_&_&/&/&p%L%L%L%L%#&#&L%#&{&'&,&#&'&#&L%'&{&#&L%#&!&!&!&L%L%L%M%",
". $ K@K@K@]#p#p#p#p#]&]&]&:&:&q#_&_&_&_&p%L%L%L%L%>&{&L%,&)&L%,&#&>&(&'&L%#&>&L%,&#&!&)&L%L%L%M%",
". $ L@p#p#p#p#]&]&]&:&:&:&q#_&_&_&^&^&/&p%L%L%L%L%'&'&L%L%,&L%L%,&,&'&'&L%,&'&L%L%'&!&L%L%L%L%M%",
". $ p#]&]&]&:&:&:&:&q#q#_&^&^&^&/&/&/&/&p%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%M%",
". $ ]&:&:&:&q#q#q#q#^&^&/&/&/&/&/&/&/&/&q%M%M%M%M%M%M%M%M%M%M%M%M%M%M%M%M%M%M%M%M%M%M%M%M%M%M%M%",
". $ :&q#q#q#q#J#^&/&/&/&/&/&/&/&/&/&/&<&<&[&: }&}&}&}&|&|&|&        |&|&|&|&|&|&|&|&|&D . . .   ",
". # q#q#q#_&/&/&/&/&/&/&/&/&/&/&*$<&<&<&<&<&<&<&<&1&1&1&1&2&2&2&2&2&2&2&2&2&2&2&2&2&2&3&.       ",
". 9 } } } } } } } } } } } } } } } } } } } } } } } } } } } } } } } } } } } } } } } } 3&4&.       ",
"  . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .       ",
"                                                                                                ",
"                                                                                                ",
"                                                                                                "};

/* XPM */
static char * wave_alert[] = {
"48 52 677 2",
"  	c None",
". 	c #000000",
"+ 	c #232323",
"@ 	c #1F1F1F",
"# 	c #DADADA",
"$ 	c #FFFFFF",
"% 	c #F6F6F6",
"& 	c #CFCFCF",
"* 	c #707070",
"= 	c #FEFEFE",
"- 	c #FBFBFB",
"; 	c #EDEDED",
"> 	c #C0C0C0",
", 	c #FF0000",
"' 	c #F7F7F7",
") 	c #D7D7D7",
"! 	c #F1F1F1",
"~ 	c #B7B7B7",
"{ 	c #D2D2D2",
"] 	c #AEAEAE",
"^ 	c #070707",
"/ 	c #FDFDFD",
"( 	c #B8B8B8",
"_ 	c #DCDCDC",
": 	c #A4A4A3",
"< 	c #0E0E0E",
"[ 	c #F5F5F4",
"} 	c #B5B5B5",
"| 	c #F9F9F9",
"1 	c #FCFCFC",
"2 	c #CBCBCB",
"3 	c #A5A5A5",
"4 	c #FDFDFC",
"5 	c #F4F4F4",
"6 	c #ACACAC",
"7 	c #ECECEC",
"8 	c #C3C3C3",
"9 	c #C2C2C2",
"0 	c #C9C9C8",
"a 	c #A8A8A8",
"b 	c #FCFCFB",
"c 	c #F4F4F3",
"d 	c #ABABAB",
"e 	c #515151",
"f 	c #474747",
"g 	c #464645",
"h 	c #464646",
"i 	c #5D5D5C",
"j 	c #A9A9A9",
"k 	c #FAFAFA",
"l 	c #F2F2F2",
"m 	c #F3F3F3",
"n 	c #AAAAAA",
"o 	c #A0A09F",
"p 	c #8A8A8A",
"q 	c #7A7A7A",
"r 	c #6C6C6C",
"s 	c #454545",
"t 	c #FAFAF9",
"u 	c #E7E7E7",
"v 	c #C6C6C5",
"w 	c #BABAB9",
"x 	c #F5F5F5",
"y 	c #EDEDEB",
"z 	c #B2B2B2",
"A 	c #949494",
"B 	c #7F7F7F",
"C 	c #8B8B8B",
"D 	c #8D8D8D",
"E 	c #EFEFEF",
"F 	c #737373",
"G 	c #727272",
"H 	c #666666",
"I 	c #4F4F4F",
"J 	c #4E4E4E",
"K 	c #4D4D4D",
"L 	c #505050",
"M 	c #CACACA",
"N 	c #4B4B4B",
"O 	c #4A4A4A",
"P 	c #4C4C4C",
"Q 	c #525252",
"R 	c #575757",
"S 	c #373737",
"T 	c #A1A1A1",
"U 	c #363636",
"V 	c #333333",
"W 	c #353535",
"X 	c #3F3F3F",
"Y 	c #5C5C5C",
"Z 	c #6B6B6B",
"` 	c #B1B1B1",
" .	c #A6A6A6",
"..	c #E4E4E4",
"+.	c #2E2E2E",
"@.	c #2D2D2D",
"#.	c #252525",
"$.	c #191919",
"%.	c #1B1B1B",
"&.	c #1C1C1C",
"*.	c #1E1E1E",
"=.	c #212121",
"-.	c #B9B9B9",
";.	c #1D1D1D",
">.	c #171717",
",.	c #242424",
"'.	c #222222",
").	c #919191",
"!.	c #292929",
"~.	c #F3F3F2",
"{.	c #9C9C9C",
"].	c #696969",
"^.	c #030303",
"/.	c #010101",
"(.	c #B0B0B0",
"_.	c #080808",
":.	c #060606",
"<.	c #868686",
"[.	c #040404",
"}.	c #0C0C0C",
"|.	c #2A2A2A",
"1.	c #F2F2F1",
"2.	c #979797",
"3.	c #5F5F5F",
"4.	c #131413",
"5.	c #222421",
"6.	c #2B302A",
"7.	c #B4BAB3",
"8.	c #2B312A",
"9.	c #2A3029",
"0.	c #292E28",
"a.	c #282D26",
"b.	c #272D26",
"c.	c #262C25",
"d.	c #252C24",
"e.	c #242B23",
"f.	c #242B22",
"g.	c #8B9289",
"h.	c #1E241D",
"i.	c #151814",
"j.	c #101010",
"k.	c #303030",
"l.	c #F1F1F0",
"m.	c #8E8E8E",
"n.	c #D4D4D4",
"o.	c #272A26",
"p.	c #495546",
"q.	c #64825E",
"r.	c #6B9063",
"s.	c #ABD3A2",
"t.	c #658D5C",
"u.	c #628C59",
"v.	c #608A56",
"w.	c #5E8B54",
"x.	c #598550",
"y.	c #57864D",
"z.	c #54844A",
"A.	c #518046",
"B.	c #4F8143",
"C.	c #84B779",
"D.	c #46773C",
"E.	c #344E2F",
"F.	c #1C241A",
"G.	c #F0F0F0",
"H.	c #848484",
"I.	c #D0D0D0",
"J.	c #262825",
"K.	c #5A6E56",
"L.	c #86C476",
"M.	c #8FE878",
"N.	c #8DEC74",
"O.	c #93F479",
"P.	c #84E66A",
"Q.	c #81E665",
"R.	c #7DE661",
"S.	c #7AE75C",
"T.	c #75E259",
"U.	c #72E653",
"V.	c #6EE14F",
"W.	c #6BE14A",
"X.	c #67E446",
"Y.	c #6FEC4D",
"Z.	c #60E53D",
"`.	c #53B13A",
" +	c #32522B",
".+	c #141A13",
"++	c #0B0B0B",
"@+	c #2B2B2B",
"#+	c #EFEFEE",
"$+	c #EFEFED",
"%+	c #777777",
"&+	c #CDCDCD",
"*+	c #414B3F",
"=+	c #7FB372",
"-+	c #93F778",
";+	c #90F974",
">+	c #8AF06F",
",+	c #90F474",
"'+	c #81E666",
")+	c #79E55C",
"!+	c #76E758",
"~+	c #71E153",
"{+	c #6FE64E",
"]+	c #67E145",
"^+	c #63E441",
"/+	c #69EE46",
"(+	c #60F537",
"_+	c #5AF032",
":+	c #449030",
"<+	c #20301D",
"[+	c #080908",
"}+	c #0A0A0A",
"|+	c #EEEEED",
"1+	c #EEEEEC",
"2+	c #FBFBFA",
"3+	c #747474",
"4+	c #313131",
"5+	c #1C1E1C",
"6+	c #586D53",
"7+	c #8AD676",
"8+	c #90FB73",
"9+	c #87E66E",
"0+	c #74B065",
"a+	c #9FD095",
"b+	c #5E8B53",
"c+	c #5A8850",
"d+	c #57864C",
"e+	c #548649",
"f+	c #508145",
"g+	c #4E8242",
"h+	c #4B7F3F",
"i+	c #487E3C",
"j+	c #47823A",
"k+	c #73C060",
"l+	c #56DA34",
"m+	c #58F72C",
"n+	c #4BBE2D",
"o+	c #284821",
"p+	c #0F140E",
"q+	c #343434",
"r+	c #414141",
"s+	c #EDEDEC",
"t+	c #E2E2E2",
"u+	c #D8D8D8",
"v+	c #C6C6C6",
"w+	c #BEBEBE",
"x+	c #BABABA",
"y+	c #BDC1BC",
"z+	c #B0D6A8",
"A+	c #96F57C",
"B+	c #8FFA72",
"C+	c #9AE089",
"D+	c #A7C0A2",
"E+	c #A6B0A3",
"F+	c #A0A79F",
"G+	c #9CA39B",
"H+	c #989E96",
"I+	c #949B92",
"J+	c #90978E",
"K+	c #878F85",
"L+	c #828B80",
"M+	c #7E8C7B",
"N+	c #799972",
"O+	c #67C750",
"P+	c #56F62C",
"Q+	c #56E92E",
"R+	c #619E53",
"S+	c #606C5E",
"T+	c #565756",
"U+	c #5A5A5A",
"V+	c #7B7B7B",
"W+	c #828282",
"X+	c #ECECEB",
"Y+	c #757575",
"Z+	c #3B4439",
"`+	c #77B069",
" @	c #8AF66D",
".@	c #84EC68",
"+@	c #65965A",
"@@	c #313C2F",
"#@	c #9C9D9C",
"$@	c #050505",
"%@	c #0D0F0C",
"&@	c #758672",
"*@	c #3D832D",
"=@	c #4DE625",
"-@	c #4AF21E",
";@	c #369320",
">@	c #182E13",
",@	c #050704",
"'@	c #121212",
")@	c #494949",
"!@	c #565656",
"~@	c #2C2C2C",
"{@	c #171917",
"]@	c #4D6149",
"^@	c #7FCE6C",
"/@	c #87FB68",
"(@	c #7DDB65",
"_@	c #53744C",
":@	c #1F241E",
"<@	c #959595",
"[@	c #020202",
"}@	c #70786E",
"|@	c #2E5B24",
"1@	c #45CA22",
"2@	c #48F719",
"3@	c #39B719",
"4@	c #1A3E12",
"5@	c #050C04",
"6@	c #141514",
"7@	c #595959",
"8@	c #EBEBEA",
"9@	c #F8F8F8",
"0@	c #5E5E5E",
"a@	c #BCBCBC",
"b@	c #638A5A",
"c@	c #82E867",
"d@	c #83FA62",
"e@	c #72C15E",
"f@	c #40543C",
"g@	c #151714",
"h@	c #6B6E6A",
"i@	c #203B1B",
"j@	c #39A51E",
"k@	c #42F112",
"l@	c #3AD410",
"m@	c #1E5C10",
"n@	c #061103",
"o@	c #111211",
"p@	c #555555",
"q@	c #EAEAE9",
"r@	c #EAEAE8",
"s@	c #F8F8F7",
"t@	c #5B5B5B",
"u@	c #0D0D0D",
"v@	c #3A4638",
"w@	c #71AE62",
"x@	c #81F563",
"y@	c #7DF15E",
"z@	c #64A155",
"A@	c #313D2E",
"B@	c #646664",
"C@	c #162813",
"D@	c #2C7919",
"E@	c #3ADE0E",
"F@	c #36DF09",
"G@	c #21780D",
"H@	c #091A05",
"I@	c #0E0F0D",
"J@	c #444444",
"K@	c #E9E9E8",
"L@	c #E9E9E7",
"M@	c #5D5D5D",
"N@	c #B6B6B6",
"O@	c #1A1C19",
"P@	c #4B6146",
"Q@	c #75C262",
"R@	c #7EF65D",
"S@	c #75DA5A",
"T@	c #517949",
"U@	c #212720",
"V@	c #0C160A",
"W@	c #1E5213",
"X@	c #30BA0C",
"Y@	c #33DD04",
"Z@	c #25890C",
"`@	c #0C2507",
" #	c #10130F",
".#	c #F6F6F5",
"+#	c #262B25",
"@#	c #5A8052",
"##	c #79E05E",
"$#	c #7BF957",
"%#	c #6BC554",
"&#	c #3E5639",
"*#	c #131613",
"=#	c #878787",
"-#	c #050A04",
";#	c #13350B",
">#	c #299E0B",
",#	c #32DA04",
"'#	c #2BB208",
")#	c #133D0A",
"!#	c #0F160E",
"~#	c #3E3E3E",
"{#	c #E8E8E7",
"]#	c #E8E8E6",
"^#	c #AFAFAF",
"/#	c #323D30",
"(#	c #66A257",
"_#	c #7AF458",
":#	c #75F553",
"<#	c #5EA44E",
"[#	c #2F3D2C",
"}#	c #0A0B0A",
"|#	c #838383",
"1#	c #585858",
"2#	c #010201",
"3#	c #091D06",
"4#	c #20720B",
"5#	c #30D004",
"6#	c #2FCB04",
"7#	c #1B610A",
"8#	c #0F1A0D",
"9#	c #404040",
"0#	c #131513",
"a#	c #3F513B",
"b#	c #6BB957",
"c#	c #75F752",
"d#	c #6EDC50",
"e#	c #4D7A43",
"f#	c #212A20",
"g#	c #808080",
"h#	c #545454",
"i#	c #040D02",
"j#	c #143F0A",
"k#	c #29A807",
"l#	c #2FCA04",
"m#	c #1F760A",
"n#	c #142511",
"o#	c #404240",
"p#	c #E7E7E6",
"q#	c #E6E6E4",
"r#	c #3C3C3C",
"s#	c #151515",
"t#	c #222721",
"u#	c #507348",
"v#	c #6FD654",
"w#	c #72F94D",
"x#	c #64C14B",
"y#	c #3B5836",
"z#	c #161A15",
"A#	c #7D7D7D",
"B#	c #010400",
"C#	c #0B2006",
"D#	c #218109",
"E#	c #2EC903",
"F#	c #249407",
"G#	c #163210",
"H#	c #3A3D3A",
"I#	c #565655",
"J#	c #E5E5E4",
"K#	c #CCCCCC",
"L#	c #C1C1C1",
"M#	c #B4B4B4",
"N#	c #AAABA9",
"O#	c #A8B5A5",
"P#	c #92D084",
"Q#	c #77F555",
"R#	c #73F84E",
"S#	c #84CE72",
"T#	c #93A38F",
"U#	c #8C8D8B",
"V#	c #7E7E7E",
"W#	c #797979",
"X#	c #717171",
"Y#	c #686868",
"Z#	c #636363",
"`#	c #424342",
" $	c #3A4538",
".$	c #337622",
"+$	c #2EBC08",
"@$	c #2DB00A",
"#$	c #2F5F23",
"$$	c #515750",
"%$	c #686867",
"&$	c #E1E1E0",
"*$	c #E3E3E2",
"=$	c #111111",
"-$	c #FBFDFA",
";$	c #EDF2EC",
">$	c #2E342D",
",$	c #575D56",
"'$	c #3F453E",
")$	c #2B322A",
"!$	c #2A3129",
"~$	c #2A3128",
"{$	c #293127",
"]$	c #A9B5A7",
"^$	c #466341",
"/$	c #66C050",
"($	c #6DFA47",
"_$	c #66E644",
":$	c #477D3C",
"<$	c #212A1F",
"[$	c #040403",
"}$	c #040504",
"|$	c #787978",
"1$	c #020302",
"2$	c #030801",
"3$	c #103807",
"4$	c #26A305",
"5$	c #2AB602",
"6$	c #1D6809",
"7$	c #283725",
"8$	c #3F443E",
"9$	c #CFD1CD",
"0$	c #D7D8D5",
"a$	c #323831",
"b$	c #E3F8DE",
"c$	c #CAEFC1",
"d$	c #6A9460",
"e$	c #7AA670",
"f$	c #6C9A62",
"g$	c #619057",
"h$	c #608F54",
"i$	c #5C8C51",
"j$	c #5A8C4E",
"k$	c #96CD89",
"l$	c #5EA44D",
"m$	c #69DF4A",
"n$	c #6AF945",
"o$	c #63C949",
"p$	c #45693D",
"q$	c #2C3B28",
"r$	c #1C2919",
"s$	c #1B2817",
"t$	c #1D2D1A",
"u$	c #7A8B76",
"v$	c #172614",
"w$	c #10190E",
"x$	c #152312",
"y$	c #1A2C15",
"z$	c #1C2C19",
"A$	c #1D291A",
"B$	c #1C2819",
"C$	c #172214",
"D$	c #152013",
"E$	c #515B4E",
"F$	c #111C0F",
"G$	c #111F0D",
"H$	c #15350D",
"I$	c #25850C",
"J$	c #2AB603",
"K$	c #218D05",
"L$	c #1E5111",
"M$	c #2B4D22",
"N$	c #0C2A04",
"O$	c #99B392",
"P$	c #AEBBA9",
"Q$	c #A6A7A5",
"R$	c #51644D",
"S$	c #B4F4A4",
"T$	c #9BF783",
"U$	c #88EC6D",
"V$	c #86EB6B",
"W$	c #81EC65",
"X$	c #7DE860",
"Y$	c #79E85B",
"Z$	c #75E757",
"`$	c #71E651",
" %	c #79F159",
".%	c #6BE84A",
"+%	c #6DF649",
"@%	c #6EF44A",
"#%	c #64BB4E",
"$%	c #4C7E3F",
"%%	c #39652E",
"&%	c #315C26",
"*%	c #2E5822",
"=%	c #2D5921",
"-%	c #73A266",
";%	c #2A591E",
">%	c #2C5821",
",%	c #3A6E2C",
"'%	c #407C30",
")%	c #427634",
"!%	c #38632E",
"~%	c #346029",
"{%	c #325D26",
"]%	c #305C24",
"^%	c #59864D",
"/%	c #2C591F",
"(%	c #2B5A1E",
"_%	c #28571B",
":%	c #265919",
"<%	c #2C7818",
"[%	c #2CAB08",
"}%	c #26A603",
"|%	c #259506",
"1%	c #288E0B",
"2%	c #1E8404",
"3%	c #42A029",
"4%	c #5EA14B",
"5%	c #90998D",
"6%	c #4F624A",
"7%	c #B0F49F",
"8%	c #97F77E",
"9%	c #84EB67",
"0%	c #83EA67",
"a%	c #7DEC60",
"b%	c #77E75A",
"c%	c #75E857",
"d%	c #70E552",
"e%	c #6DE64D",
"f%	c #74F053",
"g%	c #6BE44A",
"h%	c #71EC52",
"i%	c #6ACE51",
"j%	c #569546",
"k%	c #416E35",
"l%	c #336128",
"m%	c #315E24",
"n%	c #305F24",
"o%	c #2E5E21",
"p%	c #BEBCCB",
"q%	c #736F79",
"r%	c #2F362E",
"s%	c #DFF7DA",
"t%	c #C4EEBA",
"u%	c #619056",
"v%	c #71A165",
"w%	c #639558",
"x%	c #5B8E4F",
"y%	c #588D4C",
"z%	c #558A49",
"A%	c #538945",
"B%	c #8DC67F",
"C%	c #538A46",
"D%	c #59914C",
"E%	c #4F7846",
"F%	c #405A3A",
"G%	c #364A31",
"H%	c #34482F",
"I%	c #32472D",
"J%	c #32482D",
"K%	c #30462B",
"L%	c #625B81",
"M%	c #272534",
"N%	c #0F100F",
"O%	c #FAFDF9",
"P%	c #E8EEE5",
"Q%	c #2A3228",
"R%	c #60685F",
"S%	c #4C544A",
"T%	c #424B41",
"U%	c #434C42",
"V%	c #4F584D",
"W%	c #50594E",
"X%	c #ABB5A9",
"Y%	c #4C554A",
"Z%	c #3F473D",
"`%	c #373D36",
" &	c #3B3E3A",
".&	c #515450",
"+&	c #525652",
"@&	c #535652",
"#&	c #CAC8D5",
"$&	c #ECECEA",
"%&	c #555655",
"&&	c #383938",
"*&	c #474847",
"=&	c #626262",
"-&	c #616161",
";&	c #606060",
">&	c #A7A3B8",
",&	c #847F9C",
"'&	c #736D8E",
")&	c #DBDAE2",
"!&	c #9691AB",
"~&	c #EBEBE9",
"{&	c #B8B5C6",
"]&	c #E7E7E5",
"^&	c #E4E4E3",
"/&	c #E4E4E2",
"(&	c #EDECF0",
"_&	c #E5E5E3",
":&	c #E6E6E5",
"<&	c #E3E3E1",
"[&	c #A9A9A7",
"}&	c #A3A3A2",
"|&	c #A3A3A1",
"1&	c #E2E2E0",
"2&	c #E1E1DF",
"3&	c #9A9A9A",
"4&	c #8C8C8C",
"  . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . + @                       ",
". # $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ % & * .                   ",
". $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ = = = = = = = = = = = = - % ; > .                 ",
". $ $ $ , $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ = = = = = = = = = = = = = = ' ) $ ! ~ .               ",
". $ $ $ , $ $ $ $ $ $ $ $ $ $ $ $ $ $ = = = = = = = = = = = = = = = = ' { $ $ ; ] ^             ",
". $ $ $ , $ $ $ $ $ $ $ $ $ $ $ $ = = = = = = = = = = = = = = = = / / % ( $ / $ _ : <           ",
". $ $ $ , $ $ $ $ $ $ $ $ $ $ = = = = = = = = = = = = = = / / / / / / [ } $ | 1 $ 2 3 .         ",
". $ $ $ $ $ $ $ $ $ $ $ $ = = = = = = = = = = = = = / / / / / 4 1 1 1 5 6 7 8 2 ( 9 0 a .       ",
". $ $ $ , $ $ $ $ $ $ = = = = = = = = = = = / / / / / / 4 1 1 1 1 1 b c d e f g h h i j .       ",
". $ $ $ $ $ $ $ $ = = = = = = = = = = / / / / / 4 1 1 1 1 1 1 b - - k l m > n o p q r s .       ",
". $ $ $ $ $ $ = = = = = = = = / / / / / 1 / / / / 1 1 b - - - - k t t | - ' ' u v 0 w q .       ",
". $ $ . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . x y j .       ",
". $ $ . z A q B C D E F G H e I J K L K M N h h O P Q R P S T U V W U V W X Y Z . m m ` .       ",
". $ = .  .B R Q h S ..+.@.#.$.%.&.$.*.=.-.$.;.>.$.@ *.,.'.>.).;.>.$.;.>.$.!.X X . ~.~.} .       ",
". $ / . {.].U ;.^.. # . . . . . . /.^.^ (._.^ ^ :.^ :.^ ^ :.<.[.^.. . . . }.|.|.. 1.1.} .       ",
". $ / . 2.3.@ ^.. . ) . . . . . :.4.5.6.7.8.9.0.a.b.c.d.e.f.g.h.i._.. . . j.k.k.. l.l.} .       ",
". $ 1 . m.h ^.. . . n.. . . . _.o.p.q.r.s.t.u.v.w.x.y.z.A.B.C.D.E.F._.. . < @.@.. G.G.} .       ",
". $ b . H.V . . . . I.. . . [.J.K.L.M.N.O.P.Q.R.S.T.U.V.W.X.Y.Z.`. +.+/.. ++!.@+. #+$+} .       ",
". $ - . %+k.. . . . &+. . . j.*+=+-+;+>+,+'+R.)+!+~+{+W.]+^+/+(+_+:+<+[+. }+@+W . |+1+} .       ",
". $ 2+. 3+4+. . . . M . . /.5+6+7+8+9+0+a+b+c+d+e+f+g+h+i+j+k+l+m+n+o+p+. }+q+r+. s+s+} .       ",
". $ k . E t+u+n.& 2 v+9 w+x+y+z+A+B+C+D+E+F+G+H+I+J+g.K+L+M+N+O+P+Q+R+S+T+U+V+W+. 7 X+} .       ",
". $ t . Y+k.. . . . 8 . . < Z+`+ @.@+@@@#@^ :.^ $@^ :.:.:.%@&@*@=@-@;@>@,@'@)@!@. X+X+} .       ",
". $ | . Z ~@. . . . > . . {@]@^@/@(@_@:@<@. . . . . . . . [@}@|@1@2@3@4@5@6@P 7@. 8@8@} .       ",
". $ 9@. 0@#.. . . . a@. [.0.b@c@d@e@f@g@).. . . . . . . . . h@i@j@k@l@m@n@o@s p@. q@r@} .       ",
". $ s@. t@#.. . . . -.. u@v@w@x@y@z@A@++D . . . . . . . . . B@C@D@E@F@G@H@I@J@R . K@L@} .       ",
". $ % . M@!.. . . . N@/.O@P@Q@R@S@T@U@^.p . . . . . . . . . 0@V@W@X@Y@Z@`@ #J@t@. L@L@} .       ",
". $ .#. U++ . . . . z [.+#@###$#%#&#*#. =#. . . . . . . . . U+-#;#>#,#'#)#!#~#R . {#]#} .       ",
". $ x . t@#.. . . . ^#++/#(#_#:#<#[#}#. |#. . . . . . . . . 1#2#3#4#5#6#7#8#9#R . ]#]#} .       ",
". $ c . t@#.. . . . 6 0#a#b#c#d#e#f#[.. g#. . . . . . . . . h#. i#j#k#l#m#n#o#U+. p#q#} .       ",
". $ l . r#s#. . . . n t#u#v#w#x#y#z#/.. A#. . . . . . . . . e . B#C#D#E#F#G#H#I#. q#J#} .       ",
"[@= 1.^ K#L#-.M#(.6 N#O#P#Q#R#S#T#U#W+V#W#Y+X#r Y#Z#3.t@!@Q J )@`# $.$+$@$#$$$%$. &$*$} .       ",
"=$-$;$>$,$'$)$!$~${$]$^$/$($_$:$<$^ [$}$|$1$. . . . . . . . O . . 2$3$4$5$6$7$8$B#9$0$(..       ",
"a$b$c$d$e$f$g$h$i$j$k$l$m$n$o$p$q$r$s$t$u$v$w$x$y$z$A$B$C$D$E$w$F$G$H$I$J$K$L$M$N$O$P$Q$.       ",
"R$S$T$U$V$W$X$Y$Z$`$ %.%+%@%#%$%%%&%*%=%-%;%>%,%'%)%!%~%{%]%^%/%(%_%:%<%[%}%|%1%2%3%4%5%.       ",
"6%7%8%9%0%a%b%c%d%e%f%g%h%i%j%k%l%m%n%o%p%p%p%p%p%p%p%p%p%p%p%p%p%p%p%p%p%p%p%p%p%p%p%p%p%p%p%q%",
"r%s%t%u%v%w%x%y%z%A%B%C%D%E%F%G%H%I%J%K%p%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%M%",
"N%O%P%Q%R%S%T%U%V%W%X%Y%Z%`% &.&+&+&@&.&p%L%L%L%#&L%L%#&L%L%#&L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%M%",
"/.= $&^ %&`#&&*&=&-&( ;&`#q+r#h#R 1#R 7@p%L%L%L%>&,&'&)&>&L%#&L%'&!&'&L%,&L%L%,&L%'&,&L%L%L%L%M%",
". $ ~&. . . . . . . . . . . . . . . . . p%L%L%L%!&!&!&!&#&L%#&L%#&!&)&L%#&L%'&{&,&#&>&{&L%L%L%M%",
". $ q@q@q@r@r@K@K@{#]#]#]&q#q#J#^&/&/&/&p%L%L%L%L%#&{&'&#&!&!&L%,&{&(&L%{&,&{&,&#&!&!&)&L%L%L%M%",
". $ r@K@K@K@K@{#]#]#p#p#]&]&q#q#_&_&/&/&p%L%L%L%L%#&#&L%#&{&'&,&#&'&#&L%'&{&#&L%#&!&!&!&L%L%L%M%",
". $ K@K@K@]#p#p#p#p#]&]&]&:&:&q#_&_&_&_&p%L%L%L%L%>&{&L%,&)&L%,&#&>&(&'&L%#&>&L%,&#&!&)&L%L%L%M%",
". $ L@p#p#p#p#]&]&]&:&:&:&q#_&_&_&^&^&/&p%L%L%L%L%'&'&L%L%,&L%L%,&,&'&'&L%,&'&L%L%'&!&L%L%L%L%M%",
". $ p#]&]&]&:&:&:&:&q#q#_&^&^&^&/&/&/&/&p%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%L%M%",
". $ ]&:&:&:&q#q#q#q#^&^&/&/&/&/&/&/&/&/&q%M%M%M%M%M%M%M%M%M%M%M%M%M%M%M%M%M%M%M%M%M%M%M%M%M%M%M%",
". $ :&q#q#q#q#J#^&/&/&/&/&/&/&/&/&/&/&<&<&[&: }&}&}&}&|&|&|&        |&|&|&|&|&|&|&|&|&D . . .   ",
". # q#q#q#_&/&/&/&/&/&/&/&/&/&/&*$<&<&<&<&<&<&<&<&1&1&1&1&2&2&2&2&2&2&2&2&2&2&2&2&2&2&3&.       ",
". 9 } } } } } } } } } } } } } } } } } } } } } } } } } } } } } } } } } } } } } } } } 3&4&.       ",
"  . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .       ",
"                                                                                                ",
"                                                                                                ",
"                                                                                                "};


/* XPM */
static char *chart_organisation[] = {
/* columns rows colors chars-per-pixel */
"16 16 75 1",
"  c #5ED7B33C5AB0",
". c #6030B3F35AB0",
"X c #6030B4A95C17",
"o c #62D3B6145D7A",
"O c #62D3B6C85D7A",
"+ c #62D3B77C5ED7",
"@ c #67E5BA4462D3",
"# c #67E5BAF4641D",
"$ c #6DE7BDAF67E5",
"% c #6F11BFB46A57",
"& c #75CEC2B26F11",
"* c #7D35C6F175CE",
"= c #7F3EC83A77F7",
"- c #852ACB697D35",
"; c #8807CCAC7F3E",
": c #9A999A999A99",
"> c #A050A050A050",
", c #A75FA75FA75F",
"< c #AEE1AEE1AEE1",
"1 c #B6C8B6C8B6C8",
"2 c #BF08BF08BF08",
"3 c #8D95CFC9852A",
"4 c #8F63D1058715",
"5 c #9587D4AD8BC2",
"6 c #93CDD23F8E7D",
"7 c #9587D2DB8F63",
"8 c #9663D5488CAC",
"9 c #98EDD5E28F63",
"0 c #9663D3779048",
"q c #9816D412920D",
"w c #9B6DD714920D",
"e c #9C40D7AD92ED",
"r c #9DE3D84593CD",
"t c #9F82D9759587",
"y c #A050D9759663",
"u c #A37CDB3998ED",
"i c #A37CDB3999C4",
"p c #A50DDC649B6D",
"a c #A69ADCF99C40",
"s c #A75FDD8E9D12",
"d c #A9A8DEB69F82",
"f c #B284DE22AB2A",
"g c #BAF4E194B4A9",
"h c #BDAFE2B7B77C",
"j c #C457E4F8BF08",
"k c #823DB3F3E06F",
"l c #8F63BDAFE588",
"z c #9048BE5CE617",
"x c #9C40C64BEB10",
"c c #9D12C83AEB9C",
"v c #A75FCD4CF077",
"b c #A9A8CFC9F100",
"n c #B33CD4ADF4B4",
"m c #B4A9D5E2F53B",
"M c #BD01DA0CF85A",
"N c #BD01DAA3F85A",
"B c #C64BC64BC64B",
"V c #CC0BCC0BCC0B",
"C c #D23FD23FD23F",
"Z c #D548D548D548",
"A c #D714D714D714",
"S c #D845D845D845",
"D c #D9C0D9C0D9C0",
"F c #DBCFDBCFDBCF",
"G c #DCF9DCF9DCF9",
"H c #D23FEB10CDEC",
"J c #D377EB9CCFC9",
"K c #D412EC27D067",
"L c #D548ECB2D23F",
"P c #C3AFDE22FA6A",
"I c #D975DFDDF53B",
"U c #DE22E468F6CC",
"Y c #DF4AE588F751",
"T c #E348E96BF85A",
"R c None",
/* pixels */
"RRRRRRRRRRRRRRRR",
"RRRRRRPNmbRRRRRR",
"RRRRRRMTYcRRRRRR",
"RRRRRRnUIzRRRRRR",
"RRRRRRvxlkRRRRRR",
"RRRRRRRRRRRRRRRR",
"RRRRRRRSZRRRRRRR",
"RRGFDACVB21<,>RR",
"RRDRRRRRRRRRR:RR",
"RRRRRRRRRRRRRRRR",
"dspuRRe84;RR%#+o",
"aLKtRR5jh=RR@q0X",
"iJHeRR3gf&RRO76 ",
"yrw9RR-*&$RRX.  ",
"RRRRRRRRRRRRRRRR",
"RRRRRRRRRRRRRRRR"
};


/* XPM */
static char *cog[] = {
/* columns rows colors chars-per-pixel */
"16 16 103 2",
"   c #494949",
".  c #4E4E4E",
"X  c #515151",
"o  c gray32",
"O  c #535353",
"+  c #585858",
"@  c #5A5A5A",
"#  c #5B5B5B",
"$  c gray36",
"%  c gray38",
"&  c #626262",
"*  c #646464",
"=  c #676767",
"-  c DimGray",
";  c #6A6A6A",
":  c gray42",
">  c #6D6D6D",
",  c gray43",
"<  c #6F6F6F",
"1  c #717171",
"2  c #767676",
"3  c #777777",
"4  c #797979",
"5  c gray48",
"6  c #7E7E7E",
"7  c #808080",
"8  c #818181",
"9  c gray51",
"0  c #838383",
"q  c #848484",
"w  c gray52",
"e  c gray53",
"r  c #898989",
"t  c #8B8B8B",
"y  c gray55",
"u  c gray56",
"i  c #939393",
"p  c gray58",
"a  c #959595",
"s  c gray60",
"d  c #9A9A9A",
"f  c gray61",
"g  c gray62",
"h  c #A0A0A0",
"j  c gray63",
"k  c gray64",
"l  c #A4A4A4",
"z  c #A5A5A5",
"x  c gray65",
"c  c #A7A7A7",
"v  c gray66",
"b  c #AAAAAA",
"n  c gray67",
"m  c #ACACAC",
"M  c gray68",
"N  c gray69",
"B  c #B1B1B1",
"V  c #B2B2B2",
"C  c gray71",
"Z  c #B6B6B6",
"A  c #B7B7B7",
"S  c #B9B9B9",
"D  c gray73",
"F  c #BCBCBC",
"G  c gray74",
"H  c gray",
"J  c gray75",
"K  c #C0C0C0",
"L  c #C1C1C1",
"P  c gray76",
"I  c #C3C3C3",
"U  c gray77",
"Y  c #C5C5C5",
"T  c #C6C6C6",
"R  c gray78",
"E  c #C8C8C8",
"W  c gray79",
"Q  c #CACACA",
"!  c #CBCBCB",
"~  c gray80",
"^  c #CDCDCD",
"/  c #CECECE",
"(  c gray81",
")  c #D0D0D0",
"_  c gray82",
"`  c #D2D2D2",
"'  c gray83",
"]  c #D5D5D5",
"[  c gray84",
"{  c #D8D8D8",
"}  c gray85",
"|  c gray86",
" . c gainsboro",
".. c #DDDDDD",
"X. c gray87",
"o. c #E2E2E2",
"O. c #E4E4E4",
"+. c gray90",
"@. c #E7E7E7",
"#. c #E9E9E9",
"$. c gray93",
"%. c gray100",
"&. c None",
/* pixels */
"&.&.&.&.&.&.W I I L &.&.&.&.&.&.",
"&.&.&._ / / W +.+.M Z N M &.&.&.",
"&.&._ / / I I  . .N N M c k &.&.",
"&._  .$. .I D [ [ N M / #.Z t &.",
"&.W I  .[ { { { [ { _ / W 3 1 &.",
"&.&.I [ / W D f j I I L Z t &.&.",
"W I L { / D 0 3 6 u I L / u q q ",
"I #.[ W / k q &.&.d M I D I  .: ",
"D o.[ I / N u &.&.a c I D L _ & ",
"k u j _ I / j d a u L D D & + O ",
"&.&.M I L I W c k L D Z c : &.&.",
"&.M c [ I / _ W W / I L W , = &.",
"&.k D  .k q q L L , , k _ 0 O &.",
"&.&.0 1 & 3 q / W & @ @ .   &.&.",
"&.&.&., : 4 0 D N $ @ @ . &.&.&.",
"&.&.&.&.&.&., + O O &.&.&.&.&.&."
};


/* XPM */
static char *chart_line[] = {
/* columns rows colors chars-per-pixel */
"16 16 78 1",
"  c #2E5FA5",
". c #3062A9",
"X c #3062AA",
"o c #3264AC",
"O c #3366AE",
"+ c #3468B1",
"@ c #3568B2",
"# c #366BB5",
"$ c #376BB6",
"% c #3C72BF",
"& c #3D74C2",
"* c #3E75C3",
"= c #3E76C4",
"- c #3F76C5",
"; c #3F77C6",
": c #4670BB",
"> c #5A6BAD",
", c #4277C6",
"< c #4078C7",
"1 c #4179C9",
"2 c #417ACA",
"3 c #427ACB",
"4 c #427BCC",
"5 c #437CCC",
"6 c #437CCD",
"7 c #447DCE",
"8 c #457ED0",
"9 c #457FD1",
"0 c #709FBD",
"q c #8D527D",
"w c #AE4565",
"e c #ED222B",
"r c #EE262E",
"t c #EE272F",
"y c #EF2830",
"u c #EF2B32",
"i c #EF2D34",
"p c #F02E35",
"a c #F03137",
"s c #F03238",
"d c #F13339",
"f c #F1363C",
"g c #F1373C",
"h c #F2383D",
"j c #F2393E",
"k c #E73741",
"l c #E83841",
"z c #F23B40",
"x c #F03D43",
"c c #F23C41",
"v c #F33D42",
"b c #F33F43",
"n c #CC4D62",
"m c #F44246",
"M c #F44347",
"N c #F44548",
"B c #F54A4D",
"V c #F64D4F",
"C c #F75254",
"Z c #F85758",
"A c #F85859",
"S c #F95C5C",
"D c #F95D5D",
"F c #F96160",
"G c #FA6362",
"H c #FB6665",
"J c #FB6765",
"K c #FB6B69",
"L c #8F6493",
"P c #A85E82",
"I c #8CA1C0",
"U c #93ACD1",
"Y c #9CB1D0",
"T c #FE9694",
"R c #FC9997",
"E c #FEB5B2",
"W c gray100",
"Q c None",
/* pixels */
"QQQQQQQQQQQQQQQQ",
"QQQQQQQQQQQQQBNb",
"QQQQQQQQQQQQQmRj",
"QQQQQQQQQQQQmbjd",
"QQQQQQQQQQQQzfdQ",
"QQQQQQQ971QjfaQQ",
"KHGQQQQ5Y0>kq$+O",
"HEDAQQ51-:kw$+IX",
"FDACVP,-QdiQQO. ",
"QQQ7LnlfdiyQQQQQ",
"QQ51,=faTrQQQQQQ",
"951-QQQyreQQQQQQ",
"1U=QQQQQQQQQQQQQ",
"1=%QQQQQQQQQQQQQ",
"QQQQQQQQQQQQQQQQ",
"QQQQQQQQQQQQQQQQ"
};


/* XPM */
static char *flag_green[] = {
/* columns rows colors chars-per-pixel */
"16 16 107 2",
"   c #321D16",
".  c #507A51",
"X  c #87581D",
"o  c #8F5F21",
"O  c #9A6A2B",
"+  c #9C6B2C",
"@  c #886534",
"#  c #976E35",
"$  c #A4722E",
"%  c #AC7935",
"&  c #AC7B38",
"*  c #B07E3A",
"=  c #4DA630",
"-  c #4CA631",
";  c #4DA631",
":  c #4CA534",
">  c #47A538",
",  c #45A33C",
"<  c #52A035",
"1  c #47B133",
"2  c #47B233",
"3  c #4CB335",
"4  c #3B9477",
"5  c #44864D",
"6  c #548D49",
"7  c #4C984C",
"8  c #539447",
"9  c #5B9946",
"0  c #478856",
"q  c #428559",
"w  c #4B8C59",
"e  c #79B75E",
"r  c #63A76A",
"t  c #74CD5F",
"y  c #77CE63",
"u  c #78CF64",
"i  c #7ACF66",
"p  c #75C568",
"a  c #7BCD6A",
"s  c #7CCF68",
"d  c #7DD06A",
"f  c #7ED16C",
"g  c #70C777",
"h  c #BB8436",
"j  c #B1803C",
"k  c #BE8C45",
"l  c #C08C42",
"z  c #C79246",
"x  c #CA974D",
"c  c #D49E53",
"v  c #D6A256",
"b  c #DBAF6E",
"n  c #DFB77D",
"m  c #80D16D",
"M  c #3C7BA0",
"N  c #3084A1",
"B  c #478787",
"V  c #78BCB3",
"C  c #90AB8D",
"Z  c #ACB3AC",
"A  c #E2BC86",
"S  c #C0B4A0",
"D  c #96C282",
"F  c #96CF8E",
"G  c #8ED680",
"H  c #92D884",
"J  c #94D986",
"K  c #9BDB90",
"L  c #A2C99D",
"P  c #A1DE95",
"I  c #A3DE97",
"U  c #A3DF98",
"Y  c #A4DF99",
"T  c #A5DE9B",
"R  c #A5DF9B",
"E  c #A7E09E",
"W  c #9EDCA7",
"Q  c #98D7B6",
"!  c #A9D3A0",
"~  c #A9E0A1",
"^  c #ABE1A2",
"/  c #AAE0A3",
"(  c #ABE0A3",
")  c #AFE3A7",
"_  c #B0E3A8",
"`  c #B0E3AA",
"'  c #B1E3AB",
"]  c #B6E4AE",
"[  c #B7E6B0",
"{  c #B7E6B2",
"}  c #B9E6B4",
"|  c #B9E7B4",
" . c #BAE7B6",
".. c #BCE7B7",
"X. c #BCE7B8",
"o. c #BFE9B9",
"O. c #BEE8BA",
"+. c #E4C18F",
"@. c #C0E9BD",
"#. c #C2E9BF",
"$. c #C3EBC1",
"%. c #C6EBC3",
"&. c #C7ECC5",
"*. c #C8ECC6",
"=. c #CBEDC9",
"-. c #FBF7EF",
";. c None",
/* pixels */
";.;.;.;.;.;.;.;.;.;.;.;.;.;.;.;.",
";.;.;.;.;.;.;.. 6 7 0 @ X X ;.;.",
";.;.;.;.;.;.< e #.] m 8 -.h X ;.",
";.B : - ; = D %.=.o...S A $ ;.;.",
";.w @.X...$.*._ O.Y W # +.o ;.;.",
";.8 ~ u u H I [ { U F % b X ;.;.",
";.9 ^ i s H R  ._ P L l n X ;.;.",
"M ! K d f J E &.} [ C v z X ;.;.",
"N ` y t G ) | ( p g Z v * X ;.;.",
"4 T / / ' a 3 r Q V   c O ;.;.;.",
"q , 2 1 > 5 ;.;.;.;.+ v X ;.;.;.",
";.;.;.;.;.;.;.;.;.X j v X ;.;.;.",
";.;.;.;.;.;.;.;.;.X x v X ;.;.;.",
";.;.;.;.;.;.;.;.;.X v k X ;.;.;.",
";.;.;.;.;.;.;.;.;.X v & ;.;.;.;.",
";.;.;.;.;.;.;.;.;.X X X ;.;.;.;."
};


/* XPM */
static char *arrow_divide[] = {
/* columns rows colors chars-per-pixel */
"16 16 127 2",
"   c #2C6C27",
".  c #2F702A",
"X  c #2F712B",
"o  c #31732C",
"O  c #32742D",
"+  c #32752D",
"@  c #33762E",
"#  c #34772F",
"$  c #35782F",
"%  c #357830",
"&  c #367930",
"*  c #367A31",
"=  c #387C32",
"-  c #3A7E34",
";  c #3B7F35",
":  c #3E8438",
">  c #3F8538",
",  c #408539",
"<  c #43863D",
"1  c #438A3C",
"2  c #448B3D",
"3  c #478E3F",
"4  c #478C41",
"5  c #498B43",
"6  c #489040",
"7  c #499141",
"8  c #499142",
"9  c #4B9443",
"0  c #4C9145",
"q  c #4C9344",
"w  c #4C9544",
"e  c #4E9746",
"r  c #4E9846",
"t  c #4F9847",
"y  c #53974C",
"u  c #509A48",
"i  c #539D4A",
"p  c #55A04C",
"a  c #56A24D",
"s  c #57A34E",
"d  c #58A44F",
"f  c #59A550",
"g  c #5AA651",
"h  c #5BA751",
"j  c #5BA852",
"k  c #5CA952",
"l  c #5EAA55",
"z  c #5EAB54",
"x  c #5EAC54",
"c  c #5FAC55",
"v  c #61A35B",
"b  c #62A45B",
"n  c #65A75E",
"m  c #60AE56",
"M  c #61AF57",
"N  c #62B057",
"B  c #62B158",
"V  c #65B45A",
"C  c #66B55B",
"Z  c #69B95E",
"A  c #6BAB63",
"S  c #6BAC65",
"D  c #6CAF64",
"F  c #6FAF68",
"G  c #6BB560",
"H  c #6BBC60",
"J  c #6EBA64",
"K  c #6CBD61",
"L  c #71B16B",
"P  c #71B268",
"I  c #73B36D",
"U  c #72B469",
"Y  c #74B66C",
"T  c #76B66D",
"R  c #76B76D",
"E  c #72BE67",
"W  c #78B670",
"Q  c #78B770",
"!  c #7BB974",
"~  c #7ABE75",
"^  c #7CBE77",
"/  c #7DBF77",
"(  c #6FC164",
")  c #70C265",
"_  c #71C466",
"`  c #72C466",
"'  c #72C566",
"]  c #73C668",
"[  c #7FC079",
"{  c #80C176",
"}  c #82C27C",
"|  c #84C37D",
" . c #85C37E",
".. c #84C579",
"X. c #87C47F",
"o. c #89CA7E",
"O. c #8ACC7F",
"+. c #87C580",
"@. c #88C582",
"#. c #89C682",
"$. c #8BC784",
"%. c #8CC683",
"&. c #8ACC80",
"*. c #8CC885",
"=. c #8FCC85",
"-. c #90C988",
";. c #90CA89",
":. c #92CA8A",
">. c #94CB8C",
",. c #95CC8D",
"<. c #95CC8E",
"1. c #97CE8F",
"2. c #98CE90",
"3. c #9ACF92",
"4. c #9BCF93",
"5. c #9ED196",
"6. c #A1D398",
"7. c #A2D499",
"8. c #A4D49C",
"9. c #A6D59D",
"0. c #A8D79F",
"q. c #A9D7A0",
"w. c #AAD7A1",
"e. c #ABD8A2",
"r. c #ADDAA4",
"t. c gray100",
"y. c None",
/* pixels */
"y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.",
"y.y.y.' _ y.y.y.y.y.y.z d y.y.y.",
"y.y.' &.o.H y.y.y.y.h Y U u y.y.",
"] ' O.r.q...C N z g Y 4.1.A 3 2 ",
"_ K =.e.q.{ m z g p P 1.,.F 1 , ",
"y.K E 0.8.m y.y.y.y.r >.;.0 > y.",
"y.Z J 8.7.l g y.y.e 0 ;.*.4 ; y.",
"y.C G 6.5.R p y.y.8 n $.@.< * y.",
"y.N m *.4.,.D e 8 b X.X.L * + y.",
"y.y.g p W ;.;.! W @.| v * o y.y.",
"y.y.y.i t q I @.X.S = $ o y.y.y.",
"y.y.y.y.y.3 y | } 5 # y.y.y.y.y.",
"y.y.y.y.y.y.> / ^ + y.y.y.y.y.y.",
"y.y.y.y.y.y.; ^ ~ X y.y.y.y.y.y.",
"y.y.y.y.y.y.$ + X   y.y.y.y.y.y.",
"y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y."
};


/* XPM */
static char *arrow_rotate_clockwise[] = {
/* columns rows colors chars-per-pixel */
"16 16 97 2",
"   c #31732C",
".  c #33762E",
"X  c #367930",
"o  c #377B31",
"O  c #3A7E34",
"+  c #3B7F35",
"@  c #3E8337",
"#  c #3E8438",
"$  c #43893C",
"%  c #458C3E",
"&  c #468D3F",
"*  c #489040",
"=  c #499141",
"-  c #499142",
";  c #4E9746",
":  c #4E9846",
">  c #509947",
",  c #52954D",
"<  c #54964E",
"1  c #509A48",
"2  c #529C4A",
"3  c #539D4A",
"4  c #539E4B",
"5  c #549F4B",
"6  c #5B9D55",
"7  c #5A9E55",
"8  c #55A04C",
"9  c #56A14D",
"0  c #58A34F",
"q  c #59A650",
"w  c #5EA157",
"e  c #5CA953",
"r  c #5DAA53",
"t  c #60AE56",
"y  c #61A35A",
"u  c #66A95F",
"i  c #63B158",
"p  c #63B259",
"a  c #66B55B",
"s  c #66B65C",
"d  c #69B95E",
"f  c #6ABA5F",
"g  c #68AA60",
"h  c #69AB61",
"j  c #6AAB63",
"k  c #6AAD63",
"l  c #6CAE63",
"z  c #6FAF67",
"x  c #6CBC60",
"c  c #6DBF62",
"v  c #6EBF62",
"b  c #74B56D",
"n  c #77B771",
"m  c #79B871",
"M  c #78BA70",
"N  c #7EBC75",
"B  c #7CBF75",
"V  c #7EC177",
"C  c #81C077",
"Z  c #82C27B",
"A  c #85C77B",
"S  c #82C27C",
"D  c #84C17C",
"F  c #84C07D",
"G  c #85C37E",
"H  c #85C47E",
"J  c #87C47F",
"K  c #87C87C",
"L  c #87C581",
"P  c #88C582",
"I  c #89C682",
"U  c #8BC683",
"Y  c #8AC783",
"T  c #8BC785",
"R  c #8CCA82",
"E  c #8CC885",
"W  c #8FC987",
"Q  c #8FC988",
"!  c #90C989",
"~  c #97CC8E",
"^  c #98CE90",
"/  c #99CE90",
"(  c #9BCF93",
")  c #9BD092",
"_  c #9DD194",
"`  c #9ED196",
"'  c #A0D197",
"]  c #A1D396",
"[  c #A2D499",
"{  c #A4D49B",
"}  c #A6D59C",
"|  c #A6D59D",
" . c #A7D69E",
".. c #A9D7A0",
"X. c #AAD8A0",
"o. c #ABD8A1",
"O. c None",
/* pixels */
"O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.",
"O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.O.",
"O.O.O.O.O.O.x d a i O.O.O.O.O.O.",
"O.O.O.O.v K ] X. ./ M 0 O.O.O.O.",
"O.O.O.c R o.[ } { ) ` m > O.O.O.",
"O.O.O.A .. .' C N ~ ( ^ h O.O.O.",
"O.O.f _ | ( r q 9 2 ! E F $ O.O.",
"O.O.s p t e O.O.O.; z Q E # O.O.",
"O.O.O.O.O.O.8 O.O.- j Y P O O.O.",
"O.O.O.O.O.5 1 O.= % D V n X O.O.",
"O.O.O.O.4 l g * y L H S < O.O.O.",
"O.O.O.3 k W T I J B Z 6   O.O.O.",
"O.O.O.: u U L G S b ,   O.O.O.O.",
"O.O.O.O.& w 7 + o . O.O.O.O.O.O.",
"O.O.O.O.O.@ O O.O.O.O.O.O.O.O.O.",
"O.O.O.O.O.O.X O.O.O.O.O.O.O.O.O."
};


/* XPM */
static char *arrow_switch[] = {
/* columns rows colors chars-per-pixel */
"16 16 124 2",
"   c #174414",
".  c #174515",
"X  c #184515",
"o  c #184616",
"O  c #1A4917",
"+  c #1C4B19",
"@  c #23561F",
"#  c #255821",
"$  c #295E24",
"%  c #2C6227",
"&  c #2D6328",
"*  c #2F672A",
"=  c #30682A",
"-  c #33762E",
";  c #34772E",
":  c #35782F",
">  c #3A6D36",
",  c #367230",
"<  c #377B31",
"1  c #3C7936",
"2  c #3D7A36",
"3  c #3A7E34",
"4  c #4B7D47",
"5  c #4B7E48",
"6  c #3B8035",
"7  c #408539",
"8  c #41863A",
"9  c #43863B",
"0  c #438A3C",
"q  c #448B3D",
"w  c #4C8E43",
"e  c #4F824B",
"r  c #538B4E",
"t  c #548E4D",
"y  c #499141",
"u  c #4D9645",
"i  c #529949",
"p  c #509A48",
"a  c #539B4A",
"s  c #519C49",
"d  c #529D4A",
"f  c #549F4B",
"g  c #568A52",
"h  c #5A8E54",
"j  c #589951",
"k  c #599A53",
"l  c #599D50",
"z  c #5B9E53",
"x  c #5B9D55",
"c  c #5D9C55",
"v  c #5E9F57",
"b  c #62985D",
"n  c #55A04C",
"m  c #57A24E",
"M  c #57A34E",
"N  c #58A44F",
"B  c #59A550",
"V  c #5FA755",
"C  c #5DA952",
"Z  c #5CA953",
"A  c #5DAA54",
"S  c #5FAB54",
"D  c #60AD55",
"F  c #62AF56",
"G  c #60A658",
"H  c #67A85F",
"J  c #63B057",
"K  c #64B258",
"L  c #65B459",
"P  c #66B55A",
"I  c #679C63",
"U  c #69AA63",
"Y  c #6AAD61",
"T  c #6BAD63",
"R  c #6EAF65",
"E  c #73B16C",
"W  c #77B471",
"Q  c #7BB373",
"!  c #7BB873",
"~  c #81B679",
"^  c #83B67C",
"/  c #84B77D",
"(  c #84BC7B",
")  c #8BBE85",
"_  c #87C480",
"`  c #8AC683",
"'  c #8BC784",
"]  c #8DC886",
"[  c #8FC987",
"{  c #91C989",
"}  c #90CA89",
"|  c #92CB8B",
" . c #92CA8E",
".. c #94CB8C",
"X. c #95CC8E",
"o. c #96CD8E",
"O. c #94CB90",
"+. c #96CC91",
"@. c #97CC92",
"#. c #99CB91",
"$. c #99CF90",
"%. c #98CC93",
"&. c #99CE94",
"*. c #9BCE96",
"=. c #9DCF98",
"-. c #9ECF98",
";. c #A3CF9A",
":. c #A2D29C",
">. c #A7D3A0",
",. c #A6D4A0",
"<. c #A8D4A2",
"1. c #AFD7A7",
"2. c #B1DAAA",
"3. c #B4DCAD",
"4. c #BADFB3",
"5. c #BCE0B4",
"6. c #BEE1B6",
"7. c #BEE1B7",
"8. c #BFE2B7",
"9. c #C0E2B8",
"0. c #C0E3B9",
"q. c #C1E3B9",
"w. c #C2E3BA",
"e. c None",
/* pixels */
"e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.",
"e.e.e.e.e.e.e.e.e.e.e.m e.e.e.e.",
"e.e.e.e.e.e.e.e.e.e.e.s u e.e.e.",
"P P P K F S e.A B n G ! H 0 e.e.",
"P w.q.9.7.#.R Y { $.X.| [ v 3 e.",
"L 0.8.6.5.4.;.l o...} ] ` k : e.",
"J D C V ( 1.3.c E z 8 x j ; e.e.",
"e.e.e.e.i Q 2.~ 9 e.e., - e.e.e.",
"e.e.e.e.p w >.<.2 e.e.= % e.e.e.",
"Z N f a T c ^ ,./ r * h g @ e.e.",
"M X.| [ ' W t :.-.=.*.%.+.e + e.",
"d } ] ` _ U 1 b ) &.@.O. .5 o e.",
"u y q 7 6 < e.& $ # > I 4 X e.e.",
"e.e.e.e.e.e.e.e.e.e.e.O . e.e.e.",
"e.e.e.e.e.e.e.e.e.e.e.  e.e.e.e.",
"e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e."
};


/* XPM */
static char *box[] = {
/* columns rows colors chars-per-pixel */
"16 16 163 2",
"   c #774C15",
".  c #7A4C12",
"X  c #7E4E12",
"o  c #784D15",
"O  c #794D16",
"+  c #794E16",
"@  c #7A4E16",
"#  c #7B4F16",
"$  c #7C5017",
"%  c #7D5017",
"&  c #7E5117",
"*  c #7F5218",
"=  c #825114",
"-  c #875414",
";  c #8B5615",
":  c #8E5915",
">  c #805318",
",  c #815318",
"<  c #825419",
"1  c #835419",
"2  c #845519",
"3  c #85551A",
"4  c #86561A",
"5  c #87571A",
"6  c #88581B",
"7  c #89591B",
"8  c #8A591D",
"9  c #8B5A1C",
"0  c #8C5B1C",
"q  c #8D5B1C",
"w  c #8E5C1D",
"e  c #8F5C1D",
"r  c #8F5D1D",
"t  c #8F5D1E",
"y  c #925B16",
"u  c #965C17",
"i  c #995E17",
"p  c #905D1D",
"a  c #915E1E",
"s  c #915F1E",
"d  c #925F1E",
"f  c #9B6117",
"g  c #94601F",
"h  c #95601F",
"j  c #95611F",
"k  c #96611F",
"l  c #96621F",
"z  c #99621F",
"x  c #976220",
"c  c #9C6420",
"v  c #9F6520",
"b  c #8C6839",
"n  c #946B38",
"m  c #986D38",
"M  c #98703F",
"N  c #A16820",
"B  c #A46E29",
"V  c #A66F2B",
"C  c #A87A3F",
"Z  c #C86530",
"A  c #C86731",
"S  c #C96832",
"D  c #C96932",
"F  c #CA6B33",
"G  c #CA6D34",
"H  c #CB6E34",
"J  c #CB6E35",
"K  c #CC7036",
"L  c #CC7137",
"P  c #CD7237",
"I  c #CD7338",
"U  c #CE7438",
"Y  c #CE763A",
"T  c #CF773B",
"R  c #D07A3C",
"E  c #D07B3C",
"W  c #D17C3D",
"Q  c #D17D3E",
"!  c #D37F3F",
"~  c #AA7C41",
"^  c #A6845B",
"/  c #AB885A",
"(  c #B08C5F",
")  c #B38E5F",
"_  c #B58F60",
"`  c #B08E67",
"'  c #B79060",
"]  c #B99160",
"[  c #BB9260",
"{  c #BC9360",
"}  c #BC9361",
"|  c #BC9461",
" . c #BE9664",
".. c #D48040",
"X. c #D48240",
"o. c #D58341",
"O. c #D58542",
"+. c #D68743",
"@. c #D78944",
"#. c #D88A44",
"$. c #D88C47",
"%. c #D98D47",
"&. c #DA8F48",
"*. c #DA9149",
"=. c #DB924A",
"-. c #DC944B",
";. c #DC964C",
":. c #DD984D",
">. c #DE994D",
",. c #DE9B4F",
"<. c #DC9451",
"1. c #DF9D55",
"2. c #E09C4F",
"3. c #E19E50",
"4. c #E2A051",
"5. c #E2A252",
"6. c #E3A354",
"7. c #E3A554",
"8. c #E4A655",
"9. c #E5A957",
"0. c #E3A459",
"q. c #E6AA58",
"w. c #E7AE59",
"e. c #E6AC5E",
"r. c #E9B25B",
"t. c #DA9874",
"y. c #DA9875",
"u. c #DA9975",
"i. c #DB9B76",
"p. c #DC9E77",
"a. c #DD9F78",
"s. c #E19E62",
"d. c #DDA079",
"f. c #DEA27A",
"g. c #DEA37B",
"h. c #DFA67C",
"j. c #D9B177",
"k. c #E3A366",
"l. c #E5A769",
"z. c #E6AB6E",
"x. c #E9B362",
"c. c #EBB865",
"v. c #E0A87E",
"b. c #E2AB7F",
"n. c #E0AD7E",
"m. c #E8B071",
"M. c #EAB475",
"N. c #EBB87A",
"B. c #EEBC7D",
"V. c #E3AD80",
"C. c #E4AF81",
"Z. c #E3B280",
"A. c #E5B783",
"S. c #E6BD85",
"D. c #EFBF80",
"F. c #E8C188",
"G. c #EAC68B",
"H. c #EDC88D",
"J. c #EECC8F",
"K. c #F1C383",
"L. c #F2C587",
"P. c #F4CC8F",
"I. c None",
/* pixels */
"I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.",
"I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.",
"I.I.x l k j g d a p e q 0 I.I.I.",
"I.x C { | } [ ] ' _ ) ( / m 5 I.",
"x ~  .V N v c z h s t 8 M ^ n 2 ",
"l j.B f i u y : ; - = X . b ` < ",
"j J.P.L.K.D.B.N.M.m.z.l.k.s.V., ",
"g H.c.r.w.9.7.4.,.;.*.$.+.X.v.* ",
"d G.x.q.8.5.2.:.=.%.@.o.! E g.& ",
"a F.e.6.3.>.-.&.#.O...W T I a.$ ",
"r S.0.,.;.*.$.+.X.Q R U L H i.# ",
"w A.1.=.%.@.o.! E Y P J F S y.@ ",
"0 Z.<.#.O...W T I K G D A Z t.O ",
"9 n.C.b.v.h.f.d.p.i.u.t.t.t.t.o ",
"7 6 4 3 1 < > * & % # @ + O o   ",
"I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I."
};


/* XPM */
static char *brick[] = {
/* columns rows colors chars-per-pixel */
"16 16 72 1",
"  c gray58",
". c #959595",
"X c gray59",
"o c #979797",
"O c #989898",
"+ c gray60",
"@ c #9A9A9A",
"# c #9B9B9B",
"$ c #9D9D9D",
"% c gray62",
"& c gray63",
"* c #A2A2A2",
"= c gray64",
"- c #A5A5A5",
"; c gray65",
": c #A9A9A9",
"> c #AAAAAA",
", c gray67",
"< c #ACACAC",
"1 c #AEAEAE",
"2 c #B1B1B1",
"3 c gray70",
"4 c gray71",
"5 c #BBBBBB",
"6 c gray74",
"7 c gray",
"8 c #C0C0C0",
"9 c #C1C1C1",
"0 c gray76",
"q c #C3C3C3",
"w c gray77",
"e c #C5C5C5",
"r c gray78",
"t c gray79",
"y c #CBCBCB",
"u c gray80",
"i c #CDCDCD",
"p c #CECECE",
"a c gray81",
"s c gray82",
"d c #D2D2D2",
"f c LightGray",
"g c #D5D5D5",
"h c gray84",
"j c #D7D7D7",
"k c #D8D8D8",
"l c #DADADA",
"z c gray86",
"x c #DDDDDD",
"c c gray87",
"v c #DFDFDF",
"b c gray88",
"n c #E1E1E1",
"m c gray89",
"M c #E4E4E4",
"N c #E7E7E7",
"B c gray91",
"V c #E9E9E9",
"C c #EAEAEA",
"Z c gray92",
"A c #ECECEC",
"S c #EEEEEE",
"D c gray94",
"F c #F1F1F1",
"G c gray95",
"H c #F3F3F3",
"J c gray96",
"K c #FBFBFB",
"L c gray99",
"P c #FDFDFD",
"I c gray100",
"U c None",
/* pixels */
"UUUUU03**30UUUUU",
"UUUUU:IIII:UUUUU",
"U03**2hPLf2**30U",
"U:IIIb<ss,bIII:U",
"11gPPr4==4rLKd1$",
"<kips<IIII<su97#",
",HVxc0lPPlqj55a@",
">HFSnryssu2588p+",
":HDACMlkw570q8yO",
";JGNMvzh800067t.",
"-7mFNxlh7995y8; ",
"UU&9BZch55yr, UU",
"UUU%$eZBui3. UUU",
"UUUUU#@i6&.UUUUU",
"UUUUUUUoXUUUUUUU",
"UUUUUUUUUUUUUUUU"
};


/* XPM */
static char *database[] = {
/* columns rows colors chars-per-pixel */
"16 16 82 1",
"  c #898989",
". c gray54",
"X c #8B8B8B",
"o c #8D8D8D",
"O c #909090",
"+ c #959595",
"@ c gray59",
"# c #9B9B9B",
"$ c gray62",
"% c #9F9F9F",
"& c #A0A0A0",
"* c gray63",
"= c gray64",
"- c #A5A5A5",
"; c #A7A7A7",
": c #A9A9A9",
"> c gray67",
", c #ACACAC",
"< c gray68",
"1 c #AEAEAE",
"2 c gray69",
"3 c #B2B2B2",
"4 c gray70",
"5 c #B4B4B4",
"6 c gray71",
"7 c #B6B6B6",
"8 c #B7B7B7",
"9 c gray72",
"0 c #B9B9B9",
"q c gray73",
"w c #BBBBBB",
"e c #BCBCBC",
"r c gray74",
"t c gray75",
"y c #C0C0C0",
"u c gray76",
"i c #C3C3C3",
"p c gray77",
"a c gray79",
"s c #CDCDCD",
"d c #CECECE",
"f c gray81",
"g c #D0D0D0",
"h c gray82",
"j c #D2D2D2",
"k c gray83",
"l c #D5D5D5",
"z c gray84",
"x c #D8D8D8",
"c c gray85",
"v c gray86",
"b c gainsboro",
"n c #DDDDDD",
"m c gray87",
"M c gray88",
"N c #E1E1E1",
"B c #E2E2E2",
"V c gray89",
"C c gray90",
"Z c #E6E6E6",
"A c #E7E7E7",
"S c gray91",
"D c #EAEAEA",
"F c gray92",
"G c gray93",
"H c #EEEEEE",
"J c #EFEFEF",
"K c gray94",
"L c gray95",
"P c #F3F3F3",
"I c #F4F4F4",
"U c gray96",
"Y c #F6F6F6",
"T c gray97",
"R c #F8F8F8",
"E c gray98",
"W c #FBFBFB",
"Q c gray99",
"! c #FDFDFD",
"~ c #FEFEFE",
"^ c gray100",
"/ c None",
/* pixels */
"////////////////",
"/////q98754/////",
"///wgSP!QGMu<///",
"//qN~^^^^^^Wf://",
"//0R~^^^^^^WD;//",
"//8TAJYWEKmiZ-//",
"//6YFmzlhieyC=//",
"//5UHZBZNsuuV&//",
"//3IDNnVmartB$//",
"//2PAncMvp9wN#//",
"//1LBxlbxy48M@//",
"//,Kmkjvzt24mO//",
"//:mPvjvzyaZpX//",
"///-dGIUIJBq.///",
"////*%*>;+o ////",
"////////////////"
};


/* XPM */
static char *lightning[] = {
/* columns rows colors chars-per-pixel */
"16 16 99 2",
"   c #DAA223",
".  c #DAA323",
"X  c #DBA424",
"o  c #DBA524",
"O  c #DBA625",
"+  c #DCA726",
"@  c #DCA927",
"#  c #DEAB2B",
"$  c #DEAC29",
"%  c #DFAE2B",
"&  c #DFAF2B",
"*  c #DDA82C",
"=  c #DEAA2E",
"-  c #DFAE2D",
";  c #E0B12C",
":  c #E0B22D",
">  c #E1B42E",
",  c #E2B62F",
"<  c #EBB62F",
"1  c #E3B831",
"2  c #E4BB33",
"3  c #E5BD35",
"4  c #E4BB3D",
"5  c #E6C036",
"6  c #E7C238",
"7  c #EEC238",
"8  c #E8C43A",
"9  c #E9C73B",
"0  c #EFC739",
"q  c #E9C93C",
"w  c #EACA3D",
"e  c #EACB3E",
"r  c #EBCC3F",
"t  c #F0C83A",
"y  c #F0C93C",
"u  c #F0CB3D",
"i  c #F1CD3F",
"p  c #F1CE3F",
"a  c #E3B448",
"s  c #E4B64A",
"d  c #E6BA4C",
"f  c #E7BC4F",
"g  c #ECBC4A",
"h  c #E6B951",
"j  c #E7BD55",
"k  c #ECCE40",
"l  c #E7C04A",
"z  c #ECCD4F",
"x  c #F0CA40",
"c  c #F2CE41",
"v  c #F1CF45",
"b  c #F2D042",
"n  c #F3D243",
"m  c #F3D344",
"M  c #F3D445",
"N  c #F4D647",
"B  c #F3D54A",
"V  c #F4D848",
"C  c #EBC756",
"Z  c #EAC658",
"A  c #EFD45B",
"S  c #EDCB62",
"D  c #F1D964",
"F  c #F3D56E",
"G  c #EECC70",
"H  c #EFC97A",
"J  c #F0CC7C",
"K  c #F1CE7E",
"L  c #F1CF7F",
"P  c #EFD070",
"I  c #F2DA75",
"U  c #F3D77F",
"Y  c #F7E172",
"T  c #F1CE80",
"R  c #F2D283",
"E  c #F2D384",
"W  c #F3D786",
"Q  c #F4D788",
"!  c #F4D989",
"~  c #F5DB8A",
"^  c #F5DB8B",
"/  c #F5DC8A",
"(  c #F5DC8C",
")  c #F6DF8E",
"_  c #F5E180",
"`  c #F6E08D",
"'  c #F8E68E",
"]  c #F7E291",
"[  c #F7E391",
"{  c #F8E693",
"}  c #F8E594",
"|  c #F9E993",
" . c #F9E897",
".. c #F9E998",
"X. c #F9EA99",
"o. c #F9EB99",
"O. c #FAEB9A",
"+. c #FAED9A",
"@. c None",
/* pixels */
"@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.",
"@.@.@.k r e q 9 8 6 5 3 2 1 @.@.",
"@.@.@.r +.o. .} ] ) ^ C 1 @.@.@.",
"@.@.r D O.V m p t ( S 1 @.@.@.@.",
"@.@.w | Y M c y / P 4 @.@.@.@.@.",
"@.@.A X.N b u F U l @.@.@.@.@.@.",
"@.9 _ ' n i 0 ( Z @.@.@.@.@.@.@.",
"@.z ..B v x 7 ! > ; % $ @ O . @.",
"8 I { [ ` / ~ Q E L J H a . @.@.",
"6 5 3 2 1 , W < g T h *   @.@.@.",
"@.@.@.@.@.: G R K s o @.@.@.@.@.",
"@.@.@.@.@.& E j = X @.@.@.@.@.@.",
"@.@.@.@.& f d + @.@.@.@.@.@.@.@.",
"@.@.@.@.- # O @.@.@.@.@.@.@.@.@.",
"@.@.@.$ @ @.@.@.@.@.@.@.@.@.@.@.",
"@.@.@.@.@.@.@.@.@.@.@.@.@.@.@.@."
};


/* XPM */
static char *icon_component[] = {
/* columns rows colors chars-per-pixel */
"16 16 128 2",
"   c gray99",
".  c #EB6D79",
"X  c #73CAE5",
"o  c #CF5960",
"O  c #FFB2B7",
"+  c #8FDDF9",
"@  c #70AC33",
"#  c #FE8992",
"$  c #EA6C74",
"%  c #72C5E4",
"&  c #E7FBD4",
"*  c #A3DEF4",
"=  c gray100",
"-  c #F4767E",
";  c #9DDBF2",
":  c #7CCFEE",
">  c #D8F8B9",
",  c #9AC86D",
"<  c #DF696F",
"1  c #FFEEEE",
"2  c #D1414B",
"3  c #49AACE",
"4  c #6FBBDA",
"5  c #F8D4D6",
"6  c #F9D8DA",
"7  c #F5FEEF",
"8  c #DAEFF7",
"9  c #59ADCC",
"0  c #D5424C",
"q  c #CD3E47",
"w  c #78C5E3",
"e  c #EEF9FF",
"r  c #F08E93",
"t  c #E7FAD5",
"y  c #3E8FAF",
"u  c #C7EDFD",
"i  c #F3B7BB",
"p  c #EDF8FC",
"a  c #FFC5C8",
"s  c #F9D3D5",
"d  c #D8EEF7",
"f  c #D5EEF7",
"g  c #FDECEE",
"h  c #5EABC6",
"j  c #CB5861",
"k  c #D2535C",
"l  c #E4FBD3",
"z  c #EAFBD9",
"x  c #9DD070",
"c  c #A3D375",
"v  c #45A3C6",
"b  c #AFDE79",
"n  c #72C2DF",
"m  c #9ECA72",
"M  c #A2CF74",
"N  c #B5383E",
"B  c #D5EDF7",
"V  c #E57076",
"C  c #6CBBD7",
"Z  c #F9D7D9",
"A  c #76C2E0",
"S  c #48A7CA",
"D  c #BAE1F0",
"F  c #D6EDF6",
"G  c #D7EEC0",
"H  c #B3E3FF",
"J  c #C8EDA2",
"K  c #FFB5B3",
"L  c #93D2EC",
"P  c #DC666E",
"I  c #F9D3D6",
"U  c #93C064",
"Y  c #63AFCC",
"T  c #93C365",
"R  c #BB242F",
"E  c #2B90B4",
"W  c #B5E8FC",
"Q  c #5FACCA",
"!  c #FBFBFB",
"~  c None",
"^  c black",
"/  c black",
"(  c black",
")  c black",
"_  c black",
"`  c black",
"'  c black",
"]  c black",
"[  c black",
"{  c black",
"}  c black",
"|  c black",
" . c black",
".. c black",
"X. c black",
"o. c black",
"O. c black",
"+. c black",
"@. c black",
"#. c black",
"$. c black",
"%. c black",
"&. c black",
"*. c black",
"=. c black",
"-. c black",
";. c black",
":. c black",
">. c black",
",. c black",
"<. c black",
"1. c black",
"2. c black",
"3. c black",
"4. c black",
"5. c black",
"6. c black",
"7. c black",
"8. c black",
"9. c black",
"0. c black",
"q. c black",
"w. c black",
"e. c black",
"r. c black",
"t. c black",
"y. c black",
"u. c black",
/* pixels */
"~ ~ ~ ~ ~ ~ ~ ! ! ! ~ ~ ~ ~ ~ ~ ",
"~ ~ ~ ~ ~ ! ! Q Q Q ! ! ~ ~ ~ ~ ",
"~ ~ ~ ~ ! Q Y * w W Q Q ! ~ ~ ~ ",
"~ ~ ! ! Q W ; * n ; W W y ! ~ ~ ",
"~   T , Q = W W A W W : 3 ! ~ ~ ",
"! T > J Q 8 e u 9 X X : S   ~ ~ ",
"! T = > Q d L p C % % + v   ~ ~ ",
"! T z 7 Q D H f 4 + + % E o   ! ",
"! T l M G h F B X X E E O O N ! ",
"! T m x & c E E E E V O O - 0 ! ",
"! ! U t & b o 6 1 a k . . - 2 ! ",
"~ ~ ! @ @ @ o Z r g P $ $ # q ! ",
"~ ~ ~ ! ! ! o i K I < # # $ R ! ",
"~ ~ ~ ~ ~ ! ! j 5 s . . R R ! ! ",
"~ ~ ~ ~ ~ ~ ~ ! R R R R   ! ~ ~ ",
"~ ~ ~ ~ ~ ~ ~ ~ ! ! ! ! ~ ~ ~ ~ "
};


/* XPM */
static char *icon_extension[] = {
/* columns rows colors chars-per-pixel */
"16 16 32 1",
"  c #A9EB56",
". c #C7EF95",
"X c #89D538",
"o c #7CBC2A",
"O c #77C92C",
"+ c #99DE45",
"@ c #6AB224",
"# c #BBED87",
"$ c #55BB1B",
"% c #319311",
"& c #55A71D",
"* c #3D9A14",
"= c #83CD32",
"- c #4BA21A",
"; c #6ACA24",
": c #62AD22",
"> c #8EDE39",
", c #76B929",
"< c #4EB818",
"1 c #389613",
"2 c #5CAA20",
"3 c #72B728",
"4 c #76B927",
"5 c #459E18",
"6 c #60BF20",
"7 c #6FB525",
"8 c #6FC528",
"9 c #68C224",
"0 c #79D12D",
"q c #6ACE20",
"w c gray100",
"e c None",
/* pixels */
"eeeeewwweeeeeeee",
"eeeewoooweeeeeee",
"eeewo. +oweeeeee",
"eeewo X+4weeeeee",
"wwwww, ,wwwweeee",
"wooo,. 77@:weeee",
"wo...+=+>>2wwwee",
"wooo>==OOX&w-5we",
"woww3XOO80O5#>*w",
"ewew7XO8966$$<1w",
"w4ww@X006;*1<<%w",
"w,7@X2&-0;1w%%we",
"w,#X:www*q1wwwee",
"w3+X2wew*q%weeee",
"w7@:&-w*11%weeee",
"wwwwwwewwwwweeee"
};


/* XPM */
static char *door_in[] = {
/* columns rows colors chars-per-pixel */
"16 16 178 2",
"   c #34752E",
".  c #397136",
"X  c #377931",
"o  c #3B7E34",
"O  c #3D7339",
"+  c #3F743B",
"@  c #40733C",
"#  c #41763D",
"$  c gray27",
"%  c gray28",
"&  c gray29",
"*  c #4C4C4C",
"=  c gray31",
"-  c #515151",
";  c gray33",
":  c #585858",
">  c gray36",
",  c #467C41",
"<  c #577F54",
"1  c #606060",
"2  c #717171",
"3  c #727272",
"4  c gray46",
"5  c #777777",
"6  c gray48",
"7  c #7C7C7C",
"8  c gray49",
"9  c #7E7E7E",
"0  c #8F570C",
"q  c #90580D",
"w  c #91590F",
"e  c #925A10",
"r  c #925C13",
"t  c #945C13",
"y  c #986019",
"u  c #9C641F",
"i  c #9D6725",
"p  c #A16925",
"a  c #A66E2C",
"s  c #A56F2F",
"d  c #A87432",
"f  c #AB7334",
"g  c #AA7436",
"h  c #AF7C3D",
"j  c #AD7E3E",
"k  c #B1793B",
"l  c #B0793D",
"z  c #AE7F40",
"x  c #B67E43",
"c  c #B47E45",
"v  c #3E8237",
"b  c #42873B",
"n  c #45893D",
"m  c #458A3D",
"M  c #468B3E",
"N  c #488D3F",
"B  c #4B8345",
"V  c #4C8F46",
"C  c #4D8F47",
"Z  c #4F8A49",
"A  c #4A9041",
"S  c #4B9142",
"D  c #4D9444",
"F  c #4F9049",
"G  c #509149",
"H  c #599152",
"J  c #589851",
"K  c #61A05A",
"L  c #65A45D",
"P  c #7CC073",
"I  c #7CC074",
"U  c #7FC177",
"Y  c #AE8041",
"T  c #AF8143",
"R  c #B18345",
"E  c #B18547",
"W  c #B58447",
"Q  c #B88B42",
"!  c #BC844B",
"~  c #BA844C",
"^  c #B3884B",
"/  c #B4894F",
"(  c #BA8A4E",
")  c #B58B51",
"_  c #B68D53",
"`  c #B78F56",
"'  c #BF8954",
"]  c #B89058",
"[  c #B9915A",
"{  c #C18952",
"}  c #C68E59",
"|  c #C48E5A",
" . c #C79554",
".. c #C89658",
"X. c #C99A5A",
"o. c #C99A5B",
"O. c #CA9B5E",
"+. c #DFB45F",
"@. c #C99260",
"#. c #CB9360",
"$. c #CC9666",
"%. c #CF9766",
"&. c #CC9E61",
"*. c #CC9F62",
"=. c #CC9F63",
"-. c #D29A6A",
";. c #D09A6C",
":. c #D39D6F",
">. c #D49C6D",
",. c #D69E6F",
"<. c #D49E71",
"1. c #D69E70",
"2. c #CFA367",
"3. c #CDA069",
"4. c #D1A666",
"5. c #D1A86E",
"6. c #D1A773",
"7. c #D4AD75",
"8. c #D6AF74",
"9. c #D2AB78",
"0. c #D3AB78",
"q. c #D4AF7D",
"w. c #D7B37C",
"e. c #D7B37E",
"r. c #D7B47D",
"t. c #E1B863",
"y. c #81C378",
"u. c #81C279",
"i. c #83C37B",
"p. c #87C67D",
"a. c #FFD44B",
"s. c #EDC45E",
"d. c #808080",
"f. c gray60",
"g. c #999A99",
"h. c #9A9A9A",
"j. c #9B9B9B",
"k. c gray61",
"l. c #9D9D9D",
"z. c gray62",
"x. c #9F9F9F",
"c. c #A0A0A0",
"v. c #A1A1A0",
"b. c gray63",
"n. c #A2A2A2",
"m. c gray64",
"M. c #A4A4A4",
"N. c #A5A5A5",
"B. c #D7B382",
"V. c #DAB185",
"C. c #DCB287",
"Z. c #DAB883",
"A. c #DAB983",
"S. c #DAB984",
"D. c #D9B788",
"F. c #DCBD89",
"G. c #DCBD8B",
"H. c #DBBB8D",
"J. c #DDBF94",
"K. c #88C680",
"L. c #8DC884",
"P. c #92CB89",
"I. c #96CD8D",
"U. c #99CE8F",
"Y. c #9AD091",
"T. c #9FD294",
"R. c #DFC18F",
"E. c #DEC291",
"W. c #E0C398",
"Q. c #E1C798",
"!. c #E2C79E",
"~. c #E3CBA2",
"^. c #E5CEA7",
"/. c #E6D0A9",
"(. c #E7D1AA",
"). c #E7D1AB",
"_. c #E8D3AB",
"`. c None",
/* pixels */
"`.`.`.`.`.`.`.`.`.`.`.`.`.>.-.%.",
"`.`.`.`.`.`.`.`.`.`.`.1.>.V.[ #.",
"`.`.d.9 7 6 5 4 3 <.,.C._./.] } ",
"`.`.8 f.f.h.h.j.j.:.(.).Q.E.` { ",
"`.`.6 f.H g.j.k.k.;.^.R.F.G._ ! ",
"`.`.5 h.m Z k.l.l.$.~.F.A.S.) x ",
"D S N n L K B z.z.@.!.Z.r.e./ k ",
"A T.Y.I.P.L.J , x.| W.w.8.s.^ f ",
"M U.p.y.P I u.F < ' J.7.t.a.Q a ",
"b P.L.K.i.U C + b.~ H.5.4.+.E p ",
"v o X   G V O b.n.c D.2.&.=.R u ",
"`.`.1 c.# . n.n.m.l B.*.X.O.T y ",
"`.`.> b.@ v.m.m.M.g q.o. ...Y t ",
"`.`.: n.n.m.M.M.N.s 9.0.6.3.z w ",
"f.2 ; - = * & % $ i d h W ( j 0 ",
"`.`.`.`.`.`.`.`.`.`.`.`.e q r 0 "
};


/* XPM */
static char *door_open[] = {
/* columns rows colors chars-per-pixel */
"16 16 138 2",
"   c gray27",
".  c gray28",
"X  c gray29",
"o  c #4C4C4C",
"O  c gray31",
"+  c #515151",
"@  c gray33",
"#  c #585858",
"$  c gray36",
"%  c #606060",
"&  c #646464",
"*  c #686868",
"=  c #6C6C6C",
"-  c gray44",
";  c #717171",
":  c #727272",
">  c gray45",
",  c gray46",
"<  c #777777",
"1  c gray48",
"2  c #7C7C7C",
"3  c gray49",
"4  c #7E7E7E",
"5  c #8F570C",
"6  c #90580D",
"7  c #91590F",
"8  c #925A10",
"9  c #925C13",
"0  c #945C13",
"q  c #986019",
"w  c #9C641F",
"e  c #9D6725",
"r  c #A16925",
"t  c #A66E2C",
"y  c #A56F2F",
"u  c #A87432",
"i  c #AB7334",
"p  c #AA7436",
"a  c #AF7C3D",
"s  c #AD7E3E",
"d  c #B1793B",
"f  c #B0793D",
"g  c #AE7F40",
"h  c #B67E43",
"j  c #B47E45",
"k  c #AE8041",
"l  c #AF8143",
"z  c #B18345",
"x  c #B18547",
"c  c #B58447",
"v  c #B88B42",
"b  c #BC844B",
"n  c #BA844C",
"m  c #B3884B",
"M  c #B4894F",
"N  c #BA8A4E",
"B  c #B58B51",
"V  c #B68D53",
"C  c #B78F56",
"Z  c #BF8954",
"A  c #B89058",
"S  c #B9915A",
"D  c #C18952",
"F  c #C68E59",
"G  c #C48E5A",
"H  c #C79554",
"J  c #C89658",
"K  c #C99A5A",
"L  c #C99A5B",
"P  c #CA9B5E",
"I  c #DFB45F",
"U  c #C99260",
"Y  c #CB9360",
"T  c #CC9666",
"R  c #CF9766",
"E  c #CC9E61",
"W  c #CC9F62",
"Q  c #CC9F63",
"!  c #D29A6A",
"~  c #D09A6C",
"^  c #D39D6F",
"/  c #D49C6D",
"(  c #D69E6F",
")  c #D49E71",
"_  c #D69E70",
"`  c #CFA367",
"'  c #CDA069",
"]  c #D1A666",
"[  c #D1A86E",
"{  c #D1A773",
"}  c #D4AD75",
"|  c #D6AF74",
" . c #D2AB78",
".. c #D3AB78",
"X. c #D4AF7D",
"o. c #D7B37C",
"O. c #D7B37E",
"+. c #D7B47D",
"@. c #E1B863",
"#. c #FFD44B",
"$. c #EDC45E",
"%. c #808080",
"&. c gray60",
"*. c #9A9A9A",
"=. c #9B9B9B",
"-. c gray61",
";. c #9D9D9D",
":. c gray62",
">. c #9F9F9F",
",. c #A0A0A0",
"<. c gray63",
"1. c #A2A2A2",
"2. c gray64",
"3. c #A4A4A4",
"4. c #A5A5A5",
"5. c #D7B382",
"6. c #DAB185",
"7. c #DCB287",
"8. c #DAB883",
"9. c #DAB983",
"0. c #DAB984",
"q. c #D9B788",
"w. c #DCBD89",
"e. c #DCBD8B",
"r. c #DBBB8D",
"t. c #DDBF94",
"y. c #DFC18F",
"u. c #DEC291",
"i. c #E0C398",
"p. c #E1C798",
"a. c #E2C79E",
"s. c #E3CBA2",
"d. c #E5CEA7",
"f. c #E6D0A9",
"g. c #E7D1AA",
"h. c #E7D1AB",
"j. c #E8D3AB",
"k. c None",
/* pixels */
"k.k.k.k.k.k.k.k.k.k.k.k.k./ ! R ",
"k.k.k.k.k.k.k.k.k.k.k._ / 6.S Y ",
"k.k.%.4 2 1 < , : ) ( 7.j.f.A F ",
"k.k.3 &.&.*.*.=.=.^ g.h.p.u.C D ",
"k.k.1 &.*.*.=.-.-.~ d.y.w.e.V b ",
"k.k.< *.=.=.-.;.;.T s.w.9.0.B h ",
"k.k.> =.-.-.;.:.:.U a.8.+.O.M d ",
"k.k.- -.;.;.:.>.>.G i.o.| $.m i ",
"k.k.= ;.:.:.>.>.,.Z t.} @.#.v t ",
"k.k.* :.>.>.,.,.<.n r.[ ] I x r ",
"k.k.& >.>.,.<.<.1.j q.` E Q z w ",
"k.k.% ,.,.<.1.1.2.f 5.W K P l q ",
"k.k.$ <.<.1.2.2.3.p X.L H J k 0 ",
"k.k.# 1.1.2.3.3.4.y  ...{ ' g 7 ",
"&.; @ + O o X .   e u a c N s 5 ",
"k.k.k.k.k.k.k.k.k.k.k.k.8 6 9 5 "
};


/* XPM */
static char *door_out[] = {
/* columns rows colors chars-per-pixel */
"16 16 175 2",
"   c #256321",
".  c #276623",
"X  c #286724",
"o  c #2A6A26",
"O  c #2C6C27",
"+  c #2D6E28",
"@  c #30702A",
"#  c #34752E",
"$  c #377931",
"%  c #3B7E34",
"&  c #3E7639",
"*  c #3F773A",
"=  c #40733C",
"-  c #41763D",
";  c gray27",
":  c gray28",
">  c gray29",
",  c #4C4C4C",
"<  c gray31",
"1  c #515151",
"2  c gray33",
"3  c #585858",
"4  c gray36",
"5  c #606060",
"6  c #717171",
"7  c #727272",
"8  c gray46",
"9  c #777777",
"0  c gray48",
"q  c #7C7C7C",
"w  c gray49",
"e  c #7E7E7E",
"r  c #8F570C",
"t  c #90580D",
"y  c #91590F",
"u  c #925A10",
"i  c #925C13",
"p  c #945C13",
"a  c #986019",
"s  c #9C641F",
"d  c #9D6725",
"f  c #A16925",
"g  c #A66E2C",
"h  c #A56F2F",
"j  c #A87432",
"k  c #AB7334",
"l  c #AA7436",
"z  c #AF7C3D",
"x  c #AD7E3E",
"c  c #B1793B",
"v  c #B0793D",
"b  c #AE7F40",
"n  c #B67E43",
"m  c #B47E45",
"M  c #3E8237",
"N  c #3F8338",
"B  c #458A3D",
"V  c #468B3E",
"C  c #478C3F",
"Z  c #4F8947",
"A  c #509149",
"S  c #54904D",
"D  c #54954D",
"F  c #599152",
"G  c #5D9D56",
"H  c #65A45D",
"J  c #66A55E",
"K  c #67A65F",
"L  c #69A760",
"P  c #71BB69",
"I  c #75BC6F",
"U  c #77BD6E",
"Y  c #79BE72",
"T  c #7CBF75",
"R  c #7CC073",
"E  c #7FC177",
"W  c #AE8041",
"Q  c #AF8143",
"!  c #B18345",
"~  c #B18547",
"^  c #B58447",
"/  c #B88B42",
"(  c #BC844B",
")  c #BA844C",
"_  c #B3884B",
"`  c #B4894F",
"'  c #BA8A4E",
"]  c #B58B51",
"[  c #B68D53",
"{  c #B78F56",
"}  c #BF8954",
"|  c #B89058",
" . c #B9915A",
".. c #C18952",
"X. c #C68E59",
"o. c #C48E5A",
"O. c #C79554",
"+. c #C89658",
"@. c #C99A5A",
"#. c #C99A5B",
"$. c #CA9B5E",
"%. c #DFB45F",
"&. c #C99260",
"*. c #CB9360",
"=. c #CC9666",
"-. c #CF9766",
";. c #CC9E61",
":. c #CC9F62",
">. c #CC9F63",
",. c #D29A6A",
"<. c #D09A6C",
"1. c #D39D6F",
"2. c #D49C6D",
"3. c #D69E6F",
"4. c #D49E71",
"5. c #D69E70",
"6. c #CFA367",
"7. c #CDA069",
"8. c #D1A666",
"9. c #D1A86E",
"0. c #D1A773",
"q. c #D4AD75",
"w. c #D6AF74",
"e. c #D2AB78",
"r. c #D3AB78",
"t. c #D4AF7D",
"y. c #D7B37C",
"u. c #D7B37E",
"i. c #D7B47D",
"p. c #E1B863",
"a. c #83C37B",
"s. c #86C57D",
"d. c #FFD44B",
"f. c #EDC45E",
"g. c #808080",
"h. c #989998",
"j. c gray60",
"k. c #9A9A9A",
"l. c #9B9B9B",
"z. c gray61",
"x. c #9D9D9D",
"c. c #A0A0A0",
"v. c gray63",
"b. c #A2A2A2",
"n. c gray64",
"m. c #A4A4A4",
"M. c #A5A5A5",
"N. c #D7B382",
"B. c #DAB185",
"V. c #DCB287",
"C. c #DAB883",
"Z. c #DAB983",
"A. c #DAB984",
"S. c #D9B788",
"D. c #DCBD89",
"F. c #DCBD8B",
"G. c #DBBB8D",
"H. c #DDBF94",
"J. c #88C680",
"K. c #8DC884",
"L. c #92CB89",
"P. c #94CC8B",
"I. c #96CD8D",
"U. c #DFC18F",
"Y. c #DEC291",
"T. c #E0C398",
"R. c #E1C798",
"E. c #E2C79E",
"W. c #E3CBA2",
"Q. c #E5CEA7",
"!. c #E6D0A9",
"~. c #E7D1AA",
"^. c #E7D1AB",
"/. c #E8D3AB",
"(. c None",
/* pixels */
"(.(.(.(.(.(.(.(.(.(.(.(.(.2.,.-.",
"(.(.(.(.(.(.(.(.(.(.(.5.2.B. .*.",
"(.(.g.e q 0 9 8 7 4.3.V./.!.| X.",
"(.(.w j.j.k.k.l.l.1.~.^.R.Y.{ ..",
"(.(.0 h.F k.l.z.z.<.Q.U.D.F.[ ( ",
"(.(.9 S B l.z.x.x.=.W.D.Z.A.] n ",
"(.(.Z L H M % $ # &.E.C.i.u.` c ",
"(.C K I.L.K.J.a.@ o.T.y.w.f._ k ",
"V J P.s.R U P T O } H.q.p.d./ g ",
"(.N G J.a.E Y I X ) G.9.8.%.~ f ",
"(.(.& D A + o .   m S.6.;.>.! s ",
"(.(.5 * - v.b.b.n.v N.:.@.$.Q a ",
"(.(.4 c.= b.n.n.m.l t.#.O.+.W p ",
"(.(.3 b.b.n.m.m.M.h e.r.0.7.b y ",
"j.6 2 1 < , > : ; d j z ^ ' x r ",
"(.(.(.(.(.(.(.(.(.(.(.(.u t i r "
};


/* XPM */
static char *icon_link[] = {
/* columns rows colors chars-per-pixel */
"16 16 43 1",
"  c #323232",
". c #3F3F3F",
"X c #414141",
"o c #464646",
"O c gray29",
"+ c #4B4B4B",
"@ c #4C4C4C",
"# c gray30",
"$ c #515151",
"% c gray32",
"& c #585858",
"* c #646464",
"= c #656565",
"- c #676767",
"; c gray42",
": c #717171",
"> c gray45",
", c gray47",
"< c #797979",
"1 c #7B7B7B",
"2 c #7C7C7C",
"3 c #818181",
"4 c gray51",
"5 c gray52",
"6 c #8D8D8D",
"7 c gray57",
"8 c #929292",
"9 c #979797",
"0 c gray62",
"q c gray66",
"w c #AAAAAA",
"e c gray68",
"r c #AEAEAE",
"t c gray74",
"y c #C1C1C1",
"u c gray76",
"i c gray77",
"p c #CECECE",
"a c #D5D5D5",
"s c gray85",
"d c #DDDDDD",
"f c gray91",
"g c None",
/* pixels */
"gggggggggggggggg",
"gggggggggggggggg",
"gggggggggggggggg",
"gggggggggggggggg",
"gggg502gg205gggg",
"gg@7fdy31sdi7@gg",
"gg>a&+=8<=+&q>gg",
"g 4gg.tpue.gg4 g",
"gg-g%Xo$$oX%g-gg",
"gg#6wr9:,9rw6#gg",
"gggO*;;gg;;*Oggg",
"gggggggggggggggg",
"gggggggggggggggg",
"gggggggggggggggg",
"gggggggggggggggg",
"gggggggggggggggg"
};


void make_pixmaps(GtkWidget *window)
{
GtkStyle *style;
#ifdef WAVE_USE_GTK2
GdkPixbuf *gp;
#endif

style=gtk_widget_get_style(window);

GLOBALS->redo_pixmap=gdk_pixmap_create_from_xpm_d(window->window, &GLOBALS->redo_mask,
	&style->bg[GTK_STATE_NORMAL], (gchar **)icon_redo);

GLOBALS->larrow_pixmap=gdk_pixmap_create_from_xpm_d(window->window, &GLOBALS->larrow_mask,
	&style->bg[GTK_STATE_NORMAL], (gchar **)icon_larrow);
GLOBALS->rarrow_pixmap=gdk_pixmap_create_from_xpm_d(window->window, &GLOBALS->rarrow_mask,
	&style->bg[GTK_STATE_NORMAL], (gchar **)icon_rarrow);

GLOBALS->zoomout_pixmap=gdk_pixmap_create_from_xpm_d(window->window, &GLOBALS->zoomout_mask,
	&style->bg[GTK_STATE_NORMAL], (gchar **)icon_zoomout);
GLOBALS->zoomin_pixmap=gdk_pixmap_create_from_xpm_d(window->window, &GLOBALS->zoomin_mask,
	&style->bg[GTK_STATE_NORMAL], (gchar **)icon_zoomin);
GLOBALS->zoomfit_pixmap=gdk_pixmap_create_from_xpm_d(window->window, &GLOBALS->zoomfit_mask,
	&style->bg[GTK_STATE_NORMAL], (gchar **)icon_zoomfit);
GLOBALS->zoomundo_pixmap=gdk_pixmap_create_from_xpm_d(window->window, &GLOBALS->zoomundo_mask,
	&style->bg[GTK_STATE_NORMAL], (gchar **)icon_zoomundo);

GLOBALS->zoom_larrow_pixmap=gdk_pixmap_create_from_xpm_d(window->window, &GLOBALS->zoom_larrow_mask,
	&style->bg[GTK_STATE_NORMAL], (gchar **)zoom_larrow);
GLOBALS->zoom_rarrow_pixmap=gdk_pixmap_create_from_xpm_d(window->window, &GLOBALS->zoom_rarrow_mask,
	&style->bg[GTK_STATE_NORMAL], (gchar **)zoom_rarrow);

GLOBALS->prev_page_pixmap=gdk_pixmap_create_from_xpm_d(window->window, &GLOBALS->prev_page_mask,
	&style->bg[GTK_STATE_NORMAL], (gchar **)prev_page_xpm);
GLOBALS->next_page_pixmap=gdk_pixmap_create_from_xpm_d(window->window, &GLOBALS->next_page_mask,
	&style->bg[GTK_STATE_NORMAL], (gchar **)next_page_xpm);

GLOBALS->wave_info_pixmap=gdk_pixmap_create_from_xpm_d(window->window, &GLOBALS->wave_info_mask,
	&style->bg[GTK_STATE_NORMAL], (gchar **)wave_info);
GLOBALS->wave_alert_pixmap=gdk_pixmap_create_from_xpm_d(window->window, &GLOBALS->wave_alert_mask,
	&style->bg[GTK_STATE_NORMAL], (gchar **)wave_alert);

/* Verilog */
GLOBALS->hiericon_module_pixmap=gdk_pixmap_create_from_xpm_d(window->window, &GLOBALS->hiericon_module_mask,
	&style->bg[GTK_STATE_NORMAL], (gchar **)chart_organisation);
GLOBALS->hiericon_task_pixmap=gdk_pixmap_create_from_xpm_d(window->window, &GLOBALS->hiericon_task_mask,
	&style->bg[GTK_STATE_NORMAL], (gchar **)cog);
GLOBALS->hiericon_function_pixmap=gdk_pixmap_create_from_xpm_d(window->window, &GLOBALS->hiericon_function_mask,
	&style->bg[GTK_STATE_NORMAL], (gchar **)chart_line);
GLOBALS->hiericon_begin_pixmap=gdk_pixmap_create_from_xpm_d(window->window, &GLOBALS->hiericon_begin_mask,
	&style->bg[GTK_STATE_NORMAL], (gchar **)flag_green);
GLOBALS->hiericon_fork_pixmap=gdk_pixmap_create_from_xpm_d(window->window, &GLOBALS->hiericon_fork_mask,
	&style->bg[GTK_STATE_NORMAL], (gchar **)arrow_divide);

/* VHDL */
GLOBALS->hiericon_design_pixmap=gdk_pixmap_create_from_xpm_d(window->window, &GLOBALS->hiericon_design_mask,
	&style->bg[GTK_STATE_NORMAL], (gchar **)database);
GLOBALS->hiericon_block_pixmap=gdk_pixmap_create_from_xpm_d(window->window, &GLOBALS->hiericon_block_mask,
	&style->bg[GTK_STATE_NORMAL], (gchar **)brick);
GLOBALS->hiericon_generateif_pixmap=gdk_pixmap_create_from_xpm_d(window->window, &GLOBALS->hiericon_generateif_mask,
	&style->bg[GTK_STATE_NORMAL], (gchar **)arrow_switch);
GLOBALS->hiericon_generatefor_pixmap=gdk_pixmap_create_from_xpm_d(window->window, &GLOBALS->hiericon_generatefor_mask,
	&style->bg[GTK_STATE_NORMAL], (gchar **)arrow_rotate_clockwise);
GLOBALS->hiericon_instance_pixmap=gdk_pixmap_create_from_xpm_d(window->window, &GLOBALS->hiericon_instance_mask,
	&style->bg[GTK_STATE_NORMAL], (gchar **)icon_component);
GLOBALS->hiericon_package_pixmap=gdk_pixmap_create_from_xpm_d(window->window, &GLOBALS->hiericon_package_mask,
	&style->bg[GTK_STATE_NORMAL], (gchar **)box);

GLOBALS->hiericon_signal_pixmap=gdk_pixmap_create_from_xpm_d(window->window, &GLOBALS->hiericon_signal_mask,
	&style->bg[GTK_STATE_NORMAL], (gchar **)lightning);
GLOBALS->hiericon_portin_pixmap=gdk_pixmap_create_from_xpm_d(window->window, &GLOBALS->hiericon_portin_mask,
	&style->bg[GTK_STATE_NORMAL], (gchar **)door_in);
GLOBALS->hiericon_portout_pixmap=gdk_pixmap_create_from_xpm_d(window->window, &GLOBALS->hiericon_portout_mask,
	&style->bg[GTK_STATE_NORMAL], (gchar **)door_out);
GLOBALS->hiericon_portinout_pixmap=gdk_pixmap_create_from_xpm_d(window->window, &GLOBALS->hiericon_portinout_mask,
	&style->bg[GTK_STATE_NORMAL], (gchar **)door_open);
GLOBALS->hiericon_buffer_pixmap=gdk_pixmap_create_from_xpm_d(window->window, &GLOBALS->hiericon_buffer_mask,
	&style->bg[GTK_STATE_NORMAL], (gchar **)icon_extension);
GLOBALS->hiericon_linkage_pixmap=gdk_pixmap_create_from_xpm_d(window->window, &GLOBALS->hiericon_linkage_mask,
	&style->bg[GTK_STATE_NORMAL], (gchar **)icon_link);

#ifdef WAVE_USE_GTK2
/* set icon for window manager */
gp = xg_get_pixbuf_from_pix_and_mask(GLOBALS->wave_info_pixmap, GLOBALS->wave_info_mask, NULL);
gtk_window_set_icon(GTK_WINDOW(window), gp);
#endif
}


