
/* Implementation of a Double click,calls a special handler if 
 * doubleclick event has been received */

#include <stdlib.h>
#include <gtk/gtk.h>

typedef struct 
{
	GtkSignalFunc callback;
	gpointer *data;
} doubleclick_cb_info;

static void doubleclick_callback (GtkWidget *w,
			    GdkEventButton *event,
			    gpointer data)
{
	doubleclick_cb_info *i;
	
	i=(doubleclick_cb_info*)data;
	if (event->type==GDK_2BUTTON_PRESS ||
	    event->type==GDK_3BUTTON_PRESS)
	  {
		  i->callback(w,event,i->data);
	  }
	;
}
;

void doubleclick_connect(GtkWidget *w,
			 GtkSignalFunc callback,
			 gpointer data)
{
	doubleclick_cb_info *inf;
	
	inf=(doubleclick_cb_info*)malloc(sizeof(doubleclick_cb_info));
	inf->callback=callback;
	inf->data=data;
	gtk_signal_connect(GTK_OBJECT(w),"button_press_event",
			   GTK_SIGNAL_FUNC(doubleclick_callback),inf);
}
;

