/* these are the handling functions for the linkcount database.
 * it takes care that no symbolic link is called twice within a recursive loop */

#include <glib.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include "dirlow.h"

/* uncomment for debugging */
/* #define DEBUG */

/* this function scans for the link with the name filename within linklist.
 * possible return values are:
 *    1: the link is already registered within the database
 *    0: the link was not found within the database and is valid
 *   -1: what was given as filename is *not* a symbolic link 
 * With those return values,the caller can simply determine wether to
 * call a recursive instance of his function by checking if the return
 * value of this function is <1. */
int linkcount_use(GList **linklist,char *filename)
{
	GList *current;
	int result;
	dirlow_uniqueinodeid *newlink;
	
	result=0;
	newlink=dirlow_uniqueinodeid_get(filename);
	for (current=*linklist;
	     ((current!=NULL)&&(result==0));
	     current=current->next)
	  {
		  if (dirlow_uniqueinodeid_same(newlink,
						(dirlow_uniqueinodeid*)current->data))
		    {			    
			    result=1;
#ifdef DEBUG
			    printf ("linkcount_use: found recursive symlink %s\n",
				    filename);
#endif
		    }
		  ;
	  }
	;
	if (!result)
	  {
		  if (dirlow_islink(filename))
		    {
			    result=0;
			    *linklist=g_list_append(*linklist,(gpointer)newlink);
#ifdef DEBUG
			    printf ("linkcount_use: added symlink %s to database...\n",
				    filename);
#endif
		    }
		  else
		    {
#ifdef DEBUG
			    printf ("linkcount_use: %s is not a symlink...\n",
				    filename);
#endif
			    free(newlink);
			    result=-1;			    
		    }
		  ;
	  }
	else
	    free(newlink);
	return result;
}
;

/* free all of a linkcountlists memory and set its memory location 
 * back to NULL. */
void linkcount_free(GList **linklist)
{	    
	GList *current;

	for (current=*linklist;
	     current!=NULL;
	     current=current->next)
	    free(current->data);
	g_list_free(*linklist);
	*linklist=NULL;
}
;
