/* the varman implementation for gtoaster. it differs quite a bit from the
 * c++ version done for klens,though its been derived from it */

#ifndef VARMAN_H
#define VARMAN_H

#include <glib.h>
#include <stdio.h>

#include "helpings.h"

#define VARMAN_MAXSTRINGSIZE 1024

typedef struct
{
	char varname[VARMAN_MAXSTRINGSIZE];
	char varvalue[VARMAN_MAXSTRINGSIZE];
	GList *callbacks; /* a list of functions to be called when value changes */	
} VARMAN_VAR_ENTRY;

/* a database now simply consists of a GList */
typedef GList *varman_database;

/* varman callback function */
typedef void (*varman_varchanged)(VARMAN_VAR_ENTRY*,gpointer data);

varman_database *varman_vardatabase_create_new();
varman_database *varman_vardatabase_create_fromfile(char *name,char *section);
void varman_install_handler(varman_database *db,char *name,varman_varchanged handler,gpointer data);
/* you may set either handler or data to NULL */
void varman_remove_handler(varman_database *db,char *name,varman_varchanged handler,gpointer data);
#define varman_setvar(db,name,value) \
   varman_setvar_update(db,name,value,0)
void varman_setvar_update(varman_database *db,char *name,char *value,int update);
/* this one had to be renamed utterly as there is no function overlay support
 * in normal c. former vardatabase::setvar(char *name,doubl value); */
void varman_setvar_value(varman_database *db,char *name,double value);
char *varman_getvar(varman_database *db,char *name);
double varman_getvar_value(varman_database *db,char *name);
char *varman_getnamebyvalue(varman_database *db,char *value);
/* replace variable in String by its value. this is a generic function
 * not using any var database. variable name and value are given as
 * parameters directly */
void varman_replacestring(char *string,const char *varname,const char *svarval);
/* replace variable in String by its value. this is a generic function
 * not using any var database. variable name and value are given as
 * parameters directly 
 * difference to function above: ignore quotes */
void varman_replacestring_quote(char *string,char *varname,char *svarval);
/* see above,only difference: takes number as parameter */
void varman_replacestringbyfloat(char *string,char *varname,double value);
/* basic functionality see above, this one is used for replacing variables in 
 * computed terms,automatically inserting brackets around the expression */
void varman_replacevarbyvalue(char *string,char *varname,char *svarval);
/* see above, only difference: double value instead of value as string.
 * naming changed due to c limitations */
void varman_replacevarbyvalue_float(char *string,char *varname,double varvalue);
/* Replace whatever looks like a var in the current string */
void varman_replacevars(varman_database *db,char *string);
/* Replace whatever looks like a var 
 * in the current string by its value in brackets */
void varman_replacevarsbyvalue(varman_database *db,char *string);
VARMAN_VAR_ENTRY *varman_getentry(varman_database *db,char *name);
VARMAN_VAR_ENTRY *varman_getentrybyvalue(varman_database *db,char *value);
/* the following functions are the same as the functions above,only they
 * return a temporary copy of their results,which can be processed without
 * any danger of destroying original data. in the case of replace functions
 * this means,that a copy of the original string is made *before* any
 * vars are replaced by their values,sos the original string is unaffected
 * by those replacements. a pointer to a newly allocated string with
 * the vars replaced by their values is returned as the functions result. */
char *varman_getvar_copy(varman_database *db,char *name);
char *varman_getnamebyvalue_copy(varman_database *db,char *value);
char *varman_replacestring_copy(char *string,char *varname,char *svarval);
char *varman_replacevarbyvalue_copy(char *string,char *varname,char *svarval);
char *varman_replacevarbyvalue_float_copy(char *string,char *varname,double varvalue);
char *varman_replacevars_copy(varman_database *db,char *string);
char *varman_replacevarsbyvalue_copy(varman_database *db,char *string);
/* gets true if items could be retrieved. */
int  varman_loaddatabase(varman_database *db,char *filename,char *section);
void varman_savedatabase(varman_database *db,char *filename,char *section);
void varman_savedatabase_fd(FILE *fd,varman_database *db);

#endif // VARMAN_H
