#include <gtk/gtk.h>
#include "main.h"

int hidden = 0, old_category=0;

void remove_todo_item(GtkWidget *fake, gboolean internall){
    GtkTreeSelection *selection;
    GtkTreeIter iter;
    GtkTreeModel *model = GTK_TREE_MODEL(mw.list);
    gint value;
    gchar *category;
    xmlNodePtr cur;
    selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(mw.treeview));	
    if(!gtk_tree_selection_get_selected(selection, &model, &iter))
	{
  if(!internall)message_box( _("You need to select a todo item before you can remove it"),"",GTK_MESSAGE_INFO);
	return; 
     	}
    if(!internall) if(!message_box( _("Are you sure you want to remove the selected todo item?"), _("Remove"), GTK_MESSAGE_WARNING))
     	{
     	return;
     	}
     
    gtk_tree_model_get(model,&iter, ID, &value, CATEGORY, &category, -1);
    cur = get_id_node(category, value);

    if(cur != root) 
	{
	xmlUnlinkNode(cur);
	xmlFreeNode(cur);
	gtk_list_store_remove(mw.list, &iter);
	}
    else{
      g_print(_("item not found.. that can't be\n"));
	}
	g_free(category);
    save_xml();
    }

/* creating a new category */

void add_category(){
    GtkWidget *dialog, *entry, *label, *hbox, *okbut;
    xmlNodePtr newn;
    dialog = gtk_dialog_new_with_buttons(_("Add a Category"), GTK_WINDOW(mw.window), 
		GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, 
		GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
		NULL);
	
    okbut = gtk_dialog_add_button(GTK_DIALOG(dialog), GTK_STOCK_OK, GTK_RESPONSE_OK);
    hbox = gtk_hbox_new(FALSE, 0);
    label = gtk_label_new(_("Name:"));
    entry = gtk_entry_new();
    gtk_box_pack_start(GTK_BOX(hbox), label, TRUE, FALSE,12);
    gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
    gtk_box_pack_start(GTK_BOX(hbox), entry, TRUE, TRUE, 0);
    gtk_container_add(GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), hbox);
    gtk_container_set_border_width(GTK_CONTAINER(hbox), 9);
    gtk_container_set_border_width(GTK_CONTAINER(dialog), 3);
    
       /* ok button is default */
    GTK_WIDGET_SET_FLAGS(okbut, GTK_CAN_DEFAULT);
    gtk_widget_grab_default(okbut);
    gtk_entry_set_activates_default(GTK_ENTRY(entry), TRUE);
    gtk_widget_show_all(GTK_DIALOG(dialog)->vbox);

    switch(gtk_dialog_run(GTK_DIALOG(dialog)))
    {
    case GTK_RESPONSE_OK:
        mw.mitems = g_realloc(mw.mitems, (categorys+2)*sizeof(int *));
	mw.mitems[categorys] = g_malloc(sizeof(catitems));
	mw.mitems[categorys]->item = gtk_menu_item_new_with_label (gtk_entry_get_text(GTK_ENTRY(entry)));
	mw.mitems[categorys]->date = g_strdup(gtk_entry_get_text(GTK_ENTRY(entry)));
	mw.mitems[categorys+1] = NULL;
	gtk_menu_shell_append (GTK_MENU_SHELL (mw.menu), mw.mitems[categorys]->item);
	gtk_widget_show_all(mw.menu);
        categorys++;    
	newn = xmlNewTextChild(root, NULL, "category", NULL);	
	xmlNewProp(newn, "title", gtk_entry_get_text(GTK_ENTRY(entry)));
	gtk_option_menu_set_history(GTK_OPTION_MENU(mw.option), categorys+1);
	gtk_list_store_clear(mw.list);
	load_category();
    default:
	break;
    }
    gtk_widget_destroy(dialog);
    save_xml();
}


/* this is the function that changes the name of the category. */

void change_category(){
    GtkWidget *dialog, *entry, *label, *hbox;
    dialog = gtk_dialog_new_with_buttons(_("Rename Category"), GTK_WINDOW(mw.window), 
		GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, 
		GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
		GTK_STOCK_OK, GTK_RESPONSE_OK,
		NULL);
	
    hbox = gtk_hbox_new(FALSE, 3);
    label = gtk_label_new(_("Name:"));
    entry = gtk_entry_new();
    gtk_box_pack_start(GTK_BOX(hbox), label, TRUE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(hbox), entry, TRUE, TRUE, 0);
    gtk_container_add(GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), hbox);
    gtk_widget_show_all(GTK_DIALOG(dialog)->vbox);
    if(gtk_option_menu_get_history(GTK_OPTION_MENU(mw.option)) == 0) return;
    gtk_entry_set_text(GTK_ENTRY(entry), mw.mitems[gtk_option_menu_get_history(GTK_OPTION_MENU(mw.option))-2]->date);
    switch(gtk_dialog_run(GTK_DIALOG(dialog)))
	{
	case GTK_RESPONSE_OK:
	{
	xmlNodePtr cur = root->xmlChildrenNode;
	gchar *tm = g_strdup(mw.mitems[gtk_option_menu_get_history(GTK_OPTION_MENU(mw.option))-2]->date);
	while(cur != NULL){
        if(xmlStrEqual(cur->name, "category")){
	    xmlChar *temp = xmlGetProp(cur, (const xmlChar *)"title");
	    if(xmlStrEqual(temp, (const xmlChar *)tm))
 		{
		xmlSetProp(cur, "title", gtk_entry_get_text(GTK_ENTRY(entry)));
		read_categorys();
		cur = NULL;
		if(categorys > 0) gtk_option_menu_set_history(GTK_OPTION_MENU(mw.option), 1);
		}
	    else cur = cur->next;
	    xmlFree(temp);	
	    }
	else cur = cur->next;
	}
	g_free(tm);
	gtk_option_menu_set_history(GTK_OPTION_MENU(mw.option), categorys-1);
	}
	default:
		break;
	}
    gtk_widget_destroy(dialog);
    
    }
    


/*  The function that deletes the current category from the list. and all it todo items */

void delete_category()
    {
    xmlNodePtr cur = root->xmlChildrenNode;
    gchar *tm = NULL;
    if(gtk_option_menu_get_history(GTK_OPTION_MENU(mw.option)) == 0) return;
    if(settings.ask_delete_category)
	{
	  tm = g_strdup_printf(_("When you delete the category \"%s\", all containing items are lost"), mw.mitems[gtk_option_menu_get_history(GTK_OPTION_MENU(mw.option))-2]->date);
	  if(!message_box(tm,_("Delete"),GTK_MESSAGE_WARNING))
     	{
     	g_free(tm);
     	return;
     	}
     	g_free(tm);
	}     

     	tm = g_strdup(mw.mitems[gtk_option_menu_get_history(GTK_OPTION_MENU(mw.option))-2]->date);
	while(cur != NULL){

        if(xmlStrEqual(cur->name, "category")){
	    xmlChar *temp = xmlGetProp(cur, (const xmlChar *)"title");
	    if(xmlStrEqual(temp, (const xmlChar *)tm))
 		{
		g_signal_handler_block(mw.option, shand);
		xmlUnlinkNode(cur);
		xmlFreeNode(cur);
		read_categorys();
		g_signal_handler_unblock(mw.option, shand);
		cur = NULL;
		if(categorys > 0){
		     gtk_option_menu_set_history(GTK_OPTION_MENU(mw.option), 0);
		     category_changed();
		     }
		}
	    else cur = cur->next;
	    xmlFree(temp);	
	    }
	else cur = cur->next;
	}
    g_free(tm);
    }



/* this is the function called if the user switches to another category.. */
/* can't hurt to change the name here. */

void category_changed()
    {
    int i = gtk_option_menu_get_history(GTK_OPTION_MENU(mw.option));
    if(i != 0)if( mw.mitems == NULL || mw.mitems[i-2] == NULL) return;
    if(i == categorys+3)
	{
	category_manager();
	gtk_option_menu_set_history(GTK_OPTION_MENU(mw.option), old_category);
	gtk_list_store_clear(mw.list);
	load_category();
	return;
	}
    gtk_list_store_clear(mw.list);
    load_category();
    old_category = i;
    }


void list_toggled_done(GtkCellRendererToggle *cell, gchar *path_str)
    {
    GtkTreeIter iter;
    GtkTreeModel *model = GTK_TREE_MODEL(mw.list);
    gint value, id;
    xmlNodePtr cur;
    gchar *category;
    GtkTreePath *path = gtk_tree_path_new_from_string (path_str);
  /* get toggled iter */
    gtk_tree_model_get_iter (model, &iter, path);
    gtk_tree_path_free(path);	      
    gtk_tree_model_get(model, &iter,ID, &id,  DONE, &value, CATEGORY, &category, -1);
    gtk_list_store_set(mw.list, &iter, DONE, !value, -1);
    
    cur = get_id_node(category, id);    
    g_free(category);
   
    if(cur != root) 
	{
	xmlNodePtr test;
	test = cur->xmlChildrenNode;
	while(test != NULL)
	    {
            if(xmlStrEqual(test->name, (const xmlChar *)"attribute"))
		{
		xmlChar *atr = xmlGetProp(test, (const xmlChar *)"done");		
		if(atr != NULL){
		    gchar *temp = g_strdup_printf("%i", !value);
		     xmlSetProp(test, (const xmlChar *)"done",temp );
		     g_free(temp);
			if(!value)
				{		
				GDate *comp;
				guint64 stop_jul;
				gchar *temp1;
				comp = g_date_new();
				g_date_set_time(comp, time(NULL));
				if(g_date_valid(comp)) stop_jul = g_date_get_julian(comp);
    				else stop_jul = 0;
				 g_date_free(comp);
		    		temp1 = g_strdup_printf("%u", stop_jul);
		    		xmlSetProp(test, "completed_date", temp1);
		    		g_free(temp1);
 				gtk_list_store_set(mw.list, &iter, COMPLETED_DATE, stop_jul, -1);
				}
				else
				{
				guint64 stop_jul = 0;
				 xmlSetProp(test, "completed_date", "0");
				gtk_list_store_set(mw.list, &iter, COMPLETED_DATE, stop_jul, -1);
				}
		     }
		xmlFree(atr);
		}
	    test = test->next;
	    }
	/* set done value */
	save_xml();
	}
    else{
      g_print(_("item not found.. that can't be\n"));
	}
    }


void purge_category()
	{
	gint done, value;
	GtkTreeIter iter;
	GtkTreeModel *model = GTK_TREE_MODEL(mw.list);
	xmlNodePtr cur;
	gchar *category;
	gchar *tm;
	
	if(gtk_option_menu_get_history(GTK_OPTION_MENU(mw.option))== 0)tm = g_strdup_printf(_("Are you sure you want to remove all the completed todo items?"));
	else tm = g_strdup_printf(_("Are you sure you want to remove all the completed todo items in the category \"%s\"?"), mw.mitems[gtk_option_menu_get_history(GTK_OPTION_MENU(mw.option))-2]->date);
    
	if(!message_box( tm, _("Remove"), GTK_MESSAGE_WARNING))
     	{
     	g_free(tm);
     	return;
     	}
	g_free(tm);
	
	if(gtk_tree_model_get_iter_first(model, &iter))
	do
		{
  		gtk_tree_model_get(model,&iter,DONE, &done,  ID, &value,CATEGORY, &category, -1);
  		if(done)
  			{

    			cur = get_id_node(category, value);
			if(cur != root) 
				{
				xmlUnlinkNode(cur);
				xmlFreeNode(cur);
				}
    	    		else{
				  g_print(_("item not found.. that can't be\n"));
				}
    			}
		g_free(category);
    		}while(gtk_tree_model_iter_next(model, &iter));
    /* now save it in the file */
    save_xml();
    gtk_list_store_clear(mw.list);
    load_category();
    }


int message_box(gchar *text, gchar *buttext, GtkMessageType type)
	{
	GtkWidget *dialog, *ali;
	GtkWidget *checkbox;
	dialog = gtk_message_dialog_new(GTK_WINDOW(mw.window), 
			GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
			type,
			GTK_BUTTONS_NONE,
			text
			);
	if(type == GTK_MESSAGE_WARNING)
	    {
	    gtk_dialog_add_buttons(GTK_DIALOG(dialog),GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, buttext, GTK_RESPONSE_OK, NULL);
    	    }
	else gtk_dialog_add_buttons(GTK_DIALOG(dialog),GTK_STOCK_OK, GTK_RESPONSE_OK);
	gtk_widget_show_all(dialog);
 	switch(gtk_dialog_run(GTK_DIALOG(dialog)))
 		{
 		case GTK_RESPONSE_CLOSE:
 		case GTK_RESPONSE_OK:
 		case GTK_RESPONSE_YES:
 				gtk_widget_destroy(dialog);
 				return 1;
		default:
				gtk_widget_destroy(dialog);
 				return 0;	
		}
	return 0;
}
