#include <gtk/gtk.h>
#include "main.h"

/* make these global so I can check update the tooltip */
GtkTooltips *tray_icon_tooltip;
EggTrayIcon *tray_icon;
gboolean tray_init();
gboolean tray = FALSE;

/**************
 * Tray Icon stuff *
 *************/

void tray_destroyed(GtkObject *object, gpointer data)
{
  tray_icon = NULL;
  tray = FALSE;
    gtk_widget_set_sensitive(gtk_item_factory_get_widget(mw.item_factory, N_("/ToDo/Hide Window")), FALSE);
  if(hidden)
  	{
    	    gtk_widget_show_all(mw.window);
    	    hidden = 0;
  	}
 	if(settings.do_tray)g_idle_add((GSourceFunc)tray_init, NULL);
}

gboolean tray_create()
    {
    if(tray) return FALSE;
    tray = TRUE;
    gtk_widget_set_sensitive(gtk_item_factory_get_widget(mw.item_factory, N_("/ToDo/Hide Window")), TRUE);
    return FALSE;
    }

 /*********************
 * Tray Init.. load the icon *
 ********************/
gboolean tray_init()
{
//	GdkPixbuf *pixbuf;
	GtkWidget *tray_icon_image;
	GtkWidget *eventbox;

	/* Creation of the tray icon */
	tray_icon = egg_tray_icon_new ("MySystemTray");
							         
	/* Loads the image */
	/* TODO get this from window .. no need to load it twice */
//	pixbuf = gdk_pixbuf_new_from_file (PIXMAP_PATH"gtodo_tray.png", NULL);
    
        /* Copies the image to the tray_icon_image variable */
	tray_icon_image = gtk_image_new_from_stock("gtodo-tray", GTK_ICON_SIZE_LARGE_TOOLBAR);
// 	g_free(pixbuf);									     
    
	/* Creates the eventbox */
	eventbox = gtk_event_box_new ();
										   
 	/* Display the eventbox on the screen */
	gtk_widget_show (eventbox);
										         
 	/* Adds the tray icon image onto the event box */
	gtk_container_add (GTK_CONTAINER (eventbox), tray_icon_image);
											       
	/* Adds the eventbox to the tray icon */
	gtk_container_add (GTK_CONTAINER (tray_icon), eventbox);
												  
	/* Connect a function to the user clicking on the tray icon */
	g_signal_connect (G_OBJECT (eventbox), "button_press_event", G_CALLBACK (tray_clicked), NULL );
														
	/* Create the tooltip for the tray icon */
	tray_icon_tooltip = gtk_tooltips_new ();

	 /* Attaching the tooltip to the tray icon and giving it a text */
 	gtk_tooltips_set_tip (tray_icon_tooltip, GTK_WIDGET (tray_icon), _("Todo List"), NULL);
    
	g_signal_connect (G_OBJECT(tray_icon), "destroy",
			  G_CALLBACK (tray_destroyed), NULL);
	g_signal_connect (G_OBJECT(tray_icon_image), "expose-event",
			  G_CALLBACK (tray_create), NULL);

	/* Show all the widgets on the screen */   
	gtk_widget_show_all (GTK_WIDGET (tray_icon)); 
	return FALSE;
  }


/* hide the main window when the use clicks on the try icon */
int tray_clicked(GtkWidget *image, GdkEventButton *event){
    if(tray_icon == NULL || !tray) return;
    if(event == NULL || (event->type == GDK_BUTTON_PRESS && (event->button == 1)) || event->type == GDK_DESTROY || event->type == GDK_DELETE)
	{
	if(hidden)
	    {
    	    gtk_widget_show_all(mw.window);
    	    hidden = 0;
    	    }
	else{
		/* so if closed in hidden state..  then last position/size IS saved */
	    save_xml();
    	    gtk_widget_hide_all(mw.window);
    	    hidden = 1;
    	    }
        }
     else if((event->type == GDK_BUTTON_PRESS) && (event->button == 3))
        {
	GtkWidget *ms;
	GtkWidget *menus[2];
	ms = gtk_menu_new();
	menus[0] = gtk_image_menu_item_new_from_stock(GTK_STOCK_QUIT, NULL);
	g_signal_connect(G_OBJECT(menus[0]), "activate", G_CALLBACK(quit_program), NULL);

	menus[1] = gtk_check_menu_item_new_with_label(_("Show Main Window"));
	gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(menus[1]), (gboolean)!hidden);
	g_signal_connect(G_OBJECT(menus[1]), "activate", G_CALLBACK(tray_clicked), NULL);
	gtk_menu_append(GTK_MENU(ms), menus[1]);
	gtk_menu_append(GTK_MENU(ms), menus[0]);
	gtk_widget_show_all(ms);	
	gtk_menu_popup(GTK_MENU(ms), NULL, NULL, NULL, NULL, event->button, event->time);
	gtk_widget_show_all(ms);
	
	}
    return 1;
}

