/*
 * Copyright (C) 2011 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.common.base;

import com.google.common.annotations.Beta;

/**
 * A time source; returns a time value representing the number of nanoseconds
 * elapsed since some fixed but arbitrary point in time.
 *
 * @author Kevin Bourrillion
 * @since 9
 */
@Beta
public interface Ticker {
  /**
   * Returns the number of nanoseconds elapsed since this ticker's fixed
   * point of reference.
   */
  long read();
}
