/*
 * Copyright (C) 2008 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.collect;
public class OrderingTest_gwt extends com.google.gwt.junit.client.GWTTestCase {
@Override public String getModuleName() {
  return "com.google.common.collect.testModule";
}
public void testAllEqual() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testAllEqual();
}

public void testArbitrary_withCollisions() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testArbitrary_withCollisions();
}

public void testArbitrary_withoutCollisions() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testArbitrary_withoutCollisions();
}

public void testBinarySearch() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testBinarySearch();
}

public void testCombinationsExhaustively_startingFromNatural() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testCombinationsExhaustively_startingFromNatural();
}

public void testCompound_instance() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testCompound_instance();
}

public void testCompound_instance_generics() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testCompound_instance_generics();
}

public void testCompound_static() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testCompound_static();
}

public void testExplicit_none() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testExplicit_none();
}

public void testExplicit_one() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testExplicit_one();
}

public void testExplicit_sortingExample() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testExplicit_sortingExample();
}

public void testExplicit_two() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testExplicit_two();
}

public void testExplicit_withDuplicates() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testExplicit_withDuplicates();
}

public void testFrom() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testFrom();
}

public void testGreatestOfIterable_simple() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testGreatestOfIterable_simple();
}

public void testGreatestOfIterator_simple() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testGreatestOfIterator_simple();
}

public void testImmutableSortedCopy() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testImmutableSortedCopy();
}

public void testIsOrdered() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testIsOrdered();
}

public void testIsStrictlyOrdered() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testIsStrictlyOrdered();
}

public void testIterableMinAndMax() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testIterableMinAndMax();
}

public void testIteratorMaxExhaustsIterator() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testIteratorMaxExhaustsIterator();
}

public void testIteratorMinAndMax() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testIteratorMinAndMax();
}

public void testIteratorMinExhaustsIterator() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testIteratorMinExhaustsIterator();
}

public void testLeastOfIterableLargeK() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testLeastOfIterableLargeK();
}

public void testLeastOfIterable_empty_0() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testLeastOfIterable_empty_0();
}

public void testLeastOfIterable_empty_1() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testLeastOfIterable_empty_1();
}

public void testLeastOfIterable_simple_0() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testLeastOfIterable_simple_0();
}

public void testLeastOfIterable_simple_1() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testLeastOfIterable_simple_1();
}

public void testLeastOfIterable_simple_n() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testLeastOfIterable_simple_n();
}

public void testLeastOfIterable_simple_nMinusOne() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testLeastOfIterable_simple_nMinusOne();
}

public void testLeastOfIterable_simple_nMinusOne_withNullElement() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testLeastOfIterable_simple_nMinusOne_withNullElement();
}

public void testLeastOfIterable_simple_nPlusOne() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testLeastOfIterable_simple_nPlusOne();
}

public void testLeastOfIterable_simple_n_withNullElement() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testLeastOfIterable_simple_n_withNullElement();
}

public void testLeastOfIterable_simple_negativeOne() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testLeastOfIterable_simple_negativeOne();
}

public void testLeastOfIterable_singleton_0() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testLeastOfIterable_singleton_0();
}

public void testLeastOfIterable_ties() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testLeastOfIterable_ties();
}

public void testLeastOfIteratorLargeK() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testLeastOfIteratorLargeK();
}

public void testLeastOfIterator_empty_0() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testLeastOfIterator_empty_0();
}

public void testLeastOfIterator_empty_1() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testLeastOfIterator_empty_1();
}

public void testLeastOfIterator_simple_0() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testLeastOfIterator_simple_0();
}

public void testLeastOfIterator_simple_1() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testLeastOfIterator_simple_1();
}

public void testLeastOfIterator_simple_n() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testLeastOfIterator_simple_n();
}

public void testLeastOfIterator_simple_nMinusOne() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testLeastOfIterator_simple_nMinusOne();
}

public void testLeastOfIterator_simple_nMinusOne_withNullElement() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testLeastOfIterator_simple_nMinusOne_withNullElement();
}

public void testLeastOfIterator_simple_nPlusOne() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testLeastOfIterator_simple_nPlusOne();
}

public void testLeastOfIterator_simple_n_withNullElement() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testLeastOfIterator_simple_n_withNullElement();
}

public void testLeastOfIterator_simple_negativeOne() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testLeastOfIterator_simple_negativeOne();
}

public void testLeastOfIterator_singleton_0() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testLeastOfIterator_singleton_0();
}

public void testLeastOfIterator_ties() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testLeastOfIterator_ties();
}

public void testLeastOf_reconcileAgainstSortAndSublistSmall() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testLeastOf_reconcileAgainstSortAndSublistSmall();
}

public void testLexicographical() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testLexicographical();
}

public void testNatural() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testNatural();
}

public void testNullsFirst() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testNullsFirst();
}

public void testNullsLast() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testNullsLast();
}

public void testOnResultOf_chained() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testOnResultOf_chained();
}

public void testOnResultOf_natural() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testOnResultOf_natural();
}

public void testParameterMinAndMax() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testParameterMinAndMax();
}

public void testReverse() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testReverse();
}

public void testReverseOfReverseSameAsForward() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testReverseOfReverseSameAsForward();
}

public void testSortedCopy() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testSortedCopy();
}

public void testUsingToString() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testUsingToString();
}

public void testVarargsMinAndMax() throws Exception {
  com.google.common.collect.OrderingTest testCase = new com.google.common.collect.OrderingTest();
  testCase.testVarargsMinAndMax();
}
}
