/*
 * OO wrapper for execve
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include "Exec.h"

#include <unistd.h>			// execve
#include <stdlib.h>			// malloc, free, realloc
#include <string.h>			// strndup
#include <errno.h>

using namespace stringf;
using namespace std;

///// Exec::strlist

void Exec::strlist::expand() throw ()
{
	size *= 2;
	ptr = (char**) realloc(ptr, size * sizeof(char*));
}

Exec::strlist::strlist(int start_size) throw () : cur(0), size(start_size)
{
	ptr = (char**) malloc(size * sizeof(char*));
}

Exec::strlist::~strlist() throw ()
{
	for (int i = 0; i < cur; i++)
		if (ptr[i])
			free(ptr[i]);
	free(ptr);
}

void Exec::strlist::add(const char* str) throw ()
{
	if (cur >= size)
		expand();
	ptr[cur++] = strdup(str);
}

void Exec::strlist::add(const string& str) throw ()
{
	if (cur >= size)
		expand();
	ptr[cur++] = strndup(str.data(), str.size());
}

void Exec::exec() throw (SystemException)
{
	execve(program.c_str(), argv.get(), env.get());
	throw SystemException(errno, "Executing " + program);
}

// vim:set ts=4 sw=4:
