#ifndef PROCESS_RUNNER_H
#define PROCESS_RUNNER_H

/*
 * Run test scripts in parallel
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "Exception.h"
#include <string>

class ProcessListener
{
public:
	virtual ~ProcessListener() {}
	virtual void handleTermination(const std::string& tag, int status) throw () {}
};

/*
 * Injects ethernet packets to a given interface.
 *
 * Every method is thread-safe
 */
class ProcessRunnerImpl;

class ProcessRunner
{
protected:
	ProcessRunnerImpl* impl;
	
public:
	ProcessRunner() throw (SystemException);
	ProcessRunner(const ProcessRunner& f) throw ();
	~ProcessRunner() throw (SystemException);
	ProcessRunner& operator=(const ProcessRunner& f) throw (SystemException);

	void addProcess(const std::string& tag, const std::string& cmdline, ProcessListener* pl) throw ();

	void shutdown() throw (SystemException);
};

// vim:set ts=4 sw=4:
#endif
