# GUI For ufw (Uncomplicated FireWall) - Version 0.20.6
# Web: http://gufw.tuxfamily.org
# Licenced by GPL 3 or (at your option) any later version.
# Copyright (C) 2008 Marcos Alvarez Costales

# Gufw is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public Licence as published
# by the Free Software Foundation; either version 3 of the Licence,
# or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


# Imports
import commands
import gobject
import string
import locale
import gettext
_ = gettext.gettext

from general_rutines import view_print,add_to_gufw_log,get_ip,get_port,get_proto,component_command_as_file,component_command
from file_operations import file_search_string
from set_window      import set_window_values,set_text_rules
from checks          import check_ipv6,check_gufw_status,check_deny_all

from variables_paths_messages import *




# ---------------------- ADD ------------------------------------------
# Add a simple rule
def simple_add1(self,p_gufw):
    view_print("Add simple rule")
    
    # Exist port?
    l_port = p_gufw.simple_port.get_text()
    l_port = l_port.strip()
    
    if l_port == "":
        add_to_gufw_log(_(text_022))
        p_gufw.status.push(1,_(text_022))
        return
        
    if str(l_port) == "Intrepid":
        dlg = gtk.MessageDialog(None, buttons=gtk.BUTTONS_CLOSE, message_format="Great OS! ;)")
        dlg.run()
        dlg.destroy()
        return

    set_window_values(p_gufw,c_working,c_enabled)
            
    # [Allow|deny|Limit] + Port
    if p_gufw.simple_action.get_active() == 0:
    	l_rule = c_allow
    elif p_gufw.simple_action.get_active() == 1:
    	l_rule = c_deny
    else:
        l_rule = c_limit
    
    # Protocol?
    l_proto_value = p_gufw.simple_proto.get_active()
    if l_proto_value == 0:
    	l_proto = c_tcp
    elif l_proto_value == 1:
    	l_proto = c_udp
    else:
    	l_proto = c_any
    
    # Add rule...
    l_command = component_command("",l_rule,l_proto,c_any,c_any,c_any,l_port)
    l_result = commands.getstatusoutput(l_command)
    add_to_gufw_log(l_command)

    set_window_values(p_gufw,c_finish_working,c_enabled)




# Push preconfigured Add button
def preconf_add1(self,p_gufw):
    
    # Add a program or service?
    if p_gufw.preconf_type.get_active() == 0:
        set_window_values(p_gufw,c_working,c_enabled)
        preconf_add_service(p_gufw)
    else:
        set_window_values(p_gufw,c_working,c_enabled)
        task = preconf_add_program(p_gufw)
        gobject.idle_add(task.next)


# Add a preconfigured service    
def preconf_add_service(p_gufw):
    view_print("Add service")
    
    l_service = p_gufw.preconf_service.get_active_text()

    # [Allow|deny|Limit] + Service
    if p_gufw.preconf_action.get_active() == 0:
        l_rule = c_allow
    elif p_gufw.preconf_action.get_active() == 1:
        l_rule = c_deny
    else:
        l_rule = c_limit
    
    # Add rule...
    # Is vnc?
    if l_service.upper() == c_vnc.upper():
        l_command = "ufw " + l_rule + " " + c_vnc_rule
    else:
        l_command = component_command("",l_rule,c_any,c_any,c_any,c_any,l_service)
        
    commands.getstatusoutput(l_command)
    add_to_gufw_log(l_command )
    
    set_window_values(p_gufw,c_finish_working,c_enabled)




# Add a preconfigured program
def preconf_add_program(p_gufw):
    view_print("Add program")
    
    l_program = p_gufw.preconf_program.get_active_text()
    
    # Allow|deny
    if p_gufw.preconf_action.get_active() == 0:
        l_rule = c_allow
    elif p_gufw.preconf_action.get_active() == 1:
        l_rule = c_deny
    else:
        l_rule = c_limit
    
    l_first_command = "X"
    
    l_rows = 0
    l_row  = 0
    for row in t_programs:
        l_rows += 1
    
    # Program
    for program in t_programs:
        
        if program[0] == l_program:

            if program[2] == c_tcp:
                l_proto = c_tcp
            elif program[2] == c_udp:
                l_proto = c_udp
            else:
            	l_proto = c_any
            
            # Add rule...
            l_command = component_command("",l_rule,l_proto,c_any,c_any,c_any,program[1])
            commands.getstatusoutput(l_command)
            add_to_gufw_log(l_command)

        l_row += 1
        l_progress = float(l_row) / float(l_rows)
        if l_progress > 1:
            l_progress = 1.0
            
        p_gufw.progress.set_fraction(l_progress)
        yield True
    
    set_window_values(p_gufw,c_finish_working,c_enabled)
    yield None
    


# Add advanced rules
def advanced_add1(self,p_gufw):
    view_print("Add advanced rule")
    set_window_values(p_gufw,c_working,c_enabled)
    task = advanced_add_rutine(p_gufw)
    gobject.idle_add(task.next)



# Add a advanced rule    
def advanced_add_rutine(p_gufw):
    
    l_ipv6            = check_ipv6()

    # Values
    l_from_ip         = p_gufw.advanced_fromip.get_text()
    l_to_ip           = p_gufw.advanced_toip.get_text()
    l_from_port       = p_gufw.advanced_fromport.get_text()
    l_from_port_range = p_gufw.advanced_fromport_range.get_text()
    l_to_port         = p_gufw.advanced_toport.get_text()
    l_to_port_range   = p_gufw.advanced_toport_range.get_text()

    # Remove blanks
    l_from_ip         = l_from_ip.strip()
    l_to_ip           = l_to_ip.strip()
    l_from_port       = l_from_port.strip()
    l_from_port_range = l_from_port_range.strip()
    l_to_port         = l_to_port.strip()
    l_to_port_range   = l_to_port_range.strip()

    # To upper case
    l_from_ip         = l_from_ip.upper()
    l_to_ip           = l_to_ip.upper()
    
    # Change IP to Any if is IPv4 and blank (for next commands)
    if l_from_ip == "":
        l_from_ip = c_any.upper()
    if l_to_ip == "":
        l_to_ip = c_any.upper()

    # VALIDATIONS
    l_error_values = c_disabled
    
    # Enter ranges?
    if ( ( l_from_port_range != "" ) and ( l_from_port == "" ) ) or \
       ( ( l_to_port_range   != "" ) and ( l_to_port == "" ) ):
        add_to_gufw_log(_(text_033))
        p_gufw.status.push(1,_(text_033))
        set_window_values(p_gufw,c_finish_working,c_disabled)
        yield None
        return

    # All empty?
    if ( l_from_port == "" and ( l_from_ip == "" or l_from_ip.upper() == c_any.upper() ) ) and \
       ( l_to_port   == "" and ( l_to_ip   == "" or l_to_ip.upper()   == c_any.upper() ) ):
        l_error_values = c_enabled
                                
    if l_error_values == c_enabled:
        add_to_gufw_log(_(text_034))
        p_gufw.status.push(1,_(text_034))
        set_window_values(p_gufw,c_finish_working,c_disabled)
        yield None
        return

        
    # Check numbers ports
    l_num_aux = 0
    if l_to_port != "":
        try:
            l_num_aux = int(l_to_port)
        except:
            add_to_gufw_log(_(text_037))
            p_gufw.status.push(1, _(text_037))
            set_window_values(p_gufw,c_finish_working,c_disabled)
            yield None
            return
    if l_to_port_range != "":
        try:
            l_num_aux = int(l_to_port_range)
        except:
            add_to_gufw_log(_(text_037))
            p_gufw.status.push(1,_(text_037))
            set_window_values(p_gufw,c_finish_working,c_disabled)
            yield None
            return
    if l_from_port != "":
        try:
            l_num_aux = int(l_from_port)
        except:
            add_to_gufw_log(_(text_037))
            p_gufw.status.push(1, _(text_037))
            set_window_values(p_gufw,c_finish_working,c_disabled)
            yield None
            return
    if l_from_port_range != "":
        try:
            l_num_aux = int(l_from_port_range)
        except:
            add_to_gufw_log(_(text_037))
            p_gufw.status.push(1, _(text_037))
            set_window_values(p_gufw,c_finish_working,c_disabled)
            yield None
            return
    
    # Component Range FROM
    if l_from_port_range != "":
        l_port1A = int(l_from_port)
        l_port1B = int(l_from_port_range)        
        if l_port1A > l_port1B:
            l_port_aux = l_port1A
            l_port1A = l_port1B
            l_port1B = l_port_aux
    elif l_from_port != "":
        l_port1A = int(l_from_port)
        l_port1B = l_port1A
    else:
        l_port1A = -1
        l_port1B = -1
        
    # Component Range TO
    if l_to_port_range != "":
        l_port2A = int(l_to_port)
        l_port2B = int(l_to_port_range)        
        if l_port2A > l_port2B:
            l_port_aux = l_port2A
            l_port2A = l_port2B
            l_port2B = l_port_aux
    elif l_to_port != "":
        l_port2A = int(l_to_port)
        l_port2B = l_port2A
    else:
        l_port2A = -1
        l_port2B = -1

    l_port1A_aux = l_port1A
    l_port2A_aux = l_port2A

    # Count number iterations for progress bar
    l_iterations = 0
    while l_port1A_aux <= l_port1B:
        l_port2A = l_port2A_aux
        while l_port2A <= l_port2B:
            l_port2A += 1
            l_iterations += 1
        l_port1A_aux += 1


    # Add rules        
    l_actual_iterations = 0
    while l_port1A <= l_port1B:
        
        l_port2A = l_port2A_aux
        
        while l_port2A <= l_port2B:
            
            # [Allow|deny|limit]
            if p_gufw.advanced_action.get_active() == 0:
                l_rule = c_allow.upper()
            elif p_gufw.advanced_action.get_active() == 1:
                l_rule = c_deny.upper()
            else:
                l_rule = c_limit.upper()
            
            # Protocol
            if p_gufw.advanced_proto.get_active() == 0:
                l_proto = c_tcp.upper()
            elif p_gufw.advanced_proto.get_active() == 1:
                l_proto = c_udp.upper()
            else:
            	l_proto = c_any.upper()
            
            # FROM Port
            if l_port1A > 0:
            	l_from_port = l_port1A
            else:
            	l_from_port = c_any.upper()
            # TO Port
            if l_port2A > 0:
            	l_to_port = l_port2A
            else:
            	l_to_port = c_any.upper()	
            
            l_command = component_command("",l_rule,l_proto,l_from_ip,l_from_port,l_to_ip,l_to_port)


            # Add rule...
            commands.getstatusoutput(l_command)
            add_to_gufw_log(l_command)
            
            l_actual_iterations += 1
            l_progress = float(l_actual_iterations) / float(l_iterations)
            if l_progress > 1:
                l_progress = 1.0
            
            p_gufw.progress.set_fraction(l_progress)
            yield True
            
            l_port2A += 1
            
        l_port1A += 1
            
    set_window_values(p_gufw,c_finish_working,c_enabled)
    yield None


# Clear fields of Advanced Tab.
def advanced_clear(self,p_gufw):

    p_gufw.advanced_fromip.set_text(c_any)
    p_gufw.advanced_toip.set_text(c_any)

    p_gufw.advanced_fromport.set_text("")
    p_gufw.advanced_toport.set_text("")
    p_gufw.advanced_fromport_range.set_text("")
    p_gufw.advanced_toport_range.set_text("")




# ------------------------- ENABLE/DISABLE ----------------------------
# Enable/Disable Firewall			
def enable_disable(self,p_gufw):
    view_print("enable/disable")

    set_window_values(p_gufw,c_working,c_disabled)
    
    # Firewall active? => Disable
    if check_gufw_status() == c_disabled:

        l_result = commands.getstatusoutput(cmd_enable)

        if l_result[0] == 0:
            p_gufw.status.push(1, _(text_003))
            add_to_gufw_log(_(text_003))
        else:
            p_gufw.status.push(1, _(text_004))
            add_to_gufw_log(_(text_004))
            p_gufw.firewall.set_active(c_disabled)

    # Firewall disable? => Enable
    else:

        l_result = commands.getstatusoutput(cmd_disable)
        
        if l_result[0] == 0:
            p_gufw.status.push(1, _(text_003))
            add_to_gufw_log(_(text_003))
        else:
            p_gufw.status.push(1, _(text_004))
            add_to_gufw_log(_(text_004))
            p_gufw.firewall.set_active(c_enabled)
            
    set_window_values(p_gufw,c_finish_working,c_disabled)


# Allow/Deny all traffic
def allow_deny_all(self,p_gufw):
    view_print("Change allow/deny")
    
    set_window_values(p_gufw,c_working,c_disabled)
    
    if check_deny_all() == c_enabled:
        allow_all(p_gufw)
    else:
        deny_all(p_gufw)
        
    set_window_values(p_gufw,c_finish_working,c_disabled)
        
    

# Deny all
def deny_all(p_gufw):

    l_result = commands.getstatusoutput(cmd_deny_all)

    if l_result[0] == 0:
        p_gufw.status.push(1, _(text_048))
        add_to_gufw_log(_(text_048))
    else:
        p_gufw.status.push(1, _(text_049))
        add_to_gufw_log(_(text_049))



# Allow all
def allow_all(p_gufw):

    l_result = commands.getstatusoutput(cmd_allow_all)

    if l_result[0] == 0:
        p_gufw.status.push(1, _(text_048))
        add_to_gufw_log(_(text_048))
    else:
        p_gufw.status.push(1, _(text_049))
        add_to_gufw_log(_(text_049))


    


# ------------------------- REMOVE ------------------------------------
# Remove one rule
def remove_one(self,p_gufw):
    set_window_values(p_gufw,c_working,c_enabled)
    task = remove_one_rule(p_gufw)
    gobject.idle_add(task.next)



# Remove one rule
def remove_one_rule(p_gufw):

    # Get selected rows.
    tree,iter = p_gufw.rules.get_selection().get_selected_rows()

    l_rows = 0
    l_row  = 0
    for row in iter:
        l_rows += 1

    if l_rows == 0:
        p_gufw.status.push(1,_(text_027))
        add_to_gufw_log(text_027)
        set_window_values(p_gufw,c_finish_working,c_disabled)
        yield None
        return
    
    # For one row: Selected
    for item in iter:
        
        # Get rule selected
        l_actual_rule_to   = tree.get_value(tree.get_iter(item),1)
        l_actual_rule      = tree.get_value(tree.get_iter(item),2)
        l_actual_rule_from = tree.get_value(tree.get_iter(item),3)
        l_proto            = " "
        
        # Descomponent rule
        # FROM
        l_from_proto = get_proto(l_actual_rule_from)
        l_from_port  = get_port(l_actual_rule_from)
        l_from_ip    = get_ip(l_actual_rule_from)

        # TO
        l_to_proto = get_proto(l_actual_rule_to)
        l_to_port  = get_port(l_actual_rule_to)
        l_to_ip    = get_ip(l_actual_rule_to)
        
        if l_from_proto.upper() != c_any.upper():
            l_proto = l_from_proto
        elif l_to_proto.upper() != c_any.upper():
            l_proto = l_to_proto
        else:
            l_proto  = c_any
            
        # Component command delete
        l_string_search = component_command_as_file(l_actual_rule,l_proto,l_from_ip,l_from_port,l_to_ip,l_to_port)
        
        # Remove from IPv4 if correct rule
        if file_search_string(path_ufw_rules_ipv4,l_string_search) == c_found:
            # Component command delete
            l_command = component_command(c_delete,l_actual_rule,l_proto,l_from_ip,l_from_port,l_to_ip,l_to_port)
            commands.getstatusoutput(l_command)
            add_to_gufw_log(l_command)

        else: # Search if was created with "any" proto
            l_string_aux = l_string_search.replace(c_tcp.upper(),c_any)
            l_string_aux = l_string_aux.replace(c_udp.upper(),c_any)
            if file_search_string(path_ufw_rules_ipv4,l_string_aux) == c_found:
                # Component command and delete.
                l_proto = c_any
                l_command = component_command(c_delete,l_actual_rule,l_proto,l_from_ip,l_from_port,l_to_ip,l_to_port)
                commands.getstatusoutput(l_command)
                add_to_gufw_log(l_command)

        # Remove from IPv6 if correct rule
        l_string_search = l_string_search.replace(c_blank_ipv4,c_blank_ipv6)
        if file_search_string(path_ufw_rules_ipv6,l_string_search) == c_found:
            # Component command and delete.
            l_command = component_command(c_delete,l_actual_rule,l_proto,l_from_ip,l_from_port,l_to_ip,l_to_port)
            commands.getstatusoutput(l_command)
            add_to_gufw_log(l_command)
            
        else: # Search if was created with "any" proto
            l_string_aux = l_string_search.replace(c_tcp.upper(),c_any)
            l_string_aux = l_string_aux.replace(c_udp.upper(),c_any)
            l_proto = c_any
            if file_search_string(path_ufw_rules_ipv6,l_string_aux) == c_found:
                # Component command and delete.
                l_command = component_command(c_delete,l_actual_rule,l_proto,l_from_ip,l_from_port,l_to_ip,l_to_port)
                commands.getstatusoutput(l_command)
                add_to_gufw_log(l_command)

        # Progress bar
        l_row += 1
        l_progress = float(l_row) / float(l_rows)
        if l_progress > 1:
            l_progress = 1.0
        p_gufw.progress.set_fraction(l_progress)
        yield True

    set_window_values(p_gufw,c_finish_working,c_enabled)
    yield None
    
    
    

# Select all rules.    
def select_all(self,p_gufw):
	set_text_rules(p_gufw,c_select_all)     
