# Gufw 9.10.4 - http://gufw.tuxfamily.org
# Copyright (C) 2009 Marcos Alvarez Costales
#
# Gufw is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
# 
# Gufw is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Gufw; if not, see http://www.gnu.org/licenses for more
# information.


import pygtk
import gtk, gtk.glade
import gobject

class Guigufw:

    def __init__(self, variable, firewall):

        self.variable       = variable
        self.firewall       = firewall
        
        self.glade          = gtk.glade.XML(self.variable.get_path("glade"))
        self.model          = gtk.ListStore (gobject.TYPE_INT, gobject.TYPE_STRING, gobject.TYPE_STRING,
                                             gobject.TYPE_STRING, gobject.TYPE_STRING)        
        self.render         = gtk.CellRendererText()
        self.serv_prog_type = self.variable.get_constant("service_disabled")
        
        self.set_objects_glade()
        
        self.rules          = []
        self.log_txt_buffer = self.log_txt.get_buffer()
        
        self.set_rules_header()
        self.set_initial_values()
        self.set_window_values("")
        
        self.glade.signal_autoconnect(self)
        self.glade.get_widget("winMain").show()

        gtk.main()


# INITIALS SETS

    # Set references to objects
    def set_objects_glade(self):
        # Main Window
        self.win_main            = self.glade.get_widget("winMain")
        self.cb_enabled_firewall = self.glade.get_widget("cbEnabledFirewall")
        self.cb_policy           = self.glade.get_widget("cbPolicy")
        self.lbl_policy          = self.glade.get_widget("lblDefaultPolicy")
        self.shield              = self.glade.get_widget("imgShield")
        self.tv_rules            = self.glade.get_widget("tvRules")
        self.btn_add_window      = self.glade.get_widget("btnAddWindow")
        self.btn_remove_rule     = self.glade.get_widget("btnRemove")
        self.status_bar          = self.glade.get_widget("statusBar")
        self.progress_bar        = self.glade.get_widget("progressBar")
        
        # Rules Window
        self.action_simple     = self.glade.get_widget("cbActionSimple")
        self.port_simple       = self.glade.get_widget("entryPortSimple")
        self.proto_simple      = self.glade.get_widget("cbProtoSimple")
        self.action_preconf    = self.glade.get_widget("cbActionPreconf")
        self.type_preconf      = self.glade.get_widget("cbTypePreconf")
        self.service_preconf   = self.glade.get_widget("cbServicePreconf")
        self.program_preconf   = self.glade.get_widget("cbProgramPreconf")
        self.action_advanced   = self.glade.get_widget("cbActionAdvanced")
        self.proto_advanced    = self.glade.get_widget("cbProtoAdvanced")
        self.fromip_advanced   = self.glade.get_widget("entryFromIpAdvanced")
        self.portfrom_advanced = self.glade.get_widget("entryPortFromAdvanced")
        self.toip_advanced     = self.glade.get_widget("entryToIpAdvanced")
        self.portto_advanced   = self.glade.get_widget("entryPortToAdvanced")
        self.rules_notebook    = self.glade.get_widget("rulesNotebook")
        self.add_btn_add       = self.glade.get_widget("btnAddRule")
        
        # Log Window
        self.winlog        = self.glade.get_widget("winLog")
        self.log_txt       = self.glade.get_widget("logTxt")
        self.log_btn_close = self.glade.get_widget("btnCloseLog")
        
        
        # Preference Window
        self.winpreferences = self.glade.get_widget("winPreferences")
        self.cb_ufw_log     = self.glade.get_widget("cbUfwLog")
        self.lbl_ufw_level  = self.glade.get_widget("lblLogLevel")
        self.cb_ufw_level   = self.glade.get_widget("cbLogLevel")
        self.cb_gufw_log    = self.glade.get_widget("cbGufwLog") 
        self.pref_btn_close = self.glade.get_widget("btnClosePref")
        
        # Menu
        self.menu_log  = self.glade.get_widget("menuLog")
        self.menu_pref = self.glade.get_widget("menuPreferences")
        
        # About Dialog
        self.winabout = self.glade.get_widget("winAbout")
        self.winabout.set_translator_credits(self.variable.get_constant("translators_credits"))

        
    # Set initial values
    def set_rules_header(self):
        # Mode
        self.tv_rules.set_model(self.model)
        self.tv_rules.get_selection().set_mode(gtk.SELECTION_MULTIPLE)

        # Font
        self.render.set_property("font", self.variable.get_constant("font_rules"))

        # The format columns
        tree_header = gtk.TreeViewColumn (self.variable.get_text("001"), self.render, text=1, foreground=4)
        tree_header.set_resizable(True)
        self.tv_rules.append_column (tree_header)
        
        tree_header = gtk.TreeViewColumn (self.variable.get_text("002"), self.render, text=2, foreground=4)
        tree_header.set_resizable(True)
        self.tv_rules.append_column (tree_header)
        
        tree_header = gtk.TreeViewColumn (self.variable.get_text("003"), self.render, text=3, foreground=4)
        self.tv_rules.append_column (tree_header)
    
    
    # Set initial values in Interface
    def set_initial_values(self):
        # Restore previus size window
        self.get_old_size_window()
        
        # ComboBoxs
        self.action_simple.set_active(0)     
        self.proto_simple.set_active(0)    
          
        self.action_preconf.set_active(0)    
        self.type_preconf.set_active(0)      
        self.service_preconf.set_active(0)   
        self.program_preconf.set_active(0)  
         
        self.action_advanced.set_active(0)   
        self.proto_advanced.set_active(0)    
        
        # Focus
        self.btn_add_window.grab_focus()
        
    
    # Set initials status to glade objects
    def set_window_values(self, status_bar):
        # Firewall Enabled
        self.cb_enabled_firewall.set_sensitive(1)
        if self.firewall.status == self.variable.get_constant("enabled"):
            self.cb_enabled_firewall.set_active(1)

        # Allow/Deny/Reject
        if self.firewall.default == self.variable.get_constant("deny"):
            self.cb_policy.set_active(0)
        elif self.firewall.default == self.variable.get_constant("reject"):
            self.cb_policy.set_active(1)
        elif self.firewall.default == self.variable.get_constant("allow"):
            self.cb_policy.set_active(2)
               
        # Status bar
        self.status_bar.push(1, status_bar)
        
        # Set values by status firewall
        if self.firewall.status == self.variable.get_constant("disabled"):
            # Sensitive values
            self.cb_policy.set_sensitive(0)
            self.lbl_policy.set_sensitive(0)
            self.add_btn_add.set_sensitive(0)
            self.btn_remove_rule.set_sensitive(0)
            # Shield
            if not self.variable.dev:
                self.shield.set_from_file(self.variable.get_path("shield_disabled"))
            else:
                self.shield.set_from_file(self.variable.get_path("shield_disabled_dev"))
            
        else:
            
            # Get actual rules
            self.rules = self.firewall.get_rules_list()
            
            # Sensitive values
            self.cb_policy.set_sensitive(1)
            self.lbl_policy.set_sensitive(1)
            self.add_btn_add.set_sensitive(1)
            if len(self.rules) == 0:
                self.btn_remove_rule.set_sensitive(0)
            else:
                self.btn_remove_rule.set_sensitive(1)

            # Shields
            if not self.variable.dev:
                if self.firewall.default == self.variable.get_constant("allow"):
                    self.shield.set_from_file(self.variable.get_path("shield_allow"))
                elif self.firewall.default == self.variable.get_constant("deny"):
                    self.shield.set_from_file(self.variable.get_path("shield_deny"))
                elif self.firewall.default == self.variable.get_constant("reject"):
                    self.shield.set_from_file(self.variable.get_path("shield_reject"))
            else:
                if self.firewall.default == self.variable.get_constant("allow"):
                    self.shield.set_from_file(self.variable.get_path("shield_allow_dev"))
                elif self.firewall.default == self.variable.get_constant("deny"):
                    self.shield.set_from_file(self.variable.get_path("shield_deny_dev"))
                elif self.firewall.default == self.variable.get_constant("reject"):
                    self.shield.set_from_file(self.variable.get_path("shield_reject_dev"))
                
        # Menu
        self.menu_pref.set_sensitive(1)
        if self.firewall.gufw_log == self.variable.get_constant("gufw_log_on"):
            self.menu_log.set_sensitive(1)
        else:
            self.menu_log.set_sensitive(0)
           
        # Set actual rules
        self.set_rules_text()

        
    # View rules in GUI
    def set_rules_text(self):
        
        self.model.clear() 

        if self.firewall.status == self.variable.get_constant("disabled"):
            return
        
        row = 0
        
        for rule in self.rules:
        
            row += 1
            
            iterador = self.model.insert(row)
            self.model.set_value(iterador, 0, row)
            
            # Values
            self.model.set_value(iterador, 1, rule[0])
            self.model.set_value(iterador, 2, rule[1])
            self.model.set_value(iterador, 3, rule[2])
            
            # Color Allow/Deny/Limit
            # Allow?
            if rule[1] == self.variable.get_constant("allow_upper"):
                if self.firewall.default != self.variable.get_constant("allow"):
                    self.model.set_value(iterador, 4, self.variable.get_constant("color_red")) 
                else:
                    self.model.set_value(iterador, 4, self.variable.get_constant("color_gray"))
                    
            # Deny?
            elif rule[1] == self.variable.get_constant("deny_upper"):
                if self.firewall.default != self.variable.get_constant("deny"):
                    self.model.set_value(iterador, 4, self.variable.get_constant("color_green"))
                else:
                    self.model.set_value(iterador, 4, self.variable.get_constant("color_gray"))
                    
            # Reject
            elif rule[1] == self.variable.get_constant("reject_upper"):
                if self.firewall.default != self.variable.get_constant("reject"):
                    self.model.set_value(iterador, 4, self.variable.get_constant("color_blue"))
                else:
                    self.model.set_value(iterador, 4, self.variable.get_constant("color_gray"))
            
            # Limit?
            elif rule[1] == self.variable.get_constant("limit_upper"):
                self.model.set_value(iterador, 4, self.variable.get_constant("color_orange"))
                




# EVENTS


# CLOSE WINDOWS

    # Close Windows
    def winMain_delete_event_cb(self, widget, event):
        self.save_size_window()
        gtk.main_quit()

    # Menu Quit
    def menuQuit_activate_cb(self, widget):
        self.save_size_window()
        gtk.main_quit()

    # Button Add
    def btnAddWindow_clicked_cb(self, widget):
        self.glade.get_widget("winAdd").show()
        self.add_btn_add.grab_focus()
        self.btn_add_window.set_sensitive(0)

    # Close Window Add Rules
    def winAdd_delete_event_cb(self, widget, event):
        self.glade.get_widget("winAdd").hide()
        self.btn_add_window.set_sensitive(1)
        return True

    # Button Close Add Rules
    def btnCloseAdd_clicked_cb(self, widget):
        self.glade.get_widget("winAdd").hide()
        self.btn_add_window.set_sensitive(1)
        return True

    # Close preferences Window
    def winPreferences_delete_event_cb(self, widget, event):
        self.glade.get_widget("winPreferences").hide()
        return True

    # Close preferences Button
    def btnClosePref_clicked_cb(self, widget):
        self.glade.get_widget("winPreferences").hide()
        return True

    # Close Log Window
    def winLog_delete_event_cb(self, widget, event):
        self.glade.get_widget("winLog").hide()
        return True

    # Close Log button
    def btnCloseLog_clicked_cb(self, widget):
        self.glade.get_widget("winLog").hide()
        return True

    # Press Scape Key Add Window
    def winAdd_key_press_event_cb(self, widget, event):
        if event.keyval == gtk.keysyms.Escape :
            self.glade.get_widget("winAdd").hide()
            self.btn_add_window.set_sensitive(1)
            return True    
            
    # Press Scape Key Preferences Window
    def winPreferences_key_press_event_cb(self, widget, event):
        if event.keyval == gtk.keysyms.Escape :
            self.glade.get_widget("winPreferences").hide()
            return True  
    
    # Press Scape Key Log Window
    def winLog_key_press_event_cb(self, widget, event):
        if event.keyval == gtk.keysyms.Escape :
            self.glade.get_widget("winLog").hide()
            return True  
    

    # Save Actual size window
    def get_old_size_window(self):    
        win_width,win_height = self.firewall.get_old_size_window()
        screen_width         = gtk.gdk.screen_width()
        screen_height        = gtk.gdk.screen_height()

        # Maximize
        if ( win_width == screen_width ) and ( win_height == screen_height ):
            self.win_main.maximize()
            
        # Not Maximize
        else:
            if win_width > screen_width:
                win_width = screen_width
            if win_height > screen_height:
                win_height = screen_height
                
            self.win_main.resize(win_width,win_height)


    # Save Actual size window
    def save_size_window(self):
        win_width, win_height = self.win_main.get_size()
        screen_width          = gtk.gdk.screen_width()
        screen_height         = gtk.gdk.screen_height()
        
        if not self.firewall.maximized:
            if win_width > screen_width:
                win_width = screen_width
            if win_height > screen_height:
                win_height = screen_height
                
            self.firewall.save_size_window(win_width, win_height)
        
        else:
            self.firewall.save_size_window(screen_width, screen_height)


    def winMain_window_state_event_cb(self, widget, event):
        if event.changed_mask & gtk.gdk.WINDOW_STATE_MAXIMIZED:
            self.firewall.maximized = not self.firewall.maximized





# MENU

    # Show Preferences
    def menuPreferences_activate_cb(self, widget):
        # Set initial values
        if self.firewall.ufw_log == self.variable.get_constant("ufw_log_off"):
            self.cb_ufw_log.set_active(0)
            self.cb_ufw_level.set_sensitive(0)
            self.lbl_ufw_level.set_sensitive(0)
            
        else:
            self.cb_ufw_log.set_active(1)
            self.cb_ufw_level.set_sensitive(1)
            self.lbl_ufw_level.set_sensitive(1)
            if self.firewall.ufw_log == self.variable.get_constant("ufw_log_low"):
                self.cb_ufw_level.set_active(0)
            elif self.firewall.ufw_log == self.variable.get_constant("ufw_log_medium"):
                self.cb_ufw_level.set_active(1)
            elif self.firewall.ufw_log == self.variable.get_constant("ufw_log_high"):
                self.cb_ufw_level.set_active(2)
            else:
                self.cb_ufw_level.set_active(3)
            
            
        if self.firewall.gufw_log != self.variable.get_constant("gufw_log_off"):
            self.cb_gufw_log.set_active(1)
        else:
            self.cb_gufw_log.set_active(0)
            
        # Show Window
        self.status_bar.push(1, "")
        self.winpreferences.show()
        self.pref_btn_close.grab_focus()
        

    # Change Logging Level
    def cbLogLevel_changed_cb(self, widget):
        if ( self.cb_ufw_level.get_active() == 0 ) and ( self.firewall.ufw_log != self.variable.get_constant("ufw_log_low") ):
            self.firewall.set_ufw_log(self.variable.get_constant("ufw_log_low"))
        elif ( self.cb_ufw_level.get_active() == 1 ) and ( self.firewall.ufw_log != self.variable.get_constant("ufw_log_medium") ):
            self.firewall.set_ufw_log(self.variable.get_constant("ufw_log_medium"))
        elif ( self.cb_ufw_level.get_active() == 2 ) and ( self.firewall.ufw_log != self.variable.get_constant("ufw_log_high") ):
            self.firewall.set_ufw_log(self.variable.get_constant("ufw_log_high"))
        elif ( self.cb_ufw_level.get_active() == 3 ) and ( self.firewall.ufw_log != self.variable.get_constant("ufw_log_full") ):
            self.firewall.set_ufw_log(self.variable.get_constant("ufw_log_full"))


    # Open About Dialog
    def menuAbout_activate_cb(self, widget):
        self.status_bar.push(1, "")
        self.winabout.show()
        self.winabout.run()
        self.winabout.hide()
        
    
    # Log Window
    def menuLog_activate_cb(self, widget):
        # Set Log Text
        log_strings  = self.firewall.get_log()
        txt = ""

        for string in log_strings:
            txt = "".join([txt, string, "\n"])
            
        self.log_txt_buffer.set_text(txt)
        
        self.status_bar.push(1, "")
        
        # Show Window
        self.winlog.show()
        self.log_btn_close.grab_focus()
        
        
        
        
       
# BUTTONS PREFERENCE WINDOW 

    # ufw Log CheckButton
    def cbUfwLog_toggled_cb(self, widget):
        if self.firewall.ufw_log != self.variable.get_constant("ufw_log_off") and self.cb_ufw_log.get_active() == 0:
            self.firewall.set_ufw_log(self.variable.get_constant("ufw_log_off"))
            self.cb_ufw_log.set_active(0)
            self.cb_ufw_level.set_sensitive(0)
            self.lbl_ufw_level.set_sensitive(0)
            
        elif self.firewall.ufw_log == self.variable.get_constant("ufw_log_off") and self.cb_ufw_log.get_active() == 1:
            self.firewall.set_ufw_log(self.variable.get_constant("ufw_log_on"))
            self.cb_ufw_log.set_active(1)
            self.cb_ufw_level.set_sensitive(1)
            self.cb_ufw_level.set_active(0)
            self.lbl_ufw_level.set_sensitive(1)
            
            
        self.status_bar.push(1, "")
       
    # Gufw Log CheckButton   
    def cbGufwLog_toggled_cb(self, widget):
        if self.firewall.gufw_log != self.variable.get_constant("gufw_log_on") and self.cb_gufw_log.get_active() == 1:
            self.firewall.set_gufw_log(self.variable.get_constant("gufw_log_on"))
        elif self.firewall.gufw_log != self.variable.get_constant("gufw_log_off") and self.cb_gufw_log.get_active() == 0:
            self.firewall.set_gufw_log(self.variable.get_constant("gufw_log_off"))
        
        self.set_window_values("")







# BUTTONS LOG WINDOW

    # Clear Log
    def btnClearLog_clicked_cb(self, widget):
        self.firewall.refresh_log()
        self.log_txt_buffer.set_text("")
        
        
    # Change Wrapping
    def cbWrapping_toggled_cb(self, widget):
        if self.firewall.wrap == self.variable.get_constant("wrap_on"):
            self.firewall.set_wrap(self.variable.get_constant("wrap_off"))
            self.log_txt.set_wrap_mode(gtk.WRAP_NONE)
        else:
            self.firewall.set_wrap(self.variable.get_constant("wrap_on"))
            self.log_txt.set_wrap_mode(gtk.WRAP_WORD)

        





       
# BUTTONS MAIN WINDOW
       
    # Button Firewall Enabled
    def cbEnabledFirewall_clicked_cb(self, widget):
        if self.firewall.status == self.variable.get_constant("enabled"):
            self.firewall.set_status(self.variable.get_constant("disabled"))
            self.add_btn_add.set_sensitive(0)
            self.set_window_values(self.variable.get_text("009"))
        else:
            self.firewall.set_status(self.variable.get_constant("enabled"))
            self.add_btn_add.set_sensitive(1)
            self.set_window_values(self.variable.get_text("008"))
            

    # Policy (Deny/Allow/Reject All)
    def cbPolicy_changed_cb(self, widget):
        # Apply?
        if self.firewall.default == self.variable.get_constant("deny") and self.cb_policy.get_active() == 0:
            return
        if self.firewall.default == self.variable.get_constant("reject") and self.cb_policy.get_active() == 1:
            return
        if self.firewall.default == self.variable.get_constant("allow") and self.cb_policy.get_active() == 2:
            return
            
        if self.cb_policy.get_active() == 0:
            self.firewall.set_default(self.variable.get_constant("deny"))
            self.set_window_values(self.variable.get_text("006"))
        elif self.cb_policy.get_active() == 1:
            self.firewall.set_default(self.variable.get_constant("reject"))
            self.set_window_values(self.variable.get_text("011"))
        elif self.cb_policy.get_active() == 2:
            self.firewall.set_default(self.variable.get_constant("allow"))
            self.set_window_values(self.variable.get_text("007"))
            

    # Button Remove Rules(s)
    def btnRemove_clicked_cb(self, widget):
        # Remove in 2 plane
        task = self.remove_rules()
        gobject.idle_add(task.next)
        
    
    # Remove Rules Method
    def remove_rules(self):
        tree,iter  = self.tv_rules.get_selection().get_selected_rows()
        removed    = 0
        actual_row = 0
        total_rows = len(iter)
           
        if total_rows == 0:
            self.set_window_values(self.variable.get_text("010"))
            yield None
            return

        # No sensitive buttons
        # Main Window
        self.cb_enabled_firewall.set_sensitive(0)
        self.cb_policy.set_sensitive(0)
        self.btn_remove_rule.set_sensitive(0)
        # Rules Window
        self.add_btn_add.set_sensitive(0)
        # Menus
        self.menu_pref.set_sensitive(0)

        # For one row: Selected
        for item in iter:

            # Get rule selected (To/Action/From)
            actual_rule_to   = tree.get_value(tree.get_iter(item),1)
            actual_rule      = tree.get_value(tree.get_iter(item),2)
            actual_rule_from = tree.get_value(tree.get_iter(item),3)
            
            # Move Progress Bar
            actual_row += 1
            progress = float(actual_row) / float(total_rows)
            if progress > 1:
                progress = 1.0
            self.progress_bar.set_fraction(progress)
            yield True

            result = self.firewall.remove_rule(actual_rule_to, actual_rule, actual_rule_from)
            if result.find(self.variable.get_constant("rule_deleted")) != -1:
                removed += 1

        # Clean Progress Bar
        self.progress_bar.set_fraction(0)
        
        if removed == 1:
            self.set_window_values(self.variable.get_text("014"))
        elif removed > 1:
            self.set_window_values(self.variable.get_text("019"))
        else:
            self.set_window_values(self.variable.get_text("012"))

        yield None


        

# BUTTONS ADD WINDOW
    
    # Add rule Button
    def btnAddRule_clicked_cb(self, widget):
        # Add a simple rule
        if self.rules_notebook.get_current_page() == 0:
            self.add_rule_preconf()
        # Add a preconfigured rule
        elif self.rules_notebook.get_current_page() == 1:
            self.add_rule_simple()
        # Add an advanced rule
        elif self.rules_notebook.get_current_page() == 2:
            self.add_rule_advanced()
            
  
    # Add a simple rule
    def add_rule_simple(self):
        # Allow|deny|Limit
        if self.action_simple.get_active() == 0:
            action = self.variable.get_constant("allow")
        elif self.action_simple.get_active() == 1:
            action = self.variable.get_constant("deny")
        elif self.action_simple.get_active() == 2:
            action = self.variable.get_constant("reject")
        else:
            action = self.variable.get_constant("limit")
        
        # Protocol
        if self.proto_simple.get_active() == 0:
            protocol = self.variable.get_constant("tcp")
        elif self.proto_simple.get_active() == 1:
            protocol = self.variable.get_constant("udp")
        else:
            protocol = self.variable.get_constant("both")

        # Port
        port = self.port_simple.get_text()
        
        # ? -> !
        if port == "asturianu":
            dlg_egg = gtk.MessageDialog(None, buttons=gtk.BUTTONS_CLOSE, message_format="Tamos fartos de glayar...\nl'asturianu llingua OFICIAL!")
            dlg_egg.run()
            dlg_egg.destroy()
            return
        
        # Validate port
        if port == "":
            self.set_window_values(self.variable.get_text("015"))
            return
            
        # Validate both and not range ports
        if ( port.find(":") != -1 ) and protocol == self.variable.get_constant("both"):
            self.set_window_values(self.variable.get_text("017"))
            return
            
        # Add rule
        result = self.firewall.add_rule(self.variable.get_constant("service_no"), action, protocol, "", "", "", port)
        if result.find(self.variable.get_constant("rule_added"))   != -1 or \
            result.find(self.variable.get_constant("rule_updated")) != -1:
            self.set_window_values(self.variable.get_text("013"))
        else:
            self.set_window_values(self.variable.get_text("012"))
        
        
    # Add a preconfigured rule
    def add_rule_preconf(self):
        # Allow|deny|Limit
        if self.action_preconf.get_active() == 0:
            action = self.variable.get_constant("allow")
        elif self.action_preconf.get_active() == 1:
            action = self.variable.get_constant("deny")
        elif self.action_preconf.get_active() == 2:
            action = self.variable.get_constant("reject")
        else:
            action = self.variable.get_constant("limit")

        # Service?
        if self.serv_prog_type == self.variable.get_constant("service_enabled"):
            port_proto = self.variable.get_service(self.service_preconf.get_active_text()) 
            if port_proto.find(self.variable.get_constant("tcp")) != -1:
                port     = port_proto.replace(self.variable.get_constant("tcp"), "")
                protocol = self.variable.get_constant("tcp")
                l_service = self.variable.get_constant("service_no")
            elif port_proto.find(self.variable.get_constant("udp")) != -1:
                port     = port_proto.replace(self.variable.get_constant("udp"), "")
                protocol = self.variable.get_constant("udp")
                l_service = self.variable.get_constant("service_no")
            elif port_proto.find(self.variable.get_constant("both")) != -1:
                port     = port_proto.replace(self.variable.get_constant("both"), "")
                protocol = self.variable.get_constant("both")
                l_service = self.variable.get_constant("service_no")
            else:
                port     = port_proto
                protocol = ""
                l_service = self.variable.get_constant("service_yes")
                
            # TODO Add rule service
            result = self.firewall.add_rule(l_service, action, protocol, "", "", "", port)
            if result.find(self.variable.get_constant("rule_added"))   != -1 or \
                result.find(self.variable.get_constant("rule_updated")) != -1:
                self.set_window_values(self.variable.get_text("013"))
            else:
                self.set_window_values(self.variable.get_text("012"))
              
        # Program?
        else:
            port_proto   = self.variable.get_program(self.program_preconf.get_active_text()) 
            ports_protos = port_proto.split("#")
            added        = 0
            
            for prog in ports_protos:
                if prog.find(self.variable.get_constant("tcp")) != -1:
                    port     = prog.replace(self.variable.get_constant("tcp"), "")
                    protocol = self.variable.get_constant("tcp")
                elif prog.find(self.variable.get_constant("udp")) != -1:
                    port     = prog.replace(self.variable.get_constant("udp"), "")
                    protocol = self.variable.get_constant("udp")
                elif prog.find(self.variable.get_constant("both")) != -1:
                    port     = prog.replace(self.variable.get_constant("both"), "")
                    protocol = self.variable.get_constant("both")
                    
                # TODO Add rule program
                result = self.firewall.add_rule(self.variable.get_constant("service_no"), action, protocol, "", "", "", port)
                if result.find(self.variable.get_constant("rule_added"))   != -1 or \
                    result.find(self.variable.get_constant("rule_updated")) != -1:
                    added += 1
                    
            if added == 1: 
                self.set_window_values(self.variable.get_text("013"))
            elif added > 1:
                self.set_window_values(self.variable.get_text("020"))
            else:
                self.set_window_values(self.variable.get_text("012"))
                
    
    # Add an advanced rule
    def add_rule_advanced(self):
        # Deny|Reject|Allow|Limit
        if self.action_advanced.get_active() == 0:
            action = self.variable.get_constant("allow")
        elif self.action_advanced.get_active() == 1:
            action = self.variable.get_constant("deny")
        elif self.action_advanced.get_active() == 2:
            action = self.variable.get_constant("reject")
        else:
            action = self.variable.get_constant("limit")

        # Protocol
        if self.proto_advanced.get_active() == 0:
            protocol = self.variable.get_constant("tcp")
        elif self.proto_advanced.get_active() == 1:
            protocol = self.variable.get_constant("udp")
        else:
            protocol = self.variable.get_constant("both")
                
        # From
        fromip   = self.fromip_advanced.get_text()
        fromport = self.portfrom_advanced.get_text()
        
        # To
        toip   = self.toip_advanced.get_text()
        toport = self.portto_advanced.get_text() 
        
        # Validate values
        if fromip == "" and fromport == "" and toip == "" and toport == "":
            self.set_window_values(self.variable.get_text("016"))
            return

        # Validate both and not range ports in FROM
        if ( fromport != "" and fromport.find(":") != -1 ) and protocol == self.variable.get_constant("both"):
            self.set_window_values(self.variable.get_text("017"))
            return
        # Validate both and not range ports in TO            
        if ( toport != "" and toport.find(":") != -1 ) and protocol == self.variable.get_constant("both"):
            self.set_window_values(self.variable.get_text("017"))
            return
                    
        # Add rule program
        result = self.firewall.add_rule(self.variable.get_constant("service_no"), action, protocol, fromip, fromport, toip, toport)
        if result.find(self.variable.get_constant("rule_added"))   != -1 or \
           result.find(self.variable.get_constant("rule_updated")) != -1:
            self.set_window_values(self.variable.get_text("013"))
        else:
            self.set_window_values(self.variable.get_text("012"))

        
    # Change between Service/Program
    def cbTypePreconf_changed_cb(self, widget):
        if self.serv_prog_type == self.variable.get_constant("service_enabled"):
            self.serv_prog_type = self.variable.get_constant("service_disabled")
            self.service_preconf.hide()   
            self.program_preconf.show()   
        else:
            self.serv_prog_type = self.variable.get_constant("service_enabled")
            self.service_preconf.show()   
            self.program_preconf.hide()   


    # Clear values
    def btnCleanAdvanced_clicked_cb(self, widget):
        self.fromip_advanced.set_text("")
        self.portfrom_advanced.set_text("")
        self.toip_advanced.set_text("")
        self.portto_advanced.set_text("")
