/*
 * Guifications - The end all, be all, toaster popup plugin
 * Copyright (C) 2003-2005 Gary Kramlich
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef GF_ITEM_ICON_H
#define GF_ITEM_ICON_H

typedef enum _GfItemIconType {
	GF_ITEM_ICON_TYPE_PROTOCOL = 0,
	GF_ITEM_ICON_TYPE_BUDDY,
	GF_ITEM_ICON_TYPE_STATUS,
	GF_ITEM_ICON_TYPE_UNKNOWN
} GfItemIconType;

typedef enum _GfItemIconSize {
	GF_ITEM_ICON_SIZE_TINY = 0,
	GF_ITEM_ICON_SIZE_SMALL,
	GF_ITEM_ICON_SIZE_LITTLE,
	GF_ITEM_ICON_SIZE_NORMAL,
	GF_ITEM_ICON_SIZE_BIG,
	GF_ITEM_ICON_SIZE_LARGE,
	GF_ITEM_ICON_SIZE_HUGE,
	GF_ITEM_ICON_SIZE_UNKNOWN
} GfItemIconSize;

#define GF_ITEM_ICON(obj)	((GfItemIcon *)(obj))

typedef struct _GfItemIcon GfItemIcon;

#include <gdk/gdk.h>

#include <xmlnode.h>

#include "gf_event_info.h"
#include "gf_item.h"

G_BEGIN_DECLS

GfItemIcon *gf_item_icon_new(GfItem *item);
GfItemIcon *gf_item_icon_new_from_xmlnode(GfItem *item, xmlnode *node);
GfItemIcon *gf_item_icon_copy(GfItemIcon *icon);
xmlnode *gf_item_icon_to_xmlnode(GfItemIcon *icon);
void gf_item_icon_destroy(GfItemIcon *item_icon);

void gf_item_icon_set_type(GfItemIcon *icon, GfItemIconType type);
GfItemIconType gf_item_icon_get_type(GfItemIcon *icon);
void gf_item_icon_set_size(GfItemIcon *icon, GfItemIconSize size);
GfItemIconSize gf_item_icon_get_size(GfItemIcon *icon);

void gf_item_icon_set_item(GfItemIcon *icon, GfItem *item);
GfItem *gf_item_icon_get_item(GfItemIcon *icon);

void gf_item_icon_render(GfItemIcon *item_icon, GdkPixbuf *pixbuf,
						 GfEventInfo *info);

G_END_DECLS

#endif /* GF_ITEM_ICON_H */
