/*
 * Copyright (C) 2009, 2010 Hermann Meyer, James Warden, Andreas Degert
 * Copyright (C) 2011 Pete Shorthose
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 * ---------------------------------------------------------------------------
 *
 *    This is the 6V6 tube table
 *    This file is part of the Guitarix Audio Engine
 *
 * ----------------------------------------------------------------------------
 */

table1d_imp<2001> tubetable_6V6[2] = {
	{ // Ri = 68k
	-5,5,200,2001, {
	239.919843376,239.854937108,239.789738489,239.724247218,239.658462996,
	239.592385535,239.526014546,239.459349752,239.392390878,239.325137654,
	239.257589818,239.189747112,239.121609284,239.053176087,238.984447281,
	238.91542263,238.846101903,238.776484877,238.706571332,238.636361055,
	238.565853836,238.495049475,238.423947772,238.352548536,238.280851579,
	238.208856722,238.136563787,238.063972604,237.991083007,237.917894835,
	237.844407935,237.770622155,237.696537352,237.622153385,237.54747012,
	237.472487429,237.397205186,237.321623273,237.245741575,237.169559984,
	237.093078396,237.016296711,236.939214835,236.86183268,236.78415016,
	236.706167196,236.627883714,236.549299644,236.470414921,236.391229484,
	236.311743279,236.231956253,236.151868362,236.071479563,235.99078982,
	235.9097991,235.828507376,235.746914624,235.665020826,235.582825967,
	235.500330038,235.417533033,235.334434951,235.251035796,235.167335575,
	235.083334301,234.999031988,234.914428659,234.829524337,234.744319051,
	234.658812834,234.573005723,234.48689776,234.400488988,234.313779459,
	234.226769224,234.13945834,234.05184687,233.963934876,233.875722429,
	233.7872096,233.698396466,233.609283107,233.519869606,233.430156051,
	233.340142534,233.249829147,233.159215991,233.068303166,232.977090779,
	232.885578937,232.793767753,232.701657342,232.609247824,232.516539321,
	232.423531959,232.330225867,232.236621177,232.142718023,232.048516546,
	231.954016887,231.85921919,231.764123605,231.66873028,231.573039372,
	231.477051037,231.380765434,231.284182727,231.187303082,231.090126667,
	230.992653654,230.894884217,230.796818534,230.698456783,230.599799147,
	230.500845813,230.401596966,230.302052798,230.202213502,230.102079273,
	230.001650309,229.900926811,229.799908981,229.698597024,229.596991149,
	229.495091566,229.392898486,229.290412124,229.187632698,229.084560426,
	228.98119553,228.877538233,228.77358876,228.66934734,228.564814202,
	228.459989578,228.354873701,228.249466808,228.143769136,228.037780925,
	227.931502416,227.824933853,227.718075481,227.610927548,227.503490301,
	227.395763992,227.287748873,227.179445197,227.070853221,226.961973202,
	226.852805398,226.743350071,226.633607482,226.523577894,226.413261574,
	226.302658786,226.1917698,226.080594885,225.969134311,225.857388351,
	225.745357278,225.633041366,225.520440893,225.407556135,225.294387371,
	225.180934881,225.067198945,224.953179846,224.838877868,224.724293293,
	224.609426409,224.494277501,224.378846857,224.263134765,224.147141516,
	224.030867399,223.914312706,223.79747773,223.680362764,223.562968102,
	223.445294038,223.32734087,223.209108892,223.090598404,222.971809703,
	222.852743088,222.733398858,222.613777314,222.493878757,222.373703489,
	222.253251812,222.132524028,222.011520442,221.890241357,221.768687078,
	221.64685791,221.524754159,221.402376131,221.279724132,221.15679847,
	221.033599452,220.910127386,220.78638258,220.662365343,220.538075983,
	220.413514811,220.288682136,220.163578268,220.038203517,219.912558193,
	219.786642608,219.660457072,219.534001897,219.407277394,219.280283874,
	219.15302165,219.025491033,218.897692335,218.769625868,218.641291945,
	218.512690877,218.383822977,218.254688558,218.125287932,217.995621411,
	217.865689308,217.735491935,217.605029605,217.47430263,217.343311321,
	217.212055993,217.080536955,216.948754521,216.816709003,216.684400712,
	216.551829959,216.418997057,216.285902317,216.152546049,216.018928564,
	215.885050174,215.750911189,215.616511919,215.481852673,215.346933762,
	215.211755495,215.076318182,214.94062213,214.804667649,214.668455047,
	214.531984632,214.395256711,214.258271591,214.121029579,213.983530982,
	213.845776106,213.707765256,213.569498737,213.430976855,213.292199913,
	213.153168215,213.013882065,212.874341767,212.734547621,212.594499931,
	212.454198998,212.313645122,212.172838605,212.031779746,211.890468845,
	211.748906201,211.607092111,211.465026874,211.322710786,211.180144145,
	211.037327247,210.894260386,210.750943858,210.607377956,210.463562975,
	210.319499207,210.175186945,210.03062648,209.885818102,209.740762104,
	209.595458773,209.449908399,209.30411127,209.158067675,209.011777899,
	208.865242228,208.718460949,208.571434346,208.424162703,208.276646303,
	208.128885428,207.980880361,207.832631382,207.684138772,207.53540281,
	207.386423774,207.237201943,207.087737593,206.938031001,206.788082442,
	206.637892191,206.487460522,206.336787708,206.185874021,206.034719731,
	205.883325111,205.73169043,205.579815955,205.427701956,205.275348699,
	205.122756451,204.969925477,204.816856041,204.663548407,204.510002838,
	204.356219595,204.20219894,204.047941132,203.893446431,203.738715095,
	203.583747381,203.428543545,203.273103843,203.117428529,202.961517858,
	202.80537208,202.648991449,202.492376215,202.335526628,202.178442936,
	202.021125388,201.86357423,201.705789708,201.547772068,201.389521553,
	201.231038406,201.072322869,200.913375184,200.75419559,200.594784326,
	200.435141631,200.275267741,200.115162893,199.954827322,199.794261261,
	199.633464944,199.472438602,199.311182467,199.149696769,198.987981736,
	198.826037597,198.663864578,198.501462905,198.338832802,198.175974495,
	198.012888205,197.849574154,197.686032562,197.52226365,197.358267635,
	197.194044735,197.029595166,196.864919145,196.700016884,196.534888597,
	196.369534496,196.203954793,196.038149697,195.872119417,195.70586416,
	195.539384134,195.372679544,195.205750595,195.03859749,194.871220431,
	194.703619619,194.535795255,194.367747539,194.199476666,194.030982836,
	193.862266242,193.69332708,193.524165544,193.354781825,193.185176116,
	193.015348605,192.845299483,192.675028937,192.504537154,192.333824319,
	192.162890617,191.991736232,191.820361346,191.648766139,191.476950793,
	191.304915485,191.132660394,190.960185696,190.787491567,190.61457818,
	190.44144571,190.268094328,190.094524205,189.92073551,189.746728413,
	189.572503081,189.398059679,189.223398374,189.048519329,188.873422706,
	188.698108668,188.522577375,188.346828986,188.17086366,187.994681553,
	187.818282821,187.641667619,187.4648361,187.287788416,187.110524719,
	186.933045159,186.755349884,186.577439042,186.399312779,186.220971241,
	186.042414571,185.863642913,185.684656407,185.505455195,185.326039416,
	185.146409208,184.966564707,184.78650605,184.606233371,184.425746802,
	184.245046478,184.064132527,183.88300508,183.701664266,183.520110212,
	183.338343043,183.156362885,182.974169862,182.791764095,182.609145707,
	182.426314816,182.243271543,182.060016004,181.876548316,181.692868595,
	181.508976953,181.324873504,181.14055836,180.95603163,180.771293424,
	180.58634385,180.401183013,180.215811021,180.030227975,179.844433981,
	179.658429138,179.472213549,179.285787311,179.099150523,178.912303282,
	178.725245682,178.537977819,178.350499785,178.162811672,177.974913571,
	177.78680557,177.598487758,177.409960222,177.221223046,177.032276316,
	176.843120113,176.653754521,176.464179619,176.274395486,176.084402201,
	175.894199839,175.703788477,175.513168189,175.322339047,175.131301123,
	174.940054487,174.748599208,174.556935354,174.365062992,174.172982186,
	173.980693001,173.788195499,173.595489741,173.402575787,173.209453697,
	173.016123528,172.822585335,172.628839174,172.434885098,172.240723159,
	172.046353409,171.851775896,171.65699067,171.461997778,171.266797264,
	171.071389174,170.87577355,170.679950435,170.483919869,170.28768189,
	170.091236537,169.894583847,169.697723853,169.500656591,169.303382093,
	169.105900389,168.90821151,168.710315484,168.512212338,168.313902098,
	168.115384789,167.916660433,167.717729053,167.518590668,167.319245298,
	167.11969296,166.919933671,166.719967446,166.519794298,166.31941424,
	166.118827282,165.918033434,165.717032704,165.515825098,165.314410622,
	165.112789281,164.910961076,164.708926008,164.506684078,164.304235284,
	164.101579623,163.898717091,163.695647681,163.492371386,163.288888199,
	163.085198108,162.881301103,162.67719717,162.472886295,162.268368463,
	162.063643656,161.858711857,161.653573044,161.448227196,161.242674291,
	161.036914304,160.83094721,160.62477298,160.418391588,160.211803002,
	160.005007191,159.798004121,159.590793759,159.383376069,159.175751012,
	158.967918551,158.759878644,158.551631251,158.343176326,158.134513827,
	157.925643705,157.716565915,157.507280405,157.297787126,157.088086025,
	156.878177048,156.66806014,156.457735244,156.247202301,156.036461253,
	155.825512036,155.614354589,155.402988847,155.191414744,154.979632212,
	154.767641183,154.555441585,154.343033346,154.130416393,153.91759065,
	153.704556041,153.491312486,153.277859907,153.064198221,152.850327345,
	152.636247195,152.421957684,152.207458725,151.992750227,151.7778321,
	151.562704251,151.347366586,151.131819009,150.916061423,150.700093728,
	150.483915823,150.267527608,150.050928976,149.834119824,149.617100043,
	149.399869526,149.182428161,148.964775837,148.746912439,148.528837853,
	148.310551961,148.092054646,147.873345786,147.65442526,147.435292944,
	147.215948713,146.99639244,146.776623997,146.556643254,146.336450078,
	146.116044336,145.895425893,145.674594613,145.453550356,145.232292983,
	145.010822352,144.789138319,144.567240739,144.345129466,144.122804351,
	143.900265243,143.677511992,143.454544443,143.231362442,143.007965832,
	142.784354453,142.560528148,142.336486752,142.112230104,141.887758038,
	141.663070388,141.438166985,141.213047659,140.987712238,140.762160551,
	140.536392421,140.310407672,140.084206127,139.857787605,139.631151926,
	139.404298906,139.177228362,138.949940108,138.722433955,138.494709716,
	138.266767199,138.038606213,137.810226563,137.581628056,137.352810494,
	137.12377368,136.894517415,136.665041496,136.435345723,136.205429892,
	135.975293798,135.744937235,135.514359995,135.283561869,135.052542648,
	134.82130212,134.589840073,134.358156292,134.126250564,133.894122672,
	133.661772399,133.429199528,133.19640384,132.963385115,132.730143131,
	132.496677668,132.262988503,132.029075413,131.794938175,131.560576562,
	131.325990352,131.091179317,130.856143233,130.620881872,130.385395008,
	130.149682414,129.913743863,129.677579128,129.441187981,129.204570195,
	128.967725544,128.730653801,128.493354739,128.255828133,128.018073758,
	127.780091388,127.541880801,127.303441774,127.064774085,126.825877513,
	126.58675184,126.347396848,126.107812322,125.867998046,125.627953809,
	125.387679402,125.147174616,124.906439246,124.665473091,124.424275951,
	124.18284763,123.941187934,123.699296676,123.457173669,123.214818733,
	122.97223169,122.729412369,122.486360602,122.243076228,121.99955909,
	121.755809038,121.511825927,121.26760962,121.023159987,120.778476904,
	120.533560256,120.288409935,120.043025842,119.797407887,119.551555992,
	119.305470084,119.059150105,118.812596006,118.565807749,118.318785311,
	118.071528678,117.824037853,117.57631285,117.328353699,117.080160446,
	116.831733152,116.583071896,116.334176775,116.085047901,115.835685411,
	115.586089457,115.336260215,115.086197883,114.835902681,114.585374855,
	114.334614673,114.083622432,113.832398456,113.580943098,113.329256739,
	113.077339793,112.825192708,112.572815961,112.320210071,112.067375588,
	111.814313105,111.561023251,111.307506702,111.053764172,110.799796425,
	110.545604269,110.291188564,110.036550219,109.781690197,109.526609517,
	109.271309257,109.015790552,108.760054603,108.504102673,108.247936094,
	107.99155627,107.734964676,107.478162863,107.221152462,106.963935187,
	106.706512834,106.448887292,106.191060538,105.933034646,105.674811791,
	105.416394248,105.157784399,104.89898474,104.639997879,104.380826542,
	104.121473582,103.861941977,103.602234839,103.342355417,103.082307103,
	102.822093435,102.561718104,102.30118496,102.040498015,101.779661449,
	101.518679619,101.25755706,100.996298495,100.734908838,100.473393204,
	100.211756913,99.9500054931,99.6881446953,99.4261804934,99.1641190935,
	98.9019669409,98.6397307266,98.3774173951,98.115034151,97.8525884667,
	97.5900880897,97.32754105,97.0649556675,96.8023405592,96.5397046474,
	96.2770571663,96.01440767,95.7517660395,95.4891424902,95.226547579,
	94.9639922112,94.7014876479,94.4390455122,94.1766777957,93.9143968652,
	93.6522154685,93.39014674,93.1282042061,92.8664017902,92.6047538171,
	92.3432750174,92.0819805307,91.820885909,91.5600071186,91.2993605427,
	91.0389629817,90.7788316539,90.5189841954,90.2594386585,90.0002135096,
	89.7413276266,89.4828002945,89.2246512005,88.9669004284,88.709568451,
	88.4526761221,88.196244667,87.940295672,87.6848510727,87.4299331406,
	87.1755644693,86.9217679583,86.6685667964,86.4159844438,86.1640446119,
	85.9127712432,85.6621884888,85.4123206855,85.163192331,84.914828058,
	84.6672526082,84.4204908033,84.1745675171,83.9295076449,83.6853360732,
	83.4420776478,83.1997571419,82.9583992232,82.7180284205,82.4786690901,
	82.2403453816,82.0030812043,81.7669001925,81.5318256718,81.2978806254,
	81.0650876604,80.8334689751,80.6030463265,80.373840999,80.1458737738,
	79.9191648987,79.6937340602,79.469600356,79.2467822688,79.025297642,
	78.8051636567,78.5863968102,78.3690128963,78.1530269874,77.9384534185,
	77.7253057722,77.5135968673,77.3033387471,77.0945426718,76.8872191109,
	76.6813777391,76.4770274327,76.274176269,76.0728315269,75.8729996892,
	75.674686447,75.4778967059,75.2826345928,75.0889034655,74.896705923,
	74.7060438173,74.5169182664,74.3293296689,74.1432777192,73.958761424,
	73.7757791196,73.5943284902,73.4144065864,73.2360098455,73.0591341108,
	72.8837746527,72.7099261894,72.5375829084,72.3667384877,72.1973861174,
	72.0295185219,71.8631279807,71.698206351,71.5347450886,71.3727352695,
	71.2121676108,71.0530324916,70.895319974,70.7390198224,70.5841215239,
	70.4306143075,70.2784871629,70.127728859,69.9783279618,69.8302728517,
	69.6835517406,69.5381526878,69.3940636164,69.251272328,69.1097665175,
	68.9695337873,68.8305616607,68.692837595,68.556348994,68.4210832195,
	68.2870276031,68.1541694565,68.0224960825,67.8919947839,67.7626528733,
	67.6344576819,67.5073965675,67.3814569225,67.2566261813,67.132891827,
	67.0102413984,66.8886624955,66.7681427857,66.6486700089,66.5302319826,
	66.4128166063,66.2964118658,66.1810058376,66.0665866919,65.9531426963,
	65.8406622188,65.7291337307,65.6185458088,65.5088871381,65.4001465135,
	65.2923128418,65.1853751436,65.0793225539,64.9741443241,64.869829823,
	64.7663685372,64.6637500722,64.5619641527,64.4610006235,64.3608494493,
	64.261500715,64.1629446261,64.0651715079,63.9681718061,63.8719360861,
	63.776455033,63.6817194506,63.5877202614,63.4944485058,63.4018953417,
	63.3100520431,63.2189100002,63.1284607182,63.038695816,62.9496070262,
	62.8611861931,62.7734252727,62.6863163309,62.5998515428,62.5140231916,
	62.4288236674,62.344245466,62.2602811881,62.1769235376,62.094165321,
	62.0119994454,61.9304189184,61.8494168459,61.7689864313,61.6891209743,
	61.6098138696,61.5310586057,61.4528487634,61.3751780152,61.2980401233,
	61.2214289391,61.1453384013,61.0697625353,60.9946954515,60.9201313444,
	60.8460644913,60.772489251,60.699400063,60.6267914458,60.554657996,
	60.4829943874,60.4117953693,60.3410557658,60.2707704748,60.2009344661,
	60.1315427815,60.0625905326,59.9940729003,59.9259851339,59.8583225495,
	59.7910805294,59.724254521,59.6578400356,59.5918326476,59.5262279936,
	59.4610217712,59.3962097382,59.3317877115,59.2677515663,59.2040972355,
	59.140820708,59.0779180285,59.0153852966,58.9532186654,58.8914143412,
	58.8299685825,58.768877699,58.708138051,58.6477460488,58.5876981511,
	58.5279908653,58.4686207459,58.4095843943,58.3508784577,58.2924996285,
	58.2344446436,58.1767102838,58.119293373,58.0621907773,58.005399405,
	57.948916205,57.892738167,57.8368623204,57.7812857339,57.7260055146,
	57.6710188078,57.616322796,57.5619146987,57.5077917713,57.4539513053,
	57.4003906269,57.3471070972,57.2940981111,57.241361097,57.1888935166,
	57.1366928636,57.084756664,57.0330824751,56.9816678854,56.9305105136,
	56.8796080089,56.8289580495,56.7785583433,56.7284066266,56.6785006639,
	56.6288382478,56.5794171979,56.5302353612,56.4812906111,56.432580847,
	56.3841039945,56.3358580041,56.2878408518,56.2400505378,56.1924850868,
	56.1451425476,56.0980209921,56.0511185157,56.0044332366,55.9579632956,
	55.9117068555,55.8656621011,55.8198272387,55.7742004958,55.7287801209,
	55.6835643831,55.6385515716,55.5937399958,55.5491279849,55.5047138872,
	55.4604960706,55.4164729216,55.3726428452,55.3290042651,55.2855556227,
	55.2422953775,55.1992220065,55.1563340038,55.1136298808,55.0711081657,
	55.0287674032,54.9866061544,54.9446229966,54.9028165229,54.8611853421,
	54.8197280785,54.7784433715,54.7373298757,54.6963862605,54.6556112098,
	54.6150034221,54.5745616098,54.5342844997,54.4941708323,54.4542193616,
	54.4144288551,54.3747980937,54.3353258713,54.2960109948,54.2568522837,
	54.2178485702,54.1789986988,54.1403015262,54.1017559213,54.0633607649,
	54.0251149495,53.9870173791,53.9490669694,53.9112626471,53.8736033501,
	53.8360880275,53.7987156391,53.7614851554,53.7243955574,53.6874458368,
	53.6506349953,53.6139620448,53.5774260075,53.5410259151,53.5047608095,
	53.4686297419,53.4326317732,53.3967659736,53.3610314227,53.3254272092,
	53.2899524309,53.2546061945,53.2193876154,53.184295818,53.149329935,
	53.1144891078,53.079772486,53.0451792278,53.0107084993,52.9763594747,
	52.9421313363,52.9080232742,52.8740344864,52.8401641783,52.8064115633,
	52.772775862,52.7392563025,52.7058521203,52.672562558,52.6393868653,
	52.6063242993,52.5733741236,52.5405356091,52.5078080332,52.4751906802,
	52.442682841,52.4102838131,52.3779929004,52.3458094133,52.3137326685,
	52.281761989,52.2498967038,52.2181361484,52.1864796639,52.1549265977,
	52.123476303,52.0921281387,52.0608814697,52.0297356664,51.998690105,
	51.9677441672,51.9368972401,51.9061487165,51.8754979942,51.8449444767,
	51.8144875727,51.7841266957,51.7538612649,51.7236907043,51.6936144428,
	51.6636319146,51.6337425585,51.6039458184,51.5742411427,51.544627985,
	51.5151058032,51.4856740601,51.4563322228,51.4270797633,51.3979161578,
	51.3688408872,51.3398534365,51.3109532954,51.2821399576,51.2534129212,
	51.2247716884,51.1962157658,51.1677446638,51.1393578971,51.1110549843,
	51.0828354481,51.0546988151,51.0266446158,50.9986723845,50.9707816593,
	50.9429719823,50.9152428991,50.8875939591,50.8600247153,50.8325347244,
	50.8051235466,50.7777907458,50.7505358892,50.7233585476,50.6962582952,
	50.6692347097,50.6422873719,50.6154158663,50.5886197804,50.5618987051,
	50.5352522345,50.5086799659,50.4821814997,50.4557564396,50.4294043921,
	50.4031249672,50.3769177775,50.3507824389,50.3247185701,50.2987257929,
	50.2728037319,50.2469520147,50.2211702716,50.1954581358,50.1698152434,
	50.1442412332,50.1187357466,50.0932984281,50.0679289244,50.0426268854,
	50.0173919631,49.9922238125,49.967122091,49.9420864588,49.9171165783,
	49.8922121146,49.8673727353,49.8425981105,49.8178879127,49.7932418167,
	49.7686594998,49.7441406417,49.7196849244,49.6952920323,49.670961652,
	49.6466934725,49.622487185,49.5983424828,49.5742590617,49.5502366195,
	49.5262748563,49.5023734741,49.4785321775,49.4547506727,49.4310286684,
	49.4073658752,49.3837620058,49.3602167748,49.336729899,49.3133010971,
	49.28993009,49.2666166002,49.2433603524,49.2201610732,49.197018491,
	49.1739323363,49.1509023413,49.12792824,49.1050097686,49.0821466646,
	49.0593386678,49.0365855194,49.0138869628,48.9912427428,48.968652606,
	48.9461163009,48.9236335776,48.901204188,48.8788278855,48.8565044252,
	48.8342335641,48.8120150606,48.7898486748,48.7677341684,48.7456713047,
	48.7236598486,48.7016995666,48.6797902266,48.6579315983,48.6361234527,
	48.6143655624,48.5926577015,48.5709996457,48.5493911719,48.5278320588,
	48.5063220864,48.484861036,48.4634486905,48.4420848342,48.4207692528,
	48.3995017333,48.3782820642,48.3571100353,48.3359854377,48.314908064,
	48.2938777081,48.272894165,48.2519572313,48.2310667048,48.2102223845,
	48.1894240707,48.1686715652,48.1479646707,48.1273031914,48.1066869326,
	48.0861157009,48.0655893041,48.0451075513,48.0246702526,48.0042772194,
	47.9839282643,47.963623201,47.9433618444,47.9231440105,47.9029695165,
	47.8828381808,47.8627498227,47.8427042628,47.8227013227,47.8027408252,
	47.7828225941,47.7629464542,47.7431122316,47.7233197533,47.7035688473,
	47.6838593428,47.6641910699,47.6445638598,47.6249775446,47.6054319576,
	47.5859269331,47.5664623061,47.5470379129,47.5276535906,47.5083091774,
	47.4890045124,47.4697394356,47.450513788,47.4313274116,47.4121801493,
	47.3930718448,47.3740023428,47.3549714891,47.3359791301,47.3170251133,
	47.2981092869,47.2792315003,47.2603916035,47.2415894475,47.2228248841,
	47.2040977659,47.1854079466,47.1667552804,47.1481396226,47.1295608293,
	47.1110187573,47.0925132644,47.0740442089,47.0556114503,47.0372148487,
	47.0188542649,47.0005295607,46.9822405986,46.9639872418,46.9457693543,
	46.9275868009,46.9094394473,46.8913271597,46.8732498052,46.8552072516,
	46.8371993674,46.8192260219,46.8012870852,46.7833824279,46.7655119216,
	46.7476754383,46.7298728509,46.712104033,46.6943688588,46.6766672034,
	46.6589989423,46.6413639518,46.6237621091,46.6061932917,46.5886573779,
	46.5711542468,46.5536837781,46.5362458519,46.5188403494,46.501467152,
	46.4841261421,46.4668172024,46.4495402166,46.4322950687,46.4150816434,
	46.3978998262,46.3807495031,46.3636305605,46.3465428857,46.3294863665,
	46.3124608912,46.2954663489,46.2785026291,46.261569622,46.2446672182,
	46.2277953091,46.2109537865,46.1941425428,46.1773614712,46.1606104651,
	46.1438894186,46.1271982264,46.1105367837,46.0939049864,46.0773027305,
	46.0607299131,46.0441864315,46.0276721836,46.0111870677,45.9947309829,
	45.9783038286,45.9619055047,45.9455359118,45.9291949509,45.9128825234,
	45.8965985314,45.8803428774,45.8641154643,45.8479161957,45.8317449755,
	45.8156017082,45.7994862988,45.7833986526,45.7673386755,45.751306274,
	45.7353013548,45.7193238253,45.7033735933,45.6874505668,45.6715546547,
	45.6556857661,45.6398438106,45.6240286981,45.6082403393,45.5924786449,
	45.5767435264,45.5610348956,45.5453526646,45.5296967462,45.5140670535,
	45.4984635,45.4828859995,45.4673344665,45.4518088158,45.4363089625,
	45.4208348222,45.4053863109,45.3899633451,45.3745658416,45.3591937176,
	45.3438468908,45.328525279,45.3132288009,45.297957375,45.2827109208,
	45.2674893576,45.2522926056,45.2371205849,45.2219732164,45.2068504212,
	45.1917521207,45.1766782368,45.1616286916,45.1466034078,45.1316023084,
	45.1166253165,45.101672356,45.0867433507,45.0718382252,45.0569569041,
	45.0420993126,45.027265376,45.0124550203,44.9976681714,44.9829047559,
	44.9681647005,44.9534479326,44.9387543794,44.924083969,44.9094366294,
	44.8948122891,44.8802108769,44.865632322,44.8510765539,44.8365435024,
	44.8220330976,44.8075452698,44.7930799499,44.778637069,44.7642165583,
	44.7498183497,44.735442375,44.7210885667,44.7067568573,44.6924471798,
	44.6781594673,44.6638936534,44.6496496719,44.6354274569,44.6212269429,
	44.6070480645,44.5928907568,44.578754955,44.5646405947,44.5505476118,
	44.5364759423,44.5224255228,44.50839629,44.4943881808,44.4804011325,
	44.4664350827,44.4524899692,44.43856573,44.4246623036,44.4107796285,
	44.3969176438,44.3830762885,44.369255502,44.3554552242,44.341675395,
	44.3279159545,44.3141768433,44.3004580021,44.2867593719,44.2730808939,
	44.2594225098,44.2457841612,44.2321657901,44.2185673388,44.2049887499,
	44.191429966,44.1778909302,44.1643715857,44.150871876,44.1373917448,
	44.1239311362,44.1104899942,44.0970682634,44.0836658884,44.0702828141,
	44.0569189857,44.0435743485,44.0302488482,44.0169424307,44.0036550418,
	43.990386628,43.9771371358,43.9639065119,43.9506947033,43.9375016571,
	43.9243273208,43.911171642,43.8980345685,43.8849160484,43.8718160299,
	43.8587344616,43.8456712922,43.8326264705,43.8195999457,43.8065916671,
	43.7936015843,43.780629647,43.7676758052,43.7547400091,43.7418222089,
	43.7289223553,43.7160403991,43.7031762912,43.6903299827,43.6775014252,
	43.66469057,43.6518973691,43.6391217743,43.6263637378,43.613623212,
	43.6009001494,43.5881945027,43.5755062248,43.5628352689,43.5501815883,
	43.5375451365,43.524925867,43.5123237339,43.499738691,43.4871706927,
	43.4746196934,43.4620856476,43.4495685102,43.437068236,43.4245847802,
	43.4121180981,43.3996681453,43.3872348772,43.3748182499,43.3624182192,
	43.3500347414,43.3376677729,43.32531727,43.3129831897,43.3006654886,
	43.2883641239,43.2760790527,43.2638102324,43.2515576206,43.2393211749,
	43.2271008533,43.2148966136,43.2027084142,43.1905362133,43.1783799696,
	43.1662396416,43.1541151882,43.1420065683,43.1299137412,43.1178366661,
	43.1057753025,43.0937296101,43.0816995485,43.0696850777,43.0576861577,
	43.0457027489,43.0337348116,43.0217823063,43.0098451938,42.9979234347,
	42.9860169902,42.9741258213,42.9622498893,42.9503891557,42.938543582,
	42.9267131299,42.9148977612,42.9030974381,42.8913121225,42.8795417768,
	42.8677863635,42.856045845,42.8443201841,42.8326093436,42.8209132865,
	42.809231976,42.7975653752,42.7859134476,42.7742761567,42.7626534662,
	42.7510453398,42.7394517416,42.7278726355,42.7163079857,42.7047577566,
	42.6932219127,42.6817004185,42.6701932388,42.6587003383,42.6472216822,
	42.6357572354,42.6243069633,42.6128708311,42.6014488044,42.5900408488,
	42.57864693,42.5672670139,42.5559010665,42.5445490538,42.5332109421,
	42.5218866978,42.5105762873,42.4992796772,42.4879968343,42.4767277253,
	42.4654723173,42.4542305773,42.4430024724,42.4317879701,42.4205870377,
	42.4093996427,42.3982257529,42.3870653359,42.3759183598,42.3647847924,
	42.3536646019,42.3425577565,42.3314642245,42.3203839745,42.309316975,
	42.2982631946,42.2872226021,42.2761951665,42.2651808567,42.2541796418,
	42.2431914911,42.2322163739,42.2212542596,42.2103051178,42.1993689181,
	42.1884456302,42.1775352242,42.1666376698,42.1557529372,42.1448809965,
	42.1340218181,42.1231753722,42.1123416295,42.1015205604,42.0907121357,
	42.0799163261,42.0691331025,42.058362436,42.0476042976,42.0368586585,
	42.0261254899,42.0154047634,42.0046964503,41.9940005222,41.9833169508,
	41.972645708,41.9619867655,41.9513400953,41.9407056694,41.9300834602,
	41.9194734397,41.9088755803,41.8982898545,41.8877162349,41.8771546939,
	41.8666052044,41.8560677391,41.845542271,41.8350287731,41.8245272183,
	41.81403758,41.8035598313,41.7930939457,41.7826398964,41.7721976572,
	41.7617672016,41.7513485032,41.740941536,41.7305462738,41.7201626905,
	41.7097907601,41.699430457,41.6890817552,41.6787446291,41.668419053,
	41.6581050015,41.6478024491,41.6375113705,41.6272317404,41.6169635335,
	41.6067067249,41.5964612895,41.5862272023,41.5760044385,41.5657929734,
	41.5555927821,41.5454038401,41.535226123,41.5250596061,41.5149042652,
	41.5047600759,41.4946270141,41.4845050556,41.4743941762,41.4642943522,
	41.4542055595,41.4441277743,41.4340609729,41.4240051315,41.4139602267,
	41.4039262349,41.3939031326,41.3838908964,41.3738895031,41.3638989294,
	41.3539191523,41.3439501485,41.3339918952,41.3240443693,41.3141075481,
	41.3041814088,41.2942659286,41.2843610849,41.2744668552,41.2645832169,
	41.2547101477,41.2448476251,41.234995627,41.225154131,41.2153231151,
	41.2055025572,41.1956924352,41.1858927273,41.1761034116,41.1663244663,
	41.1565558696,41.1467976,41.1370496357,41.1273119554,41.1175845375,
	41.1078673606,41.0981604035,41.0884636448,41.0787770634,41.0691006382,
	41.059434348,41.049778172,41.0401320891,41.0304960786,41.0208701195,
	41.0112541912,41.0016482731,40.9920523444,40.9824663846,40.9728903734,
	40.9633242901,40.9537681146,40.9442218265,40.9346854055,40.9251588316,
	40.9156420845,40.9061351443,40.8966379909,40.8871506045,40.8776729651,
	40.868205053,40.8587468484,40.8492983317,40.8398594831,40.8304302833,
	40.8210107125,40.8116007515,40.8022003807,40.792809581,40.7834283329,
	40.7740566174,40.7646944152,40.7553417072,40.7459984744,40.7366646979,
	40.7273403586,40.7180254378,40.7087199165,40.6994237762,40.6901369979,
	40.6808595632,40.6715914533,40.6623326499,40.6530831343,40.6438428882,
	40.6346118932,40.625390131,40.6161775833,40.6069742319,40.5977800587,
	40.5885950455,40.5794191744,40.5702524272,40.5610947862,40.5519462333,
	40.5428067507,40.5336763208,40.5245549257,40.5154425477,40.5063391692,
	40.4972447727,40.4881593407,40.4790828555,40.4700152999,40.4609566565,
	40.4519069079,40.4428660369,40.4338340262,40.4248108587,40.4157965172,
	40.4067909847,40.3977942441,40.3888062786,40.3798270711,40.3708566047,
	40.3618948628,40.3529418284,40.3439974848,40.3350618154,40.3261348035,
	40.3172164326,40.3083066861,40.2994055475,40.2905130003,40.2816290283,
	40.2727536149,40.2638867439,40.2550283991,40.2461785643,40.2373372232,
	40.2285043598,40.219679958,40.2108640017,40.202056475,40.1932573619,
	40.1844666466,40.1756843131,40.1669103458,40.1581447288,40.1493874464,
	40.1406384829,40.1318978228,40.1231654504,40.1144413503,40.1057255068,
	40.0970179046
	}},
	{ // Ri = 250k
	-5,5,200,2001, {
	239.919843376,239.854937108,239.789738489,239.724247218,239.658462996,
	239.592385535,239.526014546,239.459349752,239.392390878,239.325137654,
	239.257589818,239.189747112,239.121609284,239.053176087,238.984447281,
	238.91542263,238.846101903,238.776484877,238.706571332,238.636361055,
	238.565853836,238.495049475,238.423947772,238.352548536,238.280851579,
	238.208856722,238.136563787,238.063972604,237.991083007,237.917894835,
	237.844407935,237.770622155,237.696537352,237.622153385,237.54747012,
	237.472487429,237.397205186,237.321623273,237.245741575,237.169559984,
	237.093078396,237.016296711,236.939214835,236.86183268,236.78415016,
	236.706167196,236.627883714,236.549299644,236.470414921,236.391229484,
	236.311743279,236.231956253,236.151868362,236.071479563,235.99078982,
	235.9097991,235.828507376,235.746914624,235.665020826,235.582825967,
	235.500330038,235.417533033,235.334434951,235.251035796,235.167335575,
	235.083334301,234.999031988,234.914428659,234.829524337,234.744319051,
	234.658812834,234.573005723,234.48689776,234.400488988,234.313779459,
	234.226769224,234.13945834,234.05184687,233.963934876,233.875722429,
	233.7872096,233.698396466,233.609283107,233.519869606,233.430156051,
	233.340142534,233.249829147,233.159215991,233.068303166,232.977090779,
	232.885578937,232.793767753,232.701657342,232.609247824,232.516539321,
	232.423531959,232.330225867,232.236621177,232.142718023,232.048516546,
	231.954016887,231.85921919,231.764123605,231.66873028,231.573039372,
	231.477051037,231.380765434,231.284182727,231.187303082,231.090126667,
	230.992653654,230.894884217,230.796818534,230.698456783,230.599799147,
	230.500845813,230.401596966,230.302052798,230.202213502,230.102079273,
	230.001650309,229.900926811,229.799908981,229.698597024,229.596991149,
	229.495091566,229.392898486,229.290412124,229.187632698,229.084560426,
	228.98119553,228.877538233,228.77358876,228.66934734,228.564814202,
	228.459989578,228.354873701,228.249466808,228.143769136,228.037780925,
	227.931502416,227.824933853,227.718075481,227.610927548,227.503490301,
	227.395763992,227.287748873,227.179445197,227.070853221,226.961973202,
	226.852805398,226.743350071,226.633607482,226.523577894,226.413261574,
	226.302658786,226.1917698,226.080594885,225.969134311,225.857388351,
	225.745357278,225.633041366,225.520440893,225.407556135,225.294387371,
	225.180934881,225.067198945,224.953179846,224.838877868,224.724293293,
	224.609426409,224.494277501,224.378846857,224.263134765,224.147141516,
	224.030867399,223.914312706,223.79747773,223.680362764,223.562968102,
	223.445294038,223.32734087,223.209108892,223.090598404,222.971809703,
	222.852743088,222.733398858,222.613777314,222.493878757,222.373703489,
	222.253251812,222.132524028,222.011520442,221.890241357,221.768687078,
	221.64685791,221.524754159,221.402376131,221.279724132,221.15679847,
	221.033599452,220.910127386,220.78638258,220.662365343,220.538075983,
	220.413514811,220.288682136,220.163578268,220.038203517,219.912558193,
	219.786642608,219.660457072,219.534001897,219.407277394,219.280283874,
	219.15302165,219.025491033,218.897692335,218.769625868,218.641291945,
	218.512690877,218.383822977,218.254688558,218.125287932,217.995621411,
	217.865689308,217.735491935,217.605029605,217.47430263,217.343311321,
	217.212055993,217.080536955,216.948754521,216.816709003,216.684400712,
	216.551829959,216.418997057,216.285902317,216.152546049,216.018928564,
	215.885050174,215.750911189,215.616511919,215.481852673,215.346933762,
	215.211755495,215.076318182,214.94062213,214.804667649,214.668455047,
	214.531984632,214.395256711,214.258271591,214.121029579,213.983530982,
	213.845776106,213.707765256,213.569498737,213.430976855,213.292199913,
	213.153168215,213.013882066,212.874341767,212.734547621,212.594499931,
	212.454198998,212.313645123,212.172838605,212.031779747,211.890468845,
	211.748906201,211.607092111,211.465026874,211.322710786,211.180144146,
	211.037327247,210.894260386,210.750943858,210.607377956,210.463562975,
	210.319499207,210.175186945,210.03062648,209.885818102,209.740762104,
	209.595458773,209.449908399,209.304111271,209.158067675,209.011777899,
	208.865242229,208.71846095,208.571434346,208.424162703,208.276646303,
	208.128885429,207.980880362,207.832631383,207.684138772,207.53540281,
	207.386423774,207.237201943,207.087737593,206.938031001,206.788082442,
	206.637892192,206.487460523,206.336787708,206.185874021,206.034719732,
	205.883325112,205.73169043,205.579815956,205.427701956,205.2753487,
	205.122756451,204.969925477,204.816856041,204.663548407,204.510002838,
	204.356219596,204.202198941,204.047941133,203.893446432,203.738715096,
	203.583747382,203.428543546,203.273103844,203.11742853,202.961517859,
	202.805372081,202.64899145,202.492376216,202.335526629,202.178442938,
	202.021125389,201.863574231,201.70578971,201.547772069,201.389521554,
	201.231038407,201.072322871,200.913375185,200.754195591,200.594784328,
	200.435141633,200.275267743,200.115162895,199.954827324,199.794261263,
	199.633464946,199.472438604,199.31118247,199.149696771,198.987981739,
	198.826037599,198.66386458,198.501462908,198.338832806,198.175974498,
	198.012888208,197.849574157,197.686032566,197.522263653,197.358267639,
	197.194044739,197.029595171,196.864919149,196.700016888,196.534888602,
	196.369534501,196.203954798,196.038149702,195.872119422,195.705864166,
	195.53938414,195.372679551,195.205750602,195.038597496,194.871220438,
	194.703619627,194.535795263,194.367747547,194.199476675,194.030982844,
	193.862266251,193.69332709,193.524165554,193.354781836,193.185176127,
	193.015348617,192.845299495,192.675028949,192.504537166,192.333824332,
	192.162890631,191.991736246,191.820361361,191.648766155,191.476950809,
	191.304915502,191.132660411,190.960185714,190.787491586,190.6145782,
	190.441445731,190.268094349,190.094524227,189.920735533,189.746728437,
	189.572503106,189.398059705,189.223398401,189.048519357,188.873422736,
	188.698108699,188.522577407,188.34682902,188.170863695,187.994681589,
	187.818282858,187.641667658,187.46483614,187.287788459,187.110524763,
	186.933045205,186.755349932,186.577439092,186.399312831,186.220971295,
	186.042414627,185.863642971,185.684656468,185.505455258,185.326039482,
	185.146409276,184.966564778,184.786506124,184.606233447,184.425746882,
	184.245046561,184.064132614,183.883005171,183.70166436,183.52011031,
	183.338343145,183.156362991,182.974169972,182.79176421,182.609145826,
	182.426314941,182.243271672,182.060016139,181.876548456,181.69286874,
	181.508977105,181.324873662,181.140558524,180.956031801,180.771293602,
	180.586344035,180.401183206,180.215811221,180.030228184,179.844434198,
	179.658429365,179.472213784,179.285787556,179.099150778,178.912303547,
	178.725245958,178.537978106,178.350500084,178.162811983,177.974913895,
	177.786805907,177.598488109,177.409960587,177.221223426,177.032276711,
	176.843120525,176.653754949,176.464180064,176.274395949,176.084402683,
	175.894200341,175.703788999,175.513168732,175.322339612,175.131301711,
	174.940055099,174.748599845,174.556936017,174.365063682,174.172982904,
	173.980693748,173.788196276,173.59549055,173.402576629,173.209454574,
	173.01612444,172.822586284,172.628840161,172.434886125,172.240724228,
	172.046354521,171.851777054,171.656991875,171.461999032,171.266798569,
	171.071390532,170.875774963,170.679951906,170.483921399,170.287683483,
	170.091238194,169.894585571,169.697725648,169.500658458,169.303384036,
	169.105902411,168.908213614,168.710317673,168.512214616,168.313904469,
	168.115387256,167.916663,167.717731724,167.518593448,167.31924819,
	167.11969597,166.919936804,166.719970706,166.51979769,166.319417769,
	166.118830954,165.918037255,165.71703668,165.515829236,165.314414928,
	165.112793761,164.910965738,164.70893086,164.506689127,164.304240538,
	164.10158509,163.898722779,163.6956536,163.492377545,163.288894608,
	163.085204777,162.881308042,162.677204391,162.472893809,162.268376282,
	162.063651792,161.858720322,161.653581853,161.448236362,161.242683829,
	161.036924229,160.830957537,160.624783727,160.41840277,160.211814637,
	160.005019298,159.79801672,159.590806869,159.38338971,159.175765206,
	158.967933321,158.759894013,158.551647242,158.343192966,158.134531141,
	157.925661722,157.716584662,157.507299912,157.297807424,157.088107145,
	156.878199025,156.668083008,156.457759039,156.247227061,156.036487016,
	155.825538844,155.614382484,155.403017872,155.191444946,154.979663638,
	154.767673882,154.55547561,154.34306875,154.130453232,153.917628982,
	153.704595926,153.491353989,153.277903091,153.064243155,152.850374101,
	152.636295846,152.422008306,152.207511398,151.992805035,151.777889129,
	151.562763591,151.347428331,151.131883256,150.916128273,150.700163287,
	150.483988202,150.267602919,150.051007339,149.834201362,149.617184885,
	149.399957805,149.182520017,148.964871415,148.74701189,148.528941333,
	148.310659634,148.092166681,147.873462361,147.654546557,147.435419156,
	147.216080038,146.996529086,146.776766179,146.556791196,146.336604013,
	146.116204508,145.895592554,145.674768025,145.453730794,145.23248073,
	145.011017705,144.789341586,144.56745224,144.345349535,144.123033334,
	143.900503503,143.677759903,143.454802397,143.231630845,143.008245106,
	142.784645041,142.560830506,142.336801358,142.112557454,141.888098647,
	141.663424793,141.438535745,141.213431356,140.988111477,140.76257596,
	140.536824656,140.310857414,140.084674085,139.858274517,139.631658559,
	139.40482606,139.177776866,138.950510827,138.72302779,138.495327601,
	138.267410109,138.039275161,137.810922605,137.582352287,137.353564057,
	137.124557761,136.89533325,136.665890372,136.436228977,136.206348916,
	135.976250041,135.745932202,135.515395255,135.284639054,135.053663455,
	134.822468314,134.591053492,134.359418849,134.127564247,133.895489551,
	133.663194629,133.430679348,133.197943581,132.964987203,132.73181009,
	132.498412124,132.264793187,132.030953168,131.796891958,131.562609451,
	131.328105548,131.093380151,130.85843317,130.623264518,130.387874115,
	130.152261884,129.916427758,129.680371672,129.444093571,129.207593404,
	128.970871129,128.733926713,128.496760129,128.259371358,128.021760393,
	127.783927234,127.545871891,127.307594385,127.069094748,126.830373023,
	126.591429265,126.352263542,126.112875935,125.873266537,125.633435457,
	125.393382821,125.153108766,124.91261345,124.671897045,124.430959742,
	124.189801752,123.948423304,123.706824648,123.465006057,123.222967823,
	122.980710263,122.738233721,122.495538562,122.252625181,122.009493998,
	121.766145463,121.522580057,121.278798292,121.034800711,120.790587894,
	120.546160453,120.30151904,120.056664344,119.811597095,119.566318064,
	119.320828067,119.075127963,118.82921866,118.583101115,118.336776335,
	118.090245381,117.84350937,117.596569475,117.349426929,117.102083029,
	116.854539134,116.606796673,116.358857143,116.110722114,115.862393231,
	115.613872218,115.365160881,115.116261108,114.867174879,114.61790426,
	114.368451414,114.118818604,113.86900819,113.619022642,113.368864537,
	113.118536565,112.868041535,112.617382378,112.366562149,112.115584036,
	111.864451361,111.613167587,111.361736321,111.11016132,110.858446499,
	110.60659593,110.354613852,110.102504677,109.850272992,109.597923569,
	109.345461366,109.09289154,108.840219447,108.587450649,108.334590925,
	108.081646272,107.828622915,107.575527312,107.322366164,107.069146415,
	106.815875267,106.562560181,106.309208889,106.055829395,105.802429989,
	105.549019247,105.295606044,105.042199559,104.78880928,104.535445014,
	104.282116893,104.028835379,103.775611272,103.522455718,103.26938021,
	103.016396602,102.763517107,102.510754307,102.258121157,102.00563099,
	101.75329752,101.501134848,101.249157464,100.997380252,100.74581849,
	100.494487852,100.243404412,99.9925846399,99.7420454065,99.4918039784,
	99.2418780182,98.992285581,98.7430451111,98.4941754376,98.2456957684,
	97.9976256841,97.7499851301,97.5027944079,97.2560741654,97.0098453854,
	96.764129374,96.5189477467,96.2743224139,96.030275565,95.7868296514,
	95.5440073677,95.3018316327,95.0603255681,94.8195124769,94.5794158196,
	94.3400591904,94.1014662917,93.8636609074,93.6266668754,93.3905080596,
	93.1552083202,92.9207914838,92.687281313,92.4547014744,92.2230755076,
	91.9924267924,91.7627785162,91.5341536421,91.3065748752,91.0800646308,
	90.8546450013,90.6303377244,90.4071641513,90.1851452154,89.9643014023,
	89.7446527197,89.5262186689,89.309018217,89.0930697707,88.8783911506,
	88.6649995678,88.452911601,88.2421431758,88.0327095454,87.8246252726,
	87.6179042144,87.4125595073,87.2086035549,87.0060480178,86.8049038042,
	86.6051810635,86.4068891809,86.2100367742,86.0146316924,85.820681016,
	85.6281910588,85.4371673718,85.2476147483,85.059537231,84.8729381203,
	84.6878199835,84.5041846669,84.3220333071,84.1413663453,83.9621835415,
	83.78448399,83.6082661365,83.4335277947,83.2602661648,83.088477852,
	82.918158886,82.7493047404,82.581910353,82.4159701465,82.2514780484,
	82.0884275127,81.9268115401,81.7666226995,81.6078531484,81.450494654,
	81.2945386136,81.1399760753,80.9867977578,80.8349940706,80.6845551334,
	80.5354707951,80.387730653,80.2413240706,80.0962401958,79.9524679782,
	79.8099961858,79.668813422,79.5289081407,79.3902686621,79.2528831875,
	79.1167398133,78.9818265451,78.8481313104,78.7156419717,78.5843463383,
	78.4542321781,78.3252872283,78.1974992063,78.0708558196,77.9453447751,
	77.8209537885,77.6976705926,77.5754829453,77.4543786377,77.3343455008,
	77.2153714125,77.097444304,76.9805521656,76.8646830525,76.7498250897,
	76.6359664772,76.5230954944,76.411200504,76.3002699564,76.1902923926,
	76.081256448,75.9731508553,75.865964447,75.7596861581,75.6543050282,
	75.5498102036,75.446190939,75.3434365993,75.2415366608,75.1404807122,
	75.0402584562,74.94085971,74.8422744057,74.7444925918,74.6475044324,
	74.5513002088,74.4558703183,74.3612052756,74.2672957116,74.1741323741,
	74.0817061269,73.9900079501,73.8990289392,73.8087603045,73.7191933711,
	73.630319578,73.542130477,73.4546177327,73.3677731209,73.2815885286,
	73.1960559524,73.1111674979,73.0269153786,72.943291915,72.8602895336,
	72.7779007657,72.6961182464,72.6149347136,72.5343430066,72.4543360653,
	72.3749069287,72.296048734,72.2177547155,72.140018203,72.062832621,
	71.9861914875,71.9100884125,71.834517097,71.7594713319,71.6849449967,
	71.6109320582,71.5374265695,71.4644226687,71.3919145776,71.3198966008,
	71.2483631244,71.1773086147,71.1067276173,71.0366147558,70.9669647305,
	70.8977723176,70.829032368,70.7607398058,70.692889628,70.6254769025,
	70.5584967677,70.491944431,70.4258151681,70.3601043217,70.2948073007,
	70.2299195789,70.1654366943,70.1013542477,70.0376679022,69.974373382,
	69.9114664714,69.848943014,69.7867989115,69.7250301233,69.663632665,
	69.6026026079,69.5419360781,69.4816292553,69.4216783727,69.3620797151,
	69.302829619,69.2439244713,69.1853607088,69.127134817,69.0692433298,
	69.0116828285,68.9544499408,68.8975413407,68.8409537471,68.7846839236,
	68.7287286773,68.6730848588,68.6177493608,68.5627191177,68.5079911053,
	68.4535623394,68.399429876,68.3455908099,68.2920422747,68.238781442,
	68.1858055204,68.1331117557,68.0806974294,68.0285598591,67.9766963971,
	67.9251044304,67.8737813799,67.8227247,67.7719318779,67.7214004334,
	67.671127918,67.6211119148,67.5713500377,67.521839931,67.4725792692,
	67.4235657562,67.3747971248,67.3262711367,67.2779855816,67.2299382769,
	67.1821270675,67.1345498251,67.0872044479,67.0400888603,66.9932010121,
	66.9465388788,66.9001004606,66.8538837821,66.8078868926,66.7621078646,
	66.7165447945,66.6711958016,66.626059028,66.5811326384,66.5364148192,
	66.491903779,66.4475977476,66.4034949759,66.3595937358,66.3158923195,
	66.2723890395,66.2290822282,66.1859702377,66.1430514394,66.1003242235,
	66.0577869994,66.0154381946,65.9732762552,65.9312996451,65.8895068457,
	65.8478963563,65.806466693,65.7652163892,65.7241439947,65.6832480761,
	65.642527216,65.6019800131,65.5616050819,65.5214010526,65.4813665705,
	65.4415002962,65.4018009052,65.3622670877,65.3228975484,65.2836910063,
	65.2446461946,65.2057618602,65.1670367641,65.1284696804,65.0900593968,
	65.0518047142,65.0137044463,64.9757574197,64.9379624738,64.9003184602,
	64.8628242429,64.825478698,64.7882807137,64.7512291898,64.7143230378,
	64.6775611809,64.6409425534,64.6044661009,64.5681307798,64.5319355578,
	64.4958794131,64.4599613344,64.4241803212,64.388535383,64.3530255396,
	64.317649821,64.282407267,64.2472969272,64.2123178609,64.1774691369,
	64.1427498335,64.1081590383,64.0736958481,64.0393593686,64.0051487146,
	63.9710630098,63.9371013865,63.9032629857,63.8695469568,63.8359524576,
	63.8024786545,63.7691247216,63.7358898415,63.7027732045,63.669774009,
	63.636891461,63.6041247743,63.5714731704,63.5389358781,63.5065121337,
	63.4742011808,63.4420022703,63.4099146602,63.3779376154,63.3460704081,
	63.3143123171,63.2826626281,63.2511206336,63.2196856325,63.1883569306,
	63.1571338399,63.1260156789,63.0950017724,63.0640914515,63.0332840535,
	63.0025789217,62.9719754055,62.9414728602,62.9110706472,62.8807681334,
	62.8505646917,62.8204597006,62.7904525442,62.7605426122,62.7307292997,
	62.7010120074,62.6713901411,62.6418631122,62.6124303372,62.5830912378,
	62.5538452407,62.5246917779,62.4956302862,62.4666602075,62.4377809884,
	62.4089920806,62.3802929404,62.3516830289,62.3231618119,62.2947287596,
	62.2663833472,62.238125054,62.2099533641,62.1818677657,62.1538677518,
	62.1259528192,62.0981224695,62.0703762081,62.0427135449,62.0151339937,
	61.9876370727,61.9602223038,61.9328892131,61.9056373307,61.8784661904,
	61.8513753301,61.8243642916,61.7974326202,61.7705798651,61.7438055793,
	61.7171093194,61.6904906456,61.6639491218,61.6374843153,61.6110957971,
	61.5847831416,61.5585459265,61.5323837333,61.5062961465,61.4802827541,
	61.4543431474,61.4284769208,61.4026836724,61.376963003,61.3513145168,
	61.3257378211,61.3002325264,61.2747982461,61.2494345967,61.2241411979,
	61.1989176721,61.1737636448,61.1486787445,61.1236626024,61.0987148526,
	61.0738351323,61.049023081,61.0242783416,60.9996005592,60.9749893819,
	60.9504444605,60.9259654483,60.9015520014,60.8772037785,60.8529204409,
	60.8287016523,60.8045470791,60.7804563903,60.7564292571,60.7324653534,
	60.7085643554,60.6847259419,60.660949794,60.637235595,60.6135830308,
	60.5899917896,60.5664615617,60.5429920399,60.5195829191,60.4962338965,
	60.4729446717,60.4497149461,60.4265444237,60.4034328102,60.3803798139,
	60.357385145,60.3344485156,60.3115696402,60.2887482352,60.2659840191,
	60.2432767122,60.2206260372,60.1980317183,60.1754934821,60.1530110568,
	60.1305841728,60.1082125622,60.0858959592,60.0636340995,60.041426721,
	60.0192735634,59.9971743681,59.9751288783,59.9531368392,59.9311979974,
	59.9093121016,59.8874789021,59.865698151,59.8439696018,59.8222930102,
	59.8006681332,59.7790947295,59.7575725597,59.7361013857,59.7146809713,
	59.6933110816,59.6719914837,59.6507219459,59.6295022382,59.6083321322,
	59.587211401,59.5661398192,59.5451171629,59.5241432098,59.5032177389,
	59.4823405308,59.4615113675,59.4407300325,59.4199963107,59.3993099884,
	59.3786708534,59.3580786947,59.3375333029,59.3170344698,59.2965819887,
	59.2761756541,59.2558152619,59.2355006095,59.2152314953,59.1950077192,
	59.1748290824,59.1546953873,59.1346064375,59.1145620381,59.0945619952,
	59.0746061163,59.05469421,59.0348260863,59.0150015562,58.9952204321,
	58.9754825273,58.9557876566,58.9361356358,58.9165262819,58.896959413,
	58.8774348483,58.8579524084,58.8385119146,58.8191131897,58.7997560573,
	58.7804403424,58.7611658707,58.7419324694,58.7227399664,58.7035881909,
	58.684476973,58.665406144,58.6463755361,58.6273849825,58.6084343176,
	58.5895233766,58.5706519958,58.5518200125,58.533027265,58.5142735925,
	58.4955588353,58.4768828345,58.4582454322,58.4396464715,58.4210857965,
	58.402563252,58.384078684,58.3656319393,58.3472228655,58.3288513112,
	58.310517126,58.2922201602,58.2739602651,58.2557372929,58.2375510965,
	58.2194015299,58.2012884478,58.1832117056,58.16517116,58.1471666681,
	58.129198088,58.1112652786,58.0933680997,58.0755064118,58.0576800761,
	58.039888955,58.0221329113,58.0044118086,57.9867255116,57.9690738855,
	57.9514567963,57.9338741109,57.9163256968,57.8988114223,57.8813311564,
	57.8638847691,57.8464721308,57.8290931127,57.8117475869,57.7944354261,
	57.7771565037,57.7599106939,57.7426978714,57.7255179118,57.7083706914,
	57.691256087,57.6741739762,57.6571242374,57.6401067494,57.6231213918,
	57.6061680451,57.58924659,57.5723569081,57.5554988818,57.5386723939,
	57.5218773279,57.505113568,57.488380999,57.4716795062,57.4550089757,
	57.4383692942,57.4217603489,57.4051820278,57.3886342192,57.3721168123,
	57.3556296967,57.3391727627,57.3227459011,57.3063490034,57.2899819617,
	57.2736446684,57.2573370167,57.2410589004,57.2248102138,57.2085908517,
	57.1924007095,57.1762396831,57.1601076691,57.1440045645,57.127930267,
	57.1118846745,57.0958676858,57.0798792,57.063919117,57.0479873368,
	57.0320837602,57.0162082886,57.0003608236,56.9845412676,56.9687495233,
	56.952985494,56.9372490836,56.9215401962,56.9058587367,56.8902046103,
	56.8745777228,56.8589779803,56.8434052895,56.8278595578,56.8123406926,
	56.796848602,56.7813831948,56.7659443798,56.7505320667,56.7351461652,
	56.719786586,56.7044532397,56.6891460378,56.6738648919,56.6586097143,
	56.6433804175,56.6281769146,56.6129991191,56.597846945,56.5827203065,
	56.5676191185,56.5525432961,56.537492755,56.5224674112,56.507467181,
	56.4924919814,56.4775417297,56.4626163434,56.4477157406,56.4328398399,
	56.41798856,56.4031618202,56.3883595402,56.37358164,56.35882804,
	56.3440986611,56.3293934243,56.3147122514,56.3000550642,56.2854217851,
	56.2708123367,56.2562266421,56.2416646249,56.2271262086,56.2126113176,
	56.1981198764,56.1836518097,56.1692070429,56.1547855016,56.1403871117,
	56.1260117995,56.1116594916,56.097330115,56.0830235971,56.0687398656,
	56.0544788483,56.0402404738,56.0260246706,56.0118313678,55.9976604948,
	55.9835119812,55.969385757,55.9552817525,55.9411998985,55.9271401258,
	55.9131023657,55.89908655,55.8850926104,55.8711204792,55.8571700891,
	55.8432413727,55.8293342633,55.8154486945,55.8015845998,55.7877419134,
	55.7739205698,55.7601205035,55.7463416495,55.7325839431,55.7188473199,
	55.7051317156,55.6914370665,55.677763309,55.6641103798,55.6504782158,
	55.6368667544,55.6232759331,55.6097056897,55.5961559624,55.5826266896,
	55.5691178099,55.5556292623,55.542160986,55.5287129205,55.5152850055,
	55.501877181,55.4884893873,55.475121565,55.4617736549,55.448445598,
	55.4351373357,55.4218488095,55.4085799613,55.3953307332,55.3821010675,
	55.3688909069,55.3557001941,55.3425288723,55.3293768848,55.3162441752,
	55.3031306873,55.2900363653,55.2769611534,55.2639049962,55.2508678385,
	55.2378496253,55.2248503018,55.2118698137,55.1989081067,55.1859651266,
	55.1730408198,55.1601351326,55.1472480117,55.134379404,55.1215292566,
	55.1086975168,55.0958841322,55.0830890507,55.0703122201,55.0575535887,
	55.0448131049,55.0320907175,55.0193863752,55.0067000272,54.9940316227,
	54.9813811114,54.9687484428,54.956133567,54.943536434,54.9309569943,
	54.9183951983,54.9058509969,54.893324341,54.8808151818,54.8683234706,
	54.8558491591,54.8433921989,54.8309525421,54.8185301409,54.8061249475,
	54.7937369146,54.7813659949,54.7690121413,54.7566753071,54.7443554455,
	54.73205251,54.7197664544,54.7074972325,54.6952447985,54.6830091066,
	54.6707901112,54.6585877671,54.646402029,54.634232852,54.6220801911,
	54.6099440019,54.5978242398,54.5857208606,54.5736338202,54.5615630746,
	54.5495085801,54.5374702932,54.5254481704,54.5134421685,54.5014522444,
	54.4894783554,54.4775204586,54.4655785116,54.4536524719,54.4417422974,
	54.429847946,54.4179693758,54.4061065451,54.3942594124,54.3824279364,
	54.3706120757,54.3588117893,54.3470270364,54.3352577761,54.323503968,
	54.3117655715,54.3000425465,54.2883348527,54.2766424504,54.2649652996,
	54.2533033607,54.2416565943,54.2300249609,54.2184084215,54.206806937,
	54.1952204684,54.1836489771,54.1720924245,54.1605507722,54.1490239817,
	54.1375120151,54.1260148343,54.1145324014,54.1030646788,54.0916116288,
	54.0801732141,54.0687493974,54.0573401415,54.0459454094,54.0345651643,
	54.0231993694,54.0118479883,54.0005109843,53.9891883213,53.977879963,
	53.9665858734,53.9553060167,53.944040357,53.9327888587,53.9215514863,
	53.9103282045,53.8991189781,53.8879237718,53.8767425508,53.8655752802,
	53.8544219253,53.8432824515,53.8321568244,53.8210450096,53.8099469729,
	53.7988626803,53.7877920977,53.7767351915,53.7656919278,53.7546622731,
	53.7436461939,53.7326436569,53.721654629,53.7106790769,53.6997169678,
	53.6887682688,53.6778329471,53.6669109702,53.6560023055,53.6451069207,
	53.6342247836,53.6233558619,53.6125001237,53.6016575371,53.5908280702,
	53.5800116914,53.5692083692,53.558418072,53.5476407686,53.5368764276,
	53.5261250181,53.5153865089,53.5046608693,53.4939480683,53.4832480754,
	53.47256086,53.4618863916,53.4512246399,53.4405755746,53.4299391657,
	53.419315383,53.4087041967,53.398105577,53.3875194941,53.3769459184,
	53.3663848205,53.355836171,53.3452999404,53.3347760998,53.3242646199,
	53.3137654719,53.3032786267,53.2928040557,53.2823417301,53.2718916214,
	53.261453701,53.2510279406,53.240614312,53.2302127868,53.2198233371,
	53.2094459348,53.1990805521,53.1887271611,53.1783857341,53.1680562435,
	53.1577386619,53.1474329617,53.1371391157,53.1268570966,53.1165868773,
	53.1063284308,53.09608173,53.0858467482,53.0756234586,53.0654118344,
	53.0552118491,53.0450234762,53.0348466893,53.0246814621,53.0145277683,
	53.0043855819,52.9942548766,52.9841356267,52.9740278062,52.9639313893,
	52.9538463503,52.9437726636,52.9337103037,52.9236592451,52.9136194624,
	52.9035909305,52.8935736241,52.883567518,52.8735725874,52.8635888072,
	52.8536161525,52.8436545987,52.833704121,52.8237646948,52.8138362956,
	52.8039188989,52.7940124804,52.7841170158,52.7742324808,52.7643588514,
	52.7544961035,52.7446442132,52.7348031565,52.7249729097,52.7151534489,
	52.7053447507,52.6955467913,52.6857595473,52.6759829952,52.6662171118,
	52.6564618738,52.6467172578,52.636983241,52.6272598001,52.6175469122,
	52.6078445544,52.598152704,52.5884713381,52.5788004341,52.5691399694,
	52.5594899214,52.5498502678,52.5402209861,52.5306020539,52.5209934492,
	52.5113951496,52.5018071332,52.4922293778,52.4826618616,52.4731045626,
	52.463557459,52.4540205291,52.4444937512,52.4349771037,52.425470565,
	52.4159741138,52.4064877284,52.3970113878,52.3875450705,52.3780887554,
	52.3686424213,52.3592060472,52.3497796121,52.340363095,52.3309564751,
	52.3215597316,52.3121728436,52.3027957907,52.293428552,52.2840711072,
	52.2747234357,52.2653855171,52.2560573311,52.2467388573,52.2374300756,
	52.2281309658,52.2188415077,52.2095616814,52.2002914668,52.1910308441,
	52.1817797934,52.1725382949,52.1633063289,52.1540838757,52.1448709156,
	52.1356674293,52.1264733971,52.1172887997,52.1081136176,52.0989478315,
	52.0897914223,52.0806443707,52.0715066576,52.0623782639,52.0532591707,
	52.0441493588,52.0350488095,52.0259575039,52.0168754232,52.0078025486,
	51.9987388616,51.9896843435,51.9806389757,51.9716027398,51.9625756172,
	51.9535575896,51.9445486387,51.9355487462,51.9265578938,51.9175760635,
	51.908603237,51.8996393962,51.8906845233,51.8817386003,51.8728016091,
	51.8638735321,51.8549543514,51.8460440492,51.8371426079,51.8282500099,
	51.8193662375,51.8104912732,51.8016250996,51.7927676992,51.7839190547,
	51.7750791486,51.7662479639,51.7574254831,51.7486116892,51.7398065651,
	51.7310100936,51.7222222578,51.7134430406,51.7046724253,51.6959103948,
	51.6871569323,51.6784120212,51.6696756447,51.660947786,51.6522284287,
	51.643517556,51.6348151515,51.6261211987,51.6174356812,51.6087585825,
	51.6000898864,51.5914295766,51.5827776367,51.5741340507,51.5654988023,
	51.5568718755,51.5482532542,51.5396429225,51.5310408642,51.5224470636,
	51.5138615047,51.5052841718,51.496715049,51.4881541206,51.4796013709,
	51.4710567843,51.4625203452,51.453992038,51.4454718472,51.4369597573,
	51.428455753,51.4199598188,51.4114719394,51.4029920995,51.3945202839,
	51.3860564773,51.3776006646,51.3691528308,51.3607129606,51.352281039,
	51.3438570512,51.3354409821,51.3270328167,51.3186325404,51.3102401382,
	51.3018555953,51.293478897,51.2851100286,51.2767489755,51.268395723,
	51.2600502566,51.2517125617,51.2433826238,51.2350604285,51.2267459613,
	51.218439208,51.210140154,51.2018487853,51.1935650874,51.1852890462,
	51.1770206476,51.1687598773,51.1605067213,51.1522611655,51.1440231959,
	51.1357927985,51.1275699594,51.1193546647,51.1111469005,51.1029466529,
	51.0947539083,51.0865686527,51.0783908726,51.0702205543,51.062057684,
	51.0539022483,51.0457542335,51.0376136261,51.0294804127,51.0213545797,
	51.0132361137
	}}
};
