/* gupsc - A GNOME client for the Network UPS Tools package (nut-0.42.1)

   Copyright (C) 2000  Henning Kulander <hennikul@ifi.uio.no>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <unistd.h>

#include "interface.h"
#include "support.h"
#include "ups_canvas.h"
#include "ups_fetch.h"
#include "dial.h"
#include "ups_dials.h"
#include "preferences.h"
	
GtkWidget *gupsc;
	
/* Excecution starts here */
int
main (int argc, char *argv[])
{
	GtkWidget *canvas;
	char *ups = NULL;
	gchar *tmpstr;
	poptContext optCon;
	
	/* Parameter options: */
	struct poptOption optionsTable[] = {
		{ "ups", 'u', POPT_ARG_STRING, &ups, 0,
		  "Alias of UPS to use (if you want to monitor more than one UPS)",
		  "UPS" },
		{ NULL, 0, 0, NULL, 0 }
	};

#ifdef ENABLE_NLS
	bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
	textdomain (PACKAGE);
#endif

	gnome_init_with_popt_table ("gupsc", VERSION, argc, argv, 
				    optionsTable, 0, &optCon);
  
	if (ups) {/* The user has chosen a nodefault UPS */
		printf ("UPS: %s\n", ups);
		global_session_set ( ups );
	} else {
		global_session_set ("default");
	}

	/*
	 * The following code was added by Glade to create one of each 
	 * component (except popup menus), just so that you see 
	 * something after building the project. Delete any components 
	 * that you don't want shown initially.
	 */

	gupsc = create_gupsc ();
	global_window_set (gupsc);
	gtk_widget_show (gupsc);

	/* Initialize the structures keeping track of dial types */
	ups_make_dial_types ();
	
	/* Initialize battery canvas */
	canvas = lookup_widget (gupsc, "canvas_ups");
	tmpstr = preferences_get_string_variable ("/gupsc/%s/dialfont=-adobe-helvetica-medium-r-normal-*-*-100-*-*-p-*-iso8859-1");
	ups_canvas_init (canvas, tmpstr);  
	g_free (tmpstr);
 
	/* Read configuration files */
	make_thread ();
	preferences_infodials_clear ();
	preferences_load (gupsc); 
	
	/* Initialize timeout */
	gtk_main (); 

	return 0;
}

