/***************************************************************************
                          ftpsitedlg.cpp  -  description
                             -------------------
    begin                : Tue Jul 25 2000
    copyright            : (C) 2000 by llornkcor
    email                : ljp@llornkcor.com
 ***************************************************************************/
/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "optionsDialog.h"
#include "gutenbrowser.h"
#include "NetworkDialog.h"
#include "CConfigFile.h"

#include <qprogressbar.h>
#include <qlistview.h>
#include <stdlib.h>
#include <qurloperator.h>

#if defined(Q_WS_WIN)
#include <windows.h>
#endif

void optionsDialog::ftpSiteDlg( ) {
    ListFile = ( QDir::homeDirPath ()) +"/.gutenbrowser/MIRRORS.ALL";
 //   qDebug( "ftpSiteDlg: ListFile is "+ ListFile);

    QFile f(ListFile);
    if( f.exists() ) {
        openSiteList();
    } else {
        qDebug("Local ftp mirror list file does not exist");
        getSite();
        openSiteList();
    }
}

/*
// get ftp list from web- parse it. */
void optionsDialog::getSite() {
    //   qDebug("get site");
    QString file_name;
    QString ftp_listFileURL;
    QString outputFile;
    outputFile = local_library + "MIRRORS.ALL";
    outputFile = ListFile;

    QString networkUrl = "http://www.gutenberg.org/MIRRORS.ALL";

#if QT_VERSION <= 300

    QString cmd ="wget -T 15 -O " +outputFile + " " + networkUrl;// + " 2>&1" ;
    qDebug( "Issuing the command "+cmd );
    FILE *fp;
    char line[130];
    sleep(1);
    fp = popen(  (const char *) cmd, "r");
    while ( fgets( line, sizeof line, fp)) {}
    pclose(fp);
    outputFile = ListFile;
#else

   QStringList networkList;
   networkList.append((const char *)networkUrl); //host
   networkList.append("/"); //ftp base directory
   networkList.append((const char *)outputFile); //output filepath
   networkList.append("MIRRORS.ALL"); //filename

   NetworkDialog *NetworkDlg;
   NetworkDlg = new NetworkDialog( this,"Network Protocol Dialog", true, 0, networkList);
//    NetworkDlg = new NetworkDialog( this,"Network Protocol Dialog", true, 0, networkUrl, outputFile);
    if( NetworkDlg->exec() == 0 ) {
        QMessageBox::message( "Error","BLEH");
    } else {
        outputFile = ListFile;
    }
#endif
}

void optionsDialog::openSiteList() {// just opens the ftp site list
    ListFile = ( QDir::homeDirPath ()) +"/.gutenbrowser/MIRRORS.ALL";
    ftp_QListBox_1->clear();
    QFile f( ListFile);
    if(f.exists() ) {
        if(!f.open( IO_ReadWrite ))  {
            QMessageBox::message( (tr("Note")), (tr("File not opened sucessfully." )) );
        } else {
            QListViewItem * QList_Item;
            QStringList siteStringList;
            int index = 0;
            QTextStream t( &f);
            while ( !t.atEnd() ) {
                //   continent | nation | location | provider | url  |  note
                QString s = t.readLine();
                if(index > 1 && !s.isEmpty() && s.left(1) != "(" ) { //ignore the first two lines
                    siteStringList = QStringList::split( '|', s, true );

                    QString continent = siteStringList[0];
                    QString nation = siteStringList[1];
                    QString location = siteStringList[2];
                    QString provider = siteStringList[3];
                    QString url = siteStringList[4];
//                    qDebug(url);
                    QString note = siteStringList[5];

                    continent = continent.stripWhiteSpace();
                    nation = nation.stripWhiteSpace();
                    location = location.stripWhiteSpace();
                    provider = provider.stripWhiteSpace();
                    url = url.stripWhiteSpace();
                    note = note.stripWhiteSpace();

                    if(url.left(3) == "ftp" ) {
                        url = url.right(url.length()-6);
                        QList_Item = new QListViewItem( ftp_QListBox_1,  continent, nation, location, provider, url, note );
                    }
                }
                index++;
            } // end while loop
            f.close();
//            qDebug("closed list");
        }
    } else
        qDebug("List does not exist");
}

/*
List box clicked */
void optionsDialog::getSelection(QListViewItem *item) {
    QString selctionStr;
    selctionStr = item->text(4);
    select_site( selctionStr);
}

void optionsDialog::select_site( const char *index ) {
    //   ftp://ftp.datacanyon.com/pub/gutenberg/
    s_site = index;
    qDebug( "Selected site is "+ s_site );

    int i_ftp = s_site.find("/", 0, false);

    ftp_host = s_site.left(i_ftp );
    ftp_base_dir = s_site.right( s_site.length() - i_ftp);

    CConfigFile *config;
    config = new CConfigFile( (QDir::homeDirPath ()) +"/.gutenbrowser/gutenbrowserrc");
    config->read();
    config->setGroup( "FTPsite" );
    config->writeEntry("SiteName",ftp_host);
    config->writeEntry("base",ftp_base_dir);
    config->write();
    TextLabel3->setText( "Current ftp server:\n" + ftp_host /*+ ftp_base_dir*/ );
    s_site = index;
}

