/***************************************************************************
                         gutenbrowser.h  -  description
                            -------------------
   begin                : Mon Jul 24 22:33:12 MDT 2000
   copyright            : (C) 2000 by llornkcor
   email                : ljp@llornkcor.com
***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GUTENBROWSER_H
#define GUTENBROWSER_H

// include files for QT

//#ifdef Q_WS_QWS
//#include "myscrollview.h"
//#else
//#endif
#include <qapplication.h>

#include <qmultilineedit.h>
#include <qurloperator.h>
#include <qtooltip.h>
#include <qstring.h>
#include <qsplitter.h>
#include <qlistview.h>
#include <qtextview.h>
#include <qstatusbar.h>

#include <qlayout.h>
#include <qpopupmenu.h>
#include <qmainwindow.h>
#include <qaccel.h>
#include <qmenubar.h>
#include <qtoolbar.h>
#include <qpixmap.h>
#include <qtoolbutton.h>
#include <qapp.h>
#include <qstatusbar.h>
#include <qwhatsthis.h>
#include <qmsgbox.h>
#include <qfiledialog.h>
#include <qprinter.h>
#include <qpainter.h>
#include <qpushbutton.h>
#include <qmultilineedit.h>
#include <qfontmetrics.h>
#include <qfontinfo.h>

#include "LibraryDialog.h"
#include "multiline_ex.h"
#include "NetworkDialog.h"
#include "CConfigFile.h"
// application specific includes
//#include "gutenbrowserview.h"
//#include "gutenbrowserdoc.h"
#include "resource.h"

class Gutenbrowser : public QMainWindow {
    Q_OBJECT

public:
    Gutenbrowser();
    ~Gutenbrowser();
    void initMenuBar();
    void initButtonBar();
    void initStatusBar();
    //    void initDoc();
    void initView();
    void initConfig();
    void initSlots();
    void toggleButtonIcons( bool usingIcons);
    bool useIcons;
    bool queryExit();
    bool b_queryExit;
    bool UnZipIt(QString zipFile);
    QGridLayout *layout;
    QBoxLayout *topLayout;
    QBoxLayout *menu;
    QBoxLayout *buttons;
    QBoxLayout *edits;
    QMenuBar* menubar;
    QStatusBar* statusBar;

    QPushButton* LibraryButton;
    QPushButton* OpenButton;
    QPushButton* ForwardButton;
    QPushButton* BackButton;
    QPushButton* PrintButton;
    QPushButton* SearchButton;
    QPushButton* dictionaryButton;
    QPushButton* beginButton;

    QPushButton* OptionsButton;
    QPushButton* FontButton;
    QPushButton* ClearButton;
    QPushButton* lastBmkButton;
    QPushButton* setBookmarkButton;
    QPushButton* HelpButton;
    QPushButton* InfoBar;
    
	 QFile newindexLib, indexLib;
    QLabel* StatusBar;

    CConfigFile *config;
    QPrinter *printer;
    SearchDialog* searchDlg;
    QString s_Wrap;
    QString local_library;
    QString local_index;
    QString iniFile;
    QString prefBrowser;
    QString brow;
    QString file_name;
    QString ftp_base_dir;
    QString ftp_host;
    QString listItemFile;
    QString listItemNumber;
    QString listItemTitle;
    QString listItemYear;
    QString pattern;
    QString status;
    QString statusTop;
    QString title;

    int check;
    int lineCheck;
    int i_pageNum;
    int pages;
    int direction;

    char host[1024];
    char login[1024];
    char password[1024];
    /**  */
    bool loadCheck;
    int lastScrollRow;
    bool useSplitter;
    bool buttonsHidden;

    void  Search();
    int repeatSearch();
    bool setTitle();
    bool getTitle( const char *file);
    void AdjustStatus();
    void hideButtons();
    /**  */
    void OnNetworkDialog( QString networkUrl, QString output);

    QString fontStr, pointSizeStr, weightStr, italicStr, boldStr;
    int pointSize, weight;
    bool italic, bold;
    QString networkUrl;

public slots:
    void slotFilePrint();
    void BeginBtn();
    void search_slot();
    void searchdone_slot();
    bool setStatus();
    void goGetit( QString url, bool showMsg);
private:
    QArray<int>  pageStopArray;
    QFile f;
    bool useWrap;
    int fileHandle, currentFilePos, currentLine;

    QSplitter *splitter;
    QPopupMenu *fileMenu;
    QPopupMenu *editMenu;
    QPopupMenu *viewMenu;
    QPopupMenu *optionsMenu;
    QPopupMenu *bookmarksMenu;
    QPopupMenu *helpMenu;

    QToolBar *fileToolbar;
    MultiLine_Ex* Lview;
    MultiLine_Ex* Rview;
    int last_search;
private slots:

    bool load( const char *fileName );
    void resizeEvent( QResizeEvent * );
    void TopBtn();
   void cleanUp();

protected slots:
    void InfoBarClick();
    virtual void DownloadIndex();
    virtual void downloadFtpList();
    virtual void PrintBtn();
    virtual void SearchBtn();
    virtual void ForwardBtn();
    virtual void BackBtn();
    virtual void LibraryBtn();
    virtual void OpenBtn();
    virtual void HelpBtn();
    virtual void ChangeFont();
    virtual bool Bookmark();
    virtual void setBookmark();
    virtual void LookupBtn();
    virtual void ClearEdit();
    virtual void ByeBye();
    virtual void doOptions();
    virtual void annotations();
    void downloadLibIndex();
protected:
    void writeConfig();
    void moveSplitter( int pos);
    int doSearch(QString s_pattern, bool case_sensitive, bool forward, int line, int col );
    void keyPressEvent( QKeyEvent * );
    void keyReleaseEvent( QKeyEvent *e);
};
#endif

