/***************************************************************************
                          optionsDialogData.cpp  -  description
                             -------------------
    begin                : Tue Jul 25 2000
    copyright            : (C) 2000 by llornkcor
    email                : ljp@llornkcor.com
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qpixmap.h>
#include <qlayout.h>
#include "optionsDialog.h"

#include <qlabel.h>
#include <qpushbt.h>
#include <qlined.h>
#include <qcombo.h>

void optionsDialog::initDialog() {

    QGridLayout *layout = new QGridLayout( this );
    layout->setSpacing(2);
    layout->setMargin(2);

    QHBoxLayout *hlayout = new QHBoxLayout( this );
    hlayout->setSpacing(2);
    hlayout->setMargin(2);

    QSpacerItem* buttonspacer = new QSpacerItem( 200, 20, QSizePolicy::Expanding, QSizePolicy::Expanding );
    hlayout->addItem( buttonspacer);

    buttonHelp = new QPushButton( this, "buttonHelp" );
    buttonHelp->setProperty( "text", tr( "&Help" ) );
    hlayout->addWidget( buttonHelp);

    buttonOk = new QPushButton( this, "buttonOk" );
    buttonOk->setProperty( "text", tr( "&OK" ) );
    buttonOk->setProperty( "autoDefault", QVariant( true, 0 ) );
    buttonOk->setProperty( "default", QVariant( true, 0 ) );

    hlayout->addWidget( buttonOk);
    layout->addLayout(hlayout,0,0);

    /////////////////////////////////////////////////// Main tab
    tabWidget = new QTabWidget( this, "tabWidget" );
    layout->addMultiCellWidget( tabWidget, 1, 1, 0, 3);

    Widget2 = new QWidget( tabWidget, "Widget2" );

    QGridLayout *layout2 = new QGridLayout(Widget2 );
    layout2->setSpacing(2);
    layout2->setMargin(2);

    Ftp_CheckBox = new QCheckBox( Widget2, "Ftp_CheckBox" );
    Ftp_CheckBox->setProperty( "text", tr( "Use FTP" ) );
    layout2->addMultiCellWidget( Ftp_CheckBox, 0, 0, 0, 1);

    IconsCheckBox = new QCheckBox( Widget2, "IconsCheckBox" );
    IconsCheckBox->setProperty( "text", tr( "Use Icons on Buttons" ) );
    layout2->addMultiCellWidget( IconsCheckBox, 1, 1, 0, 1);

    Http_CheckBox = new QCheckBox( Widget2, "Http_CheckBox" );
    Http_CheckBox->setProperty( "text", tr( "Use pg index instead of ftp library index" ) );
    layout2->addMultiCellWidget( Http_CheckBox, 2, 2, 0, 1);

    cb_queryExit= new QCheckBox( Widget2, "cb_queryExit" );
    cb_queryExit->setProperty( "text", tr( "Query before exit." ) );
    layout2->addMultiCellWidget( cb_queryExit, 3, 3, 0, 1);

#ifndef Q_WS_QWS

    useSplit_CheckBox=new QCheckBox( Widget2, "useSplit_CheckBox" );
    useSplit_CheckBox->setProperty( "text", tr( "Use Split View" ) );
    layout2->addMultiCellWidget( useSplit_CheckBox, 4, 4, 0, 1);
#else

    useWordWrap_CheckBox=new QCheckBox( Widget2, "WordWrap_CheckBox" );
    useWordWrap_CheckBox->setProperty( "text", tr( "Use Word Wrap" ) );
    layout2->addMultiCellWidget( useWordWrap_CheckBox, 4, 4, 0, 1);
#endif


    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    layout2->addItem( spacer, 5, 0 );
    
	 tabWidget->insertTab( Widget2, tr( "Main" ) );

    /////////////////////////////////////////////////// FTP tab
    Widget3 = new QWidget( tabWidget, "Widget3" );

    QGridLayout *layout3 = new QGridLayout(Widget3 );
    layout3->setSpacing(2);
    layout3->setMargin(2);

    ftp_DownloadButton = new QPushButton( Widget3, "ftp_DownloadButton" );
    ftp_DownloadButton->setProperty( "text", tr( "&New List" ) );
    layout3->addMultiCellWidget( ftp_DownloadButton, 0, 0, 3, 3);


    TextLabel3 = new QLabel( Widget3, "TextLabel3" );
    TextLabel3->setProperty( "text", tr( "<p>Current ftp server:<br></p>" ) );
    layout3->addMultiCellWidget( TextLabel3, 1, 2, 0, 3);

    ftp_QListBox_1 = new QListView( Widget3, "ftp_QListBox_1" );
    ftp_QListBox_1->setAllColumnsShowFocus (true);
    layout3->addMultiCellWidget( ftp_QListBox_1, 3, 4, 0, 3);

    ftp_QListBox_1->addColumn( tr( "Continent" ), -1 );
    ftp_QListBox_1->setColumnAlignment( 0, 1 );

    ftp_QListBox_1->addColumn( tr( "Nation" ), -1 );
    ftp_QListBox_1->setColumnAlignment( 0, 1 );

    ftp_QListBox_1->addColumn( tr( "Location" ), -1 );
    ftp_QListBox_1->setColumnAlignment( 0, 1 );

    ftp_QListBox_1->addColumn( tr( "Provider" ), -1 );
    ftp_QListBox_1->setColumnAlignment( 0, 1 );

    ftp_QListBox_1->addColumn( tr( "Url" ), -1 );
    ftp_QListBox_1->setColumnAlignment( 0, 1 );

    ftp_QListBox_1->addColumn( tr( "Notes" ), -1 );
    ftp_QListBox_1->setColumnAlignment( 0, 1 );

    tabWidget->insertTab( Widget3, tr( "FTP" ) );

    /////////////////////////////////////////////////// Http tab
    Widget4 = new QWidget( tabWidget, "tab" );

    QGridLayout *layout4 = new QGridLayout(Widget4 );
    layout4->setSpacing(2);
    layout4->setMargin(2);

    PushButton_Browse = new QPushButton( Widget4, "PushButton_Browse" );
    PushButton_Browse->setProperty( "text", tr( "Browse" ) );
    layout4->addMultiCellWidget( PushButton_Browse, 0, 0, 3, 3);

    TextLabel3_3 = new QLabel( Widget4, "TextLabel3_3" );
    TextLabel3_3->setProperty( "text", tr( "Current http browser:" ) );
    layout4->addMultiCellWidget( TextLabel3_3, 1, 2, 0, 3);

    http_ListBox1 = new QListBox( Widget4, "http_ListBox1" );
    layout4->addMultiCellWidget( http_ListBox1, 3, 4, 0, 3);

    TextLabel5 = new QLabel( Widget4, "TextLabel5" );
    TextLabel5->setProperty( "text", tr( "HTTP Servers" ) );
    layout4->addMultiCellWidget( TextLabel5, 5, 5, 0, 3);

    ComboBox1 = new QComboBox( false, Widget4, "ComboBox1" );
    ComboBox1->insertItem( tr( "http://sailor.gutenberg.org" ) );
    ComboBox1->insertItem( tr( "http://www.prairienet.org/pg" ) );
    layout4->addMultiCellWidget( ComboBox1, 6, 6, 0, 3);

    tabWidget->insertTab( Widget4, tr( "HTTP" ) );

    initConnections();

#ifdef Q_WS_QWS

    local_library = (QDir::homeDirPath ()) +"/gutenbrowser/";
#else

    local_library = (QDir::homeDirPath ()) +"/.gutenbrowser/";
#endif

    config = new CConfigFile( local_library+"gutenbrowserrc");
    doOptions();

}

void optionsDialog::initConnections() {
    // signals and slots connections
    connect(buttonOk,SIGNAL(clicked()),this,SLOT(accept()));

    //  connect( s_Browser, SIGNAL( activated(const QString&)), SLOT( goBrowser(const QString&) ) );
    connect(Http_CheckBox,SIGNAL(clicked()),SLOT(httpCheckB()));
    connect(IconsCheckBox,SIGNAL(clicked()),SLOT(iconCheckB()));
    connect(Ftp_CheckBox,SIGNAL(clicked()),SLOT(FtpCheckB()));

    // ftpsiteDlg
    connect(ftp_DownloadButton,SIGNAL(released()),this,SLOT(getSite()));
    connect(ftp_QListBox_1,SIGNAL(clicked(QListViewItem *)),this,SLOT(getSelection(QListViewItem *)));

    //browserDialog
    connect(http_ListBox1,SIGNAL(selected(int)),this,SLOT(select_title(int)));
    connect(PushButton_Browse,SIGNAL(clicked()),SLOT(BrowseSelected()));

    connect(cb_queryExit,SIGNAL(clicked()),SLOT(slotQueryExit()));
#ifndef Q_WS_QWS
    connect(useSplit_CheckBox,SIGNAL(clicked()),SLOT(slotUseSplit()));
#else
    connect(useWordWrap_CheckBox,SIGNAL(clicked()),SLOT(slotUseSplit()));
#endif
}

void optionsDialog::listBoxMainSel( int index) {
    tabWidget->setCurrentPage( index);
}
