// ****************************************************************************
//  Project:        GUYMAGER
// ****************************************************************************
//  Programmer:     Guy Voncken
//                  Police Grand-Ducale
//                  Service de Police Judiciaire
//                  Section Nouvelles Technologies
// ****************************************************************************

#ifndef __CONFIG_H__
#define __CONFIG_H__

#define CONFIG(Param)             ( CfgGetpData ()->Param)
#define CONFIG_COLOR(Color)       (*CfgGetpColor(Color))
#define CONFIG_FONT(FontObject)   (*CfgGetpFont (FontObject ))

typedef enum
{
   CFG_STARTUPSIZE_STANDARD,
   CFG_STARTUPSIZE_FULLSCREEN,
   CFG_STARTUPSIZE_MAXIMIZED,
   CFG_STARTUPSIZE_MANUAL,
} t_CfgStartupSize;

typedef enum
{
   CFG_NUMBERSTYLE_LOCALE,
   CFG_NUMBERSTYLE_DECIMAL_COMMA,
   CFG_NUMBERSTYLE_DECIMAL_POINT
} t_CfgNumberStyle;

typedef enum
{
   CFG_ENTRYMODE_HIDE,
   CFG_ENTRYMODE_SHOWDEFAULT,
   CFG_ENTRYMODE_SHOWLAST
} t_CfgEntryMode;

const int CFG_MAX_LANGUAGE_LEN      =    8;
const int CFG_MAX_FONT_FAMILY_LEN   =   63;
const int CFG_MAX_PATH_LEN          = 1024;
const int CFG_MAX_TITLEID_LEN       =   31;
const int CFG_MAX_MENU_NAME_LEN     =  255;
const int CFG_MAX_LANGUAGE_CODE_LEN =    5;
const int CFG_MAX_FIELDNAME_LEN     =  255;
const int CFG_MAX_MISC_LEN          =  255;

class QColor; //lint !e763
class QFont;  //lint !e763

typedef enum
{
   FONTOBJECT_MENU=0,                 // must start with 0, as it is used for addressing an array
   FONTOBJECT_DIALOGDEFAULT,

   FONTOBJECT_COUNT
} t_CfgFontObject;

typedef enum
{
   COLOR_LOCALDEVICES=0,
   COLOR_STATE_IDLE,
   COLOR_STATE_ACQUIRE,
   COLOR_STATE_ACQUIRE_PAUSED,
   COLOR_STATE_VERIFY,
   COLOR_STATE_VERIFY_PAUSED,
   COLOR_STATE_CLEANUP,
   COLOR_STATE_FINISHED,
   COLOR_STATE_FINISHED_BADVERIFY,
   COLOR_STATE_ABORTED_USER,
   COLOR_STATE_ABORTED_OTHER,

   COLOR_COUNT,
   COLOR_DEFAULT  // Not really a color, but used for specifying, that a widget should switch to its default color (grey for a button, for instance)
} t_CfgColor;


// ATTENTION: The data of the following structure is filled in by the CFG tool. As this
// one doesn't know about 'bool' (it's written in ANSI C), bool MUST not be used here.
// ------------------------------------------------------------------------------------
#define bool "Do not use bool, take int instead"
typedef struct
{
   char                 Language[CFG_MAX_LANGUAGE_LEN+1];

   t_CfgStartupSize     StartupSize;
   int                  StartupSizeManualX;
   int                  StartupSizeManualY;
   int                  StartupSizeManualDx;
   int                  StartupSizeManualDy;

   t_CfgStartupSize     FileDialogSize;
   int                  FileDialogSizeManualDx;
   int                  FileDialogSizeManualDy;

   t_CfgNumberStyle     NumberStyle;
   int                  ScreenRefreshInterval;
   int                  UseFileDialogFromQt;

   int                  ScanUsingDbusHal;
   int                  ScanInterval;
   char                 CommandGetSerialNumber[CFG_MAX_PATH_LEN+1];

   int                  DefaultFormat;
   int                  EwfFormat;
   int                  EwfCompression;
   int                  AffCompression;
   int                  AffMarkBadSectors;
   int                  EwfSegmentSize;
   char                 SpecialFilenameChars[CFG_MAX_MISC_LEN+1];

   int                  FifoBlockSizeDD;
   int                  FifoBlockSizeEWF;
   int                  FifoBlockSizeAFF;
   int                  FifoMaxMem;
   int                  FifoMaxEntries;
   int                  UseSeparateHashThread;
   int                  CompressionThreads;
   int                  SignalHandling;
   int                  WriteToDevNull;
   int                  UseMemWatch;
   int                  VerboseLibewf;
   int                  CheckEwfData;
} t_CfgData, *t_pCfgData;
#undef bool


typedef struct
{
   char      Code      [CFG_MAX_LANGUAGE_CODE_LEN+1];
   char      AsciiName [CFG_MAX_MENU_NAME_LEN    +1];
} t_CfgBuffLanguage, *t_pCfgBuffLanguage;

typedef struct
{
   t_CfgFontObject Object;
   char            Family[CFG_MAX_FONT_FAMILY_LEN+1];
   int             Size;
   int             Weight;
   int             Italic;
} t_CfgBuffFont, *t_pCfgBuffFont;

typedef struct
{
   t_CfgColor Color;
   int        R;
   int        G;
   int        B;
} t_CfgBuffColor, *t_pCfgBuffColor;

typedef struct
{
   char Device [CFG_MAX_PATH_LEN+1];
} t_CfgBuffLocalDevice, *t_pCfgBuffLocalDevice;

typedef struct
{
   char Command [CFG_MAX_PATH_LEN+1];
} t_CfgBuffDeviceInfoCommand, *t_pCfgBuffDeviceInfoCommand;


// DlgAcquire fields and rules
// ---------------------------

#define CFG_DLGACQUIRE_EWF_FIELDID    "Ewf"
#define CFG_DLGACQUIRE_DST_FIELDID    "Dest"
#define CFG_DLGACQUIRE_DIR_FIELDID    "Directory"

#define CFG_DLGACQUIRE_EWF_CASENUMBER          QT_TRANSLATE_NOOP("t_DlgAcquire", "EwfCaseNumber"     )
#define CFG_DLGACQUIRE_EWF_EVIDENCENUMBER      QT_TRANSLATE_NOOP("t_DlgAcquire", "EwfEvidenceNumber" )
#define CFG_DLGACQUIRE_EWF_EXAMINER            QT_TRANSLATE_NOOP("t_DlgAcquire", "EwfExaminer"       )
#define CFG_DLGACQUIRE_EWF_DESCRIPTION         QT_TRANSLATE_NOOP("t_DlgAcquire", "EwfDescription"    )
#define CFG_DLGACQUIRE_EWF_NOTES               QT_TRANSLATE_NOOP("t_DlgAcquire", "EwfNotes"          )
#define CFG_DLGACQUIRE_DEST_IMAGEDIRECTORY     QT_TRANSLATE_NOOP("t_DlgAcquire", "DestImageDirectory")
#define CFG_DLGACQUIRE_DEST_IMAGEDIRECTORY_ALT QT_TRANSLATE_NOOP("t_DlgAcquire", "DestDirectory"     ) // Alternate name for compatibility with old Guymager versions
#define CFG_DLGACQUIRE_DEST_IMAGEFILENAME      QT_TRANSLATE_NOOP("t_DlgAcquire", "DestImageFilename" )
#define CFG_DLGACQUIRE_DEST_INFODIRECTORY      QT_TRANSLATE_NOOP("t_DlgAcquire", "DestInfoDirectory" )
#define CFG_DLGACQUIRE_DEST_INFOFILENAME       QT_TRANSLATE_NOOP("t_DlgAcquire", "DestInfoFilename"  )


typedef struct
{
   char            FieldName   [CFG_MAX_FIELDNAME_LEN+1];
   t_CfgEntryMode  EntryMode;
   char            DefaultValue[CFG_MAX_MISC_LEN     +1];
} t_CfgBuffDlgAcquireField, *t_pCfgBuffDlgAcquireField;

typedef struct
{
   char TriggerFieldName[CFG_MAX_FIELDNAME_LEN+1];
   char DestFieldName   [CFG_MAX_FIELDNAME_LEN+1];
   char Value           [CFG_MAX_MISC_LEN     +1];
} t_CfgBuffDlgAcquireRule, *t_pCfgBuffDlgAcquireRule;

class t_DlgAcquireLineEdit;
class t_CfgDlgAcquireField
{
   public:
      QString                FieldName;
      t_CfgEntryMode         EntryMode;
      QString                DefaultValue;
      QString                LastEnteredValue; // not set by config, used by DlgAcquire
      bool                   EwfField;         // This field is part of the EWF fields
      bool                   DstField;         // This field is part of the fields for entering the image/info destination
      bool                   DirField;         // This is a directory field with a browse button
      t_DlgAcquireLineEdit *pLineEdit;
};
typedef t_CfgDlgAcquireField       *t_pCfgDlgAcquireField;
typedef QList<t_pCfgDlgAcquireField> t_CfgDlgAcquireFields;
typedef t_CfgDlgAcquireFields      *t_pCfgDlgAcquireFields;

class t_CfgDlgAcquireRule
{
   public:
      QString TriggerFieldName;
      QString DestFieldName;
      QString Value;
};
typedef t_CfgDlgAcquireRule        *t_pCfgDlgAcquireRule;
typedef QList<t_pCfgDlgAcquireRule> t_CfgDlgAcquireRules;
typedef t_CfgDlgAcquireRules       *t_pCfgDlgAcquireRules;

QFont        *CfgGetpFont    (t_CfgFontObject Object);
const QColor *CfgGetpColor   (t_CfgColor      Color );
APIRET CfgGetLocalDevices        (QStringList **ppLocalDevices);
APIRET CfgGetDeviceInfoCommands  (QStringList **ppDeviceInfoCommands);
APIRET CfgGetDlgAcquireFields    (t_pCfgDlgAcquireFields *ppDlgAcquireFields);
APIRET CfgGetDlgAcquireRules     (t_pCfgDlgAcquireRules  *ppDlgAcquireRules);


APIRET CfgInit        (void);
APIRET CfgDeInit      (void);

t_pCfgData CfgGetpData(void);

APIRET CfgGetLogFileName    (t_pcchar *ppLogFileName, bool *pDefaultUsed);
APIRET CfgGetCfgFileName    (t_pcchar *ppCfgFileName, bool *pDefaultUsed);
APIRET CfgReadConfiguration (t_pcchar   pCfgFileName);

APIRET ConfigTranslateUnicodeEscape (char *pSrc, QString *pDest);

void CfgFontPrint (void);

// ------------------------------------
//             Error codes
// ------------------------------------

enum
{
   ERROR_CFG_ONLY_TEMPLATE_GENERATED = ERROR_BASE_CFG + 1,
};


#endif

