// ****************************************************************************
//  Project:        GUYMAGER
// ****************************************************************************
//  Programmer:     Guy Voncken
//                  Police Grand-Ducale
//                  Service de Police Judiciaire
//                  Section Nouvelles Technologies
// ****************************************************************************
//  Module:         Dialog that is opened when aborting an acquisition
// ****************************************************************************


#ifndef __DLGABORT_H__
#define __DLGABORT_H__

#include <QtGui> //lint !e537 Repeated include

#ifndef __COMMON_H__
   #include "common.h"
#endif

#ifndef __DEVICE_H__
  #include "device.h"
#endif

class t_DlgAbortLocal;

class t_DlgAbort: public QDialog
{
   Q_OBJECT

   public:
      t_DlgAbort ();
      t_DlgAbort (t_pcDevice pDevice, QWidget *pParent=NULL, Qt::WFlags Flags=0);
     ~t_DlgAbort ();

      static APIRET Show (t_pcDevice pDevice, bool &Abort, bool &Delete);

   private:
      t_DlgAbortLocal *pOwn;
};

enum
{
   ERROR_DLGABORT_CONSTRUCTOR_NOT_SUPPORTED = ERROR_BASE_DLGABORT + 1,
};

#endif

