// ****************************************************************************
//  Project:        GUYMAGER
// ****************************************************************************
//  Programmer:     Guy Voncken
//                  Police Grand-Ducale
//                  Service de Police Judiciaire
//                  Section Nouvelles Technologies
// ****************************************************************************
//  Module:         Acquisition dialog
// ****************************************************************************


#ifndef __DLGACQUIRE_H__
#define __DLGACQUIRE_H__

#include <QtGui> //lint !e537 Repeated include

#ifndef __COMMON_H__
   #include "common.h"
#endif

#ifndef __DEVICE_H__
  #include "device.h"
#endif

#ifndef __CONFIG_H__
   class   t_CfgDlgAcquireField;
   typedef t_CfgDlgAcquireField *t_pCfgDlgAcquireField;
#endif

class t_DlgAcquireLineEdit;
class t_DlgAcquireLocal;

class t_DlgAcquire: public QDialog
{
   Q_OBJECT

   public:
      t_DlgAcquire ();
      t_DlgAcquire (t_pDevice pDevice, QWidget *pParent=NULL, Qt::WFlags Flags=0);
     ~t_DlgAcquire ();

      APIRET GetParameters (t_Device::t_Acquisition &Acquisition, bool RememberLastUsedValues=true);
   private:
      APIRET AddField         (t_pDevice pDevice, t_pCfgDlgAcquireField pField, QGridLayout *pLayout, int *pRow);
      APIRET CheckWriteAccess (const QString &Path, const QString &Filename, bool &Ok);

   private slots:
      void UpdateCheckboxState (int State);
      void UpdateButtonState   (const QString & NewText = QString());
      void UpdateFieldState    (void);
      void SlotBrowse          (void);
      void SlotAccept          (void);
      void SlotTextEdited      (t_DlgAcquireLineEdit *pLineEdit, const QString &NewVal);

   private:
      t_DlgAcquireLocal *pOwn;
};

enum
{
   ERROR_DLGACQUIRE_CONSTRUCTOR_NOT_SUPPORTED = ERROR_BASE_DLGACQUIRE + 1,
   ERROR_DLGACQUIRE_UNKNOWN_FILEDIALOG_SIZE,
   ERROR_DLGACQUIRE_INVALID_ENTRYMODE,
   ERROR_DLGACQUIRE_INVALID_FORMAT
};

#endif

