/*  GWhere.
 *  Copyright (C) 2000  Sbastien LECACHEUR
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include "../gwsupport.h"
#include "gwfileinfo.h"
#include "gwdiskdata.h"


typedef struct disk_data
{
	struct disk_info *info;		/* Disk informations					*/
	GList *child;			/* List of files on the disk's root (the list excludes all sub folders	*/
} DiskData;


DiskData * disk_data_new ( void)
{
	DiskData *p = NULL;


#ifdef GW_DEBUG_DATA_COMPONENT
	static gint i = 0;


	i++;

	g_print ( "*** GW - %s (%d) :: %s() : %d calls\n", __FILE__, __LINE__, __PRETTY_FUNCTION__, i);
#endif

	if ( (p = (DiskData*)g_malloc0 ( sizeof ( DiskData))) != NULL )
	{
		p->info = NULL;
		p->child = NULL;
	}

	return p;
}


gint disk_data_set_info ( DiskData *p, struct disk_info *info)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( p->info != NULL )
		{
			disk_info_free ( p->info);
		}

		p->info = info;

		return 0;
	}

	return -1;
}


gint disk_data_set_child ( DiskData *p, GList *child)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( p->child != NULL )
		{
			g_list_foreach ( p->child, (GFunc)file_info_free, NULL);
			g_list_free ( p->child);
		}

		p->child = child;

		return 0;
	}

	return -1;
}


gint disk_data_append_child ( DiskData *p, struct file_info *child)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		p->child = g_list_append ( p->child, child);

		return 0;
	}

	return -1;
}


struct disk_info * disk_data_get_info ( DiskData *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		return p->info;
	}

	return NULL;
}


GList * disk_data_get_child ( DiskData *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		return p->child;
	}

	return NULL;
}


gint disk_data_free ( DiskData *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	static gint i = 0;


	i++;

	g_print ( "*** GW - %s (%d) :: %s() : %d calls\n", __FILE__, __LINE__, __PRETTY_FUNCTION__, i);
#endif

	if ( p != NULL )
	{
		disk_info_free ( p->info);

		if ( p->child != NULL )
		{
			g_list_foreach ( p->child, (GFunc)file_info_free, NULL);
			g_list_free ( p->child);
		}

		g_free ( p);

		return 0;
	}

	return -1;
}
