/*  GWhere.
 *  Copyright (C) 2000  Sbastien LECACHEUR
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include "../gwsupport.h"
#include "gwcomboboxcategories.h"

#include <string.h> /* strcmp */


/*! @define	GW_REF_CMB_BOX_CATEGORIES_CMB	The real combo */
#define GW_REF_CMB_BOX_CATEGORIES_CMB "gw_ref_cmb_box_categories_cmb"
/*! @define	GW_REF_CMB_BOX_CATEGORIES_CATALOG_INFO	The catalog info */
#define GW_REF_CMB_BOX_CATEGORIES_CATALOG_INFO "gw_ref_cmb_box_categories_catalog_info"


GtkHBox * gw_combo_box_categories_create ( GtkWindow *w, gchar *title, struct catalog_file_info *catalog_info)
{
	GtkWidget *hb, *lbl, *cmb;
	gchar *text_utf8 = NULL;


#ifdef GW_DEBUG_GUI_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	/* Vertical box for categories */
	hb = gtk_hbox_new ( FALSE, 0);
	gtk_container_set_border_width ( GTK_CONTAINER ( hb), 2);

	/* Title label for categories */
	if ( title != NULL )
	{
		g_strdup_to_gtk_text ( title, text_utf8);
		lbl = gtk_label_new ( text_utf8);
		g_free ( text_utf8);
		gtk_box_pack_start ( GTK_BOX ( hb), lbl, FALSE, FALSE, 0);
	}

	/* Combo box for categories */
	cmb = gtk_combo_new ( );
	gtk_widget_ref ( cmb);
	gtk_combo_set_use_arrows_always ( GTK_COMBO ( cmb), TRUE);
	gtk_object_set_data_full ( GTK_OBJECT ( hb), GW_REF_CMB_BOX_CATEGORIES_CMB, cmb, (GtkDestroyNotify) gtk_widget_unref);
	gtk_entry_set_editable ( GTK_ENTRY ( GTK_COMBO ( cmb)->entry), FALSE);
	gtk_box_pack_start ( GTK_BOX ( hb), cmb, TRUE, TRUE, 0);

	if ( catalog_info != NULL )
	{
		gtk_object_set_data ( GTK_OBJECT ( hb), GW_REF_CMB_BOX_CATEGORIES_CATALOG_INFO, catalog_info);
	}
	else
	{
#ifdef GW_DEBUG_GUI_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s() : catalog info is null!!\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	}

	return GTK_HBOX ( hb);
}


gint gw_combo_box_categories_load ( GtkHBox *cbc)
{
	GList *categories = NULL;
	GList *glist = NULL;
	GtkCombo *cmb = NULL;
	gchar *text_utf8 = NULL;
	gint result = -1;


#ifdef GW_DEBUG_GUI_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( (cmb = gw_combo_box_categories_get_combo ( cbc)) != NULL )
	{
		if ( (glist = gw_combo_box_categories_get_categories ( cbc)) == NULL )
		{
			glist = g_list_append ( glist, "");
			gtk_combo_set_popdown_strings ( cmb, glist);

			result = -1;
		}
		else
		{
			glist = g_list_first ( glist);
			while ( glist != g_list_last ( glist))
			{
				categories = g_list_append ( categories, category_get_name ( (struct category*)glist->data));
				glist = g_list_next ( glist);
			}

			categories = g_list_append ( categories, category_get_name ( glist->data));

			if ( categories != NULL )
			{
				gtk_combo_set_popdown_strings ( cmb, categories);
			}

			if ( categories != NULL )
			{
				g_strdup_to_gtk_text ( g_list_first ( categories)->data, text_utf8);
				gtk_entry_set_text ( GTK_ENTRY ( cmb->entry), text_utf8);
				g_free ( text_utf8);

				result = 0;
			}
			else
			{
				/*gtk_entry_set_text ( GTK_ENTRY ( cmb->entry), _("none"));*/
				result = -1;
			}
		}
	}

	return result;
}


gint gw_combo_box_categories_set_catalog_info ( GtkHBox *cbc, struct catalog_file_info *catalog_info)
{
#ifdef GW_DEBUG_GUI_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( cbc != NULL )
	{
		gtk_object_set_data ( GTK_OBJECT ( cbc), GW_REF_CMB_BOX_CATEGORIES_CATALOG_INFO, catalog_info);
	}

	return 0;
}


gint gw_combo_box_categories_set_selected_category ( GtkHBox *cbc, struct category *category)
{
	GList *categories = NULL;
	GList *selection = NULL;
	GtkCombo *cmb;
	gchar *text_utf8 = NULL;
	gint result = -1;


#ifdef GW_DEBUG_GUI_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( (cbc != NULL) && (category != NULL) )
	{
		if ( (categories = gw_combo_box_categories_get_categories ( cbc)) != NULL )
		{
			if ( (selection = g_list_find ( categories, category)) != NULL )
			{
				if ( (cmb = gw_combo_box_categories_get_combo ( cbc)) != NULL )
				{
					g_strdup_to_gtk_text ( category_get_name ( selection->data), text_utf8);
					gtk_entry_set_text ( GTK_ENTRY ( cmb->entry), text_utf8);
					g_free ( text_utf8);

					result = 0;
				}
			}
		}
	}

	return result;
}


gint gw_combo_box_categories_set_selected_category_name ( GtkHBox *cbc, gchar *name)
{
	GList *categories = NULL;
	GList *selection = NULL;
	GtkCombo *cmb;
	gchar *text_utf8 = NULL;
	gint result = -1;


#ifdef GW_DEBUG_GUI_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( (cbc != NULL) && (name != NULL) )
	{
		if ( (categories = gw_combo_box_categories_get_categories ( cbc)) != NULL )
		{
			if ( (selection = g_list_find_custom ( categories, name, (GCompareFunc)strcmp)) != NULL )
			{
				cmb = gw_combo_box_categories_get_combo ( cbc);
				g_strdup_to_gtk_text ( g_list_first ( selection)->data, text_utf8);
				gtk_entry_set_text ( GTK_ENTRY ( cmb->entry), text_utf8);
				g_free ( text_utf8);

				result = 0;
			}
		}
	}

	return result;
}


struct category * gw_combo_box_categories_get_selected_category ( GtkHBox *cbc)
{
	gchar *name;
	struct catalog_file_info *catalog_info = NULL;
	struct category *cat = NULL;


#ifdef GW_DEBUG_GUI_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( cbc != NULL )
	{
		catalog_info = gw_combo_box_categories_get_catalog_info ( cbc);
		name = gw_combo_box_categories_get_selected_category_name ( cbc);

		if ( (catalog_info != NULL) && (name != NULL) )
		{
			cat = catalog_file_info_get_category ( catalog_info, name);
		}

		if ( name != NULL )
		{
			g_free ( name);
		}
	}

	return cat;
}


gchar * gw_combo_box_categories_get_selected_category_name ( GtkHBox *cbc)
{
	GtkCombo *cmb = NULL;
	gchar *category_name = NULL;


#ifdef GW_DEBUG_GUI_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( cbc != NULL )
	{
		if ( (cmb = gtk_object_get_data ( GTK_OBJECT ( cbc), GW_REF_CMB_BOX_CATEGORIES_CMB)) != NULL)
		{
			g_strdup_from_gtk_text ( gtk_entry_get_text ( GTK_ENTRY ( cmb->entry)), category_name);
		}
	}

	return category_name;
}


GtkCombo * gw_combo_box_categories_get_combo ( GtkHBox *cbc)
{
	GtkCombo *combo = NULL;


#ifdef GW_DEBUG_GUI_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( cbc != NULL )
	{
		combo = GTK_COMBO ( gtk_object_get_data ( GTK_OBJECT ( cbc), GW_REF_CMB_BOX_CATEGORIES_CMB));
	}

	return combo;
}


struct catalog_file_info * gw_combo_box_categories_get_catalog_info ( GtkHBox *cbc)
{
	struct catalog_file_info *catalog_info = NULL;


#ifdef GW_DEBUG_GUI_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( cbc != NULL )
	{
		catalog_info = gtk_object_get_data ( GTK_OBJECT ( cbc), GW_REF_CMB_BOX_CATEGORIES_CATALOG_INFO);
	}


	return catalog_info;
}


GList * gw_combo_box_categories_get_categories ( GtkHBox *cbc)
{
	struct catalog_file_info *catalog_info = NULL;
	GList *result = NULL;


#ifdef GW_DEBUG_GUI_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( cbc != NULL )
	{
		if ( (catalog_info = gw_combo_box_categories_get_catalog_info ( cbc)) != NULL )
		{
			result = catalog_file_info_get_categories ( catalog_info);
		}
	}

	return result;
}
