/*  GWhere.
 *  Copyright (C) 2000  Sbastien LECACHEUR
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include "../gwsupport.h"
#include "gwpropertiesboxcallback.h"

#include <stdlib.h> /* strtol */
#include <string.h> /* strcmp */

#include "tools/gwtools.h"

#include "gwpropertiesbox.h"
#include "gwcomboboxcategories.h"

#include "../gwcatalogstats.h"


/* I don't like globals variables, but how to take another way? */
extern GtkCTree *ctree_properties;
extern GtkCTreeNode *node_properties;
extern GList *files_properties;


gboolean gw_properties_box_catalog_ok ( GtkWidget *b, GtkWidget *w)
{
	struct catalog_file_info *catalog_info = NULL;
	GtkCTreeNode *selection = NULL;
	gboolean result = FALSE;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( w != NULL )
	{
		selection = GTK_CTREE_NODE ( GTK_CLIST ( ctree_properties)->selection->data);

		/* Gets catalog informations */
		catalog_info = gtk_ctree_node_get_row_data ( ctree_properties, node_properties);

		/* Checks if must update catalog name */
		gw_properties_box_catalog_name_check ( w, node_properties, catalog_info);

		/* Checks if must update catalog description */
		gw_properties_box_catalog_description_check ( w, GTK_CTREE_ROW ( node_properties)->parent, catalog_info);

		gtk_widget_destroy ( w);

		/* Selectes the selected item in the exploration tree to update files informations */
		gtk_ctree_select ( ctree_properties, selection);

		result = TRUE;
	}

	return result;
}


gboolean gw_properties_box_disk_ok ( GtkWidget *b, GtkWidget *w)
{
	struct disk_info *disk_info = NULL;
	struct catalog_file_info *catalog_info = NULL;
	GtkCTreeNode *selection = NULL;
	gboolean result = FALSE;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( w != NULL )
	{
		selection = GTK_CTREE_NODE ( GTK_CLIST ( ctree_properties)->selection->data);

		/* Gets catalog and disk informations */
		catalog_info = gtk_ctree_node_get_row_data ( ctree_properties, GTK_CTREE_ROW ( node_properties)->parent);
		disk_info = disk_data_get_info ( gtk_ctree_node_get_row_data ( ctree_properties, node_properties));

		/* Checks if must update disk name */
		gw_properties_box_disk_name_check ( w, node_properties, catalog_info, disk_info);

		/* Checks if must update disk number archive */
		gw_properties_box_disk_num_archive_check ( w, node_properties, catalog_info, disk_info);

		/* Checks if must update disk category */
		gw_properties_box_disk_category_check ( w, node_properties, catalog_info, disk_info);

		/* Checks if must update disk description */
		gw_properties_box_disk_description_check ( w, node_properties, catalog_info, disk_info);

		/* Checks if must update catalog name */
		gw_properties_box_catalog_name_check ( w, GTK_CTREE_ROW ( node_properties)->parent, catalog_info);

		/* Checks if must update catalog description */
		gw_properties_box_catalog_description_check ( w, GTK_CTREE_ROW ( node_properties)->parent, catalog_info);

		gtk_widget_destroy ( w);

		/* Selectes the selected item in the exploration tree to update files informations */
		gtk_ctree_select ( ctree_properties, selection);

		result = TRUE;
	}

	return result;
}


gboolean gw_properties_box_folder_ok ( GtkWidget *b, GtkWidget *w)
{
	struct file_info *folder_info;
	struct disk_info *disk_info;
	struct catalog_file_info *catalog_info;
	GtkCTreeNode *selection = NULL;
	gboolean result = FALSE;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( w != NULL )
	{
		selection = GTK_CTREE_NODE ( GTK_CLIST ( ctree_properties)->selection->data);

		/* Gets catalog, disk and folder informations */
		folder_info = dir_data_get_info ( gtk_ctree_node_get_row_data ( ctree_properties, node_properties));
		node_properties = gw_folder_get_disk ( ctree_properties, node_properties);
		disk_info = disk_data_get_info ( gtk_ctree_node_get_row_data ( ctree_properties, node_properties));
		catalog_info = gtk_ctree_node_get_row_data ( ctree_properties, GTK_CTREE_ROW ( node_properties)->parent);

		/* Checks if must update folder category */
		gw_properties_box_folder_category_check ( w, catalog_info, folder_info);

		/* Checks if must update folder description */
		gw_properties_box_folder_description_check ( w, catalog_info, folder_info);

		/* Checks if must update disk name */
		gw_properties_box_disk_name_check ( w, node_properties, catalog_info, disk_info);

		/* Checks if must update disk number archive */
		gw_properties_box_disk_num_archive_check ( w, node_properties, catalog_info, disk_info);

		/* Checks if must update disk category */
		gw_properties_box_disk_category_check ( w, node_properties, catalog_info, disk_info);

		/* Checks if must update disk description */
		gw_properties_box_disk_description_check ( w, node_properties, catalog_info, disk_info);

		/* Checks if must update catalog name */
		gw_properties_box_catalog_name_check ( w, GTK_CTREE_ROW ( node_properties)->parent, catalog_info);

		/* Checks if must update catalog description */
		gw_properties_box_catalog_description_check ( w, GTK_CTREE_ROW ( node_properties)->parent, catalog_info);

		gtk_widget_destroy ( w);

		/* Selectes the selected item in the exploration tree to update files informations */
		gtk_ctree_select ( ctree_properties, selection);

		result = TRUE;
	}

	return result;
}


gboolean gw_properties_box_file_ok ( GtkWidget *b, GtkWidget *w)
{
	struct file_info *folder_info = NULL, *file_info = NULL;
	struct disk_info *disk_info = NULL;
	struct catalog_file_info *catalog_info = NULL;
	GtkCTreeNode *selection = NULL;
	GtkCTreeNode *folder_node = node_properties;
	gboolean result = FALSE;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( w != NULL )
	{
		selection = GTK_CTREE_NODE ( GTK_CLIST ( ctree_properties)->selection->data);

		/* Gets catalog, disk and file informations */
		file_info = (struct file_info*)files_properties->data;
		node_properties = gw_folder_get_disk ( ctree_properties, node_properties);
		disk_info = disk_data_get_info ( gtk_ctree_node_get_row_data ( ctree_properties, node_properties));
		catalog_info = gtk_ctree_node_get_row_data ( ctree_properties, GTK_CTREE_ROW ( node_properties)->parent);

		/* Checks if must update file category */
		gw_properties_box_file_category_check ( w, catalog_info, file_info);

		/* Checks if must update file description */
		gw_properties_box_file_description_check ( w, catalog_info, file_info);

		/* Checks if the file is in the root folder */
		if ( GTK_CTREE_ROW ( GTK_CTREE_ROW ( folder_node)->parent)->parent != NULL )
		{
			/* If it's not in the root folder */

			/* Gets folder informations */
			folder_info = dir_data_get_info ( gtk_ctree_node_get_row_data ( ctree_properties, folder_node));

			/* Checks if must update folder category */
			gw_properties_box_folder_category_check ( w, catalog_info, folder_info);

			/* Checks if must update folder description */
			gw_properties_box_folder_description_check ( w, catalog_info, folder_info);
		}

		/* Checks if must update disk name */
		gw_properties_box_disk_name_check ( w, node_properties, catalog_info, disk_info);

		/* Checks if must update disk number archive */
		gw_properties_box_disk_num_archive_check ( w, node_properties, catalog_info, disk_info);

		/* Checks if must update disk category */
		gw_properties_box_disk_category_check ( w, node_properties, catalog_info, disk_info);

		/* Checks if must update disk description */
		gw_properties_box_disk_description_check ( w, node_properties, catalog_info, disk_info);

		/* Checks if must update catalog name */
		gw_properties_box_catalog_name_check ( w, GTK_CTREE_ROW ( node_properties)->parent, catalog_info);

		/* Checks if must update catalog description */
		gw_properties_box_catalog_description_check ( w, GTK_CTREE_ROW ( node_properties)->parent, catalog_info);

		gtk_widget_destroy ( w);

		/* Selectes the selected item in the exploration tree to update files informations */
		gtk_ctree_select ( ctree_properties, selection);

		result = TRUE;
	}

	return result;
}


gint gw_properties_box_catalog_name_check ( GtkWidget *w, GtkCTreeNode *node, struct catalog_file_info *catalog_info)
{
	guint8 spc;
	GdkBitmap *btmp;
	GdkPixmap *pxmp;
	gchar *catalog_name = NULL;
	gchar *name = NULL;
	gchar *text_utf8 = NULL;
	gint result = -1;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( w != NULL )
	{
		catalog_name = gw_properties_box_get_catalog_name ( w);

		if ( strcmp ( catalog_name, catalog_file_info_get_title ( catalog_info)) != 0 )
		{
			/* If displayed catalog name is different as catalog name */

			if ( strcmp ( catalog_name, "") != 0 )
			{
				/* If a name is displayed */
				catalog_file_info_set_title ( catalog_info, g_strdup ( catalog_name));

				gtk_ctree_node_get_pixtext ( ctree_properties, node, 0, &name, &spc, &pxmp, &btmp);
				g_strdup_to_gtk_text ( catalog_file_info_get_title ( catalog_info), text_utf8);
				gtk_ctree_node_set_pixtext ( ctree_properties, node, 0, text_utf8, spc, pxmp, btmp);
				g_free ( text_utf8);
			}
			else
			{
				catalog_file_info_set_title ( catalog_info, NULL);

				gtk_ctree_node_get_pixtext ( ctree_properties, node, 0, &name, &spc, &pxmp, &btmp);
				g_strdup_to_gtk_text ( catalog_file_info_get_name ( catalog_info), text_utf8);
				gtk_ctree_node_set_pixtext ( ctree_properties, node, 0, text_utf8, spc, pxmp, btmp);
				g_free ( text_utf8);
			}

			/* Indicate that's catalog is modified */
			catalog_file_info_set_ismodified ( catalog_info, TRUE);
		}

		g_free ( catalog_name);

		result = 0;
	}

	return result;
}


gint gw_properties_box_catalog_description_check ( GtkWidget *w, GtkCTreeNode *node, struct catalog_file_info *catalog_info)
{
	gint result = -1;
	gchar *catalog_description = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( w != NULL )
	{
		catalog_description = gw_properties_box_get_catalog_description ( w);

		if ( strcmp ( catalog_description, catalog_file_info_get_description ( catalog_info)) != 0 )
		{
			/* If displayed description is different as catalog description */
			if ( strcmp ( catalog_description, "") != 0 )
			{
				catalog_file_info_set_description ( catalog_info, g_strdup ( catalog_description));
			}
			else
			{
				catalog_file_info_set_description ( catalog_info, NULL);
			}

			/* Indicate that's catalog is modified */
			catalog_file_info_set_ismodified ( catalog_info, TRUE);
		}

		g_free ( catalog_description);

		result = 0;
	}

	return result;
}


gint gw_properties_box_disk_name_check ( GtkWidget *w, GtkCTreeNode *node, struct catalog_file_info *catalog_info,struct disk_info *disk_info)
{
	guint8 spc;
	GdkBitmap *btmp;
	GdkPixmap *pxmp;
	gchar *tmp_name = NULL, *disk_name = NULL, *name = NULL;
	gchar *text_utf8 = NULL;
	gint result = -1;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( w != NULL )
	{
		tmp_name = gw_properties_box_get_disk_name ( w);

		if ( strcmp ( tmp_name, disk_info_get_name ( disk_info)) != 0 )
		{
			/* If displayed disk name is different as disk name */

			disk_name = gw_disk_get_name ( tmp_name);

			if ( strcmp ( disk_name, "") != 0 )
			{
				gtk_ctree_node_get_pixtext ( ctree_properties, node_properties, 0, &name, &spc, &pxmp, &btmp);
				g_strdup_to_gtk_text ( disk_name, text_utf8);
				gtk_ctree_node_set_pixtext ( ctree_properties, node_properties, 0, text_utf8, spc, pxmp, btmp);
				g_free ( text_utf8);

				disk_info_set_name ( disk_info, g_strdup ( disk_name));

				/* Indicate that's catalog is modified */
				catalog_file_info_set_ismodified ( catalog_info, TRUE);
			}

			g_free ( disk_name);
		}

		g_free ( tmp_name);

		result = 0;
	}

	return result;
}


gint gw_properties_box_disk_num_archive_check ( GtkWidget *w, GtkCTreeNode *node, struct catalog_file_info *catalog_info, struct disk_info *disk_info)
{
	gint num;
	gint result = -1;
	gchar *disk_num = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( w != NULL )
	{
		disk_num = gw_properties_box_get_disk_num ( w);

		if ( ( num = strtol ( disk_num, NULL, 10)) != disk_info_get_num ( disk_info) )
		{
			/* If displayed number archive is different as disk number archive */
			if ( num > 0 )
			{
				if ( !gw_disk_num_is_exist ( num))
				{
					/* If number archive doesn't exists : it's possible to change it */
					disk_info_set_num ( disk_info, num);

					/* Indicate that's catalog is modified */
					catalog_file_info_set_ismodified ( catalog_info, TRUE);
				}
			}
		}

		g_free ( disk_num);

		result = 0;
	}

	return result;
}


gint gw_properties_box_disk_category_check ( GtkWidget *w, GtkCTreeNode *node, struct catalog_file_info *catalog_info, struct disk_info *disk_info)
{
	gint result = -1;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( w != NULL )
	{
		if ( gw_properties_box_get_disk_category ( w) != disk_info_get_category ( disk_info) )
		{
			disk_info_set_category ( disk_info, gw_properties_box_get_disk_category ( w));

			/* Indicate that's catalog is modified */
			catalog_file_info_set_ismodified ( catalog_info, TRUE);
		}

		result = 0;
	}

	return result;
}


gint gw_properties_box_disk_description_check ( GtkWidget *w, GtkCTreeNode *node, struct catalog_file_info *catalog_info, struct disk_info *disk_info)
{
	gint result = -1;
	gchar *disk_description = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( w != NULL )
	{
		disk_description = gw_properties_box_get_disk_description ( w);

		if ( strcmp ( disk_description, disk_info_get_description ( disk_info)) != 0 )
		{
			/* If displayed description is different as disk description */
			if ( strcmp ( disk_description, "") != 0 )
			{
				disk_info_set_description ( disk_info, g_strdup ( disk_description));
			}
			else
			{
				disk_info_set_description ( disk_info, NULL);
			}

			/* Indicate that's catalog is modified */
			catalog_file_info_set_ismodified ( catalog_info, TRUE);
		}

		g_free ( disk_description);

		result = 0;
	}

	return result;
}


gint gw_properties_box_folder_category_check ( GtkWidget *w, struct catalog_file_info *catalog_info, struct file_info *folder_info)
{
	gint result = -1;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( w != NULL )
	{
		if ( gw_properties_box_get_folder_category ( w) != file_info_get_category ( folder_info) )
		{
			file_info_set_category ( folder_info, gw_properties_box_get_folder_category ( w));

			/* Indicate that's catalog is modified */
			catalog_file_info_set_ismodified ( catalog_info, TRUE);
		}

		result = 0;
	}

	return result;
}


gint gw_properties_box_folder_description_check ( GtkWidget *w, struct catalog_file_info *catalog_info, struct file_info *folder_info)
{
	gint result = -1;
	gchar *folder_description = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( w != NULL )
	{
		folder_description = gw_properties_box_get_folder_description ( w);

		if ( strcmp ( folder_description, file_info_get_description ( folder_info)) != 0 )
		{
			/* If displayed description is different as folder description */
			if ( strcmp ( folder_description, "") != 0 )
			{
				file_info_set_description ( folder_info, g_strdup ( folder_description));
			}
			else
			{
				file_info_set_description ( folder_info, NULL);
			}

			/* Indicate that's catalog is modified */
			catalog_file_info_set_ismodified ( catalog_info, TRUE);
		}

		g_free ( folder_description);

		result = 0;
	}

	return result;
}


gint gw_properties_box_file_category_check ( GtkWidget *w, struct catalog_file_info *catalog_info, struct file_info *file_info)
{
	gint result = -1;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( w != NULL )
	{
		if ( gw_properties_box_get_file_category ( w) != file_info_get_category ( file_info) )
		{
			file_info_set_category ( file_info, gw_properties_box_get_file_category ( w));

			/* Indicate that's catalog is modified */
			catalog_file_info_set_ismodified ( catalog_info, TRUE);
		}

		result = 0;
	}

	return result;
}


gint gw_properties_box_file_description_check ( GtkWidget *w, struct catalog_file_info *catalog_info, struct file_info *file_info)
{
	gint result = -1;
	gchar *file_description = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( w != NULL )
	{
		file_description = gw_properties_box_get_file_description ( w);

		if ( strcmp ( file_description, file_info_get_description ( file_info)) != 0 )
		{
			/* If displayed description is different as file description */
			if ( strcmp ( file_description, "") != 0 )
			{
				file_info_set_description ( file_info, g_strdup ( file_description));
			}
			else
			{
				file_info_set_description ( file_info, NULL);
			}

			/* Indicate that's catalog is modified */
			catalog_file_info_set_ismodified ( catalog_info, TRUE);
		}

		g_free ( file_description);

		result = 0;
	}

	return result;
}
