;; @(#) $Id: gwyddion.iss.in 8857 2008-12-17 12:30:07Z yeti-dn $
;; vim: set ff=dos :
[Setup]
AppName=Gwyddion
AppVersion=2.12
AppVerName=Gwyddion 2.12
AppPublisherURL=http://gwyddion.net/
AppCopyright=Copyright (C) 2003-2006 David Necas (Yeti), Petr Klapetek
DefaultDirName={pf}\Gwyddion
DefaultGroupName=Gwyddion
DisableStartupPrompt=yes
WindowShowCaption=yes
WindowVisible=no
LicenseFile=COPYING.wri
Compression=bzip/9
SourceDir=.
; this means inst too
OutputDir=.
OutputBaseFilename=Gwyddion-2.12
ChangesAssociations=yes
PrivilegesRequired=none

[Files]
Source: "*.dll"; DestDir: "{app}"
Source: "*.wri"; DestDir: "{app}"
Source: "gwyddion.exe"; DestDir: "{app}"
Source: "glmaterials\*.*"; DestDir: "{app}\glmaterials"
Source: "gradients\*.*"; DestDir: "{app}\gradients"
Source: "ui\*.*"; DestDir: "{app}\ui"
Source: "pixmaps\*.*"; DestDir: "{app}\pixmaps"
Source: "modules\*.*"; DestDir: "{app}\modules"
Source: "modules\file\*.*"; DestDir: "{app}\modules\file"
Source: "modules\graph\*.*"; DestDir: "{app}\modules\graph"
Source: "modules\layer\*.*"; DestDir: "{app}\modules\layer"
Source: "modules\process\*.*"; DestDir: "{app}\modules\process"
Source: "modules\tool\*.*"; DestDir: "{app}\modules\tool"
Source: "plugins\file\*.*"; DestDir: "{app}\plugins\file"
Source: "locale\cs\LC_MESSAGES\*.*"; DestDir: "{app}\locale\cs\LC_MESSAGES"
Source: "locale\de\LC_MESSAGES\*.*"; DestDir: "{app}\locale\de\LC_MESSAGES"
Source: "locale\fr\LC_MESSAGES\*.*"; DestDir: "{app}\locale\fr\LC_MESSAGES"
Source: "locale\it\LC_MESSAGES\*.*"; DestDir: "{app}\locale\it\LC_MESSAGES"
Source: "locale\ru\LC_MESSAGES\*.*"; DestDir: "{app}\locale\ru\LC_MESSAGES"

[Icons]
Name: "{group}\Gwyddion"; Filename: "{app}\gwyddion.exe"; IconFilename: "{app}\pixmaps\gwyddion.ico"
Name: "{group}\Gwyddion Website"; Filename: "http://gwyddion.net/"
Name: "{group}\Uninstall Gwyddion"; Filename: "{uninstallexe}"
Name: "{userdesktop}\Gwyddion"; Filename: "{app}\gwyddion.exe"; IconFilename: "{app}\pixmaps\gwyddion.ico"

[Registry]
; Add Gtk+ libraries to gwyddion.exe's path
Root: HKLM; Subkey: "Software\Microsoft\Windows\CurrentVersion\App Paths\gwyddion.exe"; Flags: uninsdeletekeyifempty
Root: HKLM; Subkey: "Software\Microsoft\Windows\CurrentVersion\App Paths\gwyddion.exe"; ValueType: string; ValueData: "{app}\gwyddion.exe"; Flags: uninsdeletevalue
Root: HKLM; Subkey: "Software\Microsoft\Windows\CurrentVersion\App Paths\gwyddion.exe"; ValueType: string; ValueName: "Path"; ValueData: "{app};{code:GetGtkPath}\lib;{code:GetGtkPath}\bin"; Flags: uninsdeletevalue
; Add Gwyddion paths to the registry
Root: HKLM; Subkey: "Software\Gwyddion"; Flags: uninsdeletekeyifempty
Root: HKLM; Subkey: "Software\Gwyddion\1.0"; Flags: uninsdeletekey
Root: HKLM; Subkey: "Software\Gwyddion\1.0"; ValueType: string; ValueName: "Path"; ValueData: "{app}"; Flags: uninsdeletekey
Root: HKLM; Subkey: "Software\Gwyddion\1.0"; ValueType: string; ValueName: "Version"; ValueData: "2.12"; Flags: uninsdeletekey
Root: HKCU; Subkey: "Software\Gwyddion"; Flags: uninsdeletekeyifempty
Root: HKCU; Subkey: "Software\Gwyddion\1.0"; Flags: uninsdeletekey
Root: HKCU; Subkey: "Software\Gwyddion\1.0"; ValueType: string; ValueName: "Path"; ValueData: "{app}"; Flags: uninsdeletekey
Root: HKCU; Subkey: "Software\Gwyddion\1.0"; ValueType: string; ValueName: "Version"; ValueData: "2.12"; Flags: uninsdeletekey
; File associations
Root: HKCR; Subkey: ".gwy"; ValueType: string; ValueName: ""; ValueData: "Gwyddion.NativeData"; Flags: uninsdeletevalue
Root: HKCR; Subkey: "Gwyddion.NativeData"; ValueType: string; ValueName: ""; ValueData: "Gwyddion Native Data File"; Flags: uninsdeletekey
Root: HKCR; Subkey: "Gwyddion.NativeData\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\pixmaps\gwyddion.ico"
Root: HKCR; Subkey: "Gwyddion.NativeData\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\gwyddion.exe"" --remote-new ""%1"""


[Code]
var
  Exists: Boolean;
  GtkPath: String;

function GetGtkInstalled (): Boolean;
begin
  Exists := RegQueryStringValue (HKLM, 'Software\GTK\2.0', 'Path', GtkPath);
  if not Exists then begin
    Exists := RegQueryStringValue (HKCU, 'Software\GTK\2.0', 'Path', GtkPath);
  end;
  Result := Exists
end;

function GetGtkPath (S: String): String;
begin
    Result := GtkPath;
end;

function InitializeSetup(): Boolean;
begin
  Result := GetGtkInstalled ();
  if not Result then begin
    MsgBox ('Please install the Gtk+ 2.8 (or newer) Runtime Environment before installing Gwyddion.  The preferred Gtk+ package is GladeWin32: http://gladewin32.sourceforge.net/.', mbError, MB_OK);
  end;
end;

