dnl Check for Spidermonkey in four locations.
dnl This is necessary because in Debian, libjs.so is already taken by the
dnl NGS Javascript interpreter (ngs-js); consequently, the Spidermonkey
dnl library is named libsmjs.so and has its include files in
dnl /usr/include/smjs rather than /usr/include/js.
dnl And not everybody puts it in a subdirectory...
dnl
dnl Then there's /usr/include/mozilla/js and -lmozjs.

m4_define([spidermonkey_locate_header],
   [if test -f /usr/include/"$1/$2"; then
	echo /usr/include/"$1"
    else
	echo /usr/local/include/"$1"
    fi
   ])

m4_define([spidermonkey_locate_lib],
   [case "$JS_CFLAGS" in
	/usr/local/include/*)
	  echo -L/usr/local/lib -l"$1"
	  ;;
	*)
	  echo -l"$1"
	  ;;
    esac
   ])

m4_define([spidermonkey_locate],
    [AC_CHECK_HEADER([$1/jsapi.h],
	[JS_CFLAGS="-I`spidermonkey_locate_header([$1], [jsapi.h])`"
	 JS_LIBS="`spidermonkey_locate_lib([$2])`"
	],
	[unset JS_CFLAGS JS_LIBS],
	[#define XP_UNIX])
    ])

AC_DEFUN([AC_PATH_SPIDERMONKEY],
   [AC_ARG_WITH([spidermonkey], [prefix where libjs/libsmjs is installed],
		[JS_CFLAGS="-I$withval"], [JS_CFLAGS=''])

    if test x"$JS_CFLAGS" = x; then
      #if test x"$JS_CFLAGS" = x; then
	dnl /usr/include/smjs/, /usr/lib/libsmjs.so
	spidermonkey_locate([smjs], [smjs])
      #fi
      if test x"$JS_CFLAGS" = x; then
	dnl /usr/include/js/, /usr/lib/libjs.so
	spidermonkey_locate([js], [js])
      fi
      if test x"$JS_CFLAGS" = x; then
	dnl /usr/include/, /usr/lib/libjs.so
	spidermonkey_locate([], [smjs])
      fi
      if test x"$JS_CFLAGS" = x; then
	dnl /usr/include/mozilla/js/, /usr/lib/libmozjs.so
	spidermonkey_locate([mozilla/js], [mozjs])
      fi
      if test x"$JS_CFLAGS" = x; then
	AC_MSG_ERROR([libjs not found])
      fi
    else
      saved_CFLAGS="$CFLAGS"
      CFLAGS="$CFLAGS $JS_CFLAGS"
      AC_MSG_NOTICE([using path $JS_CFLAGS for spidermonkey])
      AC_CHECK_HEADER([jsapi.h],
	[JS_LIBS="`case "$JS_CFLAGS" in
			*/smjs|*/smjs/)
			  echo sm
			  ;;
			*/mozilla/js|*/mozilla/js*)
			  echo moz
			  ;;
		   esac`"
	 JS_LIBS="`locate_lib "$JS_LIBS"`js"
	 AC_DEFINE(HAVE_LIBSMJS, 1, [Define if you have jsapi.h])
	],
	[AC_MSG_ERROR([libjs not found])],
	[#define XP_UNIX])
      CFLAGS="$saved_CFLAGS"
    fi
    AC_SUBST(JS_CFLAGS)
    AC_SUBST(JS_LIBS)
   ])
