/*
 * Copyright (C) 2001-2004 the xine-project
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * $Id: globals.h,v 1.34 2005/10/06 19:46:15 dsalt Exp $
 *
 * global variables for lazy programmers... :>
 */

#ifndef HAVE_GLOBALS_H
#define HAVE_GLOBALS_H

/*
#define EXP_STUFF
*/

#include "config.h"
#include "i18n.h"

#include <X11/Xlib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib.h>
#include <xine.h>

#include "script_engine.h"
#include "info_widgets.h"

#include "defs.h"

extern GtkWidget      *app;
extern GtkWidget      *gtv; /* GtkVideo widget */
extern GtkWidget      *menubar, *popup_menu;
extern GtkWidget      *keypad;
extern GSList	      *infobars, *timewidgets;
extern pthread_mutex_t engine_lock;
extern gboolean	       initialised;

extern GdkPixbuf      *gxine_logo;

typedef struct {
  GtkToggleAction *fullscreen, *resize_factor, *auto_resize, *auto_rescale,
		  *deinterlace, *vo_postproc, *ao_postproc, *fs_toolbar,
		  *wm_toolbar, *wm_toolbar_snap;
  GSList *aspect, *vis, *fs_toolbar_pos, *video_size, *subtitles;
} action_items_t;
extern action_items_t  action_items;

extern int             verbosity;
extern xine_t         *xine;
extern xine_stream_t  *stream;
extern se_t           *gse; /* global script engine */
extern gchar *plugindir, *bindir, *logodir, *pixmapdir, *icondir, *miscdir;
extern char           *audio_driver_id;
extern char           *video_driver_id;
extern xine_audio_port_t *audio_port;
extern xine_video_port_t *video_port;

extern GAsyncQueue    *js_queue;

#define MAX_MRL_LEN 1024

/* used in key event handlers for filtering out numlock etc. */
#define GXINE_MODIFIER_MASK \
  (GDK_SHIFT_MASK | GDK_CONTROL_MASK | \
   GDK_MOD1_MASK | GDK_MOD3_MASK | GDK_MOD4_MASK)

#define CONFIG_DATA_NONE ((void *)1)

#endif
